local L = AceLibrary("AceLocale-2.2"):new("FuBar_TrainerFu")

local crayon = AceLibrary("Crayon-2.0")
local tablet = AceLibrary("Tablet-2.0")
local abacus = AceLibrary("Abacus-2.0")
local dewdrop = AceLibrary("Dewdrop-2.0")

local LBS = LibStub("LibBabble-Spell-3.0")
local BTS = AceLibrary("Babble-Tradeskill-2.2")

TrainerFu.hasIcon = "Interface\\Icons\\INV_Scroll_05"
TrainerFu.clickableTooltip = true
TrainerFu.hideWithoutStandby = true
TrainerFu.independentProfile = true

function TrainerFu:GetSpellRequirementText(skillName, spellName, spell)
	self.spellReqTextCache = self.spellReqTextCache or {}

	local spellReq

	if self.spellReqTextCache[spellName] then
		return self.spellReqTextCache[spellName]
	end

	if spell.levelRequirement and spell.levelRequirement > 0 then
		local lvl = string.format(L["Lvl %d"], spell.levelRequirement)
		if UnitLevel("player") >= spell.levelRequirement then
			spellReq = crayon:Green(lvl)
		else
			spellReq = crayon:Red(lvl)
		end
	end

	if spell.skillRequired and spell.skillRankRequired then
		local rankText
		if self.ranks[skillName] and self.ranks[skillName].rank >= spell.skillRankRequired then
			rankText = crayon:Green(spell.skillRankRequired)
		else
			rankText = crayon:Red(spell.skillRankRequired)
		end
		if spellReq and spellReq ~= "" then
			spellReq = spellReq .. ", ".. rankText
		else
			spellReq = rankText
		end
	end

	if spellName then
		self.spellReqTextCache[spellName] = spellReq
	end

	return spellReq
end

function TrainerFu:GetSpellNameColor(spellName, spell)
	local spellNameColor = nil
	if self:IsSpellKnown(spellName) then
		return crayon:Silver(spellName)
	elseif self:IsSpellTrainable(spell) then
		return crayon:Green(spellName)
	elseif self:IsSpellTrainable(spell, self.db.profile.trainableNextLevelRange, self.db.profile.trainableNextSkillRange) then
		return crayon:Yellow(spellName)
	else
		return crayon:Red(spellName)
	end
end


function TrainerFu:GetBabbleIcon(spell)
	local _,_,spellName = string.find(spell, "(.*)%s%(")

	if not spellName then
		spellName = spell
	end

	return LBS:GetSpellIcon(spellName) or BTS:GetSkillIcon(spellName) or nil
end

function TrainerFu:GetNumberOfLearnableSkillsText()
	if self.numberOfTrainableSkills and self.numberOfTrainableSkills > 0 then
		return crayon:Green(self.numberOfTrainableSkills)
	else return crayon:Red(self.numberOfTrainableSkills) end
end

function TrainerFu:GetLearnableSkillsCostText()
	if self.costOfTrainableSkills then return abacus:FormatMoneyFull(self.costOfTrainableSkills, true, coloured)
	else return "" end
end

function TrainerFu:ToggleHeader(skillType)
	self.db.char.hiddenHeader[skillType] = not self.db.char.hiddenHeader[skillType]
end

function TrainerFu:OnTextUpdate()
	local number = ""
	local cost = ""
	if self.db.profile.showFubarTrainableSkills then
		number = self:GetNumberOfLearnableSkillsText()
	end
	if self.db.profile.showFubarTrainingCost and self.costOfTrainableSkills and self.costOfTrainableSkills > 0 then
		cost = " " .. self:GetLearnableSkillsCostText()
	end
	self:SetText( number .. cost )
end

function TrainerFu:OnTooltipUpdate()
	local function IsExpanded(skillType)
		return not self.db.char.hiddenHeader[skillType]
	end

	local cat = tablet:AddCategory()

	cat:AddLine('text', L["Trainable skills:"] .." ".. self:GetNumberOfLearnableSkillsText())
	if self.db.profile.showSkillCost then
		cat:AddLine('text', L["Training cost:"] .." ".. self:GetLearnableSkillsCostText())
	end
	cat:AddLine('text', ' ')

	for skillName,skillTable in pairs(self.db.account.skill) do
		if self:IsSkillKnown(skillName) then
			if self.ranks[skillName] then
				skillRank = " (".. self.ranks[skillName].rank .."/".. self.ranks[skillName].maxRank ..")"
			else skillRank = "" end
			cat = tablet:AddCategory(
				'text', skillName .. skillRank,
				'columns', 2,
				'child_textR', 0, 'child_textG', 1, 'child_textB', 0,
				'child_justify2', "RIGHT",
				'child_indentation', 20,
				'showWithoutChildren', true,
				'hideBlankLine', true,
				'func', 'ToggleHeader', 'arg1', self, 'arg2', skillName,
				'hasCheck', true,
				'checked', true,
				'checkIcon', not IsExpanded(skillName) and "Interface\\Buttons\\UI-PlusButton-Up" or "Interface\\Buttons\\UI-MinusButton-Up"
			)

			if IsExpanded(skillName) then
				if self.db.profile.showtrainernames and skillRank == "" then
					for trainerName,trainer in pairs(self.db.account.trainer[skillName]) do
						cat:AddLine(
							'text', trainerName ..L[" in "].. trainer.location .. self:GetCoordinateText(trainer),
							'indentation', 25,
							'noInherit', true
							)
					end
				end

				for headerName,header in pairs(skillTable.header) do
					cat = tablet:AddCategory(
						'text', headerName,
						'columns', 3,
						'indentation', 10,
						'child_indentation', 25,
						'showWithoutChildren', not IsExpanded(headerName),
						'hideBlankLine', true,
						'func', 'ToggleHeader', 'arg1', self, 'arg2', headerName,
						'hasCheck', true,
						'checked', true,
						'checkIcon', not IsExpanded(headerName) and "Interface\\Buttons\\UI-PlusButton-Up" or "Interface\\Buttons\\UI-MinusButton-Up"
						)

					if IsExpanded(headerName) then
						if self.db.profile.showtrainernames then
							for trainerName,trainer in pairs(self.db.account.trainer[skillName]) do
								if (trainer.subType == headerName or trainer.Type == skillName ) then
									cat:AddLine(
										'text', trainerName ..L[" in "].. trainer.location .. self:GetCoordinateText(trainer),
										'indentation', 25,
										'noInherit', true
									)
								end
							end
						end

						for _,spellName in ipairs(header) do
							local spell = skillTable.skills[spellName]

							function ShowSpell()
								if self:IsSpellKnown(spellName) then
									if self.db.profile.showSpellAlreadyKnown then
										return true
									end
								elseif self:IsSpellTrainable(spell) then
									if self.db.profile.showSpellTrainable then
										return true
									end
								elseif self:IsSpellTrainable(spell, self.db.profile.trainableNextLevelRange, self.db.profile.trainableNextSkillRange) then
									if self.db.profile.showSpellTrainableNext then
										return true
									end
								else
									if self.db.profile.showSpellNotTrainable then
										return true
									else
										return false
									end
								end
							end

							local spellNameColor = self:GetSpellNameColor(spellName, spell)

							if ShowSpell() then
								if self.db.profile.showSkillCost and spell.cost then
									skillCost = abacus:FormatMoneyFull(spell.cost, true, coloured)
								end

								local spellReq
								if self.db.profile.showSpellRequirement then
									spellReq = self:GetSpellRequirementText(skillName, spellName, spell)
								end

								cat:AddLine(
									'text', spellNameColor,
									'text2', spellReq,
									'text3', skillCost,
									'justify', "LEFT",
									'justify2', "RIGHT",
									'justify3', "RIGHT",
									'hasCheck', true,
									'checked', true,
									'checkIcon', self:GetBabbleIcon(spellName) or spell.iconPath,
									'func', self.TooltipClick,
									'arg1', self,
									'arg2', skillName,
									'arg3', spellName,
									'arg4', spell,
									'arg5', true,
									'onEnterFunc', self.SetTooltip,
									'onEnterArg1', self,
									'onEnterArg2', skillName,
									'onEnterArg3', spellName,
									'onEnterArg4', spell,
									'onLeaveFunc', GameTooltip.Hide,
									'onLeaveArg1', GameTooltip
								)
							end
						end
					end
				end
			end
		end
	end
end


function TrainerFu:OnClick(button)
	if button ~= "LeftButton" then return end

	local frame
	if TrainerFu:IsMinimapAttached() then
		frame = FuBarPluginTrainerFuFrameMinimapButton
	else
		frame = FuBarPluginTrainerFuFrame
	end

	dewdrop:Open(frame, 'children', function(level, val1, val2, val3, val4)
		if level == 1 then
			for skillType,_ in pairs(self.db.account.trainer) do
				dewdrop:AddLine(
					'text', skillType,
					'hasArrow', true,
					'value', skillType
				)
			end
		elseif level == 2 then
			dewdrop:AddLine(
				'text', L["Skills"],
				'hasArrow', true,
				'value', L["Skills"]
			)
			dewdrop:AddLine(
				'text', L["Trainers"],
				'hasArrow', true,
				'value', L["Trainers"]
			)
		elseif level == 3 then
			if val1 == L["Trainers"] then
				for TrainerName,trainer in pairs(self.db.account.trainer[val2]) do
					dewdrop:AddLine('text', trainer.location .. self:GetCoordinateText(trainer) .. " - ".. TrainerName)
				end
			elseif val1 == L["Skills"] then
				for headerName,header in pairs(self.db.account.skill[val2].header) do
					dewdrop:AddLine(
						'text', headerName,
						'hasArrow', true,
						'value', headerName
					)
				end
			end
		elseif level == 4 then
			if val2 == L["Skills"] then
				for _,spellName in pairs(self.db.account.skill[val3].header[val1]) do
					local spell = self.db.account.skill[val3].skills[spellName]

					local spellText = ""

					local spellReq = self:GetSpellRequirementText(skillName, spellName, spell)
					if spellReq then spellText = spellReq .. " - " end

					if self:IsSkillKnown(val3) then
						spellText = spellText .. (self:GetSpellNameColor(spellName, spell) or spellName)
					else
						spellText = spellText .. spellName
					end

					local skillCost
					if self.db.profile.showSkillCost and spell.cost then
						skillCost = abacus:FormatMoneyFull(spell.cost, true, coloured)
					end

					dewdrop:AddLine(
						'text', spellText,
						'icon', self:GetBabbleIcon(spellName) or spell.iconPath,
						'func', function()
							self:TooltipClick(val1, spellName, spell)
						end,
						'tooltipFunc', self.SetTooltip,
						'tooltipArg1', self,
						'tooltipArg2', val1,
						'tooltipArg3', spellName,
						'tooltipArg4', spell
					)
				end
			end
		end
	end)
end

function TrainerFu:TooltipClick(skillName, spellName, spell)
	if IsShiftKeyDown() and IsControlKeyDown() and GetMouseButtonClicked() == "LeftButton" and spellName then
		self.db.char.knownSpell[spellName] = true
		self:Print(spellName, L[" is now marked as learned."])
		self:CalcTrainableSkillsInfo()
		self:Update()
	elseif IsControlKeyDown() and spell.itemLink then
		DressUpItemLink(spell.itemLink)
	else
		self:SetTooltip(skillName, spellName, spell, true)
	end
end

local spellInTooltip = nil
function TrainerFu:SetTooltip(skillName, spellName, spell, clicked)
	if type(spell) ~= "table" then
		return
	end

	local tipFrame
	if clicked then
		if ItemRefTooltip:IsVisible() and spellInTooltip == spellName then
			ItemRefTooltip:Hide()
			spellInTooltip = nil
			return
		end
		spellInTooltip = spellName
		tipFrame = ItemRefTooltip
		tipFrame:SetOwner(UIParent, "ANCHOR_PRESERVE");
	else
		tipFrame = GameTooltip
		GameTooltip_SetDefaultAnchor(tipFrame, this)
	end

	if spell.itemLink then
		tipFrame:SetHyperlink("item:" .. spell.itemLink)
	else
		tipFrame:AddLine(spellName, 1, 1, 1, 1)

		if spell.description and spell.description ~= "" then
			tipFrame:AddLine(spell.description, 0, 1, 0, 1)
		end
	end

	local spellReq = self:GetSpellRequirementText(skillName, spellName, spell)
	if spellReq ~= "" then
		tipFrame:AddDoubleLine(L["Requires:"], spellReq, 0, 0.5, 0.8)
	end

	if spell.cost then
		tipFrame:AddDoubleLine(L["Training cost:"], abacus:FormatMoneyFull(spell.cost, true, coloured), 0, 0.5, 0.8)
	end

	tipFrame:Show()
end
