TrainerFu = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0", "FuBarPlugin-2.0", "AceModuleCore-2.0")
local TrainerFu = TrainerFu

local L = AceLibrary("AceLocale-2.2"):new("FuBar_TrainerFu")
local BTS = AceLibrary("Babble-Tradeskill-2.2")

TrainerFu:RegisterDB("TrainerFuDB", "TrainerFuDBPerChar")

TrainerFu:RegisterDefaults('profile', {
	showSpellAlreadyKnown = false,
	showSpellTrainable = true,
	showSpellTrainableNext = true,
	showSpellNotTrainable = false,
	trainableNextLevelRange = 2,
	trainableNextSkillRange = 5,
	showSkillCost = true,
	showSpellRequirement = true,
	showTrainerNames = true,
	showFubarTrainableSkills = true,
	showFubarTrainingCost = true,
})

TrainerFu:RegisterDefaults('account', {
	skill = {},
	trainer = {}
})

TrainerFu:RegisterDefaults('char', {
	knownSpell = {},
	hiddenHeader = {}
})

function TrainerFu:OnInitialize()
	self:CreateMenu()
end

function TrainerFu:OnEnable()
	self.class = UnitClass("player")
	self:TrainerFu_UpdateData()

	--Level or skillup
	self:RegisterEvent("PLAYER_LEVEL_UP", 2)
	self:RegisterEvent("SKILL_LINES_CHANGED", 2)
	self:RegisterEvent("TrainerFu_UpdateData", 2)

	--Visiting trainer
	self:RegisterEvent("TRAINER_SHOW", 2)
	self:RegisterEvent("TRAINER_CLOSED", 2)
	--Craftframe
	self:RegisterEvent("CRAFT_CLOSE", 2)
	self:RegisterEvent("TRADE_SKILL_CLOSE", 2)
end

function TrainerFu:PLAYER_LEVEL_UP(newLevel)
	self:ScheduleLeaveCombatAction("TrainerFu_UpdateData")
end

function TrainerFu:SKILL_LINES_CHANGED()
	self:ScheduleLeaveCombatAction("TrainerFu_UpdateData")
end

function TrainerFu:CRAFT_CLOSE()
	for i = 1, GetNumCrafts() do
		local craftName, craftSubSpellName, craftType, numAvailable, isExpanded, trainingPointCost, requiredLevel = GetCraftInfo(i)
		if craftName and craftType ~= "header" then
			if craftSubSpellName then
				craftName = craftName .. " (" .. craftSubSpellName .. ")"
			end
			self.db.char.knownSpell[craftName] = true
		end
	end
	self:ScheduleLeaveCombatAction("TrainerFu_UpdateData")
end

function TrainerFu:TRADE_SKILL_CLOSE()
	for i = 1, GetNumTradeSkills() do
		local skillName, skillType, numAvailable, isExpanded = GetTradeSkillInfo(i)
		if skillName and skillType ~= "header" then
			self.db.char.knownSpell[skillName] = true
		end
	end
	self:ScheduleLeaveCombatAction("TrainerFu_UpdateData")
end

function TrainerFu:TrainerFu_UpdateData()
	self:UpdateSkillRanks()
	self:UpdateKnownSpells()
	self:CalcTrainableSkillsInfo()
	if self.spellReqTextCache then self.spellReqTextCache = {} end
	self:Update()
end

local profRanks = {
	[L["Apprentice"]] = nil,
	[L["Journeyman"]] = L["Apprentice"],
	[L["Expert"]] = L["Journeyman"],
	[L["Artisan"]] = L["Expert"],
	[L["Master"]] = L["Artisan"],
}
local profLevelRanks = {
	[75] = L["Apprentice"],
	[150] = L["Journeyman"],
	[225] = L["Expert"],
	[300] = L["Artisan"],
	[375] = L["Master"],
}
local specialRankSkills = {
	[L["Healthstone"]] = true,
	[L["Soulstone"]] = true,
	[L["Firestone"]] = true,
}
local specialRankAlias = {
	[L["Rank "].."1"] = L["Minor"],
	[L["Rank "].."2"] = L["Lesser"],
	[L["Rank "].."3"] = "",
	[L["Rank "].."4"] = L["Greater"],
	[L["Rank "].."5"] = L["Major"],
	[L["Rank "].."6"] = L["Master"],
}

local function trim (s)
	return (string.gsub(s, "^%s*(.-)%s*$", "%1"))
end
function TrainerFu:UpdateKnownSpells()
	self.knownSpell = self.knownSpell or {}
	for i = 1, MAX_SKILLLINE_TABS do
		local name, texture, offset, numSpells = GetSpellTabInfo(i)

		if not name then
			break
		end

		for s = offset + 1, offset + numSpells do
			local spell, rank = GetSpellName(s, BOOKTYPE_SPELL)
			spell = trim(spell)
			rank = trim(rank)

			local iAmSpecial = false
			for name in pairs(specialRankSkills) do
				if string.find(spell, name) then
					iAmSpecial = true
					break
				end
			end

			if iAmSpecial and specialRankAlias[rank] then
				self.db.char.knownSpell[spell.." (".. specialRankAlias[rank] ..")"] = true
			elseif rank and rank ~= "" and rank ~= L["Passive"] and rank ~= L["Summon"] then
				rank = trim(rank)
				if profRanks[rank] or rank == L["Apprentice"] then
					--Haxx to set all known ranks of a profession, ie. a Master Tailor have already learned Artisan, Expert and so on...
					self.db.char.knownSpell[rank.." "..spell] = true
					local r = profRanks[rank]
					while r do
						self.db.char.knownSpell[r.." "..spell] = true
						r = profRanks[r]
					end
				else
					self.db.char.knownSpell[spell.." (".. rank ..")"] = true
				end
			else
				self.db.char.knownSpell[spell] = true
			end
		end
	end
end

function TrainerFu:UpdateSkillRanks()
	self.ranks = {}
	local headerName
	for i=1, GetNumSkillLines() do
		local skillName, isHeader, isExpanded, skillRank, numTempPoints, skillModifier, skillMaxRank,
			isAbandonable, stepCost, rankCost, minLevel, skillCostType, skillDescription = GetSkillLineInfo(i);

		if skillName then
			--Special rule for some crap
			if skillName == GetSpellInfo(9134) or skillName == GetSpellInfo(2575) or skillName == BTS["Riding"] then
				--local name = profNameAlias[skillName] or skillName
				local name = skillName

				local rank = profLevelRanks[skillMaxRank - numTempPoints] or L["Apprentice"]

				self.db.char.knownSpell[rank .." ".. name] = true
				local r = profRanks[rank]
				while r do
					self.db.char.knownSpell[r .." ".. name] = true
					r = profRanks[r]
				end
			end

			if isHeader then
				headerName = skillName
			elseif not string.find(skillName, L["Language"]) then
				self.ranks[skillName] = {}
				self.ranks[skillName].rank = skillRank
				self.ranks[skillName].maxRank = skillMaxRank
				self.db.char.knownSpell[skillName] = true
			end
		end
	end
end

function TrainerFu:IsSkillKnown(skillName)
	if self.ranks and self.ranks[skillName] or skillName == self.class then
		return true
	else
		return false
	end
end

function TrainerFu:IsSpellKnown(spellName)
	return self.db.char.knownSpell[spellName]
end

function TrainerFu:IsSpellTrainable(spell, levelOver, skillOver)
	if type(spell) ~= "table" then return false end
	if not levelOver then levelOver = 0 end
	if not skillOver then skillOver = 0 end

	--If levelreq
	if spell.levelRequirement and spell.levelRequirement > 0 then
		if UnitLevel("player") + levelOver < spell.levelRequirement then
			return false
		end
	end
	--If skillreq
	if spell.skillRequired then
		if not self.ranks[spell.skillRequired] then
			return false
		end
		if spell.skillRankRequired and self.ranks[spell.skillRequired].rank + skillOver < spell.skillRankRequired then
			return false
		end
	end
	--If spellreq
	if spell.abilityRequirement then
		if not self:IsSpellKnown(spell.abilityRequirement) then
			return false
		end
	end
	return true
end

function TrainerFu:GetCoordinateText(trainer)
	if trainer.xcoord ~= 0 and trainer.ycoord ~= 0 then
		return string.format(" (%.0f, %.0f)", trainer.xcoord * 100, trainer.ycoord * 100)
	else return "" end
end

function TrainerFu:CalcTrainableSkillsInfo()
	local count = 0
	local cost = 0
	for skillName,skill in pairs(self.db.account.skill) do
		if not self.db.char.hiddenHeader[skillName] and self:IsSkillKnown(skillName) then
			for spellName,spell in pairs(skill.skills) do
				if not TrainerFu:IsSpellKnown(spellName) and self:IsSpellTrainable(spell) then
					count = count + 1
					if spell.cost then cost = cost + spell.cost end
				end
			end
		end
	end
	self.costOfTrainableSkills = cost
	self.numberOfTrainableSkills = count
end

function TrainerFu:CleanKnownSpells()
	self.db.char.knownSpell = {}
	self:ScheduleLeaveCombatAction("TrainerFu_UpdateData")
	self:Print(L["Known spells and skills wiped. Open your tradeskill panels to refresh known data and Warlocks summon your pets. If anything is displayed as not known when it is, please contact author. You can also mark it as know by ctrl-shift-click it in the tooltip."])
end

function TrainerFu:CleanDatabase()
	self:Print(L["Cleaning database..."])
	for skillName,skillTable in pairs(self.db.account.skill) do
		for spellName,spell in pairs(skillTable.skills) do
			--Remove description if itemLink is stored
			if spell.itemLink and spell.description then
				self:Print(L["Removed description for "] .. spellName)
				spell.description = nil
			end

			--Remove icon path if Babble knows it already
			local icon = self:GetBabbleIcon(spellName)
			if icon and spell.iconPath then
				self:Print(L["Removed icon path for "] .. spellName)
				spell.iconPath = nil
			end
		end
	end
	self:Print(L["Done!"])
end
