local dewdrop = AceLibrary("Dewdrop-2.0")
local tablet = AceLibrary("Tablet-2.0")
local L = AceLibrary("AceLocale-2.2"):new("FuBar_TrackerFu")

local optionsTable = {
	type = 'group',
	args = {
		showMinimap = {
			order = 10,
			type = 'toggle',
			name = L["TRACKER_SHOW_MINIMAP"],
			desc = L["TRACKER_SHOW_MINIMAP"],
			set = "ToggleShowMiniMap",
			get = "IsShowingMiniMap",
		},		
	}	
}

TrackerFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0")
TrackerFu.hasIcon = true
TrackerFu.clickableTooltip = true
TrackerFu.cannotDetachTooltip = true

TrackerFu.OnMenuRequest = optionsTable

TrackerFu:RegisterDB("TrackerFuDB")
TrackerFu:RegisterDefaults('profile', {
	showMiniMap = false
})

-- Methods
function TrackerFu:IsShowingMiniMap()
	return self.db.profile.showMiniMap
end
	
function TrackerFu:ToggleShowMiniMap()
	self.db.profile.showMiniMap = not self.db.profile.showMiniMap
	if ( self.db.profile.showMiniMap ) then
		MiniMapTracking:Show()
	else
		MiniMapTracking:Hide()
	end
	return self.db.profile.showMiniMap
end

function TrackerFu:OnEnable()
	self:RegisterEvent("MINIMAP_UPDATE_TRACKING")
end

function TrackerFu:MINIMAP_UPDATE_TRACKING()
	self:Update()
end

function TrackerFu:OnTextUpdate()
	self:SetIcon(GetTrackingTexture())

	local name, texture, active, category;
	local anyActive, checked;
	local count = GetNumTrackingTypes();

	for id=1, count do
		name, texture, active, category  = GetTrackingInfo(id);
		if ( active ) then
			self:SetText(name);
		end
	end
	if ( self.db.profile.showMiniMap ) then
		MiniMapTracking:Show()
	else
		MiniMapTracking:Hide()
	end	
end

function TrackerFu:OnTooltipUpdate()
	
	local cat = {};
	cat['trades'] = tablet:AddCategory(
		'columns', 1
	)
	cat['trades']:AddLine(
		'justify', 'LEFT',
		'text', L["TRACKER_TRADESKILL_HEADER"]
	);

	cat['enemy'] = tablet:AddCategory(
		'columns', 1
	)
	cat['enemy']:AddLine(
		'justify', 'LEFT',
		'text', L["TRACKER_ENEMY_HEADER"]
	);

	cat['npc'] = tablet:AddCategory(
		'columns', 1
	)
	cat['npc']:AddLine(
		'justify', 'LEFT',
		'text', L["TRACKER_NPC_HEADER"]
	);

	cat['other'] = tablet:AddCategory(
		'columns', 1
	)
	
	local name, texture, active, category;
	local anyActive, checked;
	local count = GetNumTrackingTypes();

	for id=1, count do
		name, texture, active, category  = GetTrackingInfo(id);

		local line = {};
		
		line['justify'] = "LEFT";
		line['text'] = name;

		line['func'] = SetTracking;
		line['arg1'] = id;
		line['hasCheck'] = true;
		line['checked'] = active;
		--line['checkIcon'] = texture;
		line['indentation'] = 10;
		
		line['textR'] = 1;
		line['textG'] = 1;
		line['textB'] = 1;
		
		if ( name == L["TRACKER_SPELL_FIND_FISH"] or name == L["TRACKER_SPELL_FIND_HERBS"] or name == L["TRACKER_SPELL_FIND_MINERALS"] or name == L["TRACKER_SPELL_FIND_TREASURE"] ) then
			cat['trades']:AddLine(line);
		elseif ( category == 'spell' ) then
			cat['enemy']:AddLine(line);
		elseif ( category == 'npc' ) then
			cat['npc']:AddLine(line);
		end
		
		if ( active ) then
			anyActive = active;
		end
	end
	
	if ( anyActive ) then
		checked = nil;
	else
		checked = 1;
	end

	line = {};	
	
	line['justify'] = "LEFT";
	line['text'] = NONE;

	line['func'] = SetTracking;
	line['arg1'] = nil;
	line['hasCheck'] = true;
	line['checked'] = checked;

	line['textR'] = 1;
	line['textG'] = 1;
	line['textB'] = 1;
	
	cat['other']:AddLine(line)			
	
end
