local tablet = AceLibrary("Tablet-2.0")
local dewdrop = AceLibrary("Dewdrop-2.0")
local _G = getfenv(0)

TinyTipFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0")
TinyTipFu.hasIcon = true
TinyTipFu.hasNoText = true
TinyTipFu.defaultPosition = "LEFT"
TinyTipFu.hideMenuTitle = true
TinyTipFu.cannotDetachTooltip = true

local HINT = "Right-Click to open TinyTip options."

if GetLocale() == "koKR" then
	HINT = "우클릭시 TinyTip 설정창을 엽니다."
	
elseif GetLocale() == "esES" then
     HINT = "ClicDerecho para abrir las opciones de TinyTip."
end

function TinyTipFu:OnMenuRequest(level, value)
	_G.TinyTip_LoDRun("TinyTipOptions", "TinyTipOptions_SetLocals", _G.TinyTip_GetDB())
	_G.TinyTipOptions_CreateDDMenu(level, value)

	-- Add a spacer between this and the rest of the FBP menu.
	if level == 1 then
		dewdrop:AddLine()
	end
end

function TinyTipFu:OnTooltipUpdate()
	tablet:SetHint(HINT)
end

