local Tablet = AceLibrary("Tablet-2.0")
local L = Rock("LibRockLocale-1.0"):GetTranslationNamespace("FuBar_TalkFu")

TalkFu = Rock:NewAddon("TalkFu", "LibRockEvent-1.0", "LibRockConfig-1.0", "LibRockDB-1.0", "LibFuBarPlugin-3.0")

TalkFu:SetDatabase("TalkFuDB")
TalkFu:SetDatabaseDefaults('profile', {
	hideMapButton = true,
	hideVoiceButton = false,
})

TalkFu.version = "1.0." .. ("$Revision: 54634 $"):match("%d+")
TalkFu.date = string.sub("$Date: 2007-11-14 05:12:50 -0500 (Wed, 14 Nov 2007) $", 8, 17)
TalkFu:SetFuBarOption('iconPath', "Interface\\Common\\VoiceChat-Speaker")
TalkFu:SetFuBarOption('defaultPosition', "RIGHT")
TalkFu:SetFuBarOption('tooltipType', "GameTooltip")
TalkFu:SetFuBarOption('hideWithoutStandby', true)

function TalkFu:OnInitialize()
	local optionsTable = {
		name = "FuBar_TalkFu",
		desc = self.notes,
		handler = TalkFu,
		icon = "Interface\\Common\\VoiceChat-On",
		type = 'group',
		args = {
			hideMapButton = {
				type = 'toggle',
				name = L["Hide minimap button"],
				desc = L["Hide minimap button"],
				get = function() return self.db.profile.hideMapButton end,
				set = function()
					self.db.profile.hideMapButton = not self.db.profile.hideMapButton
					if self.db.profile.hideMapButton then
						MiniMapVoiceChatFrame:Hide()
					else
						MiniMapVoiceChatFrame:Show()
					end
				end,
			},
			hideVoiceButton = {
				type = 'toggle',
				name = L["Hide voice chat name button"],
				desc = L["You know, that little thing with the speaker which shows the name of the person talking"],
				get = function() return self.db.profile.hideVoiceButton end,
				set = function()
					self.db.profile.hideVoiceButton = not self.db.profile.hideVoiceButton
					if self.db.profile.hideVoiceButton then
						VoiceChatTalkers:Hide()
					else
						VoiceChatTalkers:Show()
					end
				end,
			},
		},
	}
	TalkFu:SetConfigTable(optionsTable)
	TalkFu.OnMenuRequest = optionsTable
	
	local frame = Rock("LibFuBarPlugin-3.0").pluginToFrame[self]
	self.frame = frame
	local talkOverlay = frame:CreateTexture("TalkFuIconTalkOverlay", "ARTWORK")
	talkOverlay:SetWidth(16)
	talkOverlay:SetHeight(16)
	talkOverlay:SetPoint("LEFT", frame, "LEFT")
	talkOverlay:SetTexture("Interface\\Common\\VoiceChat-On")
	talkOverlay:Hide()
	self.talkOverlay = talkOverlay
	--[[
	local muteOverlay = frame:CreateTexture("TalkFuIconMuteOverlay", "ARTWORK")
	muteOverlay:SetWidth(16)
	muteOverlay:SetHeight(16)
	muteOverlay:SetPoint("LEFT", frame, "LEFT")
	muteOverlay:SetTexture("Interface\\Common\\VoiceChat-Muted")
	muteOverlay:Hide()
	self.muteOverlay = muteOverlay
	--]]
end

function TalkFu:OnEnable()
	self:AddEventListener("Blizzard", "VOICE_START", "UpdateFuBarText")
	self:AddEventListener("Blizzard", "VOICE_STOP", "UpdateFuBarText")
	
	if self.db.profile.hideMapButton then
		MiniMapVoiceChatFrame:Hide()
	end
	if self.db.profile.hideVoiceButton then
		VoiceChatTalkers:Hide()
	end
end

function TalkFu:OnFuBarClick()
	if GetNumVoiceSessions() > 0 then
		ToggleDropDownMenu(1, nil, MiniMapVoiceChatDropDown, self.frame:GetName(), 0, -5)
	else
		ToggleFriendsFrame(4)
	end
end

function TalkFu:OnUpdateFuBarText()
	if #VOICECHAT_TALKERS > 0 then
		local text = ''
		for i, unit in ipairs(VOICECHAT_TALKERS) do
			local _, class = UnitClass(unit)
			text = text .. string.format(" |cff%.2x%.2x%.2x%s|r ", RAID_CLASS_COLORS[class].r * 255, RAID_CLASS_COLORS[class].g * 255, RAID_CLASS_COLORS[class].b * 255, UnitName(unit))
		end
		self:SetFuBarText(text)
		if self:IsFuBarIconShown() then
			self.talkOverlay:Show()
		end
	else
		local channel = NONE
		for i=1, GetNumVoiceSessions(), 1 do
			local name, active = GetVoiceSessionInfo(i)
			if active then
				channel = name
				break
			end
		end
		self:SetFuBarText(channel)
		self.talkOverlay:Hide()
	end
end

function TalkFu:OnUpdateFuBarTooltip()
	
end
