local L = AceLibrary("AceLocale-2.2"):new("SpeedFu")

L:RegisterTranslations("enUS", function() return {

	MENU_CALIBRATE = "Set new rate",
	MENU_RESET = "Reset all rates",
	MENU_DIGIT = "Constant text width",

	TOOLTIP_CALIBRATE = "Clicking this option when you're running at normal speed will recalibrate the base rate of current zone.",
	TOOLTIP_RESET = "Resets base rate of all zones to default value.",
	TOOLTIP_DIGIT = "Speed will always shown in three digits.",

	TEXT_HINT = "Speed relative to normal run-speed.",	
	RESET_CONFIRM = "Are you sure you want to reset all base-rates for FuBar - Speed?",
	RESET_BASERATE = "Predefined base-rates set for all zones.",
	
	NEW_BASERATE_FORMAT = "Base-rate for zone %s set to %f",
	
	-- Special zone names	
	BLACKROCK		= "Blackrock Mountain",
	WARSONG			= "Warsong Gulch",
	ALTERAC			= "Alterac Valley",
	ARATHI			= "Arathi Basin",
	
} end )



L:RegisterTranslations("koKR", function() return {

	MENU_CALIBRATE = "신규 비율 설정",
	MENU_RESET = "모든 비율 초기화",
	MENU_DIGIT = "넓은 텍스트",

	TOOLTIP_CALIBRATE = "일반 속도로 달리고 있을 때 이 항목을 클릭하면 현재 지역에 대한 기본 속도로 설정합니다.",
	TOOLTIP_RESET = "모든 지역에 대한 값을 기본값으로 초기화 합니다.",
	TOOLTIP_DIGIT = "속도를 항상 3단위 숫자로 표시합니다.",

	TEXT_HINT = "일반 달리기 속도와 관련있는 속도.",	
	RESET_CONFIRM = "정말로 FuBar - Speed의 모든 값을 초기화 하시겠습니까?",
	RESET_BASERATE = "모든 지역에 대한 값이 초기화 되었습니다.",
	
	NEW_BASERATE_FORMAT = "%s지역에 대한 기본 값 %f",
	
	-- Special zone names	
	BLACKROCK		= "검은바위 산",
	WARSONG			= "전쟁노래 협곡",
	ALTERAC			= "알터랙 계곡",
	ARATHI			= "아라시 분지",
	
} end )


L:RegisterTranslations("esES", function() return {

	MENU_CALIBRATE = "Establecer nueva tasa",
	MENU_RESET = "Reiniciar todas las tasas",
	MENU_DIGIT = "Anchura de texto constante",

	TOOLTIP_CALIBRATE = "Haciendo clic en esta opci\195\179n cuando est\195\161s corriendo a velocidad normal recalibrar\195\161 la tasa base de la zona actual.",
	TOOLTIP_RESET = "Reinicializa la tasa base de todas las zonas al valor por defecto.",
	TOOLTIP_DIGIT = "La velocidad siempre ser\195\161 mostrada con tres d\195\173gitos.",

	TEXT_HINT = "Velocidad relativa a la velocidad de correr normal.",
	RESET_CONFIRM = "\194\191Est\195\161s seguro/a de querer reiniciar todas las tasas bases para Fubar - Speed?",
	RESET_BASERATE = "Se han establecido las tasas base predefinidas en todas las zonas.",
	
	NEW_BASERATE_FORMAT = "Tasa base para la zona %s establecida en %f",
	
	-- Special zone names	
	BLACKROCK		= "Monta\195\177a Roca Negra",
	WARSONG			= "Garganta Grito de Guerra",
	ALTERAC			= "Valle de Alterac",
	ARATHI			= "Cuenca de Arathi",
	
} end )


L:RegisterTranslations("zhCN", function() return {

	MENU_CALIBRATE = "为本地区设置速率",
	MENU_RESET = "重置所有速率",
	MENU_DIGIT = "一直以3位数显示数字",

	TOOLTIP_CALIBRATE = "当你在以标准速度奔跑时按下，会重新设置当前地区的速率。",
	TOOLTIP_RESET = "重置所有地区的基础速率为默认值",
	TOOLTIP_DIGIT = "一直以3位数显示数字",

	TEXT_HINT = "速度相当于正常跑步",	
	RESET_CONFIRM = "是否确认重置所有FuBar - Speed的速率到默认值？",
	RESET_BASERATE = "为所有地区使用默认速率",
	
	NEW_BASERATE_FORMAT = "%s 的基础速率重新设定为 %f",
	
	-- Special zone names	
	BLACKROCK		= "黑石山",
	WARSONG			= "战歌峡谷",
	ALTERAC			= "奥特兰克山谷",
	ARATHI			= "阿拉希盆地",
	
} end )