local dewdrop = AceLibrary("Dewdrop-2.0")
local L = AceLibrary("AceLocale-2.2"):new("SpeedFu")

SpeedFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceConsole-2.0", "AceDB-2.0")
SpeedFu.hasIcon = "Interface\\Icons\\Ability_Rogue_Sprint.blp"

local optionsTable = {
	type = 'group',
	args = {
		calibrate = {
			order = 1,
			type = 'execute',
			name = L["MENU_CALIBRATE"],
			desc = L["TOOLTIP_CALIBRATE"],
			func = 'ToggleRate',
		},
		reset = {
			order = 2,
			type = 'execute',
			name = L["MENU_RESET"],
			desc = L["TOOLTIP_RESET"],
			func = 'ToggleReset',
		},
		digit = {
			order = 3,
			type = 'toggle',
			name = L["MENU_DIGIT"],
			desc = L["TOOLTIP_DIGIT"],
			set = "ToggleDigit",
			get = "GetDigit",
		}
	}
}

SpeedFu.blizzardTooltip = true
SpeedFu.OnMenuRequest = optionsTable
SpeedFu:RegisterChatCommand( { "/speedfu" }, optionsTable )

local FREQUENCY = 0.5
local frame

function SpeedFu:OnInitialize()

	if not frame then frame = CreateFrame("Frame") end
	frame:SetScript("OnEvent",function(frame,event,...) self[event](self,...) end)
	frame:RegisterEvent("ZONE_CHANGED_NEW_AREA")
	
	frame:Hide()
	frame:SetScript("OnUpdate", self.UpdateSpeed)
	
	self:RegisterDB("FuBar_SpeedDB")
	self:RegisterDefaults('account', {
		zoneBaseRate = {
			[1] = {
				[1] = 0.00182,	-- Ashenvale
				[2] = 0.00207,	-- Azshara
				[3] = 0.002578,	-- Azuremyst Isle
				[4] = 0.003218,	-- Bloodmyst Isle
				[5] = 0.00160,	-- Darkshore
				[6] = 0.00992,	-- Darnassus
				[7] = 0.00234,	-- Desolace
				[8] = 0.00199,	-- Durotar
				[9] = 0.00200,	-- Dustwallow Marsh
				[10] = 0.00183,	-- Felwood
				[11] = 0.00151,	-- Feralas
				[12] = 0.00455,	-- Moonglade
				[13] = 0.00204,	-- Mulgore
				[14] = 0.00748,	-- Orgrimmar
				[15] = 0.00301,	-- Silithus
				[16] = 0.00215,	-- Stonetalon Mtns
				[17] = 0.00152,	-- Tanaris
				[18] = 0.00206,	-- Teldrassil
				[19] = 0.00104,	-- The Barrens
				[20] = 0.009936,-- The Exodar
				[21] = 0.00239,	-- Thousand Needles
				[22] = 0.01006,	-- Thunder Bluff
				[23] = 0.00284,	-- Un'Goro Crater
				[24] = 0.00148,	-- Winterspring
			},
			[2] = {
				[1] = 0.00210,	-- Alterac Mtns
				[2] = 0.00292,	-- Arathi Highlands
				[3] = 0.00422,	-- Badlands
				[4] = 0.00313,	-- Blasted Lands
				[5] = 0.00359,	-- Burning Steppes
				[6] = 0.00420,	-- Deadwind Pass
				[7] = 0.00213,	-- Dun Morogh
				[8] = 0.00389,	-- Duskwood
				[9] = 0.00271,	-- Eastern Plaguelands
				[10] = 0.00302,	-- Elwynn Forest
				[11] = 0.0001,	-- Eversong Woods
				[12] = 0.0001,	-- Ghostlands
				[13] = 0.00328,	-- Hillsbrad Foothills
				[14] = 0.01327,	-- Ironforge
				[15] = 0.00381,	-- Loch Modan
				[16] = 0.00484,	-- Redridge Mnts
				[17] = 0.00470, -- Searing Gorge
				[18] = 0.0001,	-- Silvermoon City
				[19] = 0.00206,	-- Silverpine Forest
				[20] = 0.00781,	-- Stormwind
				[21] = 0.00165,	-- Stranglethorn Vale
				[22] = 0.00458,	-- Swamp of Sorrows
				[23] = 0.00272,	-- The Hinterlands
				[24] = 0.00232,	-- Tirisfal Glades
				[25] = 0.01094,	-- Undercity
				[26] = 0.00244,	-- Western Plaguelands
				[27] = 0.00300,	-- Westfall
				[28] = 0.00254,	-- Wetlands
			},
			[3] = {
				[1] = 0.001935,	-- Blade's Edge Mountains
				[2] = 0.002033,	-- Hellfire Peninsula
				[3] = 0.001900,	-- Nagrand
				[4] = 0.001883,	-- Netherstorm
				[5] = 0.001909,	-- Shadowmoon Valley
				[6] = 0.008039,	-- Shattrath City
				[7] = 0.001944,	-- Terokkar Forest
				[8] = 0.002088	-- Zangarmarsh
			},
			['special'] = {
				[L["BLACKROCK"]] = 0.0002983199214410154,
				[L["WARSONG"]] = 0.009159138767039199,
				[L["ALTERAC"]] = 0.002477872662261515,
				[L["ARATHI"]] = 0.005978692329518227
			},
		},
	})
	
	self.vars = {}
	self.text = "???%";
	
end

function SpeedFu:OnEnable()
	frame:Show()
end

function SpeedFu:OnDisable()
	frame:Hide()
end

-- This will be called from FuBar.
function SpeedFu:OnTextUpdate()
	self:SetText(self.text)
end

function SpeedFu:ToggleRate()
	self.vars.setRate = true
end

function SpeedFu:ToggleReset()
	StaticPopupDialogs["BPSPEED_RESET"] = {
		text = TEXT(L["RESET_CONFIRM"]),
		button1 = TEXT(OKAY),
		button2 = TEXT(CANCEL),
		OnAccept = function()
			self:Reset()
		end,
		timeout = 0,
		exclusive = 1
	}
	StaticPopup_Show("BPSPEED_RESET")
end

function SpeedFu:ToggleDigit()
	self.db.profile.digit = not self.db.profile.digit
end

function SpeedFu:GetDigit()
	return self.db.profile.digit
end

function SpeedFu:ZONE_CHANGED_NEW_AREA()
	SetMapToCurrentZone();
end

function SpeedFu:Reset()
	local digit = self.db.profile.digit
	self:ResetDB('account')
	self.db.profile.digit = digit

	self:Print(L["RESET_BASERATE"])
end

local difference = 0
function SpeedFu.UpdateSpeed(frame,elapsed)
	difference = difference + elapsed
	if difference < FREQUENCY then
		return
	end
	
	local self = SpeedFu

	-- Initialize.
	if (self.vars.lastPos == nil) then
		self.vars.lastTime = time()
		self.vars.setRate = false
		self.vars.iDeltaTime = 0
		self.vars.fSpeed = 0.0
		self.vars.fSpeedDist = 0.0
		self.vars.CurrPos = {}
		self.vars.lastPos = {}
		self.vars.lastPos.x, self.vars.lastPos.y = GetPlayerMapPosition("player")
	end
	
	self.vars.iDeltaTime = self.vars.iDeltaTime + difference;
	self.vars.CurrPos.x, self.vars.CurrPos.y = GetPlayerMapPosition("player")
	
	if ((self.vars.CurrPos.x == 0) and (self.vars.CurrPos.y == 0)) then
		self.vars.fSpeed = "-"
		self.vars.fSpeedDist = 0.0
		self.vars.iDeltaTime = 0.0
	else
		local dist = math.sqrt(
			((self.vars.lastPos.x - self.vars.CurrPos.x) * (self.vars.lastPos.x - self.vars.CurrPos.x) * 2.25 ) +
			((self.vars.lastPos.y - self.vars.CurrPos.y) * (self.vars.lastPos.y - self.vars.CurrPos.y))
			);
		
		self.vars.fSpeedDist = self.vars.fSpeedDist + dist;
		
		if (self.vars.iDeltaTime >= .5) then
			local continent = GetCurrentMapContinent()
			local zone = GetCurrentMapZone()
			local displacement = (self.vars.fSpeedDist / self.vars.iDeltaTime)
			local baserate; 
			
			if zone == 0 then
				continent = "special"
				zone = GetZoneText();
			end
			
			if (self.vars.setRate == true) then
				-- recalibrate this zone, the user should know this should be done when running at 100%
				self.db.account.zoneBaseRate[continent][zone] = displacement
				self:Print(L["NEW_BASERATE_FORMAT"], zone, displacement)
				-- done calibrating
				self.vars.setRate = false;
			end
			
			baserate = self.db.account.zoneBaseRate[continent][zone]
			
			if (baserate ~= nil and baserate ~= 0) then
				self.vars.fSpeed = self:Round( (displacement / baserate) * 100)
				self.vars.fSpeedDist = 0.0
				self.vars.iDeltaTime = 0.0
			else
				self.vars.fSpeed = "-";
				self.vars.fSpeedDist = 0.0
				self.vars.iDeltaTime = 0.0
			end
		end -- if (self.vars.iDeltaTime >= .5) 
	end -- if  ((self.vars.CurrPos.x == 0) and (self.vars.CurrPos.y == 0)) 
	
	self.vars.lastPos.x = self.vars.CurrPos.x
	self.vars.lastPos.y = self.vars.CurrPos.y
	
	local text;
	if self.vars.fSpeed == nil or self.vars.fSpeed == "-" then
		text = "???%";
	else
		if self.db.profile.digit then
			text = string.format("%03d", self.vars.fSpeed) .. "%"
		else
			text = self.vars.fSpeed .. "%"
		end
		if self.vars.fSpeed == 100 then
			text = string.format("|cffffffff%s|r", text)
		elseif self.vars.fSpeed > 100 then
			text = string.format("|cff00ff00%s|r", text)
		elseif self.vars.fSpeed < 100 then
			text = string.format("|cffff0000%s|r", text)
		end
	end
	
	self.text = text
	
	self:Update()
	
	difference = 0
end

function SpeedFu:Round(x)
	if(x - floor(x) > 0.5) then
		x = floor(x + 0.5)
	else
		if(x - floor(x) > 0.25) then
			x = floor(x) + 0.5
		else x = floor(x)
		end
	end
	return x
end
