--[[
Note:
Some ideas were 'borrowed' from SnaFu (Theondry of Perenolde)
Reason for the rewrite was to remove all extra functionality (like pet usage and communication) and to improve efficiency and performance.
--]]
SoulJarFu = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0", "FuBarPlugin-2.0")
local crayon = AceLibrary("Crayon-2.0")
local tablet = AceLibrary("Tablet-2.0")
local L = AceLibrary("AceLocale-2.2"):new("SoulJarFu")
local SoulJarFu = SoulJarFu

local UnitName = UnitName
local UnitBuff = UnitBuff
local UnitIsUnit = UnitIsUnit
local UnitClass = UnitClass
local GetTime = GetTime
local GetPlayerBuff = GetPlayerBuff
local GetPlayerBuffName = GetPlayerBuffName
local GetPlayerBuffTimeLeft = GetPlayerBuffTimeLeft
local GetNumPartyMembers = GetNumPartyMembers
local GetNumRaidMembers = GetNumRaidMembers
local RAID_CLASS_COLORS = RAID_CLASS_COLORS
local SSBuff = GetSpellInfo(27239)
local math_floor = math.floor
local pairs = pairs
local select = select

L:RegisterTranslations("enUS", function()
    return {
        ["Click to toggle display"] = true,
        ["Toggle Audio"] = true,
        ["Turn sounds on/off"] = true,
        ["'s soul is in the jar!"] = true,
	["'s soul has escaped!"] = true,
    }
    end
)

L:RegisterTranslations("deDE", function()
    return {
        ["Click to toggle display"] = "Click to toggle display",
        ["Toggle Audio"] = "Toggle Audio",
        ["Turn sounds on/off"] = "Turn sounds on/off",
        ["'s soul is in the jar!"] = "'s soul is in the jar!",
	["'s soul has escaped!"] = "'s soul has escaped!",
    }
    end
)

L:RegisterTranslations("frFR", function()
    return {
        ["Click to toggle display"] = "Click to toggle display",
        ["Toggle Audio"] = "Toggle Audio",
        ["Turn sounds on/off"] = "Turn sounds on/off",
        ["'s soul is in the jar!"] = "'s soul is in the jar!",
	["'s soul has escaped!"] = "'s soul has escaped!",
    }
    end
)


SoulJarFu.hasIcon = "Interface\\Icons\\Spell_Shadow_SoulGem"
SoulJarFu.overrideMenu = true
SoulJarFu.tooltipHiddenWhenEmpty = true
SoulJarFu.fubarText = ""
SoulJarFu.hideWithoutStandby = true
SoulJarFu:RegisterDB("SoulJarFuDB")
SoulJarFu:RegisterDefaults('profile',{
        Amount = true,
        Audio =  true,
    }
)

function SoulJarFu:OnInitialize()
	local commands = {
		type = 'group',
		args = {
			Sounds = {
				type = 'toggle',
				name = L["Toggle Audio"],
				desc = L["Turn sounds on/off"],
				get = function()
				    return self.db.profile.Audio
				end,
				set = function(v)
				    self.db.profile.Audio = v
				end,
			},
		}
	}
	self.OnMenuRequest = commands
end

local SSList = {}
local tempSSList = {}
local classList = {}
local oldSS
local totalStones = 0

function SoulJarFu:OnEnable()
	self:ScheduleRepeatingEvent( self.Update, 1, self)
end

function SoulJarFu:OnClick()
	if self.db.profile.Amount then
		self.db.profile.Amount = false
	else
		self.db.profile.Amount = true
	end
end

function SoulJarFu:OnTextUpdate()
	self:SetText(self.fubarText)
end

function SoulJarFu:OnTooltipUpdate()
	local category = tablet:AddCategory( "columns", 2, 'child_textR', 1, 'child_textG', 1, 'child_textB', 0, 'child_text2R', 1, 'child_text2G', 1, 'child_text2B', 1 )
	
	if oldSS and oldSS <= 1800 then
		for name in pairs(SSList) do
			local class = classList[name]
			local r, g, b = RAID_CLASS_COLORS[class].r, RAID_CLASS_COLORS[class].g, RAID_CLASS_COLORS[class].b
			category:AddLine('text', name, 'textR', r, 'textG', g, 'textB', b, 'text2', SoulJarFu:FormatTime( SoulJarFu:GetTimeLeft( name ) ))
		end
	end
	
	if FuBar then tablet:SetHint(L["Click to toggle display"]) end
end

function SoulJarFu:OnDataUpdate()
    	self:UpdateAll()
	oldSS = self:GetOldSS()
	self.fubarText = self:GetText()
end

function SoulJarFu:GetText()
	if self.db.profile.Amount then
		if totalStones > 0 then
			return crayon:Green(" " .. totalStones)
		else
			return crayon:Purple(" 0")
		end
	else
		if not oldSS then
			return crayon:White("--")
		else
			if oldSS > 99 then
				return crayon:Green(self:FormatTime(oldSS))
			elseif oldSS < 0 then
				return crayon:Red("??:??")
			else
				return crayon:Red(oldSS .. "s")
			end
		end
	end
end

function SoulJarFu:Notify(name, gained)
	local sound = self.db.profile.Audio
	
	if gained then
		self:Print(crayon:Gold(name) .. L["'s soul is in the jar!"])
		if sound then PlaySound("PVPTHROUGHQUEUE") end
	else
		self:Print(crayon:Red(name) .. L["'s soul has escaped!"])
		UIErrorsFrame:AddMessage(crayon:Red(name) .. L["'s soul has escaped!"])
		if sound then PlaySound("PVPENTERQUEUE") end	
	end
end

function SoulJarFu:CheckUnit(unitID)
	local name = UnitName(unitID)
	local index
	local i = 1
	
	while UnitBuff(unitID,i) do
		if UnitBuff(unitID, i) == SSBuff then
			index = i
			break
		end
		i = i + 1
	end

	if index and name then
		if not SSList[name] then
			local timeleft = select(6, UnitBuff( unitID, index ))

			if timeleft then
				tempSSList[name] = GetTime() + timeleft - 1800
			else
				if UnitIsUnit( unitID, "player" ) then
					for i = 1, 32 do
						local bindex = GetPlayerBuff(i, "HELPFUL")
						if bindex >= 0 then
							if GetPlayerBuffName(bindex) == SSBuff then
								tempSSList[name] = GetTime() + GetPlayerBuffTimeLeft(bindex) - 1800
								break
							end
						end
					end	    		
				else
					tempSSList[name] = GetTime()
				end
			end

			self:Notify( name, true )
		else
			tempSSList[name] = SSList[name]
		end

		classList[name] = select(2, UnitClass( unitID ))
		totalStones = totalStones + 1
	end
end

function SoulJarFu:UpdateAll()
	totalStones = 0
	local unitID
	
	if GetNumRaidMembers() > 0 then
		for i = 1, 40 do
			self:CheckUnit( "raid" .. i )
		end
	else 
		self:CheckUnit("player")
		
		if GetNumPartyMembers() > 0 then	
			for i = 1, 5 do
				self:CheckUnit( "party" .. i )
			end
		end
	end
	
	for name in pairs( SSList ) do
		if tempSSList[name] == nil then
			self:Notify( name )
		end
		SSList[name] = nil
	end
	
	for k, v in pairs( tempSSList ) do
		SSList[k] = v
		tempSSList[k] = nil
	end
end

function SoulJarFu:GetOldSS()
	local oldest

	for name in pairs( SSList ) do
		local time = SoulJarFu:GetTimeLeft( name )
	
		if oldest then
			if time < oldest and time > 0 then
				oldest = time
			end
		else
			oldest = time
		end
	end

	return oldest
end

function SoulJarFu:GetTimeLeft( name )
	return math_floor( 1800 - GetTime() + SSList[name] )
end

function SoulJarFu:FormatTime( time )
	if time < 0 then
		return "??:??"
	end

	local seconds = time - ( math_floor( time / 60 ) * 60 )
	
	if seconds < 10 then
		seconds = "0" .. seconds
	end
	
	return math_floor( time / 60 ) .. ":" .. seconds
end


