SkillsPlusFuLt = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0",
                                              "AceConsole-2.0",
                                              "AceDB-2.0",
                                              "AceEvent-2.0" -- ,
                                              -- "AceHook-2.1"       -- not required
                                              )
-- variables
local L       = AceLibrary("AceLocale-2.2"):new("SkillsPlusFuLt")
local BS      = AceLibrary("Babble-Spell-2.2")
local crayon  = AceLibrary("Crayon-2.0")
local tablet  = AceLibrary("Tablet-2.0")
local dewdrop = AceLibrary("Dewdrop-2.0")

local toonSaveKey = ''
                     
alchemyID = 1
                     
-- set properties                                             
SkillsPlusFuLt.clickableTooltip = true
SkillsPlusFuLt.canHideText      = true
SkillsPlusFuLt.defaultPosition  = "RIGHT"
SkillsPlusFuLt.hasIcon          = BS:GetSpellIcon("Engineering")
SkillsPlusFuLt.hasNoColor       = true

-- register stuff
SkillsPlusFuLt:RegisterDB("SkillsPlusFuLtDB")
SkillsPlusFuLt:RegisterDefaults("char", {
                                -- flags
                                showBooleanSkills = false,
                                -- lists
                                hidden = {},} )
SkillsPlusFuLt:RegisterDefaults("account", {
                                -- lists
                                toonSave = {},} 
                             )
SkillsPlusFuLt:RegisterChatCommand(L["CMD_OPTIONS"], options)

-- methods

function SkillsPlusFuLt:IsShowingBooleanSkills()
	return self.db.char.showBooleanSkills
end

function SkillsPlusFuLt:ToggleShowingBooleanSkills()
	self.db.char.showBooleanSkills = not self.db.char.showBooleanSkills
	self:UpdateTooltip()
	return self.db.char.showBooleanSkills
end

function SkillsPlusFuLt:OnInitialize()
    self.labelName = L["FUBAR_LABEL"]
	self.skillList = {}
end

function SkillsPlusFuLt:OnEnable()
    -- skills management
	self:RegisterEvent("SKILL_LINES_CHANGED","Update")
	self:RegisterEvent("PLAYER_LEVEL_UP","Update") 
    -- variables
    toonSaveKey = GetCVar('realmName')..'|'..UnitName('player')
    
    -- alchemy hack
    for i = 1,99 do
       local spellName = GetSpellName(i, BOOKTYPE_SPELL)
       if not spellName then
          break
       end
       if spellName == BS["Alchemy"] then
         alchemyID = i
         break
       end
       i = i + 1
    end

    self:UpdateToonInfo()
end

-- toon management
function SkillsPlusFuLt:UpdateToonInfo()
    if (self.db.account.toonSave[toonSaveKey] == nil) then
        self.db.account.toonSave[toonSaveKey] = {}
    end
    if (self.labelName == L["FUBAR_LABEL"]) and
       (self.db.account.toonSave[toonSaveKey].LastUsed ~= nil) then
        self.labelName = self.db.account.toonSave[toonSaveKey].LastUsed
    else
        self.db.account.toonSave[toonSaveKey].LastUsed = self.labelName
    end
end

dewdropPurgeFunction = function(self,toonKey) self:PurgeCharacterData(toonKey) end

function SkillsPlusFuLt:PurgeCharacterData(toonKey)
    self.db.account.toonSave[toonKey] = nil
    self:Update()
end

-- skills management

function SkillsPlusFuLt:ToggleCategory(id, button)
	if self.db.char.hidden[id] then
		self.db.char.hidden[id] = false
	else
		self.db.char.hidden[id] = true
	end
	-- Refresh in place
	self:UpdateTooltip()
end

function SkillsPlusFuLt:AddProfessionLine(skillName)
        if (skillName == BS["Alchemy"]) then
       		dewdrop:AddLine(
        		'text', BS["Alchemy"],
	        	'func', function() CastSpell(alchemyID,BOOKTYPE_SPELL) -- CastSpellByName(BS["Alchemy"])
                                   self:UpdateText(BS["Alchemy"],BS:GetSpellIcon("Alchemy"))
                        end,
                'closeWhenClicked', true,                        
       			'arg1', self
                )
        end
        if (skillName == BS["Blacksmithing"]) then
       		dewdrop:AddLine(
        		'text', BS["Blacksmithing"],
	        	'func', function() CastSpellByName(BS["Blacksmithing"])
                                   self:UpdateText(BS["Blacksmithing"],BS:GetSpellIcon("Blacksmithing"))
                         end,
                'closeWhenClicked', true,
      			'arg1', self
                )
        end
        if (skillName == BS["Cooking"]) then
       		dewdrop:AddLine(
        		'text', BS["Cooking"],
	        	'func', function() CastSpellByName(BS["Cooking"])
                                   self:UpdateText(BS["Cooking"],BS:GetSpellIcon("Cooking"))
                        end,
                'closeWhenClicked', true,
       			'arg1', self
                )
        end
        if (skillName == BS["Enchanting"]) then
       		dewdrop:AddLine(
        		'text', BS["Enchanting"],
	        	'func', function() CastSpellByName(BS["Enchanting"])
                                   self:UpdateText(BS["Enchanting"],BS:GetSpellIcon("Enchanting"))
                        end,
                'closeWhenClicked', true,
       			'arg1', self
                )
        end
        if (skillName == BS["Engineering"]) then
       		dewdrop:AddLine(
        		'text', BS["Engineering"],
	        	'func', function() CastSpellByName(BS["Engineering"])
                                   self:UpdateText(BS["Engineering"],BS:GetSpellIcon("Engineering"))
                        end,
                'closeWhenClicked', true,
       			'arg1', self
                )
        end
        if (skillName == BS["First Aid"]) then
       		dewdrop:AddLine(
        		'text', BS["First Aid"],
	        	'func', function() CastSpellByName(BS["First Aid"])
                                   self:UpdateText(BS["First Aid"],BS:GetSpellIcon("First Aid"))
                        end,
                'closeWhenClicked', true,
       			'arg1', self
                )
        end
        if (skillName == BS["Jewelcrafting"]) then
       		dewdrop:AddLine(
        		'text', BS["Jewelcrafting"],
	        	'func', function() CastSpellByName(BS["Jewelcrafting"])
                                   self:UpdateText(BS["Jewelcrafting"],BS:GetSpellIcon("Jewelcrafting"))
                         end,
                'closeWhenClicked', true,                
      			'arg1', self
                )
        end
        if (skillName == BS["Leatherworking"]) then
       		dewdrop:AddLine(
        		'text', BS["Leatherworking"],
	        	'func', function() CastSpellByName(BS["Leatherworking"])
                                   self:UpdateText(BS["Leatherworking"],BS:GetSpellIcon("Leatherworking"))
                         end,
                'closeWhenClicked', true,
      			'arg1', self
                )
        end
        if (skillName == BS["Mining"]) then
       		dewdrop:AddLine(
        		'text', BS["Smelting"],
	        	'func', function() CastSpellByName(BS["Smelting"])
                                   self:UpdateText(BS["Smelting"],BS:GetSpellIcon("Smelting"))
                        end,
                'closeWhenClicked', true,
       			'arg1', self
                )
        end
        if (skillName == BS["Poisons"]) then
       		dewdrop:AddLine(
        		'text', BS["Poisons"],
	        	'func', function() CastSpellByName(BS["Poisons"])
                                   self:UpdateText(BS["Poisons"],BS:GetSpellIcon("Poisons"))
                        end,
                'closeWhenClicked', true,
       			'arg1', self
                )
        end
        if (skillName == BS["Tailoring"]) then
       		dewdrop:AddLine(
        		'text', BS["Tailoring"],
	        	'func', function() CastSpellByName(BS["Tailoring"])
                                   self:UpdateText(BS["Tailoring"],BS:GetSpellIcon("Tailoring"))
                        end,
                'closeWhenClicked', true,
       			'arg1', self
                )
        end
end

function SkillsPlusFuLt:OnMenuRequest(level, value)
	if level == 1 then
        	for _,category in pairs(self.skillList) do
	        	if category.nonBooleanSkills > 0 then
        		        for _,skill in pairs(category.skills) do              
                                        self:AddProfessionLine(skill.name)
                                end
                        end
                end
       		if (GetNumSkillLines() > 0) then dewdrop:AddLine() end
		dewdrop:AddLine(
			'text', L["MENU_SHOW_BOOLEAN_SKILLS"],
			'func', 'ToggleShowingBooleanSkills',
			'arg1', self,
            'closeWhenClicked', true,
			'checked', self:IsShowingBooleanSkills()
		)
		dewdrop:AddLine(
			'text', L["MENU_PURGE_CHARACTER"],        -- stub for popup
			'arg1', self,
			'hasArrow', true,
			'value', "PURGE"
		)              
	elseif level == 2 then
		if value == "PURGE" then
            for k, v in pairs(self.db.account.toonSave) do
                local toonName = string.sub(k,string.find(k,'|')+1)
                local realmName = string.sub(k,1,string.find(k,'|')-1)
                if (toonName ~= UnitName('player')) and
                   (realmName == GetCVar('realmName')) then
                    local toonKey = realmName..'|'..toonName            
    				dewdrop:AddLine(
	    				'text', toonName,
                        'arg1', self, 'arg2', toonKey,
                        'func', dewdropPurgeFunction,
                        'closeWhenClicked', true
				    )
                end
			end
		end    
	end
end

function SkillsPlusFuLt:OnDataUpdate()
	local skillIndex = 0
	local skillList = {}
	local headerIndex = 0
	
	local numSkills = GetNumSkillLines()
	
	for skillIndex=1, numSkills do
		local skillName, isHeader, isExpanded, skillRank, numTempPoints, skillModifier, skillMaxRank, isAbandonable, stepCost, rankCost, minLevel, skillCostType, skillDesc = GetSkillLineInfo(skillIndex)
		
        if skillName ~= nil then
            if isHeader then
                headerIndex = headerIndex + 1
                table.insert(skillList, {category=skillName, skills={}, nonBooleanSkills = 0})
            else
                if skillMaxRank > 1 then skillList[headerIndex].nonBooleanSkills = skillList[headerIndex].nonBooleanSkills + 1 end
                table.insert(skillList[headerIndex].skills, {name = skillName,  rank = skillRank,  maxrank = skillMaxRank, rankbonus = skillModifier})
            end
        end
	end
	self.skillList = skillList
end

function SkillsPlusFuLt:UpdateText(newLabel,newIcon)
    if newIcon ~= nil then self:SetIcon(newIcon) end
    if newLabel ~= nil then
       self.labelName = newLabel
       self:UpdateToonInfo()
    end
    self:SetText(self.labelName)
end

function SkillsPlusFuLt:OnTooltipUpdate()
	tablet:SetHint(L["TOOLTIP_HINT"])
	
	for _,category in pairs(self.skillList) do
		if category.nonBooleanSkills > 0 or self:IsShowingBooleanSkills() then
			local cat = tablet:AddCategory(
				'id', category.category, 'columns', 2,
				'text', category.category,
				'func', 'ToggleCategory', 'arg1', self, 'arg2', category.category,
				'child_textR', 1, 'child_textG', 1, 'child_textB', 0,
				'showWithoutChildren', true,
				'checked', true, 'hasCheck', true, 'checkIcon', self.db.char.hidden[category.category] and "Interface\\Buttons\\UI-PlusButton-Up" or "Interface\\Buttons\\UI-MinusButton-Up"
			)
			if not self.db.char.hidden[category.category] then
				for _,skill in pairs(category.skills) do
					if skill.maxrank > 1 then
						local rank = skill.rank
						if skill.rankbonus > 0  then
							rank = rank.."(+"..skill.rankbonus..")"
						end
						rank = rank.."/"..skill.maxrank
						local r,g,b = crayon:GetThresholdColor((skill.rank+(skill.rankbonus or 0)) / skill.maxrank)
						cat:AddLine(
							'text', skill.name, 'text2', rank, 
							'text2R', r, 'text2G', g, 'text2B', b)
					elseif self:IsShowingBooleanSkills() then
						cat:AddLine('text', skill.name)
					end
				end
			end
		end
	end
end

function SkillsPlusFuLt:OnClick()
    if self.labelName == L["FUBAR_LABEL"] then
        ToggleCharacter("SkillFrame")
    else
        if chosenProfession == BS["Alchemy"] then
            CastSpell(alchemyID,BOOKTYPE_SPELL)
        else
            CastSpellByName(chosenProfession)
        end
    end
end