SkillsPlusFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0",
                                              "AceConsole-2.0",
                                              "AceDB-2.0",
                                              "AceEvent-2.0" -- ,
                                              -- "AceHook-2.1"       -- not required
                                              )
-- variables
local L         = AceLibrary("AceLocale-2.2"):new("SkillsPlusFu")
local crayon    = LibStub("LibCrayon-3.0")
local tablet    = AceLibrary("Tablet-2.0")
local dewdrop   = AceLibrary("Dewdrop-2.0")

local chosenProfession = L["FUBAR_LABEL"]
local toonSaveKey = ''
local toonFaction = ''

-- set properties                                             
SkillsPlusFu.clickableTooltip = true
SkillsPlusFu.canHideText      = true
SkillsPlusFu.defaultPosition  = "RIGHT"
SkillsPlusFu.hasIcon	  =	select(3, GetSpellInfo(4036))
SkillsPlusFu.hasNoColor       = true

-- register stuff
SkillsPlusFu:RegisterDB("SkillsPlusFuDB")
SkillsPlusFu:RegisterDefaults("char", {
                                  hidden = {},                -- hidden nodes
                                  lastUsed = '',              -- last used skill
                                      } 
                             )
SkillsPlusFu:RegisterDefaults("profile", {
                                  -- flags
                                  showBooleanSkills = false,
                                  showLanguageSkills = true,
                                  showWeaponSkills = true,
                                  showCrossFactionSkills = false,
                                  showNotification = false,
                                  showPlayerNames = true,
                                  showSkillLabel = true,
                                  }
                              )
SkillsPlusFu:RegisterDefaults("account", {
                                  -- lists                                  
                                  cooldownSave = {},         -- cooldown info per character (middle part of list)
                                  skillsSave = {},           -- skills per character (last part of list)
                                  toonSave = {},             -- saves the faction of each toon   
                                  }
                              )
SkillsPlusFu:RegisterChatCommand(L["CMD_OPTIONS"], options)

-- menu toggles

function SkillsPlusFu:IsShowingSkillLabel()
	return self.db.profile.showSkillLabel
end

function SkillsPlusFu:ToggleShowingSkillLabel()
	self.db.profile.showSkillLabel = not self.db.profile.showSkillLabel
	self:UpdateText()
	return self.db.profile.showSkillLabel
end

function SkillsPlusFu:IsShowingCrossFactionSkills()
	return self.db.profile.showCrossFactionSkills
end

function SkillsPlusFu:ToggleCrossFactionSkills()
	self.db.profile.showCrossFactionSkills = not self.db.profile.showCrossFactionSkills
    self:Update()
	return self.db.profile.showCrossFactionSkills
end

function SkillsPlusFu:IsShowingBooleanSkills()
	return self.db.profile.showBooleanSkills
end

function SkillsPlusFu:ToggleShowingBooleanSkills()
	self.db.profile.showBooleanSkills = not self.db.profile.showBooleanSkills
	self:UpdateTooltip()
	return self.db.profile.showBooleanSkills
end

function SkillsPlusFu:IsShowingLanguageSkills()
	return self.db.profile.showLanguageSkills
end

function SkillsPlusFu:ToggleShowingLanguageSkills()
	self.db.profile.showLanguageSkills = not self.db.profile.showLanguageSkills
	self:UpdateTooltip()
	return self.db.profile.showLanguageSkills
end

function SkillsPlusFu:IsShowingWeaponSkills()
	return self.db.profile.showWeaponSkills
end

function SkillsPlusFu:ToggleShowingWeaponSkills()
	self.db.profile.showWeaponSkills = not self.db.profile.showWeaponSkills
	self:UpdateTooltip()
	return self.db.profile.showWeaponSkills
end

function SkillsPlusFu:IsShowingPlayerNames()
	return self.db.profile.showPlayerNames
end

function SkillsPlusFu:ToggleShowingPlayerNames()
	self.db.profile.showPlayerNames = not self.db.profile.showPlayerNames
	self:UpdateTooltip()
	return self.db.profile.showPlayerNames
end

function SkillsPlusFu:IsShowNotification()
	return self.db.profile.showNotification
end

function SkillsPlusFu:ToggleShowNotification()
	self.db.profile.showNotification = not self.db.profile.showNotification
	self:UpdateTooltip()
	return self.db.profile.showNotification
end

-- update

function SkillsPlusFu:OnUpdate(difference)
	if(self:IsShowNotification()) then
		for k, v in pairs(self.db.account.cooldownSave) do
			for itemName, itemTable in pairs(v) do      
                local remaining = ((itemTable.Cooldown + itemTable.LastCheck) - time())
                if (remaining <= COOLDOWN_NOTIFYTIME) then
                    if (self.db.account.cooldownSave[k][itemName].IsReady ~= 1) then
                        local _, _, realm, player = string.find(k, '^(.+)\|(.+)$')
                        -- do not show notification for hidden items
                        if not itemTable.Hide then             
                            if (remaining <= 0) then
                                self:Print(format(L["COOLDOWN_IS_READY"], itemName, realm, player))
                            else
                                self:Print(format(L["COOLDOWN_WILL_BE_READY"], itemName, realm, player))
                            end
                            PlaySound('AuctionWindowOpen')
                            self.db.account.cooldownSave[k][itemName].IsReady = 1
                            self:Update()
                        end 
                    end
                end
			end
		end
	end
end

-- init/exit functions

function SkillsPlusFu:OnInitialize()
	self.skillList = {}
end

function SkillsPlusFu:OnEnable()
    -- skills management
	self:RegisterEvent('SKILL_LINES_CHANGED','Update') 
	self:RegisterEvent('PLAYER_LEVEL_UP','Update')
	
    -- cooldown management
    self:RegisterEvent('TRADE_SKILL_UPDATE')
	self:RegisterEvent('CRAFT_UPDATE')
    -- combat log tracking
    self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
    
    self:ScheduleRepeatingEvent(self.name, self.OnUpdate, COOLDOWN_TIMER_FREQUENCY, self) 
    
    -- variables
    toonSaveKey = GetCVar('realmName')..'|'..UnitName('player')
    toonFaction = UnitFactionGroup('player')

    for i = 1,99 do
		local spellName = GetSpellName(i, BOOKTYPE_SPELL)
		if not spellName then
			break
		end
	end

	self:UpdateToonInfo()
	self:UpdateData()
 end

function SkillsPlusFu:OnDisable()
    self:CancelScheduledEvent(self.name)
end

-- toon management

function SkillsPlusFu:UpdateToonInfo()
    if (self.db.account.toonSave[toonSaveKey] == nil) then
        self.db.account.toonSave[toonSaveKey] = {}
    end
    if self.db.account.toonSave[toonSaveKey].Faction == nil then
        self.db.account.toonSave[toonSaveKey].Faction = toonFaction
    end
    if self.db.account.toonSave[toonSaveKey].Hide == nil then
        self.db.account.toonSave[toonSaveKey].Hide = false
    end
    
    if (chosenProfession == L["FUBAR_LABEL"]) and 
       (self.db.char.lastUsed ~= '') then
        chosenProfession = self.db.char.lastUsed
    else 
        self.db.char.lastUsed = chosenProfession
    end    
end

function SkillsPlusFu:ShowEntry(toonKey)
    if self.db.account.skillsSave[toonKey] == nil then
        return self:IsShowingCrossFactionSkills()
    else 
        if self.db.account.toonSave[toonKey].Faction == nil then
            return self:IsShowingCrossFactionSkills()
       else
            return (toonFaction == self.db.account.toonSave[toonKey].Faction) or 
                   (self:IsShowingCrossFactionSkills())
        end
    end
end

local dewdropPurgeFunction = function(self,toonKey) self:PurgeCharacterData(toonKey) end

function SkillsPlusFu:PurgeCharacterData(targetToon)
    self.db.account.toonSave[targetToon] = nil
    self.db.account.toonSave[targetToon] = nil
    self.db.account.skillsSave[targetToon] = nil
    self:Update()
end

local dewdropToggleHideSkill = function(self,toonKey,skillName) self:ToggleHideSkill(toonKey,skillName) end

function SkillsPlusFu:ToggleHideSkill(toonKey,skillName)
    if self.db.account.skillsSave[toonKey][skillName].Hide == nil then
        self.db.account.skillsSave[toonKey][skillName].Hide = false
    end    
    self.db.account.skillsSave[toonKey][skillName].Hide = not self.db.account.skillsSave[toonKey][skillName].Hide
    self:Update()
end

local dewdropToggleHideToon = function(self,toonKey) self:ToggleHideToon(toonKey) end

function SkillsPlusFu:ToggleHideToon(toonKey)
    self.db.account.toonSave[toonKey].Hide = not self.db.account.toonSave[toonKey].Hide
end

function SkillsPlusFu:GetHideToon(toonKey)
    return self.db.account.toonSave[toonKey].Hide
end


-- cooldown management

function SkillsPlusFu:CooldownRemaining(timeStamp)
    local timeRemaining = {}
          timeRemaining.d = 0
          timeRemaining.h = 0
          timeRemaining.m = 0
          timeRemaining.s = 0

    -- 86,400 seconds equals one day
    if (timeStamp >= 86400) then
        timeRemaining.d = floor(timeStamp / 86400)
        timeStamp = (timeStamp - (timeRemaining.d * 86400))
    end
    -- 3,600 seconds equals one hour
    if (timeStamp >= 3600) then
        timeRemaining.h = floor(timeStamp / 3600)
        timeStamp = (timeStamp - (timeRemaining.h * 3600))
    end
    -- 60 seconds equals one minute
    if ( timeStamp >= 60 ) then
        timeRemaining.m = floor(timeStamp / 60)
        timeStamp = (timeStamp - (timeRemaining.m * 60))
    end
    -- add remaining seconds
    timeRemaining.s = timeStamp
    
    return timeRemaining
end

function SkillsPlusFu:WriteCooldownInfo(itemName,cooldown)
    -- general cooldown function
    if (cooldown == nil) then cooldown = 0 end
--    self:Print('Logging: '..toonSaveKey..' '..itemName..' '..format(cooldown))        

    if (self.db.account.cooldownSave[toonSaveKey] == nil) then
        self.db.account.cooldownSave[toonSaveKey] = {}
    end
    if (self.db.account.cooldownSave[toonSaveKey][itemName] == nil) then
        self.db.account.cooldownSave[toonSaveKey][itemName] = {}
    end
    self.db.account.cooldownSave[toonSaveKey][itemName].Cooldown = cooldown
    self.db.account.cooldownSave[toonSaveKey][itemName].LastCheck = time()
    self.db.account.cooldownSave[toonSaveKey][itemName].IsReady = 0
    if self.db.account.cooldownSave[toonSaveKey][itemName].Hide == nil then 
      self.db.account.cooldownSave[toonSaveKey][itemName].Hide = false
    end

end

function SkillsPlusFu:COMBAT_LOG_EVENT_UNFILTERED(_, eventType, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags, spellId, spellName, spellSchool, amount, ...)
    if (srcName ~= nil) and 
       (srcName == UnitName("player")) then
          if eventType == "SPELL_CAST_START" then
            local cooldownSpell = false        
            local itemName = nil
            local cooldown = nil
            
            if spellId == 19566 then                          -- Salt Shaker           
                itemName = L["COOLDOWN_SALT_SHAKER"]
                cooldown = 252000                             -- 252000 (70 hours), used to be 259200 (72 hours); before 2.4.2
                cooldownSpell = true
            end 
            
            if spellId == 21935 then                          -- Snowmaster 9000
                itemName = L["COOLDOWN_SNOWMASTER"]
                cooldown = 72000                              -- 72000 (20 hours), used to be 86400 (24 hours); before 2.4.2
                cooldownSpell = true
            end
            
            if spellId == 26265 then                          -- Create Elune Stone
                itemName = L["COOLDOWN_ELUNES_LANTERN"]
                cooldown = 72000                              -- 72000 (20 hours), used to be 86400 (24 hours); before 2.4.2
                cooldownSpell = true
            end
            
            if cooldownSpell then 
                self:WriteCooldownInfo(itemName,cooldown)
                self:Update()                                    
            end
        end
    end   
    -- self:Print('CLE '..crayon:Orange(srcName)..' '..crayon:Orange(dstName)..' '..crayon:Orange(eventType)..' '..crayon:Orange(spellName)..' '..crayon:Orange( spellId)) 
end

function SkillsPlusFu:CRAFT_UPDATE()

    local enchantingCooldown = false    
    local cooldownItem = nil
    local cooldown = nil
    
	local numSkills = GetNumCrafts()
	for i=1, numSkills do
		local itemName, _, _, _, _, _, _ = GetCraftInfo(i)
		
        -- enchanting cooldowns share the same timer
		if (itemName == GetSpellInfo(28027) or -- Prismatic Sphere
            itemName == GetSpellInfo(28028)) then -- Void Sphere
            cooldownItem = L["COOLDOWN_ENCHANTING"]           
            cooldown = GetCraftCooldown(i)
            enchantingCooldown = true
		end
	end
    
    if enchantingCooldown then    
        self:WriteCooldownInfo(cooldownItem,cooldown)
        self:Update()                                    
    end
end


function SkillsPlusFu:TRADE_SKILL_UPDATE()

    local alchemyCooldown = false
    local cooldownItem = nil
    local cooldown = nil
    
	local numSkills = GetNumTradeSkills()
	for i=1, numSkills do
		local itemName = GetTradeSkillInfo(i)		
        -- check alchemy cooldowns by spellID
        if alchemyCooldown == false  then
            if( itemName == GetSpellInfo(11479) or              -- Transmute: Iron to Gold
                itemName == GetSpellInfo(11480) or              -- Transmute: Earth Mithril to Truesilver
                -- itemName == GetSpellInfo(17187) or           -- Transmute: Arcanite removed cooldown in 2,4
                itemName == GetSpellInfo(17559) or              -- Transmute: Air to Fire
                itemName == GetSpellInfo(17566) or              -- Transmute: Earth to Life
                itemName == GetSpellInfo(17561) or              -- Transmute: Earth to Water
                itemName == GetSpellInfo(17560) or              -- Transmute: Fire to Earth
                itemName == GetSpellInfo(17565) or              -- Transmute: Life to Earth           
                itemName == GetSpellInfo(17563) or              -- Transmute: Undeath to Water
                itemName == GetSpellInfo(17562) or              -- Transmute: Water to Air            
                itemName == GetSpellInfo(17564) or              -- Transmute: Water to Undeath
                itemName == GetSpellInfo(25146) or              -- Transmute: Elemental Fire            
                -- TBC
                itemName == GetSpellInfo(29688) or              -- Transmute: Primal Might
                itemName == GetSpellInfo(28566) or              -- Transmute: Primal Air to Fire
                itemName == GetSpellInfo(28567) or              -- Transmute: Primal Earth to Water
                itemName == GetSpellInfo(28568) or              -- Transmute: Primal Fire to Earth
                itemName == GetSpellInfo(28569) or              -- Transmute: Primal Water to Air
                itemName == GetSpellInfo(28585) or              -- Transmute: Primal Earth to Life
                itemName == GetSpellInfo(28583) or              -- Transmute: Primal Fire to Mana
                itemName == GetSpellInfo(28584) or              -- Transmute: Primal Life to Earth
                itemName == GetSpellInfo(28582) or              -- Transmute: Primal Mana to Fire
                itemName == GetSpellInfo(28580) or              -- Transmute: Primal Shadow to Water
                itemName == GetSpellInfo(28581) or              -- Transmute: Primal Water to Shadow
                -- WotLK
                itemName == GetSpellInfo(54020) or              -- Transmute: Eternal Might           
                itemName == GetSpellInfo(53777) or              -- Transmute: Eternal Air to Earth
                itemName == GetSpellInfo(52776) or              -- Transmute: Eternal Air to Water
                itemName == GetSpellInfo(53781) or              -- Transmute: Eternal Earth to Air
                itemName == GetSpellInfo(53782) or              -- Transmute: Eternal Earth to Shadow
                itemName == GetSpellInfo(53775) or              -- Transmute: Eternal Fire to Life
                itemName == GetSpellInfo(53774) or              -- Transmute: Eternal Fire to Water
                itemName == GetSpellInfo(53773) or              -- Transmute: Eternal Life to Fire
                itemName == GetSpellInfo(53771) or              -- Transmute: Eternal Life to Shadow
                itemName == GetSpellInfo(53779) or              -- Transmute: Eternal Shadow to Earth
                itemName == GetSpellInfo(52780) or              -- Transmute: Eternal Shadow to Life
                itemName == GetSpellInfo(53783) or              -- Transmute: Eternal Water to Air
                itemName == GetSpellInfo(53784)                 -- Transmute: Eternal Water to Fire
                ) then
                cooldownItem = L["COOLDOWN_TRANSMUTES"]
                cooldown = GetTradeSkillCooldown(i)
                if (cooldown == nil) then cooldown = 0 end      -- safety catch; should cooldown be removed (or wrong spell ID used
                -- self:Print('Found: '..itemName..format(cooldown)) 
                
                -- write alchemy cooldown information to the database
                self:WriteCooldownInfo(cooldownItem,cooldown)   
                alchemyCooldown = true
            end
        end
        
        -- check for tailoring and jewelcrafting cooldowns each with a specific cooldown
		if ( -- itemName == GetSpellInfo(18560) or              -- Mooncloth (cooldown removed in 2.4.3)
            itemName == GetSpellInfo(26751) or              -- Primal Mooncloth
            itemName == GetSpellInfo(31373) or              -- Spellcloth
            itemName == GetSpellInfo(36686) or              -- Shadowcloth
			itemName == GetSpellInfo(47280)) then           -- Brilliant Glass
            
            -- write the actual cooldown information to the database
            self:WriteCooldownInfo(itemName,GetTradeSkillCooldown(i))
        end       
	end
	self:Update()
end

local dewdropToggleHideCooldown = function(self,toonKey,itemName) self:ToggleHideCooldown(toonKey,itemName) end

function SkillsPlusFu:ToggleHideCooldown(toonKey,itemName)
    if self.db.account.cooldownSave[toonKey][itemName].Hide == nil then
        self.db.account.cooldownSave[toonKey][itemName].Hide = false
    end    
    self.db.account.cooldownSave[toonKey][itemName].Hide = not self.db.account.cooldownSave[toonKey][itemName].Hide
    self:Update()
end

function SkillsPlusFu:ClearCooldownData()
	self.db.account.cooldownSave = {}
	self:Update()
end

-- skills management

function SkillsPlusFu:AddProfessionLine(skillName)
        -- Alchemy
		if (skillName == GetSpellInfo(2259)) then
			local spellname,_,tmpicon = GetSpellInfo(2259)
       		dewdrop:AddLine(
        		'text', spellname,
	        	'func', function() CastSpellByName(spellname)
                                   self:UpdateText(spellname,tmpicon)
                        end,
                'closeWhenClicked', true,                
       			'arg1', self
                )
        end
		-- Blacksmithing
        if (skillName == GetSpellInfo(2018)) then
			local spellname,_,tmpicon = GetSpellInfo(2018)
       		dewdrop:AddLine(
        		'text', spellname,
	        	'func', function() CastSpellByName(spellname)
                                   self:UpdateText(spellname,tmpicon)
                         end,
                'closeWhenClicked', true,                
      			'arg1', self
                )
        end
		-- Cooking
        if (skillName == GetSpellInfo(2550)) then
			local spellname,_,tmpicon = GetSpellInfo(2550)
       		dewdrop:AddLine(
        		'text', spellname,
	        	'func', function() CastSpellByName(spellname)
                                   self:UpdateText(spellname,tmpicon)
                        end,
                'closeWhenClicked', true,                
       			'arg1', self
                )
        end
		-- Enchanting
        if (skillName == GetSpellInfo(7411)) then
       		local spellname,_,tmpicon = GetSpellInfo(7411)
			dewdrop:AddLine(
        		'text', spellname,
	        	'func', function() CastSpellByName(spellname)
                                   self:UpdateText(spellname,tmpicon)
                        end,
                'closeWhenClicked', true,                
       			'arg1', self
                )
        end
		-- Engineering
        if (skillName == GetSpellInfo(4036)) then
			local spellname,_,tmpicon = GetSpellInfo(4036)
       		dewdrop:AddLine(
        		'text', spellname,
	        	'func', function() CastSpellByName(spellname)
                                   self:UpdateText(spellname,tmpicon)
                        end,
                'closeWhenClicked', true,                
       			'arg1', self
                )
        end
		-- First Aid
        if (skillName == GetSpellInfo(3273)) then
			local spellname,_,tmpicon = GetSpellInfo(3273)
       		dewdrop:AddLine(
        		'text', spellname,
	        	'func', function() CastSpellByName(spellname)
                                   self:UpdateText(spellname,tmpicon)
                        end,
                'closeWhenClicked', true,                
       			'arg1', self
                )
        end
		-- Jewelcrafting
        if (skillName == GetSpellInfo(25229)) then
       		local spellname,_,tmpicon = GetSpellInfo(25229)
			dewdrop:AddLine(
        		'text', spellname,
	        	'func', function() CastSpellByName(spellname)
                                   self:UpdateText(spellname,tmpicon)
                         end,
                'closeWhenClicked', true,                
      			'arg1', self
                )
        end
		-- Leatherworking
        if (skillName == GetSpellInfo(2108)) then
       		local spellname,_,tmpicon = GetSpellInfo(2108)
			dewdrop:AddLine(
        		'text', spellname,
	        	'func', function() CastSpellByName(spellname)
                                   self:UpdateText(spellname,tmpicon)
                         end,
                'closeWhenClicked', true,                
      			'arg1', self
                )
        end
		-- Mining
        if (skillName == GetSpellInfo(2575)) then
       		local spellname,_,tmpicon = GetSpellInfo(2656)
			dewdrop:AddLine(
        		'text', spellname,
	        	'func', function() CastSpellByName(spellname)
                                   self:UpdateText(spellname,tmpicon)
                        end,
                'closeWhenClicked', true,                
       			'arg1', self
                )
        end
		-- Poisons
        if (skillName == GetSpellInfo(2842)) then
       		local spellname,_,tmpicon = GetSpellInfo(2842)
			dewdrop:AddLine(
        		'text', spellname,
	        	'func', function() CastSpellByName(spellname)
                                   self:UpdateText(spellname,tmpicon)
                        end,
                'closeWhenClicked', true,                
       			'arg1', self
                )
        end
		-- Tailoring
        if (skillName == GetSpellInfo(3908)) then
       		local spellname,_,tmpicon = GetSpellInfo(3908)
			dewdrop:AddLine(
        		'text', spellname,
	        	'func', function() CastSpellByName(spellname)
                                   self:UpdateText(spellname,tmpicon)
                        end,
                'closeWhenClicked', true,                
       			'arg1', self
                )
        end
end

function SkillsPlusFu:SaveProfession(skillName,skillRank,skillMaxRank,skillModifier)
    if (skillName == GetSpellInfo(2259)) or
       (skillName == GetSpellInfo(2018)) or
       (skillName == GetSpellInfo(2550)) or
       (skillName == GetSpellInfo(7411)) or
       (skillName == GetSpellInfo(4036)) or
       (skillName == GetSpellInfo(3273)) or
       (skillName == GetSpellInfo(7620)) or       
       (skillName == GetSpellInfo(9134)) or       
       (skillName == GetSpellInfo(25229)) or
       (skillName == GetSpellInfo(2108)) or
       (skillName == GetSpellInfo(2575)) or       
       (skillName == GetSpellInfo(8613)) or       
       (skillName == GetSpellInfo(3908)) then
      	if (self.db.account.skillsSave[toonSaveKey] == nil) then
          	self.db.account.skillsSave[toonSaveKey] = {}
         end
         if (self.db.account.skillsSave[toonSaveKey][skillName] == nil) then
        	self.db.account.skillsSave[toonSaveKey][skillName] = {}
        end
        self.db.account.skillsSave[toonSaveKey][skillName].Rank = skillRank
        self.db.account.skillsSave[toonSaveKey][skillName].MaxRank = skillMaxRank
        self.db.account.skillsSave[toonSaveKey][skillName].Modifier = skillModifier
    end
end

-- general

function SkillsPlusFu:OnMenuRequest(level, value)
	if level == 1 then
        local cooldownFound = false
    	for _,category in pairs(self.skillList) do
            -- items are added with other toon skills following cooldown items
            -- just stop adding skill menus when cooldown entry is found to stop
            -- other toon skills showing up in the menu
            if not cooldownFound then
  	    	    if category.nonBooleanSkills > 0 then
    		        for _,skill in pairs(category.skills) do 
                        self:AddProfessionLine(skill.name)
                    end
                end
                cooldownFound = category.category == L["COOLDOWN_CATEGORY"]                
            end
        end
        
       	if (GetNumSkillLines() > 0) then dewdrop:AddLine() end
		-- add TradeSkillInfo menu
		if TradeskillInfo and TradeskillInfo:IsActive() then
			dewdrop:AddLine(
				'text', BINDING_HEADER_TRADESKILLINFO,
				'func', TradeskillInfo.UI_Toggle,
	            'closeWhenClicked', true,
	 			'arg1', TradeskillInfo
			);
			dewdrop:AddLine();
		end
       	-- add regular menu options
		dewdrop:AddLine(
			'text', L["MENU_SHOW_SKILL_LABEL"],       -- toggles skill name in fubar menu
    		'func', 'ToggleShowingSkillLabel',
 			'arg1', self,
            'closeWhenClicked', true,                
			'checked', self:IsShowingSkillLabel()
		)
		dewdrop:AddLine(
			'text', L["MENU_SHOW_BOOLEAN_SKILLS"],    -- toggles boolean skill visibility
			'func', 'ToggleShowingBooleanSkills',
			'arg1', self,
            'closeWhenClicked', true,                
			'checked', self:IsShowingBooleanSkills()
		)
		dewdrop:AddLine(
			'text', L["MENU_SHOW_LANGUAGE_SKILLS"],    -- toggles Language skill visibility
			'func', 'ToggleShowingLanguageSkills',
			'arg1', self,
            'closeWhenClicked', true,                
			'checked', self:IsShowingLanguageSkills()
		)
		dewdrop:AddLine(
			'text', L["MENU_SHOW_WEAPON_SKILLS"],    -- toggles Weapon skill visibility
			'func', 'ToggleShowingWeaponSkills',
			'arg1', self,
            'closeWhenClicked', true,                
			'checked', self:IsShowingWeaponSkills()
		)
		dewdrop:AddLine(
			'text', L["MENU_SHOW_OTHER_TOON_SKILLS"],    -- stub for popup
			'arg1', self,
			'hasArrow', true,
			'value', "SHOW_TOON"
		)        
		dewdrop:AddLine(
			'text', L["MENU_SHOW_CROSS_FACTION_SKILLS"], -- toggles cross faction skills
			'func', 'ToggleCrossFactionSkills',
			'arg1', self,
            'closeWhenClicked', true,                
			'checked', self:IsShowingCrossFactionSkills()
		)
		dewdrop:AddLine(
			'text', L["MENU_PURGE_CHARACTER"],        -- stub for popup
			'arg1', self,
			'hasArrow', true,
			'value', "PURGE"
		)        
		dewdrop:AddLine()                             -- separator
		dewdrop:AddLine(
			'text', L["MENU_SHOW_TOON_NAMES"],        -- toggles player names in cooldown items
			'func', 'ToggleShowingPlayerNames',
			'arg1', self,
            'closeWhenClicked', true,                
			'checked', self:IsShowingPlayerNames()
		)
		dewdrop:AddLine(
			'text', L["MENU_SHOW_NOTIFICATION"],      -- toggles cooldown notification
			'func', 'ToggleShowNotification',
			'arg1', self,
            'closeWhenClicked', true,                
			'checked', self:IsShowNotification()
		)
        dewdrop:AddLine(
			'text', L["MENU_HIDE_COOLDOWN_FOR"],      -- stub for popup
			'arg1', self,
			'hasArrow', true,
			'value', "HIDE_COOLDOWN"
        )
		dewdrop:AddLine(
			'text', L["MENU_CLEAR_COOLDOWN_DATA"],    -- clears saved cooldown data
			'func', 'ClearCooldownData',
            'closeWhenClicked', true,                
			'arg1', self
		)
		dewdrop:AddLine()                             -- separator
	elseif level == 2 then
		if value == "SHOW_TOON" then                  -- stub for popup
            for k, v in pairs(self.db.account.skillsSave) do
                local toonName = string.sub(k,string.find(k,'|')+1)
                local realmName = string.sub(k,1,string.find(k,'|')-1)
                if toonName ~= UnitName('player') and
                   realmName == GetCVar('realmName') and
                   toonFaction == self.db.account.toonSave[k].Faction then                  
                    local toonKey = realmName..'|'..toonName            
    				dewdrop:AddLine(
	    				'text', toonName,
                        'arg1', self,
                        'hasArrow', true,
                        'value', k
				    )
                end
			end
		end    
		if value == "PURGE" then
            for k, v in pairs(self.db.account.skillsSave) do
                local toonName = string.sub(k,string.find(k,'|')+1)
                local realmName = string.sub(k,1,string.find(k,'|')-1)
                if toonName ~= UnitName('player') and
                   realmName == GetCVar('realmName') then
                    local toonKey = realmName..'|'..toonName            
    				dewdrop:AddLine(
	    				'text', toonName,
                        'arg1', self, 'arg2', toonKey,
                        'func', dewdropPurgeFunction,
                        'closeWhenClicked', true
				    )
                end
			end
		end
		if value == "HIDE_COOLDOWN" then
	        for _,category in pairs(self.skillList) do
                if category.category == L["COOLDOWN_CATEGORY"] then
                    for _,skill in pairs(category.skills) do
                        dewdrop:AddLine(
                            'text', skill.name,
                            'arg1', self, 'arg2', skill.toonKey, 'arg3', skill.itemName,
                            'func', dewdropToggleHideCooldown,
                            'checked', skill.hide,
                            'closeWhenClicked', true
                        )
                    end
                end
            end
        end
	elseif level == 3 then
        -- toggles other player skills
        for key, skillList in pairs(self.db.account.skillsSave) do
            if value == key then
                dewdrop:AddLine(
                    'text', L["MENU_HIDE_TOON"],
                    'arg1', self, 'arg2', key,
                    'func', dewdropToggleHideToon,
                    'checked', self:GetHideToon(key),
                    'closeWhenClicked', true
                )
            
                for skillName, skill in pairs(skillList) do
                    dewdrop:AddLine(
                        'text', skillName,
                        'arg1', self, 'arg2', key, 'arg3', skillName,
                        'func', dewdropToggleHideSkill,
                        'checked', not skill.Hide
                    )
                end
            end
        end
	end
end

function SkillsPlusFu:OnDataUpdate()
	local skillIndex = 0
	local skillList = {}
	local headerIndex = 0
	
	local numSkills = GetNumSkillLines()
	
	for skillIndex=1, numSkills do
		local skillName, isHeader, isExpanded, skillRank, numTempPoints, skillModifier, skillMaxRank,
              isAbandonable, stepCost, rankCost, minLevel, skillCostType, showSkill,
              skillDesc = GetSkillLineInfo(skillIndex)

        if skillName ~= nil then
            if isHeader then
                headerIndex = headerIndex + 1
                table.insert(skillList, {category=skillName, skills={}, nonBooleanSkills = 0})
            else
                if skillMaxRank > 1 then
                   skillList[headerIndex].nonBooleanSkills = skillList[headerIndex].nonBooleanSkills + 1
                end
                table.insert(skillList[headerIndex].skills, {name = skillName,  rank = skillRank,
                             maxrank = skillMaxRank, rankbonus = skillModifier})
                self:SaveProfession(skillName,skillRank,skillMaxRank,skillModifier)
            end
        end
	end
	
	-- add cooldown header and items
	local toonName = ''
	headerIndex = headerIndex + 1
	table.insert(skillList, {category=L["COOLDOWN_CATEGORY"], skills={}, nonBooleanSkills = 0})
    for k, v in pairs(self.db.account.cooldownSave) do
        if self:IsShowingPlayerNames() then
          toonName = string.sub(k,string.find(k,'|')+1)..': '
        end
		local foo = k
        for itemName, itemTable in pairs(v) do
            skillList[headerIndex].nonBooleanSkills = skillList[headerIndex].nonBooleanSkills + 1
			if itemName == true then
				itemName = nil
			else
            table.insert(skillList[headerIndex].skills, {name = toonName..itemName,
                         rank = itemTable.Cooldown,
                         maxrank = itemTable.LastCheck,
                         rankbonus = itemTable.IsReady,
                         hide = itemTable.Hide,
                         toonKey = k,
                         itemName = itemName}
                        )
			end
        end
    end
    
    -- add other toon skills
    for k, v in pairs(self.db.account.skillsSave) do
        toonName = string.sub(k,string.find(k,'|')+1)
        local realmName = string.sub(k,1,string.find(k,'|')-1)
        if (toonName ~= UnitName('player')) and
           (self:ShowEntry(k)) and
           (realmName == GetCVar('realmName')) then
            headerIndex = headerIndex + 1
            table.insert(skillList, {category=toonName, skills={}, nonBooleanSkills = 0})
            for skillName, skillTable in pairs(v) do
                skillList[headerIndex].nonBooleanSkills = skillList[headerIndex].nonBooleanSkills + 1
                table.insert(skillList[headerIndex].skills, {name = skillName,
                             rank = skillTable.Rank,
                             maxrank = skillTable.MaxRank,
                             rankbonus = skillTable.Modifier,
                             hide = skillTable.Hide}
                            )
            end
        end
    end
    
	self.skillList = skillList
end

function SkillsPlusFu:UpdateText(newProfession,newIcon)
    if newProfession ~= nil then 
        chosenProfession = newProfession 
        self:UpdateToonInfo()  -- set lastUsed variable
    end
    if newIcon ~= nil then self:SetIcon(newIcon) end

    -- add cooldown information
    local cooldownInfo = ''
    local totalItems = 0
    local readyItems = 0
    
    -- loop and add items and ready items
    -- do not show hidden items in label
    for k, v in pairs(self.db.account.cooldownSave) do
  	    for itemName, itemTable in pairs(v) do
            if not itemTable.Hide then                     
                local remaining = ((itemTable.Cooldown + itemTable.LastCheck) - time())
                    totalItems = totalItems + 1
                if (remaining <= 0) then
                    readyItems = readyItems + 1
                end
            end
  	    end
    end
    
    -- only show cooldownInfo if there are cooldown items
    if (totalItems > 0) then
        -- set label text count colours
        if (readyItems == 0) then
            cooldownInfo = "(0/"..format(totalItems)..")"
        else
            cooldownInfo = "("..crayon:Green(readyItems).."/"..format(totalItems)..")"        
        end
    end
    
    -- add skill label is toggle is true
    if self:IsShowingSkillLabel() then
        self.labelName = chosenProfession..' '..cooldownInfo
	else
	    self.labelName = cooldownInfo
    end
    
    -- set the actual label
	self:SetText(self.labelName)
end

function SkillsPlusFu:ToggleCategory(id, button)
    -- hidden is character specific data
    self.db.char.hidden[id] = not self.db.char.hidden[id]
	-- refresh in place
	self:UpdateTooltip()
end

function SkillsPlusFu:ShowCategory(category)
    local toonKey = GetCVar('realmName')..'|'..category.category
    if self.db.account.toonSave[toonKey] ~= nil then
        return not self.db.account.toonSave[toonKey].Hide
    else
        return category.nonBooleanSkills > 0 or 
               self:IsShowingBooleanSkills() 
    end
end

function SkillsPlusFu:OnTooltipUpdate()
	tablet:SetHint(L["TOOLTIP_HINT"])
	-- skills
	for _,category in pairs(self.skillList) do
        if not ((category.category == L["CATEGORY_LANGUAGES"] and not self.db.profile.showLanguageSkills) or
                (category.category == L["CATEGORY_WEAPON_SKILLS"] and not self.db.profile.showWeaponSkills)) then                   
            if self:ShowCategory(category) then
                local tooltipLine = tablet:AddCategory('id', category.category, 'columns', 2,
                                       'text', category.category,
                                       'func', 'ToggleCategory', 'arg1', self, 'arg2', category.category,
                                       'child_textR', 1, 'child_textG', 1, 'child_textB', 0,
                                       'showWithoutChildren', true,
                                       'checked', true, 'hasCheck', true, 'checkIcon',
                                       self.db.char.hidden[category.category] and 'Interface\\Buttons\\UI-PlusButton-Up' or 'Interface\\Buttons\\UI-MinusButton-Up'
                )
                if not self.db.char.hidden[category.category] then
                    for _,skill in pairs(category.skills) do
                        if not skill.hide then
                            if category.category ~= L["COOLDOWN_CATEGORY"] then
                                -- is either current toon skill or other toon skill
                                if skill.maxrank > 1 then
                                    local rank = skill.rank
                                    if skill.rankbonus > 0  then
                                        rank = rank..'(+'..skill.rankbonus..')'
                                    end
                                    rank = rank..'/'..skill.maxrank
                                    local r,g,b = crayon:GetThresholdColor((skill.rank+(skill.rankbonus or 0)) / skill.maxrank)
                                    tooltipLine:AddLine('text', skill.name, 'text2', rank,
                                                        'text2R', r, 'text2G', g, 'text2B', b)
                                elseif self:IsShowingBooleanSkills() then
                                    tooltipLine:AddLine('text', skill.name)
                                end
                            else  -- is cooldown item
                                -- rank contains itemTable.Cooldown, max rank contains itemTable.LastCheck
                                local timeRemaining = ((skill.rank + skill.maxrank) - time())
                                local timeRemainingText = ''

                                if (timeRemaining <= 0) then
                                    timeRemainingText = crayon:Green(L["COOLDOWN_READY"])
                                else
                                    local timeTable = self:CooldownRemaining(timeRemaining)
                                    local timeString = string.format(L["COOLDOWN_TIME_FORMAT"], timeTable.d, timeTable.h, timeTable.m)
                                    if ((timeTable.d == 0) and (timeTable.h == 0)) then
                                       timeRemainingText = crayon:Orange(timeString)
                                    else
                                        timeRemainingText = crayon:Red(timeString)
                                    end
                                end
                                tooltipLine:AddLine('text', skill.name, 'text2', timeRemainingText)
                            end
                        end
                    end
                end
            end
        end
    end
end

function SkillsPlusFu:OnClick()    
	if self.chosenProfession == L["FUBAR_LABEL"] then
		ToggleCharacter('SkillFrame')
	else
		CastSpellByName(chosenProfession)
	end
end
