ShardCountFu = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0","AceEvent-2.0","FuBarPlugin-2.0")
ShardCountFu:RegisterChatCommand({"/shardcount", "/sc"}, options)

ShardCountFu.hasIcon = true
ShardCountFu.defaultPosition = "LEFT"

local shardCount = 0;
local showExtendedText = false;
local L = AceLibrary("AceLocale-2.2"):new("Fubar_SoulShardFu")
local soulShard = L["Soul shard"]

ShardCountFu.OnMenuRequest = {
	type='group',
	args = {
        extendedtext = {
            type = 'toggle',
            name = L["Extended text"],
            desc = L["Show extended text"],
            get = "IsExtendedText",
            set = "ToggleExtendedText",
        },
    },
}

-- Register Event an get initial shard count...
function ShardCountFu:OnEnable()
	self:RegisterEvent("BAG_UPDATE")
	self:AquireCount()
end

-- Recalculate Shard count when bag got changes...
function ShardCountFu:BAG_UPDATE()
	self:AquireCount()
end

-- UnRegister Event when the addon is disabled...
function ShardCountFu:OnDisable()
	self:UnRegisterEvent("BAG_UPDATE")
end

-- Print Shard count in chat window...
function ShardCountFu:OutputShardCount()
	self:Print(string.format(L["You currently have %d shards in your bags."], shardCount))
end

-- Is extended text displayed ? 
function ShardCountFu:IsExtendedText()
	return self.showExtendedText
end

-- Toggle display of extended text...
function ShardCountFu:ToggleExtendedText()
	self.showExtendedText = not self.showExtendedText
	self:UpdateText()
end

-- Get count of shards
function ShardCountFu:AquireCount()
	newCount = 0
    for bag=0,4 do
		for slot=1,GetContainerNumSlots(bag) do
			if (GetContainerItemLink(bag,slot)) then
				if (string.find(GetContainerItemLink(bag,slot), soulShard)) then
					newCount = newCount + 1;
				end
			end
		end
	end
	if newCount ~= shardCount then
		shardCount = newCount
		self:UpdateText()
	end
end

-- Set Fubar text
function ShardCountFu:OnTextUpdate()
    if self.showExtendedText then
	    self:SetText(string.format(L["Soul shards: %d"], shardCount))
    else
	    self:SetText(string.format("%d", shardCount))
    end
end
