local Tablet = AceLibrary("Tablet-2.0")
local L = Rock("LibRockLocale-1.0"):GetTranslationNamespace("FuBar_ScaleFu")

ScaleFu = Rock:NewAddon("ScaleFu", "LibRockConfig-1.0", "LibRockConsole-1.0", "LibRockDB-1.0", "LibFuBarPlugin-3.0")

ScaleFu:SetDatabase("ScaleFuDB")
ScaleFu:SetDatabaseDefaults("profile", {})

ScaleFu:SetFuBarOption("iconPath", "Interface\\AddOns\\Fubar_ScaleFu\\Images\\Icon")
ScaleFu:SetFuBarOption("defaultPosition", "RIGHT")
ScaleFu:SetFuBarOption("tooltipType", "Tablet-2.0")
ScaleFu:SetFuBarOption("hasNoText", true)

ScaleFu.OnSlashCommand = function(self, command, text)
	assert(command == "/scalefu")
	if (tonumber(text)) then
		ScaleFu:SetScale(tonumber(text))
	else
		ScaleFu:Print(L["Only values of 0.64 to 1.0 are valid."])
	end
end
ScaleFu:AddSlashCommand("OnSlashCommand", "/scalefu")

function ScaleFu:OnInitialize()
	local optionsTable = {
		name = "FuBar_ScaleFu",
		desc = L["UI Scale Plugin for FuBar."],
		handler = ScaleFu,
		type = "group",
		args = {
			scale = {
				type = "text",
				name = L["UI Scale"],
				desc = L["Only values of 0.64 to 1.0 are valid."],
				usage = "<number>",
				get = function()
					return UIParent:GetEffectiveScale()
				end,
				set = function(value)
					ScaleFu:SetScale(tonumber(value))
				end,
			},
		},
	}

	ScaleFu:SetConfigTable(optionsTable)
	ScaleFu.OnMenuRequest = optionsTable
end

function ScaleFu:SetScale(value)
	if (value == nil) then
		value = 0.7
		ScaleFu:Print(L["Only values of 0.64 to 1.0 are valid."])
	elseif (value < 0.64) then
		value = 0.64
		ScaleFu:Print(L["The scale entered was too small and was automatically adjusted to 0.64"])
	elseif (value > 1.00) then
		value = 1.00
		ScaleFu:Print(L["The scale entered was too large and was automatically adjusted to 1.00"])
	end
	SetCVar("useUiScale", 1, USE_UISCALE)	-- Set the use UI scale option to true
	SetCVar("uiScale", value)		-- Set the UI scale
	if (FuBar) then
		FuBar:OnInitialize()		-- Refresh FuBar to correctly size itself
	end
end

function ScaleFu:OnUpdateFuBarTooltip()
	local cat = Tablet:AddCategory(
		"text", L["Current UI Scale: "]..floor(UIParent:GetEffectiveScale()*100+0.5).."%",
		"justify", "CENTER"
	)

	cat:AddLine("text", "")

	Tablet:SetHint(L["Right-click to adjust UI scale."])
end
