local L = AceLibrary("AceLocale-2.2"):new("SWStats2Fu")

SW_StatsFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceEvent-2.0", "AceDB-2.0", "AceDebug-2.0")
local dewdrop = AceLibrary("Dewdrop-2.0")

local icon_on = "Interface\\AddOns\\FuBar_SWStats2Fu\\icon_on.tga"
local icon_sws = "Interface\\Addons\\SW_Stats\\images\\SW_Icon.tga"
local icon_off = "Interface\\AddOns\\FuBar_SWStats2Fu\\icon_off.tga"
SW_StatsFu.hasIcon = icon_sws

--[[
function SW_StatsFu:IsValue()
    return self.value
end

function SW_StatsFu:ToggleValue()
    self.value = not self.value
    self:Update()
end
--]]
local SWFU_RAID_PER_SEC = RAID..L["/s"];
local SWFU_SELF_PER_SEC = SW_SELF_STRING..L["/s"];
local SWFU_Buffer = SW_ViewBuffer:new();
local SWFU_SettingsDmg = {
	CF = 1,
	SF = "SW_Filter_EverGroup",
	PF = "SW_PF_VPR",
	IN = 1,
};
local SWFU_SettingsHeal = {
	CF = 1,
	SF = "SW_Filter_EverGroup",
	PF = "SW_PF_VPR",
	IN = 2,
	HealEff = true,
	HealInF = true,
	HealOH = false,
};
local SWFU_StartVals = {
	RDmg = 0,
	RHeal = 0,
	SelfDmg = 0,
	SelfHeal = 0,
	HealRank = 0,
	DmgRank = 0,
};
local SWFU_TmpVals = {
	RDmg = 0,
	RHeal = 0,
	SelfDmg = 0,
	SelfHeal = 0,
	HealRank = 0,
	DmgRank = 0,
};
local SWFU_PS_Vals = {
	RDmg = 0,
	RHeal = 0,
	RDmgHeal = 0,
	SelfDmg = 0,
	SelfHeal = 0,
	SelfDmgHeal = 0, 
};
local SWFU_DispBuffer = {};

local SWFU_PrefightSnapshotHeal = SW_ViewBuffer:new()
local SWFU_PrefightSnapshotDmg = SW_ViewBuffer:new()

function GetDmgSnapshot(viewBuffer)
	-- get the applicable units
	local unitInfo, bSet, petFil = SW_DataCollection:getApplicableUnits(SW_InfoTypes[1], SWFU_SettingsDmg);
	-- get a snapshot of the current damage
	SW_UpdateGeneralList( true, SW_C_UnitData.getDmgDone, unitInfo, bSet, petFil, viewBuffer );
end

function GetHealSnapshot(viewBuffer)
	local unitInfo, bSet, petFil = SW_DataCollection:getApplicableUnits(SW_InfoTypes[2], SWFU_SettingsHeal);
	SW_UpdateGeneralList( true, SW_C_UnitData.getEffectiveInFHealDone, unitInfo, bSet, petFil, SWFU_Buffer );
end

function SWFU_SetData(dataBuff)
	local currData;

	-- Get the damage snapshot
	GetDmgSnapshot(SWFU_Buffer)
	dataBuff.RDmg = 0;
	dataBuff.SelfDmg = 0;
	for i=1, #SWFU_Buffer.data do
		currData = SWFU_Buffer.data[i];
		dataBuff.RDmg = dataBuff.RDmg + currData.val;
		if currData.txt == SW_SELF_STRING then
			dataBuff.SelfDmg = currData.val;
			dataBuff.DmgRank = i;
		end
	end
	-- and the healing snapshot
	GetHealSnapshot(SWFU_Buffer)
	dataBuff.RHeal = 0;
	dataBuff.SelfHeal = 0;
	for i=1, #SWFU_Buffer.data do
		currData = SWFU_Buffer.data[i];
		dataBuff.RHeal = dataBuff.RHeal + currData.val;
		if currData.txt == SW_SELF_STRING then
			dataBuff.SelfHeal = currData.val;
			dataBuff.HealRank = i;
		end
	end
end
function SWFU_OnFightStart()
	SWFU_SetData(SWFU_StartVals);
	GetDmgSnapshot(SWFU_PrefightSnapshotDmg)
	GetHealSnapshot(SWFU_PrefightSnapshotHeal)
end
SW_RPS:registerFightStart(SWFU_OnFightStart);

function SWFU_OnFightEnd(secs)
	SWFU_SetData(SWFU_TmpVals);
	SWFU_PS_Vals.RDmg = (SWFU_TmpVals.RDmg - SWFU_StartVals.RDmg) / secs;
	SWFU_PS_Vals.RHeal = (SWFU_TmpVals.RHeal - SWFU_StartVals.RHeal) / secs;
	SWFU_PS_Vals.RDmgHeal = ((SWFU_TmpVals.RHeal - SWFU_StartVals.RHeal) + (SWFU_TmpVals.RDmg - SWFU_StartVals.RDmg) ) / secs;
	SWFU_PS_Vals.SelfDmg = (SWFU_TmpVals.SelfDmg - SWFU_StartVals.SelfDmg) / secs;
	SWFU_PS_Vals.SelfHeal = (SWFU_TmpVals.SelfHeal - SWFU_StartVals.SelfHeal) / secs;
	SWFU_PS_Vals.SelfDmgHeal = ( (SWFU_TmpVals.SelfHeal - SWFU_StartVals.SelfHeal) + (SWFU_TmpVals.SelfDmg - SWFU_StartVals.SelfDmg) )/ secs;

	SW_StatsFu:SetIcon(icon_sws)
	SW_StatsFu:Update();
end
SW_RPS:registerFightEnd(SWFU_OnFightEnd);






SW_StatsFu:RegisterDB("FuBar_SWStats2FuDB", "FuBar_SWStats2FuPerCharDB")
SW_StatsFu:RegisterDefaults('profile', {
	 RDPS = false,
	 RHPS = false,
	 
	 selfDPS = false,
	 selfHPS = false,
	 
	 HideMiniMap = false,
	 LiveTarget = false,
	 LiveText = false,
	 
	 AutoNuke = false,
     debug = false,
     logoutNuked = false,
})





function SW_StatsFu:OnInitialize()
 	self:SetDebugging(self.db.profile.debug)
end

function SW_StatsFu:OnEnable()
	self.data = {}
	self.flash = icon_on
	
	if self.db.profile.logoutNuked then 
		self.db.profile.logoutNuked = false
		self:Debug("SWS Data Was Nuked On Last Logout")
	end

	self:SetLiveTargetReporting(self.db.profile.LiveTarget )	
	self:SetAutoNuke(self.db.profile.AutoNuke)
	self:GetSWSMenu()
	
	self:RegisterEvent("SWS_Settings_Resp")
	self:RegisterEvent("RosterLib_RosterUpdated")
	
	self:ScheduleRepeatingEvent(self.OnUpdate, 2, self)

	if self.db.profile.HideMiniMap then
		SW_IconFrame:Hide();
	else
		SW_IconFrame:Show();
	end
end
function SW_StatsFu:OnDisable()
end

function SW_StatsFu:SetDebugging(b)
	self.db.profile.debug = b
	self.debugging = b
	if b then self:Debug("Debug ON") end
	Interview:SetDebugging(b)
end


function SW_StatsFu:OnUpdate()
	local secs = SW_RPS.currentSecs; 
	
	if self.db.profile.liveTarget then 
		self.data.ActiveTV = InterviewSWS:GetActiveVariableUnit()
	else	
		if not SW_RPS.isRunning or secs < 1 then return; end
		
		if self.flash == icon_on then
			self:SetIcon(icon_off)
			self.flash = icon_off
		else
			self:SetIcon(icon_on)
			self.flash = icon_on	
		end
		
		SWFU_SetData(SWFU_TmpVals);
		SWFU_PS_Vals.RDmg = (SWFU_TmpVals.RDmg - SWFU_StartVals.RDmg) / secs;
		SWFU_PS_Vals.RHeal = (SWFU_TmpVals.RHeal - SWFU_StartVals.RHeal) / secs;
		SWFU_PS_Vals.RDmgHeal = ((SWFU_TmpVals.RHeal - SWFU_StartVals.RHeal) + (SWFU_TmpVals.RDmg - SWFU_StartVals.RDmg) ) / secs;	
		SWFU_PS_Vals.SelfDmg = (SWFU_TmpVals.SelfDmg - SWFU_StartVals.SelfDmg) / secs;
		SWFU_PS_Vals.SelfHeal = (SWFU_TmpVals.SelfHeal - SWFU_StartVals.SelfHeal) / secs;
		SWFU_PS_Vals.SelfDmgHeal = ( (SWFU_TmpVals.SelfHeal - SWFU_StartVals.SelfHeal) + (SWFU_TmpVals.SelfDmg - SWFU_StartVals.SelfDmg) )/ secs;
		self:Update();
	end
end
function SW_StatsFu:ToggleSWMiniMap()
	if self.db.profile.HideMiniMap then
		self.db.profile.HideMiniMap = false;
		SW_IconFrame:Show();
	else
		self.db.profile.HideMiniMap = true;
		SW_IconFrame:Hide();
	end
end
function SWFU_SetVis(what)
	if SW_StatsFu.db.profile[what] then
		SW_StatsFu.db.profile[what] = false;
	else
		SW_StatsFu.db.profile[what] = true;
	end
	SW_StatsFu:Update();
end



function SWFU_GetVis(what)
	return SW_StatsFu.db.profile[what]
end


SW_StatsFu.EmptyList = {
	showRHPS = {
		order = 1,
		type = 'execute',
		name = L["Update User List..."],
		desc = L["See who is available for data sharing"],
		func = function() SW_StatsFu:SendSWS_Settings_Query() end,
	},
	swsfuGroup2 = {
		order = 2,
		type = 'header',
	},
}

SW_StatsFu.optionsTable = {
	type = 'group',
	args = {
		sws = {
			order = 1,
			type = 'group',
			name = "SW Stats",
			desc = L["SW Stats Program Menu"],
			hidden = function() SW_StatsFu:GetSWSMenu() return false end,
			args = {}
		},

		swsfuGroup1 = {
			type = 'header',
			order = 10,
		},

		showRaid = {
			order = 20,
			type = 'group',
			name = L["Group/s"],
			desc = L["Stats for the group\n(Only visible when grouped)"],
			args = {
				showRDPS = {
					type = 'toggle',
					name = L["GDPS"],
					desc = L["Total DPS for the group\n(Only visible when grouped)"],
					set = function () SWFU_SetVis("RDPS") end,
					get = function () return  SWFU_GetVis("RDPS")  end;
				},
				showRHPS = {
					type = 'toggle',
					name = L["GHPS"],
					desc = L["Total HPS for the group\n(Only visible when grouped)"],
					set = function () SWFU_SetVis("RHPS") end,
					get = function () return SWFU_GetVis("RHPS")end;
				},
			},	
		},

		showSelf = {
			order = 30,
			type = 'group',
			name = SWFU_SELF_PER_SEC,
			desc = L["Stats for just you"] ,
			args = {
				showRHPS = {
					type = 'toggle',
					name = L["HPS"],
					desc = L["Total HPS for you"],
					set = function () SWFU_SetVis("SelfHPS") end,
					get = function () return SWFU_GetVis("SelfHPS")end;
				},
				showRDPS = {
					type = 'toggle',
					name = L["DPS"],
					desc = L["Total DPS for you"],
					set = function () SWFU_SetVis("SelfDPS") end,
					get = function () return SWFU_GetVis("SelfDPS") end;
				},
			},			
		},

		swsfuGroup2 = {
			type = 'header',
			order = 40,
		},

		showInterview = {
			order = 50,
			hidden = function() if InterviewSWS and IsGrouped() then return false else return true end end,
			type = 'group',
			name = L["Shared Options"],
			desc = L["Share SW Stats configuration settings with other users"],
			args = SW_StatsFu.EmptyList,
		},

		swsfuGroup3 = {
			type = 'header',
			order = 60,
		},

		liveTarget = {
			order = 65,
			type = 'group',
			name = L["Live Report"],
			desc = L["Live Reporting On Targeted Unit"],
			args = 
			{
				hideSWLiveReportToggle = {
					type = 'toggle',
					order = 1,
					name = L["Enable Live Reporting On Targeted Unit"],
					desc = L["Keep the SW Stats report by unit in sync with your current target"],
					set = "SetLiveTargetReporting",
					get = function () return SW_StatsFu.db.profile.LiveTarget end,

				},

				hideSWLiveTextToggle = {
					type = 'toggle',
					order = 2,
					name = L["Show name on FuBar Text"],
					desc = L["Show Live Target name on FuBar Text"],
					set = function (v) SW_StatsFu.db.profile.LiveText = v; SW_StatsFu:Update() end,
					get = function () return SW_StatsFu.db.profile.LiveText end,
				}
			}
		},

		swsfuGroup4 = {
			type = 'header',
			order = 70,
		},

		purgeData = {
			type = 'toggle',
			order = 75,
			name = L["Nuke Data Automatically"],
			desc = L["When enabled, the sws stored data will automatically be deleted when you log out of the game"],
			set = function (v) SW_StatsFu:SetAutoNuke(v) end,
			get = function () return SW_StatsFu.db.profile.AutoNuke end,

		},	 		
				      
		hideSWStatsMinimap = {
			type = 'toggle',
			order = 80,			
			name = L["Hide SW Stats Minimap Icon"],
			desc = L["Hide SW Stats Minimap Icon"],
			set = function () SW_StatsFu:ToggleSWMiniMap() end,
			get = function () return SW_StatsFu.db.profile.HideMiniMap end,

		},	  
	},		
}

function SW_StatsFu:SetLiveTargetReporting(v)
	self.db.profile.LiveTarget = v

	if v then
		local n = UnitName("Target")
		InterviewSWS:SetActiveVariableUnit(n or "") 

		self.data.ActiveTV = InterviewSWS:GetActiveVariableUnit()
		self:RegisterEvent("PLAYER_TARGET_CHANGED")
	elseif self:IsEventRegistered("PLAYER_TARGET_CHANGED")	then
		self:UnregisterEvent("PLAYER_TARGET_CHANGED")	
	end

	self:Update()
end

function SW_StatsFu:PLAYER_TARGET_CHANGED()
	if not self.db.profile.LiveTarget then return end
	
	self.data.ActiveTV = UnitName("target") or ""
	InterviewSWS:SetActiveVariableUnit(self.data.ActiveTV)
	self:Update()
end


function SW_StatsFu:SetAutoNuke(v)
	if v then 
		self:Debug("AutoNuke is ON")
		if not self:IsEventRegistered("PLAYER_LOGOUT") then 
			self:RegisterEvent("PLAYER_LOGOUT")
		end
	else
		self:Debug("AutoNuke is OFF")
		if self:IsEventRegistered("PLAYER_LOGOUT") then 
			self:UnregisterEvent("PLAYER_LOGOUT")
		end
	end
	self.db.profile.AutoNuke = v
end


function SW_StatsFu:PLAYER_LOGOUT()
	-- since we are doing it at logoff we want to avoid
	-- doing alot of work but we arent sure if this event
	-- can fire at other times so we cant just nil stuff
	
	-- This messes thing up a ilttle if you do it during a raid.
	-- Perhaps dont autonuke when you are grouped
	if self.db.profile.AutoNuke and not IsGrouped() then
		 self:Debug("PLAYER_LOGOUT - Nuking")
		 self.db.profile.logoutNuked = true
		SW_StrTable = SW_C_StringTable:new(); 
		SW_DataCollection = SW_C_DataCollection:new();
		SW_DataCollection.meta:updateGroupRaid();
		SW_DataCollection:raiseMarkerChanged();
		SW_DataCollection:checkGroup();
--			collectgarbage();	
	end
end


function SW_StatsFu:GetSWSMenu()
	for i,o in ipairs(SW_MiniIconMenu) do
		if not o.isTitle then
			if o.textShow then
				txt = o.textShow;
				if o.checkFrame and getglobal(o.checkFrame):IsVisible() then
					txt = o.textHide;
				end
			elseif o.text then
				txt = o.text;			
			else
				txt = "";
			end
			
			if txt ~= "" then
				self.optionsTable.args.sws.args["tog"..i] = {
						type = 'execute',
						name = txt,
						desc = txt,
						func = o.func,
						order = i,
				}	
			else
				self.optionsTable.args.sws.args["tog"..i] = {
						type = 'header',
						order = i,						
				}				
			end
			
				
		end
	end
end

SW_StatsFu.OnMenuRequest = SW_StatsFu.optionsTable

local Dewdrop = AceLibrary:HasInstance("Dewdrop-2.0") and AceLibrary("Dewdrop-2.0")



function SW_StatsFu:SendSWS_Settings_Query()
	self.optionsTable.args.showInterview.args = SW_StatsFu.EmptyList
	InterviewSWS:SendSWS_Settings_Query(Interview:GetCommChannel())
	Dewdrop:Refresh(2)
end


function SW_StatsFu:SWS_Settings_Resp(channel, sender, resp)
	if not self.optionsTable.args.showInterview.args[sender] then
		self.optionsTable.args.showInterview.args[sender] = { 
				type = 'group',
				name = sender,
				desc = sender,
			--	args = {}
		}
	end
	
	self.optionsTable.args.showInterview.args[sender].args = {}
		
	for i, bS in pairs(resp) do
		local l_sender = sender
		local l_idx = i
		
			self.optionsTable.args.showInterview.args[sender].args["tab"..i] = {
				type = 'execute',
				name = "<"..i..">  "..bS,
				desc = "<"..i..">  "..bS,
				func = function() SW_StatsFu:SendSWS_Settings_Retrieve(l_sender, l_idx) end,
			}	
	end
	
	Dewdrop:Refresh(2)
end



function SW_StatsFu:SendSWS_Settings_Retrieve(user, view)
	InterviewSWS:SendSWS_Settings_Retrieve(user, view)
end



function SW_StatsFu:RosterLib_RosterUpdated(updatedUnits)
	if not IsGrouped() then 
		SWFU_PS_Vals.RDmg = 0
		SWFU_PS_Vals.RHeal = 0
		SWFU_PS_Vals.RDmgHeal = 0
	end

	self:Update()
end

function SW_StatsFu:OnDataUpdate()
	self.data.rpsActive = SW_RPS.isRunning
	self.data.healRank = SWFU_TmpVals.HealRank
	self.data.dmgRank = SWFU_TmpVals.DmgRank
end

function SW_StatsFu:OnTextUpdate()
	local text = ""

	if self.db.profile.LiveText then
		text = "|cff00ff00"..(self.data.ActiveTV or "").."|r "
	end

	if self.db.profile.RDPS or self.db.profile.RHPS or self.db.profile.SelfDPS or self.db.profile.SelfHPS then
		if IsGrouped() then
			if self.db.profile.RDPS  and  self.db.profile.RHPS and self:IsTextColored() then
				table.insert(SWFU_DispBuffer, string.format(L["Group"]..": |cffff0000%.1f|r/|cff00ff00%.1f|r", SWFU_PS_Vals.RDmg, SWFU_PS_Vals.RHeal));
			else
				if self.db.profile.RDPS  then
					table.insert(SWFU_DispBuffer, string.format(L["GDPS"]..": |cffff0000%.1f|r", SWFU_PS_Vals.RDmg));
				end
				if self.db.profile.RHPS then
					table.insert(SWFU_DispBuffer, string.format(L["GHPS"]..": |cff00ff00%.1f|r", SWFU_PS_Vals.RHeal));
				end
			end
		end
		if self.db.profile.SelfDPS  and  self.db.profile.SelfHPS and self:IsTextColored() then
			table.insert(SWFU_DispBuffer, string.format(L["Self"]..": |cffff0000%.1f|r/|cff00ff00%.1f|r", SWFU_PS_Vals.SelfDmg, SWFU_PS_Vals.SelfHeal));
		else
			if self.db.profile.SelfDPS then
				table.insert(SWFU_DispBuffer, string.format(L["DPS"]..": |cffff0000%.1f|r", SWFU_PS_Vals.SelfDmg));
			end
			if self.db.profile.SelfHPS then
				table.insert(SWFU_DispBuffer, string.format(L["HPS"]..": |cff00ff00%.1f|r", SWFU_PS_Vals.SelfHeal));
			end
		end

		text = text .. table.concat(SWFU_DispBuffer, " ")
		--SWFU_DispBuffer.n = 0;
	 	SWFU_DispBuffer = {}
	end

	if text ~= "" then
		self:SetText(text)
	else
		self:SetText(self:GetTitle())
	end    
end  

local tablet = AceLibrary("Tablet-2.0")
--%.1f
function SW_StatsFu:OnTooltipUpdate()
	local str = ""
	if self.data.rpsActive then str = L["|cff00ff00Active|r"] else
	                            str = L["|cffffff00Last Fight"] end

	if IsGrouped() then 
	    local cat = tablet:AddCategory(
	        'text', L["Group/s"],
			'textR', 1,
			'textG', 1,
			'textB', 0,
	        'text2', str,
	        'columns', 2,
			'child_textR', 0.60,
			'child_textG', 0.60,
			'child_textB', 0,
			'child_indentation', 10
	    )
	    
	    local txtRankDmg = string.format("#%d", self.data.dmgRank)
	    local txtRankHeal = string.format("#%d", self.data.healRank)
	    
	    cat:AddLine(
			'text',   L["DPS"],
	        'text2',  string.format("%.1f", SWFU_PS_Vals.RDmg),
	        'text2R', 1,
			'text2G', 0,
			'text2B', 0
	    )
	    
	    cat:AddLine(
			'text',   L["HPS"],
	        'text2',  string.format("%.1f", SWFU_PS_Vals.RHeal),
	        'text2R', 0,
			'text2G', 1,
			'text2B', 0
	    )
	
	    cat:AddLine(
			'text',   L["D+HPS"],
	        'text2',  string.format("%.1f", SWFU_PS_Vals.RDmgHeal),
	        'text2R', 1,
			'text2G', 1,
			'text2B', 0
	    )    
	end
    
    cat = tablet:AddCategory(
        'text', SWFU_SELF_PER_SEC,
		'textR', 1,
		'textG', 1,
		'textB', 0,
        'text2', str,
		'columns', 2,
		'child_textR', 0.60,
		'child_textG', 0.60,
		'child_textB', 0,
		'child_indentation', 10		
    )
    
---		'text',   "DPS".."     "..txtRankDmg,
    cat:AddLine(
		'text',   L["DPS"],
        'text2',  string.format("%.1f", SWFU_PS_Vals.SelfDmg),
        'text2R', 1,
		'text2G', 0,
		'text2B', 0 
    )
    
--    		'text',   "HPS".."     "..txtRankHeal,

    cat:AddLine(
		'text',   L["HPS"],
        'text2',  string.format("%.1f", SWFU_PS_Vals.SelfHeal),
        'text2R', 0,
		'text2G', 1,
		'text2B', 0
    )

    cat:AddLine(
		'text',   L["D+HPS"],
        'text2',  string.format("%.1f", SWFU_PS_Vals.SelfDmgHeal),
        'text2R', 1,
		'text2G', 1,
		'text2B', 0
    )

    
    tablet:SetHint(L["|cffeda55fClick|r to toggle SWS\n|cffeda55fShift-Click|r to set report subject to target"])
end

function SW_StatsFu:OnClick()
	if IsShiftKeyDown() then 
		local n = UnitName("Target")
		if n then
			self.data.ActiveTV = n
			InterviewSWS:SetActiveVariableUnit(n)
			self:Update()
		end
	else
		SW_ToggleBarFrame();
	end
end

function IsGrouped()
	if GetNumRaidMembers() > 0 or GetNumPartyMembers() > 0 then
		return true
	end
	
	return false
end
