--[[

Module based character information distribution system

*** DESIGNED NEVER TO WORK UNLESS THE PLAYERS ARE GROUPED BY CHOICE ***

Will use AddonMessages to communicate over the GUILD, RAID, and PARTY channels

Roles: Manager, Applicant

Actions:

	Manager:  GetApplicants - Obtain the live-list of  responders 




--]]
local L = AceLibrary("AceLocale-2.2"):new("Interview")

Interview = AceLibrary("AceAddon-2.0"):new(	"AceComm-2.0", 
											"AceDebug-2.0", 
											"AceModuleCore-2.0", 
											"AceConsole-2.0", 
											"AceDB-2.0", 
											"AceEvent-2.0"
)





local commPrefix = "Interview"

Interview:RegisterDB("InterviewDB", "InterviewDBPerChar")
Interview:RegisterDefaults("profile", {
	debug = false,
	console = false,
})

Interview.revision = tonumber(string.sub("$Revision: 14954 $", 12, -3))
Interview.roster = AceLibrary("Roster-2.1")
Interview.cmdtable = {
	type = "group", handler = Interview, args = {
		optsep = {
			order = 201,
			type = 'header',
		},	
		showConsole = {
			order = 201,
			type = 'toggle',
			name = "Allow Console Output",
			desc = "Allow Interactive Console Printing",
			get = function() return Interview.db.profile.console end,
			set = function(v) Interview.db.profile.console = v end,		
		},
	}
}

Interview.OnMenuRequest = Interview.cmdtable
Interview:RegisterChatCommand( { "/iv" }, Interview.cmdtable )


--- AceAddon-2.0 Stock Methods
function Interview:OnInitialize()
 	self:SetDebugging(self.db.profile.debug)
	self.checks = {}
   
   	self:RegisterEvent("ADDON_LOADED")
	self:Debug("OnInitialize()")

	if not self.version then self.version = GetAddOnMetadata("Interview", "Version") end
	local rev = self.revision
	for name,module in self:IterateModules() do
		self:RegisterModule(name,module)
		rev = math.max(rev, module.revision)
	end
	self.version = (self.version or "2.0").. " |cffff8888r"..rev.."|r"
	

	self:SetCommPrefix(commPrefix) 	
end

function Interview:OnEnable()
 --	self:SetDebugging(true)
	self:Debug("OnEnable()")


--	self:RegisterEvent("CHAT_MESSAGE_ADDON")
	self:RegisterEvent("Interview_Send")

    self:RegisterComm(commPrefix, "PARTY")
    self:RegisterComm(commPrefix, "RAID")
    self:RegisterComm(commPrefix, "GUILD")
end

function Interview:SetDebugging(b)
	self.db.profile.debug = b
	self.debugging = b
end


--
--
-- Module Prototype
-- 
--
Interview.modulePrototype.core = Interview
Interview.modulePrototype.revision = 1
Interview.modulePrototype.consoleOptions = nil		-- Options table for the module
Interview.modulePrototype.consoleCmd = nil			-- Set to override the console command (default = module name)
Interview.modulePrototype.toggleOptions = nil		-- Set to a table of strings to create auto-toggle options
Interview.modulePrototype.evtMap = nil				-- Mnemonic->Event Map

Interview:SetModuleMixins("AceDebug-2.0", "AceEvent-2.0")

function Interview.modulePrototype:RegisterCheck( c, e )
	self.core:RegisterCheck(c, e)
	self:RegisterEvent(e)
end

function Interview.modulePrototype:UnregisterCheck( c )
	self.core:UnregisterCheck(c)
end

function Interview.modulePrototype:UnregisterAllChecks()
	if self.evtMap then
		for mnemonic, event in pairs(self.evtMap) do
			self:UnregisterCheck(mnemonic, event)
		end
	end
end
function Interview.modulePrototype:RegisterAllChecks()
	if self.evtMap then
		for mnemonic, event in pairs(self.evtMap) do
			self:RegisterCheck(mnemonic, event)
		end
	end
end

function Interview.modulePrototype:SendMessage(chan, msg, p1, p2, p3, p4, p5, p6, p7)
	self.core:TriggerEvent("Interview_Send", chan, msg, p1, p2, p3, p4, p5, p6, p7)
end

function Interview.modulePrototype:Print( msg )
	if (self.core.db.profile.console) then
		self.core:Print("(%s) %s", self.name, msg )
	else
		self:Debug("(%s) %s", self.name, msg )
	end
end

function Interview.modulePrototype:ConsolePrint( msg )
	self.core:Print("(%s) %s", self.name, msg )
end

function Interview.modulePrototype:BestChanToSender(sender)
	return self.core:GetCommChannel(self.core.roster:GetUnitIDFromName(sender))
end

function Interview.modulePrototype:IsModuleDisabled()
	return not self.core:IsModuleActive(self)
end


function Interview.modulePrototype:OnInitialize()
	self:Debug("OnInitialize()")
end

function Interview.modulePrototype:OnEnable()
	self:Debug("OnEnable()")
	self:RegisterAllChecks()
end

function Interview.modulePrototype:OnDisable()
    self:Debug("OnDisable()")
	self:UnregisterAllChecks()
end





-- Checks if a player is in the raid and optionally if he/she has the correct rank
-- Args: name - name of the player
--       ignorerank - flag, when set to true will ignore the rank of the player
-- Returns true when a player is authorized for a request

function Interview:IsValidRequest( name, ignorerank )
    if (not name) then name = UnitName("player") end
	local u = self.roster:GetUnitObjectFromName( name )
	if u then
		if ignorerank then return true end
		if u.rank > 0 then return true end
	end
	return false
end




function Interview:ADDON_LOADED(addon)
	local gname = GetAddOnMetadata(addon, "X-InterviewModule")
	if not gname then return end

	local g = getglobal(gname)
	if not g or not g.name then return end

	g.external = true

	self:RegisterModule(g.name, g)
end



function Interview:OnDisable()
	-- The comms should be disabled automatically by AceComm-2.0
end


-- Registers a keyword check
-- Args: check - keyword to check on
--       event - event to fire when the keyword is received

function Interview:RegisterCheck(check,event)
	self.checks[check] = event
	self:Debug("RegisterCheck() - "..check.."-->"..self.checks[check])
end

-- Unregisters a keyword check
-- Args: check - keyword to remove from the checklist

function Interview:UnregisterCheck(check)
	if self.checks[check] then self.checks[check] = nil end
	self:Debug("UnregisterCheck() - "..check)
end


function Interview:RegisterModule(name, module)
	self:Debug("RegisterModule() - "..name)
	-- Set up DB
	local opts, cons
	local revision = type(module.revision) == "number" and module.revision or -1
	local m = module

	if module.toggleoptions then
		opts = self:BuildAutoToggleOptions(name, module, opts)
	end

	if module.db then 
		module:RegisterDefaults("profile", opts or module.defaultDB or {})
	else 
		self:RegisterDefaults(name, "profile", opts or module.defaultDB or {}) 
	end

	if not module.db then module.db = self:AcquireDBNamespace(name) end

	self:InjectModuleCommonOptions(cons or module.consoleOptions, module)

	-- Set up AceConsole
	if module.consoleOptions then
		if module.external then
			self.cmdtable.args[module.consoleCmd or name] = cons or module.consoleOptions
		else
			self:Debug("RegisterModule() - Cmd= "..(module.consoleCmd or name))
			self.cmdtable.args[module.consoleCmd or name] = cons or module.consoleOptions
		end
	end
end

function Interview:InjectModuleCommonOptions(opts, module)
	local m = module
	
	opts.args[L["toggle"]] = {
				type = "toggle",
				name = L["Active"],
				order = -10,
				desc = L["Activate or deactivate this module."],
				get = function() return m.core:IsModuleActive(m) end,
				set = function() m.core:ToggleModuleActive(m) end,
			}
			
	opts.args[L["debug"]] = {
				type = "toggle",
				name = L["Debugging"],
				desc = L["Show debug messages."],
				order = -9,
				get = function() return m:IsDebugging() end,
				set = function(v) m:SetDebugging(v) end,
				hidden = function() return not m:IsDebugging() and not Interview:IsDebugging() end,
	}
	opts.args.header1 = {
		type = "header",
		order = -8,
	}			
end

function Interview:BuildAutoToggleOptions(name, module)
	local opts = {}
	for _,v in pairs(module.toggleoptions) do if v ~= -1 then opts[v] = true end end
	
	return opts
end

function Interview:Interview_Send(channel, message, p1, p2, p3, p4, p5, p6, p7)
	self:SendCommMessage(channel, message, p1, p2, p3, p4, p5, p6, p7)
end

function Interview:OnCommReceive(prefix, sender, distribution, message, p1, p2, p3, p4, p5, p6, p7)
	if self.checks[message] then
		self:Debug("OnCommReceive() - "..message.."-->"..self.checks[message])
		self:TriggerEvent(self.checks[message], distribution, sender, p1, p2, p3, p4, p5, p6, p7)
	else
	 	self:TriggerEvent("Interview_Comm", sender, distribution, message, p1, p2, p3, p4, p5, p6, p7)
	end
end


-- Get the comm channel needed to talk to the specified unit
--
-- Returns: PARTY, RAID, GUILD, nil
function Interview:GetCommChannel(unit)
	if unit ~= nil then
		self:Debug("GetCommChannel() - "..unit)
		if UnitIsUnit(unit, "player") then 
			return
		elseif UnitInParty(unit) then
			return "PARTY"
		elseif UnitInRaid(unit) then
		    return "RAID"
		elseif IsInGuild() then
			local guildNameP, _, _ = GetGuildInfo("player")
			local guildNameU, _, _ = GetGuildInfo(unit)
			if guildNameP == guildNameU then
				return "GUILD"
			end
		end
		
		return -- Dont give a channel if we cant talk to the unit
	end

	if GetNumRaidMembers() > 0 then
		return "RAID"
	elseif GetNumPartyMembers() > 0 then
		return "PARTY"
	else
		return "RAID"
--	if IsInGuild() then --  Guild wont work if the other person in in a raid or bg
--		return "GUILD"
	end
end 










