assert( Interview, "Interview not found!")
local L = AceLibrary("AceLocale-2.2"):new("InterviewSWS")

L:RegisterTranslations("enUS", function() return {
	["sws"] = true,
	["SWS"] = true,
	["SW Stats"] = true,
	["SW Stats Utilities"] = true,
	["query"] = true,
	["Query"] = true,
	["Query for published setttings"] = true,
	["local"] = true,
	["Local"] = true,
	["Local test query"] = true,
	["Retrieve"] = true,
	["retrieve"] = true,
	["Retrieve a view from another user"] = true,
} end )	

----------------------------------
--      Module Declaration      --
----------------------------------
InterviewSWS = Interview:NewModule(L["SWS"])
InterviewSWS.revision = tonumber(string.sub("$Revision: 12345 $", 12, -3))
InterviewSWS.consoleCmd = L["sws"]

InterviewSWS.consoleOptions = {
	type = "group",
	name = L["SW Stats"],
	desc = L["SW Stats Utilities"],
	args = {
		[L["query"]] = {
			type = "text",
			name = L["Query"],
			desc = L["Query for published setttings"],
			set  = function(v) return InterviewSWS:SendSWS_Settings_Query(v) end,
			get  = false,
			validate  = { "GUILD", "PARTY", "RAID" }  
		},
		[L["local"]] = {
			type = "execute",
			name = L["Local"],
			desc = L["Local test query"],
			func = function(v) return InterviewSWS:LocalTestQuery() end,
		},
		[L["retrieve"]] = {
			type = "text",
			name = L["Retrieve"],
			desc = L["Retrieve a view from another user"],
			input = true,
			usage = "<user> <view#>",
			set  = function(u, v) return InterviewSWS:SendSWS_Settings_Retrieve(u, v) end,
			get  = false,
		}			
	}
}

function InterviewSWS:OnInitialize()

end

function InterviewSWS:OnEnable()
	if (SW_GetInfoSettings == nil) then return end
	
	self:RegisterCheck("SWSCQ", "SWS_Settings_Query")
	self:RegisterCheck("SWSCR", "SWS_Settings_Resp")
	self:RegisterCheck("SWSCL", "SWS_Settings_Retrieve")
	self:RegisterCheck("SWSCS", "SWS_Settings_Transmit")	
end


function InterviewSWS:SendSWS_Settings_Query(channel)
	self:SendMessage(channel, "SWSCQ")
end

function InterviewSWS:SWS_Settings_Query(channel, sender)
	local count, resp = self:GetPanelList()
	if count then 
		self:SendSWS_Settings_Resp(self:BestChanToSender(sender), resp)
	end
end

function InterviewSWS:SendSWS_Settings_Resp(channel, resp)
	if channel then self:SendMessage(channel, "SWSCR", resp) end
end

function InterviewSWS:SWS_Settings_Resp(channel, sender, resp)
	self:ConsolePrint("Reply from <"..sender.."> on <"..channel..">")
	local i=1	

	for i, bS in pairs(resp) do
		self:ConsolePrint("   <"..i..">  "..bS)	
	end
end

function InterviewSWS:SendSWS_Settings_Retrieve(user, view)
	local channel = self:BestChanToSender(user)
	self.userAsked = user
	self.viewAsked = view
	if channel then self:SendMessage(channel, "SWSCL", user, view) end
end

function InterviewSWS:SWS_Settings_Retrieve(channel, sender, user, view)
	local is = SW_Settings["InfoSettings"][view]
	if is then self:SendSWS_Settings_Transmit(self:BestChanToSender(sender), is) end
end

function InterviewSWS:SendSWS_Settings_Transmit(channel, is)
	if channel then self:SendMessage(channel, "SWSCS", is) end
end

function InterviewSWS:SWS_Settings_Transmit(channel, sender, isIN)
	self:Debug("Reply from <"..sender.."> on <"..channel..">")

	if self.userAsked == sender and isIN ~= nil then
		SW_Settings["InfoSettings"][self.viewAsked] = {}
		iS = SW_Settings["InfoSettings"][self.viewAsked];
	    
   		for k,v in pairs(isIN) do 
			if type(v) ~= "table" then
				iS[k] = v;
			else
				iS[k] = {};
				for si, sv in ipairs(v) do
					table.insert(iS[k], sv);
				end
			end
		end
 		
		SW_UpdateBars()
		SW_OptKey(self.viewAsked)
		
		self:ConsolePrint("Panel <"..self.viewAsked.."> is now configured like "..sender.."'s")
	end
end

function InterviewSWS:GetActivePanelNum()
	BS = SW_Settings["BarFrames"]["SW_BarFrame1"]["Selected"]
	return BS 
end

function InterviewSWS:GetInfoSettings(panelNum)
	return SW_GetInfoSettings(panelNum)
end

function InterviewSWS:GetActiveVariableUnit()
	local num = self:GetActivePanelNum()
	local IS = self:GetInfoSettings(num) 
	return IS["TV"]
end

function InterviewSWS:SetActiveVariableUnit(unitName)
	local num = self:GetActivePanelNum()
	local IS = self:GetInfoSettings(num) 
	
	IS["TV"] = unitName
	
	SW_UpdateBars()
	SW_SelOpt(getglobal("SW_BarFrame1_Selector_Opt"..num))
end 

function InterviewSWS:LocalTestQuery()
	local count, resp = self:GetPanelList()

	if count then 
		self:SWS_Settings_Resp("LOCAL", "SELF", resp)
	end
end

function InterviewSWS:GetPanelList()
	local count = SW_Settings["QuickOptCount"]
	local resp = nil
	local i = 1
	
	if count~=nil then 
		resp = {}	
		local bS, i 
		for i, bS in pairs(SW_Settings["InfoSettings"]) do
			if bS ~= nil then 
				local paneLbl = bS["OTF"];
				if paneLbl == nil then paneLbl = "Unlabled" end

				local btnLbl  = bS["OT"];
				if btnLbl == nil then btnLbl = i end
				
				resp[i] = btnLbl.." - "..paneLbl
			end
		end		
	end

	return count, resp
end

