﻿assert( RogueTimerFu, "RogueTimerFu not found!")
local BS = AceLibrary("Babble-Spell-2.2")
local L = AceLibrary("AceLocale-2.2"):new("RogueTimerFu")
local parser = ParserLib:GetInstance("1.1")

local BothTranslation = setmetatable({}, {__index = function(self, string)
	local value
	if BS:HasTranslation(string) then
		value = BS[string]
	elseif L:HasTranslation(string) then
		value = L[string]
	else value = string
	end
	self[string] = value
	return value
end } )

local SpellIcon = setmetatable({}, {__index = function(self, string)
	local icon = AceLibrary("Babble-Spell-2.2"):GetSpellIcon(string)
	self[string] = icon
	return icon
end } )

RogueTimerFu.Rules = {}
RogueTimerFu.timers = {}
RogueTimerFu.RuleMenu = {}
RogueTimerFu.done = {}
RogueTimerFu.finish = {BothTranslation["Eviscerate"], BothTranslation["Kidney Shot"], BothTranslation["Rupture"], BothTranslation["Expose Armor"], BothTranslation["Slice and Dice"], BothTranslation["Envenom"]}

function RogueTimerFu:RulesInit()
for _, v in pairs(self.timers) do
		v(self)
end
self.timers = nil
for k in pairs(self.RuleMenu) do
	self.Menu.args[BothTranslation[k]] = {
		type = "group",
		order = 4,
		name = BothTranslation[k],
		desc = BothTranslation["Which Buffs to show."],
		args = {}
	}
	for v in pairs(self.RuleMenu[k]) do
	if self.Rules[BothTranslation[v]].Alt then name = BothTranslation[self.Rules[BothTranslation[v]].Alt] else name  = BothTranslation[v] end
		self.Menu.args[BothTranslation[k]].args[name] = {
			order = 3,
			type = 'toggle',
			name = name,
		    desc = BothTranslation["Enable/Dissable the timer"],
		    get = function()
		        return self.db.profile.rules[BothTranslation[v]]
		    end,
		    set = function()
				self.db.profile.rules[BothTranslation[v]] = not self.db.profile.rules[BothTranslation[v]]
			end,
			map = { [false] = "Disabled", [true] = "Enabled" }
	}
	end
end
self.RuleMenu = nil	
end

function RogueTimerFu:RulesSetup()
--Spell Events
self:RegisterEvent("UNIT_SPELLCAST_SENT", "spell")
self:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED", "spellSent")
--Damage
parser:RegisterEvent("RogueTimerFu", "CHAT_MSG_SPELL_PERIODIC_CREATURE_DAMAGE", self.Attack)
parser:RegisterEvent("RogueTimerFu", "CHAT_MSG_SPELL_PERIODIC_HOSTILEPLAYER_DAMAGE", self.Attack)
parser:RegisterEvent("RogueTimerFu", "CHAT_MSG_SPELL_SELF_DAMAGE", self.Attack)
-- Other Break aura
parser:RegisterEvent("RogueTimerFu", "CHAT_MSG_SPELL_AURA_GONE_OTHER", self.Fade)
parser:RegisterEvent("RogueTimerFu", "CHAT_MSG_SPELL_BREAK_AURA", self.Fade)
--Self Buffs
parser:RegisterEvent("RogueTimerFu", "CHAT_MSG_SPELL_PERIODIC_SELF_BUFFS", self.Buff)
-- Self Fades
parser:RegisterEvent("RogueTimerFu", "CHAT_MSG_SPELL_AURA_GONE_SELF", self.Fade_Self)
end

function RogueTimerFu:AddRule(group, name, table)
if not table.d then table.d = {} end
if not self.RuleMenu[group] then self.RuleMenu[group] = {} end
self.RuleMenu[group][name] = table
self.Rules[BothTranslation[name]] = table
self.defaults.rules[BothTranslation[name]] = true
end

--Parsing
function RogueTimerFu:spell()
	self.Combo = GetComboPoints()
	self.Target = arg4
end

function RogueTimerFu:spellSent()
if self.db.profile.rules[BothTranslation["Find Weakness"]] then 
	for _, v in pairs(self.finish) do
		if arg2 == v then
			self.done[arg2.."f"] = {s = BothTranslation["Find Weakness"]}
			self:ScheduleEvent(self.CompleteCast, 0.5, self, arg2)
			break
		end
	end
end
if not  self.db.profile.rules[arg2] or arg2 == BothTranslation["Stealth"] or self.Rules[arg2].parse or (arg2 == BothTranslation["Blade Flurry"] and arg3 == "Rank 1") then return end
if self.Rules[arg2].buff then
	self:Bars(arg2, self.Combo, nil, ParserLib_SELF)
	return
else
self.done[arg2] = {r=arg3, c=self.Combo, t=self.Target}
self:ScheduleEvent(self.CompleteCast, 0.5, self, arg2)
end
end

function RogueTimerFu:CompleteCast(spell)
	local active = self.done[spell] or self.done[spell.."f"]
	if active and active.t and not active.s then
		self:Bars(spell, active.c, active.r, active.t, -0.25)
		self.done[spell] = nil
	elseif active and active.s then
		self:Bars(active.s, nil, nil, nil, -0.25)
		self.done[spell] = nil
	end
end

function RogueTimerFu:Attack(info)
local self = RogueTimerFu
if self.Rules[info.skill] and self.Rules[info.skill].Alt then info.skill = self.Rules[info.skill].Alt end
if info.type == "miss" then
	self.done[info.skill] = nil
	self.done[info.skill.."f"] = nil
end
if info.type == "debuff" and self.Rules[info.skill] and self.Rules[info.skill].parse then
	if self.db.profile.rules[info.skill] or  self.db.profile.rules[self.Rules[info.skill].Alt] then
		self:Bars(info.skill, nil, nil, info.victim, nil, info.amountRank)
	end
end
if info.skill == BothTranslation["Envenom"] then self:StopBar(BothTranslation["Deadly Poison"], info.victim) end
end

function RogueTimerFu:Buff(info)
local self = RogueTimerFu
if info.type == "buff" and self.Rules[info.skill] and self.Rules[info.skill].parse then
	if self.db.profile.rules[info.skill] then 
		self:Bars(info.skill, nil, self.Rank, info.victim)
	end
end
end

function RogueTimerFu:Fade(info)
local self = RogueTimerFu
		self:StopBar(info.skill, info.victim)
		if self.Rules[info.skill] and ((self.db.profile.rules.PvP and UnitIsPVP("player")) or (self.db.profile.rules.PvE and not UnitIsPVP("player"))) then
			if self.Rules[info.skill].dr then
				self:Bars("DR: "..self.Rules[info.skill].dr, nil, nil, UnitName("target"), nil, nil, info.skill)
			end
		end
end

function RogueTimerFu:Fade_Self(info)
local skill
local self = RogueTimerFu
if self.Rules[info.skill] and self.Rules[info.skill].Alt then skill = self.Rules[info.skill].Alt else skill = info.skill end
	RogueTimerFu:StopBar(skill, info.victim)
	if self.Rules[info.skill] and self.Rules[info.skill].Trigger and self.db.profile.rules[BothTranslation[self.Rules[info.skill].Trigger]] then
		self:Bars(BothTranslation[self.Rules[info.skill].Trigger], nil, nil, info.victim)
	end
end

--Bars
function RogueTimerFu:Bars(move, combo, rank, target, dur, applications, iconName)
local dur = dur or 0
local time = string.find(move, "DR") and 15 or self:GetDuration(self.Rules[move].d, self.Rules[move].time, combo, rank) + dur
if time < 1 then return end
if self.Rules[move] and self.Rules[move].Alt then move = self.Rules[move].Alt end
local path =  SpellIcon[iconName or move]
self:StartBar(move, target, applications, time, path)
end

function RogueTimerFu:GetDuration(record, duration, cp, rank)
	if record.cp then duration = duration + ((cp or GetComboPoints()) - 1) * record.cp end
	if record.rs then duration = duration + (self:NumRank(rank)-1) * record.rs end
	if record.tn then
		local _,_,_,_, tr = GetTalentInfo(unpack(record.tn))
		if record.to == 1 and tr < 1 then return 0 end
		if tr > 0 and record.to ~= 1 then
			local gain = record.tt and record.tt[tr] or (record.tb + (tr-1) * (record.ts or record.tb))
			duration = duration + (record.tp and (duration/100) * gain or gain)
		end
	end
	if record.p and UnitIsPlayer("target") then duration = record.p end
	return duration
end 

function RogueTimerFu:NumRank(rank)
local _, _, _, rank = string.find(rank, "(.+) (%d+)")
return rank
end 