﻿assert( RogueTimerFu, "RogueTimerFu not found!")
local BS = AceLibrary("Babble-Spell-2.2")
local L = AceLibrary("AceLocale-2.2"):new("RogueTimerFu")
local parser = ParserLib:GetInstance("1.1")

RogueTimerFu_Rules = RogueTimerFu:NewModule("Rules")
RogueTimerFu_Rules.Rules = {}
RogueTimerFu_Rules.defaults = {}
RogueTimerFu_Rules.timers = {}
RogueTimerFu_Rules.Menu = {}
RogueTimerFu_Rules.done = {}
RogueTimerFu_Rules.finish = {"Eviscerate", "Kidney Shot", "Rupture", "Expose Armor", "Slice and Dice"}

function RogueTimerFu_Rules:OnInitialize()
self.settings = RogueTimerFu:AcquireDBNamespace("BuffTimer")
for _, v in pairs(self.timers) do
		v(self)
end
RogueTimerFu:RegisterDefaults("BuffTimer", "profile", self.defaults)
for k in pairs(self.Menu) do
RogueTimerFu.Menu.args[L[k]] = {
	type = "group",
	order = 4,
	name = L[k],
	desc = L["Which Buffs to show."],
	args = {}
}
for v in pairs(self.Menu[k]) do
local name = self:Translation(v)
if v == "Remorseless" then name = self:Translation("Remorseless Attacks") end
	RogueTimerFu.Menu.args[L[k]].args[name] = {
		order = 3,
		type = 'toggle',
		name = name,
	    desc = L["Enable/Dissable the timer"],
	    get = function()
	        return self.settings.profile[self:Translation(v)]
	    end,
	    set = function()
			self.settings.profile[self:Translation(v)] = not self.settings.profile[self:Translation(v)]
		end,
		map = { [false] = "Disabled", [true] = "Enabled" }
}
end
end
self.Menu = nil
end

function RogueTimerFu_Rules:OnEnable()
--Spell Events
self:RegisterEvent("UNIT_SPELLCAST_SENT", "spell")
self:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED", "spellSent")
--Damage
parser:RegisterEvent("RogueTimerFu_Stun", "CHAT_MSG_SPELL_PERIODIC_CREATURE_DAMAGE", self.Attack)
parser:RegisterEvent("RogueTimerFu_Stun", "CHAT_MSG_SPELL_PERIODIC_HOSTILEPLAYER_DAMAGE", self.Attack)
parser:RegisterEvent("RogueTimerFu_Stun", "CHAT_MSG_SPELL_SELF_DAMAGE", self.Attack)
-- Other Break aura
parser:RegisterEvent("RogueTimerFu_Stun", "CHAT_MSG_SPELL_AURA_GONE_OTHER", self.Fade)
parser:RegisterEvent("RogueTimerFu_Stun", "CHAT_MSG_SPELL_BREAK_AURA", self.Fade)
--Self Buffs
parser:RegisterEvent("RogueTimerFu_Stun", "CHAT_MSG_SPELL_PERIODIC_SELF_BUFFS", self.Buff)
-- Self Fades
parser:RegisterEvent("self", "CHAT_MSG_SPELL_AURA_GONE_SELF", self.Fade_Self)
end

function RogueTimerFu_Rules:AddRule(group, name, table)
if not table.d then table.d = {} end
if not self.Menu[group] then self.Menu[group] = {} end
self.Menu[group][name] = table
self.Rules[self:Translation(name)] = table
self.defaults[self:Translation(name)] = true
end

function RogueTimerFu_Rules:OnDisable()
parser:UnregisterAllEvents("self")
end

--Parsing
function RogueTimerFu_Rules:spell()
	self.Combo = GetComboPoints()
	--self.Skill = arg2
	self.Target = arg4
	--self.Player = UnitIsPlayer("target")
end

function RogueTimerFu_Rules:spellSent()
if self.settings.profile[BS["Find Weakness"]] then 
	for _, v in pairs(self.finish) do
		if arg2 == v then
			self.done[arg2.."f"] = {s = BS["Find Weakness"]}
			self:ScheduleEvent(self.CompleteCast, 0.5, self, arg2)
			break
		end
	end
end
if not  self.settings.profile[arg2] or arg2 == BS["Stealth"] or self.Rules[arg2].parse then return end
if self.Rules[arg2].buff then
	self:Bars(arg2, self.Combo, nil, ParserLib_SELF)
else
self.done[arg2] = {r=arg3, c=self.Combo, t=self.Target}
self:ScheduleEvent(self.CompleteCast, 0.5, self, arg2)
end
end

function RogueTimerFu_Rules:CompleteCast(spell)
	local active = self.done[spell] or self.done[spell.."f"]
	if active and active.t and not active.s then
		self:Bars(spell, active.c, active.r, active.t, -0.25)
		self.done[spell] = nil
	elseif active and active.s then
		self:Bars(active.s, nil, nil, nil, -0.25)
		self.done[spell] = nil
	end
end

function RogueTimerFu_Rules:Attack(info)
local self = RogueTimerFu_Rules
if info.skill == self:Translation("Dazed") then info.skill = self:Translation("Blade Twisting") end
if info.type == "miss" then
	self.done[info.skill] = nil
	self.done[info.skill.."f"] = nil
elseif info.type == "debuff" and self.Rules[info.skill] and self.Rules[info.skill].parse then
	if self.settings.profile[info.skill] then
		self:Bars(info.skill, nil, nil, info.victim)
	end

end
end

function RogueTimerFu_Rules:Buff(info)
local self = RogueTimerFu_Rules
if info.type == "buff" and self.Rules[info.skill] and self.Rules[info.skill].parse then
	if self.settings.profile[info.skill] then
		self:Bars(info.skill, nil, self.Rank, info.victim)
	end
end
end

function RogueTimerFu_Rules:Fade(info)
local self = RogueTimerFu_Rules
		RogueTimerFu_Bars:RogueTimerFu_StopBar(self, info.skill, info.victim)
		if  self.Rules[info.skill] and ((self.settings.profile.PvP and UnitIsPVP("player")) or (self.settings.profile.PvE and not UnitIsPVP("player"))) then
			if self.Rules[info.skill].dr == 1 then
				self:Bars("DR: CS", nil, nil, info.victim)
			elseif self.Rules[info.skill].dr == 2 then--and self.Player then
				self:Bars("DR: Incapitating", nil, nil, info.victim)
			elseif self.Rules[info.skill].dr == 3 then
				self:Bars("DR: KS", nil, nil, info.victim)
			end
		end
end

function RogueTimerFu_Rules:Fade_Self(info)
local self = RogueTimerFu_Rules
	RogueTimerFu_Bars:RogueTimerFu_StopBar(self, info.skill, info.victim)
	if info.skill == BS["Stealth"] then
		if self.settings.profile["Master of Subtlety"] then
			self:Bars("Master of Subtlety", nil, nil, info.victim)
		end
	end
end

--Bars
function RogueTimerFu_Rules:Bars(move, combo, rank, target, dur)
local B, dur = self.Buffs, dur or 0
local time = string.find(move, "DR") and 15 or self:GetDuration(self.Rules[move].d, self.Rules[move].time, combo, rank) + dur
if time == 0 then return end
if move == BS["Remorseless"] then move = BS["Remorseless Attacks"] end
local path =  string.find(move, "DR") and BS:GetSpellIcon("Sap") or BS:GetSpellIcon(move)
RogueTimerFu_Bars:RogueTimerFu_StartBar(self, move, target, time, path)
end

function RogueTimerFu_Rules:GetDuration(record, duration, cp, rank)
	if record.cp then duration = duration + ((cp or GetComboPoints()) - 1) * record.cp end
	if record.rs then duration = duration + (self:NumRank(rank)-1) * record.rs end
	if record.tn then
		local _,_,_,_, tr = GetTalentInfo(unpack(record.tn))
		if record.to == 1 and tr < 1 then return 0 end
		if tr > 0 and record.to ~= 1 then
			local gain = record.tt and record.tt[tr] or (record.tb + (tr-1) * (record.ts or record.tb))
			duration = duration + (record.tp and (duration/100) * gain or gain)
		end
	end
	if record.p and UnitIsPlayer("target") then duration = record.p end
	return duration
end 

function RogueTimerFu_Rules:Translation(arg)
if not arg then return end
if BS:HasTranslation(arg) then
	return BS[arg]
elseif L:HasTranslation(arg) then
	return L[arg]
end
return nil
end

function RogueTimerFu_Rules:NumRank(rank)
local _, _, _, rank = string.find(rank, "(.+) (%d+)")
return rank
end 