﻿--Texture registering
local surface = AceLibrary("Surface-1.0")
surface:Register("Otravi", "Interface\\AddOns\\FuBar_RogueTimerFu\\Textures\\otravi")
surface:Register("Smooth", "Interface\\AddOns\\FuBar_RogueTimerFu\\Textures\\smooth")
surface:Register("Glaze", "Interface\\AddOns\\FuBar_RogueTimerFu\\Textures\\glaze")
surface:Register("Charcoal", "Interface\\AddOns\\FuBar_RogueTimerFu\\Textures\\Charcoal")
surface:Register("BantoBar", "Interface\\AddOns\\FuBar_RogueTimerFu\\Textures\\default")

--Locals
local L = AceLibrary("AceLocale-2.2"):new("RogueTimerFu")

--Ace2 Registering
RogueTimerFu = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0", "AceModuleCore-2.0", "FuBarPlugin-2.0")
RogueTimerFu:SetModuleMixins("AceEvent-2.0", "CandyBar-2.0")

--Mod Options
RogueTimerFu.Menu = { 
    type ="group",
    args = {
		[L["Bars To Show"]] = {
			type = "header",
			name = L["Bars To Show"],
			order = 1,
		},
		["spacer1"] = {
			type = "header",
			name = " ",
			order = 10,
		},
		[L["Classes"]] = {
			type = 'toggle',
			order = 11,
			name = L["Classes"],
		    desc = L["Enable/Dissable auto enable for Rogues/dissable for other classes"],
		    get = "GetLoad",
		    set = "SetLoad",
			map = { [false] = "Disabled", [true] = "Enabled" }
		},
		["spacer2"] = {
			type = "header",
			name = " ",
			order = 100,
		},
		[L["Reset settings"]] = {
			type = "execute",
			order = 102,
			name = L["Reset settings"],
			desc = L["Reset settings for this profile"],
			func = function() self:ResetDB("profile") end,
		},	
	},
} 

--Dissable if not rogue
function RogueTimerFu:OnInitialize()
--Revision
self.revision = tonumber(string.sub("$Rev: 23759 $", 7, -3))
self.version = self.version .. " |cffff8888r"..self.revision.."|r"
--Saved Information
self:RegisterDB("RogueTimerFuDB")
self:RegisterDefaults('profile', {class = true})
if self.db.profile.class then
	local playerClass, englishClass = UnitClass("player");
	if (englishClass == "ROGUE") then
	self:ToggleActive(true)
	else
	self:ToggleActive(false)
	end
end
self:RegisterChatCommand({"/RogueTimerFu", "/rt"}, self.Menu)
end

function RogueTimerFu:OnEnable()
for name, module in self:IterateModules() do
	self:ToggleModuleActive(module, true)
end
end

function RogueTimerFu:OnDisable()
	for name, module in self:IterateModules() do
		self:ToggleModuleActive(module, false)
	end
end
 
--FuBar Stuff
local tablet = AceLibrary("Tablet-2.0")
RogueTimerFu.OnMenuRequest = RogueTimerFu.Menu
RogueTimerFu.hasNoColor = true
RogueTimerFu.hasIcon = "Interface\\Icons\\Ability_Sap"
RogueTimerFu.defaultMinimapPosition = 180
RogueTimerFu.cannotDetachTooltip = true
RogueTimerFu.hideWithoutStandby = true

function RogueTimerFu:GetLoad()
return self.db.profile.class
end

function RogueTimerFu:SetLoad()
self.db.profile.class = not self.db.profile.class
end 