﻿local Tablet = AceLibrary("Tablet-2.0")
RicoXPFu = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "FuBarPlugin-2.0", "AceDB-2.0", "AceConsole-2.0")
RicoXPFu:RegisterDB("RicoXPFuDB")

local L = AceLibrary("AceLocale-2.2"):new("FuBar_RicoXPFu")

local RicoXPFu_BarHeight = 4

local RicoXPFu_XPBar = CreateFrame("Frame", nil, UIParent)
RicoXPFu_XPBar:SetFrameStrata("HIGH")
RicoXPFu_XPBar:SetHeight(RicoXPFu_BarHeight)
local tex = RicoXPFu_XPBar:CreateTexture(nil,"HIGH")
tex:SetTexture("Interface\\AddOns\\FuBar_RicoXPFu\\bar.tga")
tex:SetVertexColor(0,0,1,1)
tex:SetAllPoints(RicoXPFu_XPBar)
RicoXPFu_XPBar.texture = tex
RicoXPFu_XPBar:SetPoint("BOTTOMLEFT", RicoXPFu.frame, "BOTTOMLEFT")

local RicoXPFu_RestBar = CreateFrame("Frame", nil, UIParent)
RicoXPFu_RestBar:SetFrameStrata("HIGH")
RicoXPFu_RestBar:SetHeight(RicoXPFu_BarHeight)
tex = RicoXPFu_RestBar:CreateTexture(nil,"HIGH")
tex:SetTexture("Interface\\AddOns\\FuBar_RicoXPFu\\bar.tga")
tex:SetVertexColor(1,0,1,1)
tex:SetAllPoints(RicoXPFu_RestBar)
RicoXPFu_RestBar.texture = tex
RicoXPFu_RestBar:SetPoint("BOTTOMLEFT", RicoXPFu.frame, "BOTTOMLEFT")

local RicoXPFu_Bar = CreateFrame("Frame", nil, UIParent)
RicoXPFu_Bar:SetFrameStrata("MEDIUM")
RicoXPFu_Bar:SetHeight(RicoXPFu_BarHeight)
tex = RicoXPFu_Bar:CreateTexture(nil,"HIGH")
tex:SetTexture("Interface\\AddOns\\FuBar_RicoXPFu\\bar.tga")
tex:SetVertexColor(0.95,0.95,0.95,1)
tex:SetAllPoints(RicoXPFu_Bar)
RicoXPFu_Bar.texture = tex
RicoXPFu_Bar:SetPoint("BOTTOMLEFT", RicoXPFu.frame, "BOTTOMLEFT")

function RicoXPFu:OnEnable()
	self.timeSinceLastUpdate = 0
	self:ScheduleRepeatingEvent(self.Update, 1, self)
	_, self.playerClass = UnitClass("player")
end

function RicoXPFu:UpdateText()
	local curXP = UnitXP("player")
	local maxXP = UnitXPMax("player")
	local rstXP = GetXPExhaustion() or 0
	local level = UnitLevel("player")
	local rawpercent = curXP/maxXP
	local percent = floor(rawpercent*100)
	local restpercent = curXP + rstXP
	if restpercent > maxXP then
		restpercent = 1
	else
		if restpercent ~= 0 then
			restpercent = restpercent/maxXP
		end
	end
	--DEFAULT_CHAT_FRAME:AddMessage(rawpercent .. " - " .. restpercent)

	
	local msg = ""
	if RicoXPFu:IsShowingLevel() then
		msg = msg..L["Level "]..level..": "
	end
	
	if RicoXPFu:IsShowingCurrent() then
		msg = msg..curXP.."/"..maxXP
	end
	
	if RicoXPFu:IsShowingPercent() then
		if RicoXPFu:IsShowingCurrent() then
			msg = msg.." ("..percent.."%)"
		else
			msg = msg..percent.."%"
		end
	end
	
	if RicoXPFu:IsShowingToGo() then
		local next = level + 1

		if GetLocale() == "koKR" then
			msg = msg.." - "..next..L[" xp from "]..(maxXP-curXP)
		else
			msg = msg.." - "..(maxXP-curXP)..L[" xp from "]..next
		end
	end

	if rstXP ~= nil and rstXP > 0 and RicoXPFu:IsShowingRest() then
		msg = msg.." ("..rstXP..L[" rested"]..")"
	end			

	self:SetText(msg)
	
	if RicoXPFu:IsShowingBar() then
		RicoXPFu_Bar:Show()
		RicoXPFu_XPBar:Show()
		RicoXPFu_RestBar:Show()
		RicoXPFu_XPBar:SetWidth(RicoXPFu.frame:GetWidth() * rawpercent)
		RicoXPFu_XPBar:SetPoint("BOTTOMLEFT", RicoXPFu.frame, "BOTTOMLEFT", 0, 3)
		RicoXPFu_RestBar:SetWidth(RicoXPFu.frame:GetWidth() * restpercent)
		RicoXPFu_RestBar:SetPoint("BOTTOMLEFT", RicoXPFu.frame, "BOTTOMLEFT", 0, 3)
		RicoXPFu_Bar:SetWidth(RicoXPFu.frame:GetWidth())
		RicoXPFu_Bar:SetPoint("BOTTOMLEFT", RicoXPFu.frame, "BOTTOMLEFT", 0, 3)
	else
		RicoXPFu_XPBar:Hide()
		RicoXPFu_RestBar:Hide()
		RicoXPFu_Bar:Hide()
	end
end

RicoXPFu.OnMenuRequest = {
	type = "group",
	handler = RicoXPFu,
	args = {
		RicoXp_level = {
			type = "toggle",
			name = L["Show Level"],
			desc = L["ShowLevelDesc"],
			order= 1,
			get  = function() return RicoXPFu:IsShowingLevel() end,
			set  = function() RicoXPFu:ToggleShowingLevel() end,
		},
		RicoXp_current = {
			type = "toggle",
			name = L["Show current XP"],
			desc = L["ShowXPDesc"],
			order= 2,
			get  = function() return RicoXPFu:IsShowingCurrent() end,
			set  = function() RicoXPFu:ToggleShowingCurrent() end,
		},
		RicoXp_percent = {
			type = "toggle",
			name = L["Show XP Percent"],
			desc = L["ShowXPPercentDesc"],
			order= 3,
			get  = function() return RicoXPFu:IsShowingPercent() end,
			set  = function() RicoXPFu:ToggleShowingPercent() end,
		},
		RicoXp_togo = {
			type = "toggle",
			name = L["Show XP's to next level"],
			desc = L["NextLevelDesc"],
			order= 4,
			get  = function() return RicoXPFu:IsShowingToGo() end,
			set  = function() RicoXPFu:ToggleShowingToGo() end,
		},
		RicoXp_rest = {
			type = "toggle",
			name = L["Show Rest XP"],
			desc = L["ShowRestXPDesc"],
			order= 5,
			get  = function() return RicoXPFu:IsShowingRest() end,
			set  = function() RicoXPFu:ToggleShowingRest() end,
		},
		RicoXp_bar = {
			type = "toggle",
			name = L["Show XP Bar"],
			desc = L["ShowXPBarDesc"],
			order= 6,
			get  = function() return RicoXPFu:IsShowingBar() end,
			set  = function() RicoXPFu:ToggleShowingBar() end,
		},
	},
}

function RicoXPFu:IsShowingLevel()
	return self.db.profile["ShowLevel"]
end

function RicoXPFu:ToggleShowingLevel(loud)
	self.db.profile["ShowLevel"] = not self.db.profile["ShowLevel"]
	self:UpdateText()
	return self.db.profile["ShowLevel"]
end

function RicoXPFu:IsShowingCurrent()
	return self.db.profile["ShowCurrent"]
end

function RicoXPFu:ToggleShowingCurrent(loud)
	self.db.profile["ShowCurrent"] = not self.db.profile["ShowCurrent"]
	self:UpdateText()
	return self.db.profile["ShowCurrent"]
end

function RicoXPFu:IsShowingPercent()
	return self.db.profile["ShowPercent"]
end

function RicoXPFu:ToggleShowingPercent(loud)
	self.db.profile["ShowPercent"] = not self.db.profile["ShowPercent"]
	self:UpdateText()
	return self.db.profile["ShowPercent"]
end

function RicoXPFu:IsShowingToGo()
	return self.db.profile["ShowToGo"]
end

function RicoXPFu:ToggleShowingToGo(loud)
	self.db.profile["ShowToGo"] = not self.db.profile["ShowToGo"]
	self:UpdateText()
	return self.db.profile["ShowToGo"]
end

function RicoXPFu:IsShowingRest()
	return self.db.profile["ShowRest"]
end

function RicoXPFu:ToggleShowingRest(loud)
	self.db.profile["ShowRest"] = not self.db.profile["ShowRest"]
	self:UpdateText()
	return self.db.profile["ShowRest"]
end

function RicoXPFu:IsShowingBar()
	return self.db.profile["ShowBar"]
end

function RicoXPFu:ToggleShowingBar(loud)
	self.db.profile["ShowBar"] = not self.db.profile["ShowBar"]
	self:UpdateText()
	return self.db.profile["ShowBar"]
end

function RicoXPFu:OnTooltipUpdate()
	local curXP = UnitXP("player")
	local maxXP = UnitXPMax("player")
	local rstXP = GetXPExhaustion() or 0
	local level = UnitLevel("player")
	local baseArmor, effectiveArmor, petArmor, posBuff, negBuff = UnitArmor("player")

	local cat = Tablet:AddCategory(
		'columns', 2,
		'child_textR', 1,
		'child_textG', 1,
		'child_textB', 0,
		'child_text2R', 1,
		'child_text2G', 1,
		'child_text2B', 1
	)
	cat:AddLine('text', L["Level:"],            'text2', level)
	cat:AddLine('text', L["Current XP:"],       'text2', curXP)
	cat:AddLine('text', L["Percent of level:"], 'text2', (floor(curXP/maxXP*100)).."%")
	cat:AddLine('text', L["XP to next level:"], 'text2', (maxXP-curXP))
	cat:AddLine('text', L["Rested XP:"],        'text2', rstXP)
	cat:AddLine('text', L["Armor"],             'text2', "")
	cat:AddLine('text', L["    Base"],          'text2', baseArmor)
	cat:AddLine('text', L["    Effective"],     'text2', effectiveArmor)
	cat:AddLine('text', L["    Full"],          'text2', petArmor)
	cat:AddLine('text', L["    Negative buff"], 'text2', negBuff)
	cat:AddLine('text', L["    Positive buff"], 'text2', posBuff)
	cat:AddLine('text', L["Strength:"],         'text2', UnitStat("player", 1))
	cat:AddLine('text', L["Agility:"],          'text2', UnitStat("player", 2))
	cat:AddLine('text', L["Stamina:"],          'text2', UnitStat("player", 3))
	cat:AddLine('text', L["Intellect:"],        'text2', UnitStat("player", 4))
	cat:AddLine('text', L["Spirit:"],           'text2', UnitStat("player", 5))
end
