-- Code from NabuFiveSec


RegenFuFiveSec = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0", "AceDebug-2.0", "CandyBar-2.0")

local regenfuBarName = "RegenFuFiveSecBar"
local regenfuBarIcon = "Interface\\Addons\\FuBar_RegenFu\\textures\\5.tga"
local regenfuBarTextures = { smooth = "Interface\\Addons\\FuBar_RegenFu\\textures\\smooth.tga" }

local regenfuBarDefaultX = -1
local regenfuBarDefaultY = -1
local regenfuBarDefaultWidth = 150
local regenfuBarDefaultHeight = 16



-----------------------------
-- OnInitialize / OnEnable --
-----------------------------
RegenFuFiveSec:RegisterDB("FuBar_RegenFSRDB")

RegenFuFiveSec:RegisterDefaults("profile", {
	locked = false,
	anchor = {
		x = regenfuBarDefaultX,
		y = regenfuBarDefaultY,
	},
	size = {
		width = regenfuBarDefaultWidth,
		height = regenfuBarDefaultHeight,
	},
	currMana = 0,
})

function RegenFuFiveSec:OnInitialize()	
	self.options = {
		type = "group",
		args = {
			lock = {
				name = "Lock",
				desc = "Lock the FiveSec Bar",
				type = "toggle",
				get = function() return self.db.profile.locked end,
				set = "toggleFSBLock",
				map = {[false] = "Unlocked", [true] = "Locked"},
			},
			size = {
				name = "Size",
				desc = "Size of the FiveSec Bar",
				type = "group",
				args = {
					width = {
						name = "Width",
						desc = "Set the width of the FiveSec Bar",
						type = "text",
						usage = "<number>",
						get = function() return self.db.profile.size.width end,
						set = "setFSBWidth",
						validate = "numberValidation",
					},
					heigth = {
						name = "Height",
						desc = "Set the height of the FiveSec Bar",
						type = "text",
						usage = "<number>",
						get = function() return self.db.profile.size.height end,
						set = "setFSBHeight",
						validate = "numberValidation",
					},
				},
			},
			reset = {
				name = "Reset",
				desc = "Resets the FiveSec Bar back to the middle of the screen.",
				type = "execute",
				func = "resetFSB",
			}
		}
	}
	
	--self:RegisterChatCommand({ "/nfs", "/nfivesec", "/RegenFuFiveSec", "/fs", "/fivesec" }, self.options )
end
		

function RegenFuFiveSec:OnEnable()
	self:CreateAnchorFrame()


	self.AnchorFrame:Show()
	self:LoadAnchorPosition()
	self:SetAnchorStyle(self.db.profile.locked)
	self:CreateCandyBar()	
	
	
	self:RegisterEvent("UNIT_MANA")
	
	self:Debug("OnEnable.Processed")
end


function RegenFuFiveSec:OnDisable()
	self.AnchorFrame:Hide()
end


----------------------
-- Option Functions --
----------------------

function RegenFuFiveSec:toggleFSBLock(v)
	self.db.profile.locked = v
	self:SetAnchorStyle(v)
end


function RegenFuFiveSec:setFSBWidth(v)
	self.db.profile.size.width = tonumber(v)
	self:UpdateSize()
end


function RegenFuFiveSec:setFSBHeight(v)
	self.db.profile.size.height = tonumber(v)
	self:UpdateSize()
end


function RegenFuFiveSec:resetFSB()
	self.db.profile.anchor.x = regenfuBarDefaultX
	self.db.profile.anchor.y = regenfuBarDefaultY 
	self.db.profile.size.width = regenfuBarDefaultWidth
	self.db.profile.size.height = regenfuBarDefaultHeight
	
	self:LoadAnchorPosition()
	self:UpdateSize()
end


function RegenFuFiveSec:numberValidation(v)
	return tonumber(v) ~= nil
end


-----------------------
-- General Functions --
-----------------------

function RegenFuFiveSec:UpdateSize()
	self.AnchorFrame:SetWidth(self.db.profile.size.width + self.db.profile.size.height)
	self.AnchorFrame:SetHeight(self.db.profile.size.height)
	self:SetCandyBarWidth(regenfuBarName, self.db.profile.size.width)
	self:SetCandyBarHeight(regenfuBarName, self.db.profile.size.height)
	
	self:Debug("UpdateSize.Processed")
end


----------------------------
-- Anchor Frame Functions --
----------------------------

function RegenFuFiveSec:CreateAnchorFrame()
	if RegenFuFiveSecAnchor then 
		self.AnchorFrame = RegenFuFiveSecAnchor
		return
	end
	
	self.AnchorFrame = CreateFrame("Frame","RegenFuFiveSecAnchor",UIParent)
	self.AnchorFrame:SetWidth(self.db.profile.size.width + self.db.profile.size.height)
	self.AnchorFrame:SetHeight(self.db.profile.size.height)
	self.AnchorFrame:SetFrameStrata("BACKGROUND")
	self.AnchorFrame:SetClampedToScreen(true)
	
	self.AnchorFrame:SetScript("OnMouseDown",	function() 
													if not self.db.profile.locked then 
														this:StartMoving() 
													end 
												end )

	self.AnchorFrame:SetScript("OnMouseUp",	function()
												this:StopMovingOrSizing()
												if not self.db.profile.locked then
													self:SaveAnchorPosition()
												end
											end )
											
	local gameFont, _, _ = GameFontHighlightSmall:GetFont()										
	self.AnchorFrame.Range = self.AnchorFrame:CreateFontString("AnchorBarName", "OVERLAY")
	self.AnchorFrame.Range:SetJustifyH("CENTER")
	self.AnchorFrame.Range:SetFont(gameFont, 12)
	self.AnchorFrame.Range:SetTextColor(1, 1, 1)
	self.AnchorFrame.Range:SetText("FiveSec Bar")
	self.AnchorFrame.Range:ClearAllPoints()
	self.AnchorFrame.Range:SetPoint("BOTTOM", self.AnchorFrame, "TOP", 0, 2)
							

end


function RegenFuFiveSec:SaveAnchorPosition()
	self.db.profile.anchor.x = floor(this:GetLeft() * self.AnchorFrame:GetEffectiveScale() + .5)
	self.db.profile.anchor.y = floor(this:GetTop() * self.AnchorFrame:GetEffectiveScale() + .5)
	
	self:Debug("SaveAnchorPosition: x=", self.db.profile.anchor.x, ", y=", self.db.profile.anchor.y)
end


function RegenFuFiveSec:LoadAnchorPosition()
	self.AnchorFrame:ClearAllPoints()
	if self.db.profile.anchor.x > -1 then
		local s = self.AnchorFrame:GetEffectiveScale()
		self.AnchorFrame:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT", floor(self.db.profile.anchor.x/s + .5), floor(self.db.profile.anchor.y/s + .5))
	else
		self.AnchorFrame:SetPoint("CENTER", UIParent, "CENTER")
	end
	
	self:Debug(
		"LoadAnchorPosition: x=", floor(self.db.profile.anchor.x/self.AnchorFrame:GetEffectiveScale() + .5),
		", y=", floor(self.db.profile.anchor.y/self.AnchorFrame:GetEffectiveScale() + .5),
		", width=", (self.db.profile.size.width),
		", height=", (self.db.profile.size.height)
	)
end


function RegenFuFiveSec:SetAnchorStyle(locked)
	if locked then
		self.AnchorFrame:EnableMouse(false)
		self.AnchorFrame:SetMovable(false)
		
		self.AnchorFrame:SetBackdrop(nil)
		self.AnchorFrame:SetBackdropBorderColor(nil)
		self.AnchorFrame:SetBackdropColor(nil)
		
		self.AnchorFrame.Range:Hide()
	else
		self.AnchorFrame:EnableMouse(true)
		self.AnchorFrame:SetMovable(true)
		
		self.AnchorFrame:SetBackdrop({
			bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = true, tileSize = 8,
		})
		self.AnchorFrame:SetBackdropBorderColor(TOOLTIP_DEFAULT_COLOR.r, TOOLTIP_DEFAULT_COLOR.g, TOOLTIP_DEFAULT_COLOR.b)
		self.AnchorFrame:SetBackdropColor(TOOLTIP_DEFAULT_BACKGROUND_COLOR.r, TOOLTIP_DEFAULT_BACKGROUND_COLOR.g, TOOLTIP_DEFAULT_BACKGROUND_COLOR.b)
		
		self.AnchorFrame.Range:Show()
	end
end


---------------------------
-- FiveSec Bar Functions --
---------------------------

function RegenFuFiveSec:CreateCandyBar()	
	self:RegisterCandyBar(regenfuBarName, 5, "FSR", regenfuBarIcon, "blue") 
	self:SetCandyBarTexture(regenfuBarName, regenfuBarTextures["smooth"]) 
	self:SetCandyBarPoint(regenfuBarName, "CENTER", self.AnchorFrame, "CENTER")
	self:SetCandyBarFade(regenfuBarName, 1)
	self:SetCandyBarWidth(regenfuBarName, self.db.profile.size.width)
	self:SetCandyBarHeight(regenfuBarName, self.db.profile.size.height)
	
	self:Debug("CreateCandyBar.Processed")
end


function RegenFuFiveSec:UNIT_MANA(unit)
	if ( unit == "player" ) and ( UnitPowerType("player") == 0 ) then
		local currMana = UnitMana("player")
		if ( currMana < self.db.profile.currMana) then
			if self:IsCandyBarRegistered(regenfuBarName) then
				self:StartCandyBar(regenfuBarName, false) 
			end
		end
		self.db.profile.currMana = currMana
	end
end
