﻿local L = AceLibrary("AceLocale-2.2"):new("RecountFu_Options")

L:RegisterTranslations("enUS", function() return {
	["Reset"] = true,
	["Resets the data"] = true,
	["VerChk"] = true,
	["Displays the versions of players in the raid"] = true,
	["Toggle"] = true,
	["Toggles the main window"] = true,
	["Report"] = true,
	["Allows the data of a window to be reported"] = true,
	["Detail"] = true,
	["Reports the Detail Window Data"] = true,
	["Main"] = true,
	["Reports the Main Window Data"] = true,
	["Select View Mode..."] = true,
	["Select which view mode to display."] = true,
	["Config"] = true,
	["Shows the config window"] = true,
	["ResetPos"] = true,
	["Resets the positions of the detail, graph, and main windows"] = true,
	["Lock"] = true,
	["Toggles windows being locked"] = true,
	["|cffff4040Disabled|r"] = true,
	["|cff40ff40Enabled|r"] = true,
	["Realtime"] = true,
	["Specialized Realtime Graphs"] = true,
	["FPS"] = true,
	["Starts a realtime window tracking your FPS"] = true,
	["Lag"] = true,
	["Starts a realtime window tracking your latency"] = true,
	["Upstream Traffic"] = true,
	["Starts a realtime window tracking your upstream traffic"] = true,
	["Downstream Traffic"] = true,
	["Starts a realtime window tracking your downstream traffic"] = true,
	["Available Bandwidth"] = true,
	["Starts a realtime window tracking amount of available AceComm bandwidth left"] = true,
	["Raid"] = true,
	["Tracks your entire raid"] = true,
	["DPS"] = true,
	["Tracks Raid Damage Per Second"] = true,
	["DTPS"] = true,
	["Tracks Raid Damage Taken Per Second"] = true,
	["HPS"] = true,
	["Tracks Raid Healing Per Second"] = true,
	["HTPS"] = true,
	["Tracks Raid Healing Taken Per Second"] = true,
	["Text Options"] = true,
	["Options for Displaying Text in Fubar"] = true,
	["Update Frequency"] = true,
	["How Frequently to update text on the Fubar Toolbar (In Seconds)"] = true,
	["Show DPS"] = true,
	["Show DPS in Fubar Toolbar"] = true,
	["Self/Raid DPS"] = true,
	["Show Self or Raid DPS"] = true,
	["Self DPS"] = true,
	["Raid DPS"] = true,
	["DPS Type"] = true,
	["Pick DPS type Output to Fubar"] = true,
	["Overall"] = true,
	["Last Fight"] = true,
	["Displays the %s mode"] = true,
	["Displaying Versions"] = true,
} end)

L:RegisterTranslations("deDE", function() return {
	["Reset"] = "Zurücksetzen",
	["Resets the data"] = "Setzt die Daten zurück",
	["VerChk"] = "Versions Check",
	["Displays the versions of players in the raid"] = "Zeigt die Versionen aller Spieler im Schlachtzug an",
	["Toggle"] = "Ein-/Ausblenden",
	["Toggles the main window"] = "Hauptfenster ein-/ausblenden",
	["Report"] = "Bericht",
	["Allows the data of a window to be reported"] = "Berichten der Fensterdaten erlauben",
	["Detail"] = "Detail",
	["Reports the Detail Window Data"] = "Berichtet die Daten im Detailfenster",
	["Main"] = "Haupt",
	["Reports the Main Window Data"] = "Berichtet die Daten im Hauptfenster",
	["Select View Mode..."] = "Anzeigemodus wählen...",
	["Select which view mode to display."] = "Wähle welcher Anzeigemodus angezeigt werden soll",
	["Config"] = "Konfig",
	["Shows the config window"] = "Zeigt das Konfigurationsfenster",
	["ResetPos"] = "UrsprungsPos",
	["Resets the positions of the detail, graph, and main windows"] = "Setzt die Positionen von Detail-, Graphik- und Hauptfenster zurück",
	["Lock"] = "Sperren",
	["Toggles windows being locked"] = "Schaltet die Sperre für Fensterverschiebung an/aus",
	["|cffff4040Disabled|r"] = "|cffff4040Ausgeschaltet|r",
	["|cff40ff40Enabled|r"] = "|cff40ff40Eingeschaltet|r",
	["Realtime"] = "Echtzeit",
	["Specialized Realtime Graphs"] = "Spezielle Echtzeit Graphen",
	["FPS"] = "FPS",
	["Starts a realtime window tracking your FPS"] = "Öffnet ein Echtzeitfenster für Deine FPS (Frames Per Seconds)",
	["Lag"] = "Lag",
	["Starts a realtime window tracking your latency"] = "Öffnet ein Echtzeitfenster für Deine Latenz",
	["Upstream Traffic"] = "Ankommender Verkehr",
	["Starts a realtime window tracking your upstream traffic"] = "Öffnet ein Echtzeitfenster für Deinen ankommenden Verkehr",
	["Downstream Traffic"] = "Ausgehender Verkehr",
	["Starts a realtime window tracking your downstream traffic"] = "Öffnet ein Echtzeitfenster für Deinen ausgehenden Verkehr",
	["Available Bandwidth"] = "Verfügbare Bandbreite",
	["Starts a realtime window tracking amount of available AceComm bandwidth left"] = "Öffnet ein Echtzeitfenster für verfügbare AceComm Bandbreite",
	["Raid"] = "Schlachtzug",
	["Tracks your entire raid"] = "Verfolgt den gesamten Schlachtzug",
	["DPS"] = "DPS",
	["Tracks Raid Damage Per Second"] = "Verfolgt im Schlachtzug ausgeteilten Schaden pro Sekunde (DPS)",
	["DTPS"] = "DTPS",
	["Tracks Raid Damage Taken Per Second"] = "Verfolgt im Schlachtzug genommenen Schaden pro Sekunde (DTPS)",
	["HPS"] = "HPS",
	["Tracks Raid Healing Per Second"] = "Verfolgt im Schlachtzug ausgeteilte Heilung pro Sekunde (HPS)",
	["HTPS"] = "HTPS",
	["Tracks Raid Healing Taken Per Second"] = "Verfolgt im Schlachtzug genommene Heilung pro Sekunde (HTPS)",
	["Text Options"] = "Textoptionen",
	["Options for Displaying Text in Fubar"] = "Textoptionen für den Text in FuBar",
	["Update Frequency"] = "Aktualisierungsfrequenz",
	["How Frequently to update text on the Fubar Toolbar (In Seconds)"] = "Wie oft der Text in Fubar aktualisiert wird (in Sekunden)",
	["Show DPS"] = "Zeige DPS",
	["Show DPS in Fubar Toolbar"] = "Zeige DPS in FuBar",
	["Self/Raid DPS"] = "Eigene/Schlachtzug DPS",
	["Show Self or Raid DPS"] = "Zeige eigene oder Schlachtzug DPS",
	["Self DPS"] = "Eigene DPS",
	["Raid DPS"] = "Schlachtzug DPS",
	["DPS Type"] = "DPS Typ",
	["Pick DPS type Output to Fubar"] = "Wähle welcher DPS Typ in FuBar angezeigt werden soll",
	["Overall"] = "Alle Daten",
	["Last Fight"] = "Letzter Kampf",
	["Displays the %s mode"] = "Zeige den %s Modus",
	["Displaying Versions"] = "Versionen anzeigen",
} end)

L:RegisterTranslations("zhCN", function() return {
	["Reset"] = "重置统计数据",
	["Resets the data"] = "重置统计数据",
	["VerChk"] = "版本检查",
	["Displays the versions of players in the raid"] = "显示团队成员安装的Recount版本",
	["Toggle"] = "切换显示/隐藏Recount",
	["Toggles the main window"] = "切换Recount主窗体的显示与否",
	["Report"] = "报告",
	["Allows the data of a window to be reported"] = "发送统计结果的数据报告到指定频道",
	["Detail"] = "详细",
	["Reports the Detail Window Data"] = "发送详细数据报告",
	["Main"] = "主要",
	["Reports the Main Window Data"] = "只发送主窗体上显示的统计数据报告",
	["Select View Mode..."] = "选择数据统计类别...",
	["Select which view mode to display."] = "选择要查看的战斗统计数据的类别。",
	["Config"] = "设置",
	["Shows the config window"] = "显示设置窗口",
	["ResetPos"] = "重置位置",
	["Resets the positions of the detail, graph, and main windows"] = "恢复各个窗体的默认显示位置",
	["Lock"] = "锁定",
	["Toggles windows being locked"] = "锁定/解锁窗体的显示位置",
	["|cffff4040Disabled|r"] = "|cffff4040关闭|r",
	["|cff40ff40Enabled|r"] = "|cff40ff40开启|r",
	["Realtime"] = "实时图表",
	["Specialized Realtime Graphs"] = "显示专业的实时统计图表",
	["FPS"] = "每秒帧数FPS",
	["Starts a realtime window tracking your FPS"] = "开启一个实时监控每秒帧数FPS的图表",
	["Lag"] = "延时",
	["Starts a realtime window tracking your latency"] = "开启一个实时监控网络延时的图表",
	["Upstream Traffic"] = "上行传输",
	["Starts a realtime window tracking your upstream traffic"] = "开启一个实时监控网络上行传输情况的图表",
	["Downstream Traffic"] = "下行传输",
	["Starts a realtime window tracking your downstream traffic"] = "开启一个实时监控网络下行传输情况的图表",
	["Available Bandwidth"] = "可用带宽",
	["Starts a realtime window tracking amount of available AceComm bandwidth left"] = "开启一个实时监控AceComm可用带宽情况的图表",
	["Raid"] = "团队",
	["Tracks your entire raid"] = "监视整个团队",
	["DPS"] = "每秒伤害DPS",
	["Tracks Raid Damage Per Second"] = "开启一个实时监控团队平均每秒伤害量的图表",
	["DTPS"] = "每秒承受伤害DTPS",
	["Tracks Raid Damage Taken Per Second"] = "开启一个实时监控团队平均每秒承受伤害量的图表",
	["HPS"] = "每秒治疗HPS",
	["Tracks Raid Healing Per Second"] = "开启一个实时监控团队平均每秒治疗量的图表",
	["HTPS"] = "每秒接受治疗HTPS",
	["Tracks Raid Healing Taken Per Second"] = "开启一个实时监控团队平均每秒接受治疗量的图表",
	["Text Options"] = "Fubar文本显示选项",
	["Options for Displaying Text in Fubar"] = "设定 Fubar 上的文本显示内容",
	["Update Frequency"] = "刷新频率",
	["How Frequently to update text on the Fubar Toolbar (In Seconds)"] = "设定 Fubar 信息面板上文字的刷新频率(以秒为单位)",
	["Show DPS"] = "显示 DPS",
	["Show DPS in Fubar Toolbar"] = "在 Fubar 信息面板上直接显示DPS数据",
	["Self/Raid DPS"] = "自身/团队 DPS",
	["Show Self or Raid DPS"] = "显示自身/团队 DPS",
	["Self DPS"] = "自身 DPS",
	["Raid DPS"] = "团队 DPS",
	["DPS Type"] = "DPS 类别",
	["Pick DPS type Output to Fubar"] = "选择 Fubar 信息面板上显示的DPS数据类别",
	["Overall"] = "全部战斗数据",
	["Last Fight"] = "仅当前战斗数据",
	["Displays the %s mode"] = "显示 %s 模式",
	["Displaying Versions"] = "显示版本",
} end)

L:RegisterTranslations("zhTW", function() return {
	["Reset"] = "重置統計數據",
	["Resets the data"] = "重置統計數據",
	["VerChk"] = "版本檢查",
	["Displays the versions of players in the raid"] = "顯示團隊成員安裝的 Recount 版本",
	["Toggle"] = "切換顯示/隱藏 Recount",
	["Toggles the main window"] = "切換 Recount 主視窗顯示與否",
	["Report"] = "報告",
	["Allows the data of a window to be reported"] = "發送統計結果的數據報告到指定頻道",
	["Detail"] = "詳細",
	["Reports the Detail Window Data"] = "發送詳細數據報告",
	["Main"] = "主要",
	["Reports the Main Window Data"] = "只發送主視窗上顯示的統計數據報告",
	["Select View Mode..."] = "選擇數據統計類別...",
	["Select which view mode to display."] = "選擇要查看的戰鬥統計數據的類別",
	["Config"] = "設置",
	["Shows the config window"] = "顯示設置視窗",
	["ResetPos"] = "重置位置",
	["Resets the positions of the detail, graph, and main windows"] = "重置各個視窗的預設顯示位置",
	["Lock"] = "鎖定",
	["Toggles windows being locked"] = "鎖定/解鎖視窗的顯示位置",
	["|cffff4040Disabled|r"] = "|cffff4040關閉|r",
	["|cff40ff40Enabled|r"] = "|cff40ff40開啟|r",
	["Realtime"] = "即時圖表",
	["Specialized Realtime Graphs"] = "顯示專業的即時統計圖表",
	["FPS"] = "每秒張數 FPS",
	["Starts a realtime window tracking your FPS"] = "開啟一個即時監控每秒張數 FPS 的圖表",
	["Lag"] = "延遲",
	["Starts a realtime window tracking your latency"] = "開啟一個即時監控網路延遲的圖表",
	["Upstream Traffic"] = "上行傳輸",
	["Starts a realtime window tracking your upstream traffic"] = "開啟一個即時監控網路上行傳輸情況的圖表",
	["Downstream Traffic"] = "下行傳輸",
	["Starts a realtime window tracking your downstream traffic"] = "開啟一個即時監控網路下行傳輸情況的圖表",
	["Available Bandwidth"] = "可用頻寬",
	["Starts a realtime window tracking amount of available AceComm bandwidth left"] = "開啟一個即時監控 AceComm 可用頻寬情況的圖表",
	["Raid"] = "團隊",
	["Tracks your entire raid"] = "監視整個團隊",
	["DPS"] = "每秒傷害 DPS",
	["Tracks Raid Damage Per Second"] = "開啟一個即時監控團隊平均每秒傷害量的圖表",
	["DTPS"] = "每秒承受傷害 DTPS",
	["Tracks Raid Damage Taken Per Second"] = "開啟一個即時監控團隊平均每秒承受傷害量的圖表",
	["HPS"] = "每秒治療 HPS",
	["Tracks Raid Healing Per Second"] = "開啟一個即時監控團隊平均每秒治療量的圖表",
	["HTPS"] = "每秒接受治療 HTPS",
	["Tracks Raid Healing Taken Per Second"] = "開啟一個即時監控團隊平均每秒接受治療量的圖表",
	["Text Options"] = "Fubar 文字顯示選項",
	["Options for Displaying Text in Fubar"] = "設定 Fubar 上的文字顯示內容",
	["Update Frequency"] = "更新頻率",
	["How Frequently to update text on the Fubar Toolbar (In Seconds)"] = "設定 Fubar 訊息面板上文字的更新頻率(以秒為單位)",
	["Show DPS"] = "顯示 DPS",
	["Show DPS in Fubar Toolbar"] = "在 Fubar 訊息面板上直接顯示 DPS 數據",
	["Self/Raid DPS"] = "自身/團隊 DPS",
	["Show Self or Raid DPS"] = "顯示自身/團隊 DPS",
	["Self DPS"] = "自身 DPS",
	["Raid DPS"] = "團隊 DPS",
	["DPS Type"] = "DPS 類別",
	["Pick DPS type Output to Fubar"] = "選擇 Fubar 訊息面板上顯示的 DPS 數據類別",
	["Overall"] = "全部戰鬥數據",
	["Last Fight"] = "僅當前戰鬥數據",
	["Displays the %s mode"] = "顯示 %s 模式",
	["Displaying Versions"] = "顯示版本",
} end)

L:RegisterTranslations("koKR", function() return {
	["Reset"] = "초기화",
	["Resets the data"] = "데이터 초기화",
	["VerChk"] = "버전 체크",
	["Displays the versions of players in the raid"] = "공격대에 있는 플레이어들의 버전을 표시합니다.",
	["Toggle"] = "전환",
	["Toggles the main window"] = "메인창 전환",
	["Report"] = "보고",
	["Allows the data of a window to be reported"] = "기록된 정보를 모두 표시합니다.",
	["Detail"] = "상세",
	["Reports the Detail Window Data"] = "상세 데이터를 보고합니다.",
	["Main"] = "메인",
	["Reports the Main Window Data"] = "메인 데이터를 보고합니다.",
	["Select View Mode..."] = "관찰 모드 선택...",
	["Select which view mode to display."] = "표시될 관찰 모드를 선택합니다.",
	["Config"] = "설정",
	["Shows the config window"] = "설정창을 불러옵니다.",
	["ResetPos"] = "위치 초기화",
	["Resets the positions of the detail, graph, and main windows"] = "상세/그래프/메인창의 위치를 초기화 합니다.",
	["Lock"] = "잠금",
	["Toggles windows being locked"] = "창의 위치를 고정합니다.",
	["|cffff4040Disabled|r"] = "|cffff4040중지|r",
	["|cff40ff40Enabled|r"] = "|cff40ff40사용|r",
	["Realtime"] = "실시간",
	["Specialized Realtime Graphs"] = "실시간으로 그래프를 표시합니다.",
	["FPS"] = "FPS",
	["Starts a realtime window tracking your FPS"] = "현재 FPS를 기록합니다.",
	["Lag"] = "Lag",
	["Starts a realtime window tracking your latency"] = "현재 지연시간을 기록합니다.",
	["Upstream Traffic"] = "업스트림 트래픽",
	["Starts a realtime window tracking your upstream traffic"] = "현재 업스트림 트래픽을 기록합니다.",
	["Downstream Traffic"] = "다운스트림 트래픽",
	["Starts a realtime window tracking your downstream traffic"] = "현재 다운스트림 트래픽을 기록합니다.",
	["Available Bandwidth"] = "가능한 대역폭",
	["Starts a realtime window tracking amount of available AceComm bandwidth left"] = "AceComm에서 가능한 대역폭을 기록합니다.",
	["Raid"] = "Raid",
	["Tracks your entire raid"] = "공격대시에 기록합니다.",
	["DPS"] = "DPS",
	["Tracks Raid Damage Per Second"] = "공격대 초당 데미지를 기록합니다.",
	["DTPS"] = "DTPS",
	["Tracks Raid Damage Taken Per Second"] = "공격대 받은 데미지를 기록합니다.",
	["HPS"] = "HPS",
	["Tracks Raid Healing Per Second"] = "공격대 치유량을 기록합니다.",
	["HTPS"] = "HTPS",
	["Tracks Raid Healing Taken Per Second"] = "공격대 받은 치유량을 기록합니다.",
	["Text Options"] = "문자 설정",
	["Options for Displaying Text in Fubar"] = "Fubar에 문자 표시하기 위한 설정입니다.",
	["Update Frequency"] = "업데이트 빈도",
	["How Frequently to update text on the Fubar Toolbar (In Seconds)"] = "Fubar 툴바에 문자의 업데이트 빈도수(초) 입니다.",
	["Show DPS"] = "DPS 표시",
	["Show DPS in Fubar Toolbar"] = "Fubar 툴바에 DPS를 표시합니다.",
	["Self/Raid DPS"] = "자신/공격대 DPS",
	["Show Self or Raid DPS"] = "자신 또는 공격대 DPS를 표시합니다.",
	["Self DPS"] = "자신의 DPS",
	["Raid DPS"] = "공격대의 DPS",
	["DPS Type"] = "DPS 유형",
	["Pick DPS type Output to Fubar"] = "Fubar에 출력할 DPS 유형 선택합니다.",
	["Overall"] = "전체",
	["Last Fight"] = "마지막 전투",
	["Displays the %s mode"] = "%s 모드 표시",
	["Displaying Versions"] = "버전 표시",
} end)

RecountFu.consoleOptions = {
	type = 'group',
	args = {
		toggle = {
			name = L["Toggle"],
			desc = L["Toggles the main window"],
			order = 10,
			type = 'execute',
			func = function() if Recount.MainWindow:IsShown() then Recount.MainWindow:Hide() else Recount.MainWindow:Show() Recount:RefreshMainWindow() end end
		},
		lock = {
			name = L["Lock"],
			desc = L["Toggles windows being locked"],
			order = 20,
			type = 'toggle',
			get = function() return Recount.db.char.Locked end,
			set = function(v)
				Recount.db.char.Locked=v 
				Recount:LockWindows(v)
			end,
			map = { [false] = L["|cffff4040Disabled|r"], [true] = L["|cff40ff40Enabled|r"] }
		},
		resetpos = {
			name = L["ResetPos"],
			desc = L["Resets the positions of the detail, graph, and main windows"],
			order = 30,
			type = 'execute',
			func = function() Recount:ResetPositions() end
		},
		config = {
			name = L["Config"],
			desc = L["Shows the config window"],
			order = 40,
			type = 'execute',
			func = function() Recount:ShowConfig() end
		},
		verchk = {
			name = L["VerChk"],
			desc = L["Displays the versions of players in the raid"],
			order = 50,
			type = 'execute',
			func = function() Recount:Print(L["Displaying Versions"]) if Recount.VerTable~=nil then for k,v in pairs(Recount.VerTable) do Recount:Print(k.." "..v) end end end
		},
		selectmode = {
			name = L["Select View Mode..."],
			type = 'group',
			desc = L["Select which view mode to display."],
			order = 60,
			args = {
			-- Elsia: These will be now auto-generated from Recount's MainWindowModes
			}
		},
		realtime = {
			name = L["Realtime"],
			type = 'group',
			desc = L["Specialized Realtime Graphs"],
			order = 70,
			args = {
				fps = {
					name = L["FPS"],
					desc = L["Starts a realtime window tracking your FPS"],
					order = 20,
					type = 'execute',
					func = function() Recount:CreateRealtimeWindow("FPS","FPS","") end
				},
				lag = {
					name = L["Lag"],
					desc = L["Starts a realtime window tracking your latency"],
					order = 30,
					type = 'execute',
					func = function() Recount:CreateRealtimeWindow("Latency","LAG","") end
				},
				uptraffic = {
					name = L["Upstream Traffic"],
					desc = L["Starts a realtime window tracking your upstream traffic"],
					order = 40,
					type = 'execute',
					func = function() Recount:CreateRealtimeWindow("Upstream Traffic","UP_TRAFFIC","") end
				},
				downtraffic = {
					name = L["Downstream Traffic"],
					desc = L["Starts a realtime window tracking your downstream traffic"],
					order = 50,
					type = 'execute',
					func = function() Recount:CreateRealtimeWindow("Downstream Traffic","DOWN_TRAFFIC","") end
				},
				bandwidth = {
					name = L["Available Bandwidth"],
					desc = L["Starts a realtime window tracking amount of available AceComm bandwidth left"],
					order = 60,
					type = 'execute',
					func = function() Recount:CreateRealtimeWindow("Bandwidth Available","AVAILABLE_BANDWIDTH","") end
				},
				raid = {
					name = L["Raid"],
					desc = L["Tracks your entire raid"],
					order = 10,
					type = 'group',
					args = {
						dps = {
							name = L["DPS"],
							desc = L["Tracks Raid Damage Per Second"],
							order = 1,
							type = 'execute',
							func = function() Recount:CreateRealtimeWindow("!RAID","DAMAGE","Raid DPS") end
						},
						dtps = {
							name = L["DTPS"],
							desc = L["Tracks Raid Damage Taken Per Second"],
							order = 2,
							type = 'execute',
							func = function() Recount:CreateRealtimeWindow("!RAID","DAMAGETAKEN","Raid DTPS") end
						},
						hps = {
							name = L["HPS"],
							desc = L["Tracks Raid Healing Per Second"],
							order = 3,
							type = 'execute',
							func = function() Recount:CreateRealtimeWindow("!RAID","HEALING","Raid HPS") end
						},
						htps = {
							name = L["HTPS"],
							desc = L["Tracks Raid Healing Taken Per Second"],
							order = 4,
							type = 'execute',
							func = function() Recount:CreateRealtimeWindow("!RAID","HEALINGTAKEN","Raid HTPS") end
						}
					}
				}
			}
		},
		report = {
			name = L["Report"],
			type = 'group',
			desc = L["Allows the data of a window to be reported"],
			order = 80,
			args = {
				main = {
					name = L["Main"],
					desc = L["Reports the Main Window Data"],
					order = 1,
					type = 'execute',
					func = function()  Recount:ShowReport(L["Main"],Recount.ReportData) end
				},
				detail = {
					name = L["Detail"],
					desc = L["Reports the Detail Window Data"],
					order = 2,
					type = 'execute',
					func = function()  Recount:ShowReport(L["Detail"],Recount.ReportDetail) end
				}
			}
		},
		textOptions = {
			name = L["Text Options"],
			desc = L["Options for Displaying Text in Fubar"],
			order = 90,
			type = 'group',
			args = {
				DPS = {
					type = 'toggle',
					name = L["Show DPS"],
					desc = L["Show DPS in Fubar Toolbar"],
					order = 1,
					get = function() return RecountFu.db.profile.text.show_dps end,
					set = function(v) RecountFu.db.profile.text.show_dps = v RecountFu:DoTextUpdate() RecountFu:UpdateTimeChanged() end
				},
				DPS_Type = {
					type = 'text',
					name = L["DPS Type"],
					desc = L["Pick DPS type Output to Fubar"],
					order = 2,
					get = function() return RecountFu.db.profile.text.dps_type end,
					set = function(v) RecountFu.db.profile.text.dps_type = v RecountFu:DoTextUpdate() end,
					validate = {
						Overall = L["Overall"],
						LastFight = L["Last Fight"]
					}
				},
				DPS_Raid = {
					type = 'text',
					name = L["Self/Raid DPS"],
					desc = L["Show Self or Raid DPS"],
					order = 3, -- Darkclaw: now order 3
					get = function() return RecountFu.db.profile.text.dps_raid end,
					set = function(v) RecountFu.db.profile.text.dps_raid = v RecountFu:DoTextUpdate() end,
					validate = {
						SelfDPS = L["Self DPS"], -- Darkclaw: added space (changed all locals as needed)
						RaidDPS = L["Raid DPS"]  -- Darkclaw: added space (changed all locals as needed)
					}
				},
				Update_Time = {
					type = 'range',
					name = L["Update Frequency"],
					desc = L["How Frequently to update text on the Fubar Toolbar (In Seconds)"],
					order = 4, -- Darkclaw: now order 4
					get = function() return RecountFu.db.profile.text.update_time end,
					set = function(v) RecountFu.db.profile.text.update_time = v RecountFu:UpdateTimeChanged() end,
					min = 0.1,
					max = 5,
					step = 0.1
				}
			}
		},
		reset = {
			name = L["Reset"],
			desc = L["Resets the data"],
			order = 100,
			type = 'execute',
			func = function() Recount:ShowReset() end
		}
	}
}

for k,v in pairs(Recount.MainWindowData) do
	RecountFu.consoleOptions.args.selectmode.args["selectmode"..k] = {
		name = v[1],
		desc = string.format(L["Displays the %s mode"],v[1]),
		type = 'execute',
		func = function() Recount:SetMainWindowMode(k)  end
		}
end

RecountFu.OnMenuRequest = RecountFu.consoleOptions
RecountFu:RegisterChatCommand({"/recfu"}, RecountFu.consoleOptions)