RecapFu = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceDB-2.0", "AceDebug-2.0", "FuBarPlugin-2.0")

local L = AceLibrary("AceLocale-2.2"):new("RecapFu")
local tablet = AceLibrary("Tablet-2.0")
local crayon = AceLibrary("Crayon-2.0")

local TYPES = {
	a = {var = "DPS", text = L["Your DPS"]},
	b = {var = "DMG_IN", text = L["Your damage received"]},
	c = {var = "DMG_OUT", text = L["Your damage dealt"]},
	d = {var = "HEALING", text = L["Your healing"]},
	e = {var = "OVERHEAL", text = L["Your over-healing percentage"]},
	f = {var = "MAXHIT", text = L["Your max hit"]},
	g = {var = "DPS_IN", text = L["Total DPS In"]},
	h = {var = "DPS_OUT", text = L["Total DPS Out"]},
}

local recapFu_index = 1

local options = {
	type = 'group',
	args = {
		pause = {
			type = 'toggle',
			order = 100,
			name = L["Pause"],
			desc = L["Pause/Resume Monitoring"],
			get = function()
				return recap.Opt.Paused.value
			end,
			set = function()
				Recap_OnClick("Pause")
			end,
		},
		display = {
			type = 'group',
			order = 102,
			name = L["Display"],
			desc = L["Toggle what is displayed on the panel"],
			args = {
				label = {
					type = 'toggle',
					order = 100,
					name = L["Label"],
					desc = L["Show/Hide the DPS label"],
					get = function()
						return RecapFu.db.profile.showlabel
					end,
					set = function()
						RecapFu.db.profile.showlabel = not RecapFu.db.profile.showlabel
						RecapFu:UpdateText()
					end,
				},
				dps = {
					type = 'toggle',
					order = 110,
					name = L["DPS"],
					desc = L["Your DPS"],
					get = function()
						return RecapFu.db.profile.DPS
					end,
					set = function()
						RecapFu.db.profile.DPS = not RecapFu.db.profile.DPS
						RecapFu:UpdateText()
					end,
				},
				dmgin = {
					type = 'toggle',
					order = 120,
					name = L["Received"],
					desc = L["Your damage received"],
					get = function()
						return RecapFu.db.profile.DMG_IN
					end,
					set = function()
						RecapFu.db.profile.DMG_IN = not RecapFu.db.profile.DMG_IN
						RecapFu:UpdateText()
					end,
				},
				dmgout = {
					type = 'toggle',
					order = 130,
					name = L["Dealt"],
					desc = L["Your damage dealt"],
					get = function()
						return RecapFu.db.profile.DMG_OUT
					end,
					set = function()
						RecapFu.db.profile.DMG_OUT = not RecapFu.db.profile.DMG_OUT
						RecapFu:UpdateText()
					end,
				},
				healing = {
					type = 'toggle',
					order = 140,
					name = L["Healing"],
					desc = L["Your healing"],
					get = function()
						return RecapFu.db.profile.HEALING
					end,
					set = function()
						RecapFu.db.profile.HEALING = not RecapFu.db.profile.HEALING
						RecapFu:UpdateText()
					end,
				},
				overheal = {
					type = 'toggle',
					order = 150,
					name = L["Overhealing"],
					desc = L["Your over-healing percentage"],
					get = function()
						return RecapFu.db.profile.OVERHEAL
					end,
					set = function()
						RecapFu.db.profile.OVERHEAL = not RecapFu.db.profile.OVERHEAL
						RecapFu:UpdateText()
					end,
				},
				maxhit = {
					type = 'toggle',
					order = 160,
					name = L["Max"],
					desc = L["Your max hit"],
					get = function()
						return RecapFu.db.profile.MAXHIT
					end,
					set = function()
						RecapFu.db.profile.MAXHIT = not RecapFu.db.profile.MAXHIT
						RecapFu:UpdateText()
					end,
				},
				dpsin = {
					type = 'toggle',
					order = 170,
					name = L["DPSin"],
					desc = L["Total DPS In"],
					get = function()
						return RecapFu.db.profile.DPS_IN
					end,
					set = function()
						RecapFu.db.profile.DPS_IN = not RecapFu.db.profile.DPS_IN
						RecapFu:UpdateText()
					end,
				},
				dpsout = {
					type = 'toggle',
					order = 180,
					name = L["DPSout"],
					desc = L["Total DPS Out"],
					get = function()
						return RecapFu.db.profile.DPS_OUT
					end,
					set = function()
						RecapFu.db.profile.DPS_OUT = not RecapFu.db.profile.DPS_OUT
						RecapFu:UpdateText()
					end,
				},
			}
		},
	}
}

RecapFu.version = "2.0." .. string.sub("$Revision: 30568 $", 12, -3)
RecapFu.date = string.sub("$Date: 2007-03-19 22:48:32 -0400 (Mon, 19 Mar 2007) $", 8, 17)
RecapFu.hasIcon = "Interface\\AddOns\\Recap\\Recap-Status"
RecapFu.hasNoColor = true
RecapFu.independentProfile = true
RecapFu.OnMenuRequest = options

RecapFu:RegisterChatCommand({"/recapfu", "/fubar_recapfu"}, options)

RecapFu:RegisterDB("RecapFuDB")
RecapFu:RegisterDefaults('profile', {
	showlabel = true,
   	DPS = true,
})

function RecapFu:OnEnable()
	self.text = {}
end

function RecapFu:OnDisable()
	self.text = nil
end

function RecapFu:OnClick()
	RecapFrame_Toggle()
end

function RecapFu:UpdateData()
	self:Debug("Update Data")
	
	if recap.Opt then
		if recap.Opt.State then
			self.state = recap.Opt.State.value or "n/a"
		else
			self.state = "n/a"
		end
		if recap.Opt.View and recap_temp.LastAll then
			self.viewtype = recap_temp.LastAll[recap.Opt.View.value] or "n/a"
		else
			self.viewtype = "n/a"
		end
	else
		self.state = "n/a"
		self.viewtype = "n/a"
	end
	
	local Player
	if (recapFu_index < recap_temp.ListSize) and (recap_temp.List[recapFu_index].Name == recap_temp.Player) then
		Player = recap_temp.List[recapFu_index]
	else
		local i
		for i=1,(recap_temp.ListSize-1) do
			if recap_temp.List[i].Name==recap_temp.Player then
				recapFu_index = i
				Player = recap_temp.List[i]
				break
			end
		end
	end
	
	if Player == nil then	
		self.dmgin = 0
		self.dmgout = 0
		self.maxhit = 0
		self.healing = 0
		self.overheal = 0
		self.dpsin = 0
		self.dpsout = 0
	else
		self.dmgin = Player.DmgIn
		self.dmgout = Player.DmgOut
		self.maxhit = Player.MaxHit
		self.healing = Player.Heal
		self.overheal = Player.Over
	end
	
	if not self.yourdps then
		self.yourdps = RecapMinYourDPS_Text:GetText()
	end
	if not self.dpsin then
		self.dpsin = RecapMinDPSIn_Text:GetText()
	end
	if not self.dpsout then
		self.dpsout = RecapMinDPSOut_Text:GetText()
	end
	
	self.text.DPS = crayon:White(self.yourdps)
	self.text.DPS_IN = crayon:Red(self.dpsin)
	self.text.DPS_OUT = crayon:Green(self.dpsout)
	self.text.DMG_IN = crayon:Red(self.dmgin)
	self.text.DMG_OUT = crayon:Green(self.dmgout)
	self.text.HEALING = crayon:Colorize("00ffff", self.healing)
	self.text.OVERHEAL = crayon:Colorize("00ffff", self.overheal.."%")
	self.text.MAXHIT = crayon:Orange(self.maxhit)
end

function RecapFu:UpdateText()
	self:Debug("Update Text")
	-- format the colored status bubble
	if (self:IsIconShown()) then
		if self.state=="Idle" then
			self.iconFrame:SetVertexColor(.5,.5,.5)
		elseif self.state=="Active" then
			self.iconFrame:SetVertexColor(0,1,0)
		elseif self.state=="Stopped" then
			self.iconFrame:SetVertexColor(1,0,0)
		end
	end

	local t = {}
	if self.db.profile.showlabel then
		table.insert(t, L["DPS"]..": ")
	end
	
	for i,e in self:pairsByKeys(TYPES) do
		if self.db.profile[e.var] then
			table.insert(t, self.text[e.var])
		end
	end
	
	self:SetText(table.concat(t, " "))
end

function RecapFu:OnTooltipUpdate()
	self:Debug("Update Tooltip")
	local cat = tablet:AddCategory(
		'columns', 2,
		'child_textR', 1,
		'child_textG', 1,
		'child_textB', 0,
		'child_text2R', 1,
		'child_text2G', 1,
		'child_text2B', 1
	)
	cat:AddLine('text', L["State"], 'text2', self.state)
	cat:AddLine('text', L["View Type"], 'text2', self.viewtype)
	
	local cat = tablet:AddCategory(
		'columns', 2,
		'child_textR', 1,
		'child_textG', 1,
		'child_textB', 0
	)
	for i,e in self:pairsByKeys(TYPES) do
		cat:AddLine('text', e.text, 'text2', self.text[e.var])
	end
	tablet:SetHint(L["Left-click to toggle Recap window"])
end

function RecapFu:pairsByKeys (t, f)
--taken from an example in the Programming in Lua book
	local a = {}
	for n in pairs(t) do
		table.insert(a, n)
	end
	table.sort(a, f)
	local i = 0      -- iterator variable
	local iter = function ()   -- iterator function
		i = i + 1
		if a[i] == nil then
			return nil
		else
			return a[i], t[a[i]]
		end
	end
	return iter
end

-- Simulate Titan Panel plugin
-- Necessary or updates to dps data on the plugin may not occur until after combat ends
function TitanPanelRecap_Update(state,yourdps,dpsin,dpsout)
	RecapFu.state = state
	RecapFu.yourdps = yourdps
	RecapFu.dpsin = dpsin
	RecapFu.dpsout = dpsout
	RecapFu:Update()
end