L = AceLibrary("AceLocale-2.2"):new("FuBar_RecZone")
local Tablet = AceLibrary("Tablet-2.0")
local Jostle = AceLibrary("LibJostle-3.0")

RecZone = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0")

RecZone.version = "2.0." .. string.sub("$Revision: 72551 $", 12, -3);
RecZone.date = string.sub("$Date: 2008-05-03 14:20:59 -0400 (Sat, 03 May 2008) $", 8, 17);
RecZone.hasIcon = true;
RecZone.clickableTooltip = true;
RecZone.cannotDetachTooltip = true; -- Walk path dosn't work with detached tooltip yet.

RecZone:RegisterDB("RecZoneDB")
RecZone:RegisterDefaults("profile", {
			showCurInstance = true,
			showInstance = true,
			showBattleground = true,
			showRaid = false,
			showFaction = false,
			showContinent = false,
			showLoc = true,
			showMap = true,
			lower = 5,
			higher = 5,
			showColoredText = true,
			showZoneName = true,
			showSubZoneName = false,
			showCoords = true,
			showMapCoords = true,
			minimapBar = false,
})

function RecZone:IsShowingCurInstance()
	return self.db.profile.showCurInstance;
end
function RecZone:ToggleShowingCurInstance()
	self.db.profile.showCurInstance = not self.db.profile.showCurInstance;
	self:UpdateTooltip();
end
function RecZone:IsShowingInstance()
	return self.db.profile.showInstance;
end
function RecZone:ToggleShowingInstance()
	self.db.profile.showInstance = not self.db.profile.showInstance;
	self:UpdateTooltip();
end
function RecZone:IsShowingBattleground()
	return self.db.profile.showBattleground;
end
function RecZone:ToggleShowingBattleground()
	self.db.profile.showBattleground = not self.db.profile.showBattleground;
	self:UpdateTooltip();
end
function RecZone:IsShowingRaid()
	return self.db.profile.showRaid;
end
function RecZone:ToggleShowingRaid()
	self.db.profile.showRaid = not self.db.profile.showRaid;
	self:UpdateTooltip();
end
function RecZone:IsShowingFaction()
	return self.db.profile.showFaction;
end
function RecZone:ToggleShowingFaction()
	self.db.profile.showFaction = not self.db.profile.showFaction;
	self:UpdateTooltip();
end
function RecZone:IsShowingContinent()
	return self.db.profile.showContinent;
end
function RecZone:ToggleShowingContinent()
	self.db.profile.showContinent = not self.db.profile.showContinent;
	self:UpdateTooltip();
end
function RecZone:IsShowingLoc()
	return self.db.profile.showLoc;
end
function RecZone:ToggleShowingLoc()
	self.db.profile.showLoc = not self.db.profile.showLoc;
	self:UpdateTooltip();
end
function RecZone:GetLower()
	return self.db.profile.lower;
end
function RecZone:SetLower(value)
	self.db.profile.lower = value;
	self:UpdateTooltip();
end
function RecZone:GetHigher()
	return self.db.profile.higher;
end
function RecZone:SetHigher(value)
	self.db.profile.higher = value;
	self:UpdateTooltip();
end
function RecZone:IsShowingColoredText()
	return self.db.profile.showColoredText;
end
function RecZone:ToggleShowingColoredText()
	self.db.profile.showColoredText = not self.db.profile.showColoredText;
	self:Update();
end
function RecZone:IsShowingZoneName()
	return self.db.profile.showZoneName;
end
function RecZone:ToggleShowingZoneName()
	self.db.profile.showZoneName = not self.db.profile.showZoneName;
	self:Update();
end
function RecZone:IsShowingSubZoneName()
	return self.db.profile.showSubZoneName;
end
function RecZone:ToggleShowingSubZoneName()
	self.db.profile.showSubZoneName = not self.db.profile.showSubZoneName;
	self:Update();
end
function RecZone:IsShowingCoords()
	return self.db.profile.showCoords;
end
function RecZone:ToggleShowingCoords(value)
	if value == nil then
		self.db.profile.showCoords = not self.db.profile.showCoords;
	else
		self.db.profile.showCoords = value
	end
	if  self.db.profile.showCoords then
		self:StartCoordsUpdate();
		self:Update();
	else
		self:StopCoordsUpdate();
		self:Update();
	end
end
function RecZone:IsShowingMap()
	return self.db.profile.showMap;
end
function RecZone:ToggleShowingMap(value)
	if value == nil then
		self.db.profile.showMap = not self.db.profile.showMap;
	else
		self.db.profile.showMap = value;
	end
	if ( self.db.profile.showMap ) then
		RecZoneMapText:Show();
	else
		RecZoneMapText:Hide();
	end
end
function RecZone:IsShowingMapCoords()
	return self.db.profile.showMapCoords
end
function RecZone:ToggleShowingMapCoords(value)
	if value == nil then
		self.db.profile.showMapCoords = not self.db.profile.showMapCoords
	else
		self.db.profile.showMapCoords = value
	end
	if not self.db.profile.showMapCoords then
		RecZoneMapFrameCursorCoords:Hide()
		RecZoneMapFramePlayerCoords:Hide()
	else
		RecZoneMapFrameCursorCoords:Show()
		RecZoneMapFramePlayerCoords:Show()
	end
end
function RecZone:IsShowingMinimapBar()
	return self.db.profile.minimapBar
end
function RecZone:ToggleShowingMinimapBar(value)
	if value == nil then
		self.db.profile.minimapBar = not self.db.profile.minimapBar
	else
		self.db.profile.minimapBar = value
	end
	if not self.db.profile.minimapBar then
		MinimapBorderTop:Hide()
		MinimapToggleButton:Hide()
		MinimapZoneTextButton:Hide()
	else
		MinimapBorderTop:Show()
		MinimapToggleButton:Show()
		MinimapZoneTextButton:Show()
	end
	Jostle:Refresh()
end

-- Enumerations.
-- Faction
local RZ_ALLIANCE			= 1;
local RZ_HORDE				= 2;
local RZ_CONTESTED		= 3;
local RZ_SANCTUARY		= 4;
-- Continent
local RZ_KALIMDOR			= 1;
local RZ_EASTERN 			= 2;
local RZ_OUTLAND 			= 3;
local RZ_OTHER	 			= 4;
-- Type
local RZ_ZONE					= 1;
local RZ_CITY					= 2;
local RZ_TRANSPORT		= 3;
local RZ_NONE					= 4;
local RZ_INSTANCE			= 5;
local RZ_BATTLEGROUND	= 6;
local RZ_RAID20				= 7;
local RZ_RAID40				= 8;
local RZ_RAID25				= 9;
local RZ_RAID10				=10;


RecZone.vars = {};
RecZone.vars.current_continent = nil;
RecZone.vars.current_zone = nil;
RecZone.vars.playerLevel = 0;
RecZone.vars.zoneName = "";
RecZone.vars.subZoneName = "";
RecZone.vars.playerFaction = 0;
RecZone.vars.zonetext = "";
RecZone.vars.coordtext = "";
RecZone.vars.leveltext = "";
RecZone.vars.playerCoordX = 0;
RecZone.vars.playerCoordY = 0;

RecZone.vars.factions = {
	[RZ_ALLIANCE] 		= L["Alliance"],
	[RZ_HORDE] 				= L["Horde"],
	[RZ_CONTESTED]		= L["Contested"],
	[RZ_SANCTUARY]		= L["Sanctuary"],
}
RecZone.vars.types = {
	[RZ_ZONE] 				= "",
	[RZ_CITY] 				= "City",
	[RZ_TRANSPORT] 		= "Transport",
	[RZ_NONE] 				= "",
	[RZ_INSTANCE] 		= "",
	[RZ_BATTLEGROUND] = L["Battleground"],
	[RZ_RAID20] 			= L["Raid20"],
	[RZ_RAID40] 			= L["Raid40"],
	[RZ_RAID25]				= L["Raid25"],
	[RZ_RAID10]				= L["Raid10"],
}
RecZone.vars.continents = {};
RecZone.vars.zones = {};
do
	local function zn(zonename)
		for nr,zone in ipairs(RecZone.vars.zones) do
			if zone.name == zonename then
				return nr;
			end
		end
	end
	local function znx(zonename,x)
		for nr,zone in ipairs(RecZone.vars.zones) do
			if zone.name == zonename and zone.x and zone.x == x then
				return nr;
			end
		end
	end
	local Z = LibStub("LibBabble-Zone-3.0"):GetLookupTable()
	RecZone.vars.zones={ 
	
-- Eastern
		{name=Z["Stormwind City"],low=70,high=70,faction=RZ_ALLIANCE,type=RZ_CITY,continent=RZ_EASTERN},
		{name=Z["Ironforge"],low=70,high=70,faction=RZ_ALLIANCE,type=RZ_CITY,continent=RZ_EASTERN},
		{name=Z["Undercity"],low=70,high=70,faction=RZ_HORDE,type=RZ_CITY,continent=RZ_EASTERN},
		{name=Z["Dun Morogh"],low=1,high=12,faction=RZ_ALLIANCE,type=RZ_ZONE,continent=RZ_EASTERN},
		{name=Z["Elwynn Forest"],low=1,high=12,faction=RZ_ALLIANCE,type=RZ_ZONE,continent=RZ_EASTERN},
		{name=Z["Tirisfal Glades"],low=1,high=12,faction=RZ_HORDE,type=RZ_ZONE,continent=RZ_EASTERN},
		{name=Z["Loch Modan"],low=10,high=20,faction=RZ_ALLIANCE,type=RZ_ZONE,continent=RZ_EASTERN},
		{name=Z["Westfall"],low=10,high=20,faction=RZ_ALLIANCE,type=RZ_ZONE,continent=RZ_EASTERN},
		{name=Z["Silverpine Forest"],low=10,high=20,faction=RZ_HORDE,type=RZ_ZONE,continent=RZ_EASTERN},
		{name=Z["Redridge Mountains"],low=15,high=25,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_EASTERN},
		{name=Z["Wetlands"],low=20,high=30,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_EASTERN},
		{name=Z["Duskwood"], low=20,high=30,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_EASTERN},
		{name=Z["Hillsbrad Foothills"],low=20,high=30,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_EASTERN},
		{name=Z["Alterac Mountains"],low=30,high=40,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_EASTERN},
		{name=Z["Arathi Highlands"],low=30,high=40,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_EASTERN},
		{name=Z["Stranglethorn Vale"],low=30,high=45,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_EASTERN},
		{name=Z["Badlands"],low=35,high=45,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_EASTERN},
		{name=Z["Swamp of Sorrows"],low=35,high=45,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_EASTERN},
		{name=Z["The Hinterlands"],low=40,high=50,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_EASTERN},
		{name=Z["Searing Gorge"],low=43,high=50,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_EASTERN},
		{name=Z["Blasted Lands"],low=47,high=55,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_EASTERN},
		{name=Z["Burning Steppes"],low=50,high=60,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_EASTERN},
		{name=Z["Western Plaguelands"],low=50,high=60,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_EASTERN},
		{name=Z["Deadwind Pass"],low=55,high=60,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_EASTERN},
		{name=Z["Eastern Plaguelands"],low=55,high=60,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_EASTERN},
		{name=Z["Isle of Quel'Danas"],low=65,high=70,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_EASTERN},
		
-- Kalimdor
		{name=Z["Darnassus"],low=70,high=70,faction=RZ_ALLIANCE,type=RZ_CITY,continent=RZ_KALIMDOR},
		{name=Z["Orgrimmar"],low=70,high=70,faction=RZ_HORDE,type=RZ_CITY,continent=RZ_KALIMDOR},
		{name=Z["Thunder Bluff"],low=70,high=70,faction=RZ_HORDE,type=RZ_CITY,continent=RZ_KALIMDOR},
		{name=Z["Moonglade"],low=0,high=0,faction=RZ_CONTESTED,type=RZ_CITY,continent=RZ_KALIMDOR},
		{name=Z["Teldrassil"],low=1,high=12,faction=RZ_ALLIANCE,type=RZ_ZONE,continent=RZ_KALIMDOR},
		{name=Z["Durotar"],low=1,high=12,faction=RZ_HORDE,type=RZ_ZONE,continent=RZ_KALIMDOR},
		{name=Z["Mulgore"],low=1,high=12,faction=RZ_HORDE,type=RZ_ZONE,continent=RZ_KALIMDOR},
		{name=Z["Darkshore"],low=10,high=20,faction=RZ_ALLIANCE,type=RZ_ZONE,continent=RZ_KALIMDOR},
		{name=Z["The Barrens"],low=10,high=25,faction=RZ_HORDE,type=RZ_ZONE,continent=RZ_KALIMDOR},
		{name=Z["Stonetalon Mountains"],low=15,high=27,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_KALIMDOR},
		{name=Z["Ashenvale"], low=15,high=30,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_KALIMDOR},
		{name=Z["Thousand Needles"],low=25,high=35,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_KALIMDOR},
		{name=Z["Desolace"],low=30,high=40,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_KALIMDOR},
		{name=Z["Dustwallow Marsh"],low=35,high=45,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_KALIMDOR},
		{name=Z["Feralas"],low=40,high=50,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_KALIMDOR},
		{name=Z["Tanaris"],low=40,high=50,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_KALIMDOR},
		{name=Z["Un'Goro Crater"],low=48,high=55,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_KALIMDOR},
		{name=Z["Azshara"],low=48,high=55,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_KALIMDOR},
		{name=Z["Felwood"],low=48,high=55,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_KALIMDOR},
		{name=Z["Silithus"],low=55,high=60,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_KALIMDOR},
		{name=Z["Winterspring"],low=55,high=60,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_KALIMDOR},

-- Blood Elf
		{name=Z["Silvermoon City"],low=70,high=70,faction=RZ_HORDE,type=RZ_CITY,continent=RZ_EASTERN},
		{name=Z["Eversong Woods"],low=1,high=12,faction=RZ_HORDE,type=RZ_ZONE,continent=RZ_EASTERN},
		{name=Z["Ghostlands"],low=10,high=20,faction=RZ_HORDE,type=RZ_ZONE,continent=RZ_EASTERN},
	
-- Draenei	
		{name=Z["The Exodar"],low=70,high=70,faction=RZ_ALLIANCE,type=RZ_CITY,continent=RZ_KALIMDOR},
		{name=Z["Azuremyst Isle"],low=1,high=12,faction=RZ_ALLIANCE,type=RZ_ZONE,continent=RZ_KALIMDOR},
		{name=Z["Bloodmyst Isle"],low=10,high=20,faction=RZ_ALLIANCE,type=RZ_ZONE,continent=RZ_KALIMDOR},
		{name=L["Boat"],x=5,low=70,high=70,faction=RZ_CONTESTED,type=RZ_TRANSPORT,continent=RZ_OTHER},

-- Outland	
		{name=Z["Shattrath City"],low=1,high=1,faction=RZ_SANCTUARY,type=RZ_CITY,continent=RZ_OUTLAND},
		{name=Z["Hellfire Peninsula"],low=58,high=63,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_OUTLAND},
		{name=Z["Zangarmarsh"],low=60,high=64,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_OUTLAND},
		{name=Z["Terokkar Forest"],low=62,high=65,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_OUTLAND},
		{name=Z["Nagrand"],low=64,high=67,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_OUTLAND},
		{name=Z["Blade's Edge Mountains"],low=65,high=68,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_OUTLAND},
		{name=Z["Netherstorm"],low=67,high=70,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_OUTLAND},
		{name=Z["Shadowmoon Valley"],low=67,high=70,faction=RZ_CONTESTED,type=RZ_ZONE,continent=RZ_OUTLAND},
	
-- Instances
		{name=Z["Ragefire Chasm"],low=13,high=20,type=RZ_INSTANCE,faction=RZ_HORDE,continent=RZ_KALIMDOR},
		{name=Z["Wailing Caverns"],low=17,high=24,type=RZ_INSTANCE,faction=RZ_CONTESTED,continent=RZ_KALIMDOR},
		{name=Z["The Deadmines"],low=17,high=26,type=RZ_INSTANCE,faction=RZ_CONTESTED,continent=RZ_EASTERN},
		{name=Z["The Stockade"],low=24,high=32,type=RZ_INSTANCE,faction=RZ_ALLIANCE,continent=RZ_EASTERN},
		{name=Z["Shadowfang Keep"],low=20,high=28,type=RZ_INSTANCE,faction=RZ_CONTESTED,continent=RZ_EASTERN},
		{name=Z["Blackfathom Deeps"],low=23,high=30,type=RZ_INSTANCE,faction=RZ_CONTESTED,continent=RZ_KALIMDOR},
		{name=Z["Gnomeregan"],low=29,high=38,type=RZ_INSTANCE,faction=RZ_CONTESTED,continent=RZ_EASTERN},
		{name=Z["Razorfen Kraul"],low=29,high=38,type=RZ_INSTANCE,faction=RZ_CONTESTED,continent=RZ_KALIMDOR},
		{name=Z["Scarlet Monastery"],low=33,high=44,type=RZ_INSTANCE,faction=RZ_CONTESTED,continent=RZ_EASTERN},
		{name=Z["Razorfen Downs"],low=37,high=46,type=RZ_INSTANCE,faction=RZ_CONTESTED,continent=RZ_KALIMDOR},
		{name=Z["Uldaman"],low=38,high=46,type=RZ_INSTANCE,faction=RZ_CONTESTED,continent=RZ_EASTERN},
		{name=Z["Maraudon"],low=45,high=55,type=RZ_INSTANCE,faction=RZ_CONTESTED,continent=RZ_KALIMDOR},
		{name=Z["Zul'Farrak"],low=43,high=50,type=RZ_INSTANCE,faction=RZ_CONTESTED,continent=RZ_KALIMDOR},
		{name=Z["The Temple of Atal'Hakkar"],low=44,high=52,type=RZ_INSTANCE,faction=RZ_CONTESTED,continent=RZ_EASTERN},
		{name=Z["Blackrock Depths"],low=50,high=56,type=RZ_INSTANCE,faction=RZ_CONTESTED,continent=RZ_EASTERN},
		{name=Z["Blackrock Spire"],low=56,high=60,type=RZ_INSTANCE,faction=RZ_CONTESTED,continent=RZ_EASTERN},
		{name=Z["Stratholme"],low=56,high=60,type=RZ_INSTANCE,faction=RZ_CONTESTED,continent=RZ_EASTERN},
		{name=Z["Dire Maul"],low=56,high=60,type=RZ_INSTANCE,faction=RZ_CONTESTED,continent=RZ_KALIMDOR},
		{name=Z["Scholomance"],low=58,high=60,type=RZ_INSTANCE,faction=RZ_CONTESTED,continent=RZ_EASTERN},
		{name=Z["Warsong Gulch"],x=1,low=10,high=60,type=RZ_BATTLEGROUND,faction=RZ_HORDE,continent=RZ_KALIMDOR},
		{name=Z["Warsong Gulch"],x=2,low=10,high=60,type=RZ_BATTLEGROUND,faction=RZ_ALLIANCE,continent=RZ_KALIMDOR},
		{name=Z["Arathi Basin"],low=20,high=60,type=RZ_BATTLEGROUND,faction=RZ_CONTESTED,continent=RZ_EASTERN},
		{name=Z["Alterac Valley"],low=51,high=60,type=RZ_BATTLEGROUND,faction=RZ_CONTESTED,continent=RZ_EASTERN},
		{name=Z["Blackwing Lair"],low=60,high=60,type=RZ_RAID40,faction=RZ_CONTESTED,continent=RZ_EASTERN},
		{name=Z["Molten Core"],low=60,high=60,type=RZ_RAID40,faction=RZ_CONTESTED,continent=RZ_EASTERN},
		{name=Z["Onyxia's Lair"],low=60,high=60,type=RZ_RAID40,faction=RZ_CONTESTED,continent=RZ_KALIMDOR},
		{name=Z["Zul'Gurub"],low=60,high=60,type=RZ_RAID20,faction=RZ_CONTESTED,continent=RZ_EASTERN},
		{name=Z["Ahn'Qiraj"],low=60,high=60,type=RZ_RAID20,faction=RZ_CONTESTED,continent=RZ_KALIMDOR},
		{name=Z["Temple of Ahn'Qiraj"],low=60,high=60,type=RZ_RAID40,faction=RZ_CONTESTED,continent=RZ_EASTERN},
		{name=Z["Naxxramas"],low=60,high=60,type=RZ_RAID40,faction=RZ_CONTESTED,continent=RZ_KALIMDOR},

-- BC Instances
		{name=Z["Hellfire Ramparts"],low=60,high=62,faction=RZ_CONTESTED,type=RZ_INSTANCE,continent=RZ_OUTLAND},
		{name=Z["The Blood Furnace"],low=61,high=63,faction=RZ_CONTESTED,type=RZ_INSTANCE,continent=RZ_OUTLAND},
		{name=Z["The Slave Pens"],low=62,high=64,faction=RZ_CONTESTED,type=RZ_INSTANCE,continent=RZ_OUTLAND},
		{name=Z["The Underbog"],low=63,high=65,faction=RZ_CONTESTED,type=RZ_INSTANCE,continent=RZ_OUTLAND},
		{name=Z["Auchenai Crypts"],low=64,high=66,faction=RZ_CONTESTED,type=RZ_INSTANCE,continent=RZ_OUTLAND},
		{name=Z["Shadow Labyrinth"],low=65,high=67,faction=RZ_CONTESTED,type=RZ_INSTANCE,continent=RZ_OUTLAND},
		{name=Z["Sethekk Halls"],low=67,high=69,faction=RZ_CONTESTED,type=RZ_INSTANCE,continent=RZ_OUTLAND},
		{name=Z["The Mechanar"],low=69,high=72,faction=RZ_CONTESTED,type=RZ_INSTANCE,continent=RZ_OUTLAND},
		{name=Z["The Shattered Halls"],low=70,high=72,faction=RZ_CONTESTED,type=RZ_INSTANCE,continent=RZ_OUTLAND},
		{name=Z["The Botanica"],low=70,high=72,faction=RZ_CONTESTED,type=RZ_INSTANCE,continent=RZ_OUTLAND},
		{name=Z["The Arcatraz"],low=70,high=72,faction=RZ_CONTESTED,type=RZ_INSTANCE,continent=RZ_OUTLAND},
		{name=Z["Mana-Tombs"],low=70,high=72,faction=RZ_CONTESTED,type=RZ_INSTANCE,continent=RZ_OUTLAND},
		{name=Z["The Steamvault"],low=70,high=72,faction=RZ_CONTESTED,type=RZ_INSTANCE,continent=RZ_OUTLAND},
		{name=Z["Karazhan"],low=70,high=72,faction=RZ_CONTESTED,type=RZ_RAID10,continent=RZ_EASTERN},
		{name=Z["Gruul's Lair"],low=70,high=72,faction=RZ_CONTESTED,type=RZ_RAID25,continent=RZ_OUTLAND},
		{name=Z["Magtheridon's Lair"],low=70,high=72,faction=RZ_CONTESTED,type=RZ_RAID25,continent=RZ_OUTLAND},
		{name=Z["Eye of the Storm"],low=70,high=72,faction=RZ_CONTESTED,type=RZ_RAID25,continent=RZ_OUTLAND},
		{name=Z["Black Temple"],low=70,high=72,faction=RZ_CONTESTED,type=RZ_RAID25,continent=RZ_OUTLAND},
		{name=Z["Serpentshrine Cavern"],low=70,high=72,faction=RZ_CONTESTED,type=RZ_RAID25,continent=RZ_OUTLAND},
		{name=Z["Magisters' Terrace"],low=70,high=72,faction=RZ_CONTESTED,type=RZ_INSTANCE,continent=RZ_EASTERN},
		{name=Z["Sunwell Plateau"],low=70,high=72,faction=RZ_CONTESTED,type=RZ_RAID25,continent=RZ_EASTERN},
		{name=Z["Zul'Aman"],low=70,high=72,faction=RZ_CONTESTED,type=RZ_RAID10,continent=RZ_EASTERN},

-- Towns and transport zones
		{name=Z["Booty Bay"],low=30,high=45,faction=RZ_CONTESTED,type=RZ_CITY,continent=RZ_EASTERN},
		{name=Z["Ratchet"],low=10,high=25,faction=RZ_CONTESTED,type=RZ_CITY,continent=RZ_KALIMDOR},
		{name=Z["Gadgetzan"],low=40,high=50,faction=RZ_CONTESTED,type=RZ_CITY,continent=RZ_KALIMDOR},
		{name=Z["Deeprun Tram"],low=0,high=0,faction=RZ_ALLIANCE,type=RZ_CITY,continent=RZ_EASTERN},
		{name=Z["Theramore Isle"],low=35,high=45,faction=RZ_ALLIANCE,type=RZ_CITY,continent=RZ_KALIMDOR},
		{name=Z["Menethil Harbor"],low=20,high=30,faction=RZ_ALLIANCE,type=RZ_CITY,continent=RZ_EASTERN},
		{name=Z["Auberdine"],low=10,high=20,faction=RZ_ALLIANCE,type=RZ_CITY,continent=RZ_KALIMDOR},
		{name=Z["Grom'gol Base Camp"],low=30,high=45,faction=RZ_HORDE,type=RZ_CITY,continent=RZ_EASTERN},
		{name=Z["Blackrock Mountain"],low=60,high=60,type=RZ_TRANSPORT,faction=RZ_CONTESTED,continent=RZ_EASTERN},

-- Transports
		{name=L["Boat"],x=1,low=70,high=70,faction=RZ_ALLIANCE,type=RZ_TRANSPORT,continent=RZ_OTHER},
		{name=L["Boat"],x=2,low=70,high=70,faction=RZ_ALLIANCE,type=RZ_TRANSPORT,continent=RZ_OTHER},
		{name=L["Boat"],x=3,low=70,high=70,faction=RZ_ALLIANCE,type=RZ_TRANSPORT,continent=RZ_OTHER},
		{name=L["Boat"],x=4,low=70,high=70,faction=RZ_CONTESTED,type=RZ_TRANSPORT,continent=RZ_OTHER},
		{name=L["Portal"],x=1,low=70,high=70,faction=RZ_CONTESTED,type=RZ_TRANSPORT,continent=RZ_OTHER},
		{name=L["Portal"],x=2,low=70,high=70,faction=RZ_ALLIANCE,type=RZ_TRANSPORT,continent=RZ_OTHER},
		{name=L["Portal"],x=3,low=70,high=70,faction=RZ_ALLIANCE,type=RZ_TRANSPORT,continent=RZ_OTHER},
		{name=L["Portal"],x=4,low=70,high=70,faction=RZ_ALLIANCE,type=RZ_TRANSPORT,continent=RZ_OTHER},
		{name=L["Portal"],x=5,low=70,high=70,faction=RZ_HORDE,type=RZ_TRANSPORT,continent=RZ_OTHER},
		{name=L["Portal"],x=6,low=70,high=70,faction=RZ_HORDE,type=RZ_TRANSPORT,continent=RZ_OTHER},
		{name=L["Portal"],x=7,low=70,high=70,faction=RZ_HORDE,type=RZ_TRANSPORT,continent=RZ_OTHER},
		{name=L["Zeppelin"],x=1,low=70,high=70,faction=RZ_HORDE,type=RZ_TRANSPORT,continent=RZ_OTHER},
		{name=L["Zeppelin"],x=2,low=70,high=70,faction=RZ_HORDE,type=RZ_TRANSPORT,continent=RZ_OTHER},
		{name=L["Zeppelin"],x=3,low=70,high=70,faction=RZ_HORDE,type=RZ_TRANSPORT,continent=RZ_OTHER},

-- Transport between old and new world	
		{name=Z["The Dark Portal"],low=1,high=1,faction=RZ_CONTESTED,type=RZ_TRANSPORT,continent=RZ_OTHER},
		{name=L["Orb of Translocation"],low=1,high=1,faction=RZ_HORDE,type=RZ_TRANSPORT,continent=RZ_OTHER},
	
-- Not real zones
		{name=Z["The Forbidding Sea"],low=0,high=0,faction=RZ_CONTESTED,type=RZ_NONE,continent=RZ_OTHER},
		{name=Z["Twisting Nether"],low=0,high=0,faction=RZ_CONTESTED,type=RZ_NONE,continent=RZ_OTHER},
		{name=Z["The Great Sea"],low=0,high=0,faction=RZ_CONTESTED,type=RZ_NONE,continent=RZ_OTHER},
		{name=Z["The North Sea"],low=0,high=0,faction=RZ_CONTESTED,type=RZ_NONE,continent=RZ_OTHER},
		{name=Z["The Veiled Sea"],low=0,high=0,faction=RZ_CONTESTED,type=RZ_NONE,continent=RZ_OTHER},
		{name=Z["Hall of Legends"],low=0,high=0,faction=RZ_CONTESTED,type=RZ_NONE,continent=RZ_OTHER},
		{name=Z["Hyjal"],low=0,high=0,faction=RZ_CONTESTED,type=RZ_NONE,continent=RZ_KALIMDOR},
	}

	table.sort(RecZone.vars.zones,function(a,b)
		if a.low<b.low then return true end
		if a.low==b.low and a.high<b.high then return true end
		if a.low==b.low and a.high==b.high and a.name<b.name then return true end
	end);
	
	RecZone.vars.zones[zn(Z["Stormwind City"])].zones={zn(Z["Deeprun Tram"]),zn(Z["Elwynn Forest"]),zn(Z["The Stockade"])}
	RecZone.vars.zones[zn(Z["Ironforge"])].zones={zn(Z["Deeprun Tram"]),zn(Z["Dun Morogh"]),zn(Z["Isle of Quel'Danas"]),znx(L["Portal"],2)}
	RecZone.vars.zones[zn(Z["Darnassus"])].zones={zn(Z["Teldrassil"]),znx(L["Boat"],3)}
	RecZone.vars.zones[zn(Z["Undercity"])].zones={zn(L["Orb of Translocation"]),zn(Z["Tirisfal Glades"])}
	RecZone.vars.zones[zn(Z["Orgrimmar"])].zones={zn(Z["Durotar"]),zn(Z["Ragefire Chasm"])}
	RecZone.vars.zones[zn(Z["Thunder Bluff"])].zones={zn(Z["Mulgore"])}
	RecZone.vars.zones[zn(Z["Moonglade"])].zones={zn(Z["Winterspring"])}
	RecZone.vars.zones[zn(Z["Dun Morogh"])].zones={zn(Z["Ironforge"]),zn(Z["Loch Modan"]),zn(Z["Gnomeregan"])}
	RecZone.vars.zones[zn(Z["Elwynn Forest"])].zones={zn(Z["Stormwind City"]),zn(Z["Westfall"]),zn(Z["Redridge Mountains"]),zn(Z["Duskwood"])}
	RecZone.vars.zones[zn(Z["Teldrassil"])].zones={zn(Z["Darnassus"])}
	RecZone.vars.zones[zn(Z["Tirisfal Glades"])].zones={zn(Z["Undercity"]),zn(Z["Silverpine Forest"]),zn(Z["Western Plaguelands"]),znx(L["Zeppelin"],1),znx(L["Zeppelin"],2),zn(Z["Scarlet Monastery"])}
	RecZone.vars.zones[zn(Z["Durotar"])].zones={zn(Z["Orgrimmar"]),zn(Z["The Barrens"]),zn(Z["Azshara"]),znx(L["Zeppelin"],1),znx(L["Zeppelin"],3)}
	RecZone.vars.zones[zn(Z["Mulgore"])].zones={zn(Z["Thunder Bluff"]),zn(Z["The Barrens"])}
	RecZone.vars.zones[zn(Z["Loch Modan"])].zones={zn(Z["Dun Morogh"]),zn(Z["Wetlands"]),zn(Z["Badlands"])}
	RecZone.vars.zones[zn(Z["Westfall"])].zones={zn(Z["Elwynn Forest"]),zn(Z["Duskwood"]),zn(Z["The Deadmines"])}
	RecZone.vars.zones[zn(Z["Silverpine Forest"])].zones={zn(Z["Tirisfal Glades"]),zn(Z["Hillsbrad Foothills"]),zn(Z["Alterac Mountains"]),zn(Z["Shadowfang Keep"])}
	RecZone.vars.zones[zn(Z["Darkshore"])].zones={zn(Z["Ashenvale"]),zn(Z["Auberdine"])}
	RecZone.vars.zones[zn(Z["The Barrens"])].zones={zn(Z["Ratchet"]),zn(Z["Durotar"]),zn(Z["Mulgore"]),zn(Z["Stonetalon Mountains"]),zn(Z["Ashenvale"]),zn(Z["Thousand Needles"]),zn(Z["Dustwallow Marsh"]),zn(Z["Wailing Caverns"]),zn(Z["Razorfen Kraul"]),zn(Z["Razorfen Downs"]),znx(Z["Warsong Gulch"],1)}
	RecZone.vars.zones[zn(Z["Redridge Mountains"])].zones={zn(Z["Elwynn Forest"]),zn(Z["Burning Steppes"])}
	RecZone.vars.zones[zn(Z["Stonetalon Mountains"])].zones={zn(Z["The Barrens"]),zn(Z["Ashenvale"]),zn(Z["Desolace"])}
	RecZone.vars.zones[zn(Z["Ashenvale"])].zones={zn(Z["Darkshore"]),zn(Z["The Barrens"]),zn(Z["Stonetalon Mountains"]),zn(Z["Azshara"]),zn(Z["Felwood"]),zn(Z["Blackfathom Deeps"]),znx(Z["Warsong Gulch"],2)}
	RecZone.vars.zones[zn(Z["Wetlands"])].zones={zn(Z["Loch Modan"]),zn(Z["Arathi Highlands"]),zn(Z["Menethil Harbor"])}
	RecZone.vars.zones[zn(Z["Duskwood"])].zones={zn(Z["Elwynn Forest"]),zn(Z["Westfall"]),zn(Z["Stranglethorn Vale"]),zn(Z["Deadwind Pass"])}
	RecZone.vars.zones[zn(Z["Hillsbrad Foothills"])].zones={zn(Z["Silverpine Forest"]),zn(Z["Alterac Mountains"]),zn(Z["Arathi Highlands"])}
	RecZone.vars.zones[zn(Z["Thousand Needles"])].zones={zn(Z["The Barrens"]),zn(Z["Feralas"]),zn(Z["Tanaris"])}
	RecZone.vars.zones[zn(Z["Alterac Mountains"])].zones={zn(Z["Silverpine Forest"]),zn(Z["Hillsbrad Foothills"]),zn(Z["The Hinterlands"]),zn(Z["Western Plaguelands"]),zn(Z["Alterac Valley"])}
	RecZone.vars.zones[zn(Z["Arathi Highlands"])].zones={zn(Z["Wetlands"]),zn(Z["Hillsbrad Foothills"]),zn(Z["Arathi Basin"])}
	RecZone.vars.zones[zn(Z["Desolace"])].zones={zn(Z["Stonetalon Mountains"]),zn(Z["Feralas"]),zn(Z["Maraudon"])}
	RecZone.vars.zones[zn(Z["Stranglethorn Vale"])].zones={zn(Z["Booty Bay"]),zn(Z["Duskwood"]),zn(Z["Grom'gol Base Camp"]),zn(Z["Zul'Gurub"])}
	RecZone.vars.zones[zn(Z["Badlands"])].zones={zn(Z["Loch Modan"]),zn(Z["Searing Gorge"]),zn(Z["Uldaman"])}
	RecZone.vars.zones[zn(Z["Swamp of Sorrows"])].zones={zn(Z["Blasted Lands"]),zn(Z["Deadwind Pass"]),zn(Z["The Temple of Atal'Hakkar"])}
	RecZone.vars.zones[zn(Z["Dustwallow Marsh"])].zones={zn(Z["The Barrens"]),zn(Z["Theramore Isle"]),zn(Z["Onyxia's Lair"])}
	RecZone.vars.zones[zn(Z["The Hinterlands"])].zones={zn(Z["Alterac Mountains"]),zn(Z["Western Plaguelands"])}
	RecZone.vars.zones[zn(Z["Feralas"])].zones={zn(Z["Thousand Needles"]),zn(Z["Desolace"]),zn(Z["Dire Maul"])}
	RecZone.vars.zones[zn(Z["Tanaris"])].zones={zn(Z["Thousand Needles"]),zn(Z["Un'Goro Crater"]),zn(Z["Gadgetzan"]),zn(Z["Zul'Farrak"])}
	RecZone.vars.zones[zn(Z["Searing Gorge"])].zones={zn(Z["Badlands"]),zn(Z["Blackrock Mountain"])}
	RecZone.vars.zones[zn(Z["Blasted Lands"])].zones={zn(Z["Swamp of Sorrows"]),zn(Z["The Dark Portal"])}
	RecZone.vars.zones[zn(Z["Un'Goro Crater"])].zones={zn(Z["Tanaris"]),zn(Z["Silithus"])}
	RecZone.vars.zones[zn(Z["Azshara"])].zones={zn(Z["Durotar"]),zn(Z["Ashenvale"])}
	RecZone.vars.zones[zn(Z["Felwood"])].zones={zn(Z["Darkshore"]),zn(Z["Ashenvale"]),zn(Z["Winterspring"])}
	RecZone.vars.zones[zn(Z["Burning Steppes"])].zones={zn(Z["Redridge Mountains"]),zn(Z["Blackrock Mountain"])}
	RecZone.vars.zones[zn(Z["Western Plaguelands"])].zones={zn(Z["Tirisfal Glades"]),zn(Z["Alterac Mountains"]),zn(Z["The Hinterlands"]),zn(Z["Eastern Plaguelands"]),zn(Z["Scholomance"])}
	RecZone.vars.zones[zn(Z["Deadwind Pass"])].zones={zn(Z["Duskwood"]),zn(Z["Swamp of Sorrows"]),zn(Z["Karazhan"])}
	RecZone.vars.zones[zn(Z["Karazhan"])].zones={zn(Z["Deadwind Pass"])}
	RecZone.vars.zones[zn(Z["Eastern Plaguelands"])].zones={zn(Z["Western Plaguelands"]),zn(Z["Stratholme"]),zn(Z["Naxxramas"]),zn(Z["Ghostlands"])}
	RecZone.vars.zones[zn(Z["Silithus"])].zones={zn(Z["Un'Goro Crater"]),zn(Z["Ahn'Qiraj"]),zn(Z["Temple of Ahn'Qiraj"])}
	RecZone.vars.zones[zn(Z["Winterspring"])].zones={zn(Z["Moonglade"]),zn(Z["Felwood"])}

	RecZone.vars.zones[zn(Z["Isle of Quel'Danas"])].zones={zn(Z["Magisters' Terrace"]),zn(Z["Sunwell Plateau"]),zn(Z["Ironforge"]),zn(Z["Silvermoon City"])}

	RecZone.vars.zones[zn(Z["Silvermoon City"])].zones={zn(Z["Eversong Woods"]),zn(L["Orb of Translocation"]),zn(Z["Isle of Quel'Danas"])}
	RecZone.vars.zones[zn(Z["Eversong Woods"])].zones={zn(Z["Ghostlands"]),zn(Z["Silvermoon City"])}
	RecZone.vars.zones[zn(Z["Ghostlands"])].zones={zn(Z["Eversong Woods"]),zn(Z["Eastern Plaguelands"]),zn(Z["Zul'Aman"])}

	RecZone.vars.zones[zn(Z["Auberdine"])].zones={zn(Z["Darkshore"]),znx(L["Boat"],2),znx(L["Boat"],3),znx(L["Boat"],5)}
	RecZone.vars.zones[zn(Z["Azuremyst Isle"])].zones={zn(Z["Bloodmyst Isle"]),zn(Z["The Exodar"]),znx(L["Boat"],5)}
	RecZone.vars.zones[zn(Z["Bloodmyst Isle"])].zones={zn(Z["Azuremyst Isle"])}
	RecZone.vars.zones[zn(Z["The Exodar"])].zones={zn(Z["Azuremyst Isle"])}

	RecZone.vars.zones[zn(Z["Shattrath City"])].zones={zn(Z["Terokkar Forest"]),znx(L["Portal"],1),znx(L["Portal"],2),znx(L["Portal"],3),znx(L["Portal"],4),znx(L["Portal"],5),znx(L["Portal"],6),znx(L["Portal"],7)}
	RecZone.vars.zones[zn(Z["Hellfire Peninsula"])].zones={zn(Z["Zangarmarsh"]),zn(Z["Terokkar Forest"]),zn(Z["Hellfire Ramparts"]),zn(Z["The Blood Furnace"]),zn(Z["The Shattered Halls"]),zn(Z["Magtheridon's Lair"]),zn(Z["The Dark Portal"])}
	RecZone.vars.zones[zn(Z["Zangarmarsh"])].zones={zn(Z["Hellfire Peninsula"]),zn(Z["Terokkar Forest"]),zn(Z["Nagrand"]),zn(Z["Blade's Edge Mountains"]),zn(Z["The Slave Pens"]),zn(Z["The Underbog"]),zn(Z["The Steamvault"]),zn(Z["Serpentshrine Cavern"])}
	RecZone.vars.zones[zn(Z["Terokkar Forest"])].zones={zn(Z["Hellfire Peninsula"]),zn(Z["Zangarmarsh"]),zn(Z["Nagrand"]),zn(Z["Shadowmoon Valley"]),zn(Z["Auchenai Crypts"]),zn(Z["Shadow Labyrinth"]),zn(Z["Sethekk Halls"]),zn(Z["Mana-Tombs"]),zn(Z["Shattrath City"])}
	RecZone.vars.zones[zn(Z["Nagrand"])].zones={zn(Z["Zangarmarsh"]),zn(Z["Terokkar Forest"])}
	RecZone.vars.zones[zn(Z["Blade's Edge Mountains"])].zones={zn(Z["Zangarmarsh"]),zn(Z["Netherstorm"]),zn(Z["Gruul's Lair"])}
	RecZone.vars.zones[zn(Z["Netherstorm"])].zones={zn(Z["Blade's Edge Mountains"]),zn(Z["The Mechanar"]),zn(Z["The Botanica"]),zn(Z["The Arcatraz"]),zn(Z["Eye of the Storm"])}
	RecZone.vars.zones[zn(Z["Shadowmoon Valley"])].zones={zn(Z["Terokkar Forest"]),zn(Z["Black Temple"])}
	
	RecZone.vars.zones[zn(Z["Ragefire Chasm"])].zones={zn(Z["Orgrimmar"])}
	RecZone.vars.zones[zn(Z["Wailing Caverns"])].zones={zn(Z["The Barrens"])}
	RecZone.vars.zones[zn(Z["The Deadmines"])].zones={zn(Z["Westfall"])}
	RecZone.vars.zones[zn(Z["The Stockade"])].zones={zn(Z["Stormwind City"])}
	RecZone.vars.zones[zn(Z["Shadowfang Keep"])].zones={zn(Z["Silverpine Forest"])}
	RecZone.vars.zones[zn(Z["Blackfathom Deeps"])].zones={zn(Z["Ashenvale"])}
	RecZone.vars.zones[zn(Z["Gnomeregan"])].zones={zn(Z["Dun Morogh"])}
	RecZone.vars.zones[zn(Z["Razorfen Kraul"])].zones={zn(Z["The Barrens"])}
	RecZone.vars.zones[zn(Z["Scarlet Monastery"])].zones={zn(Z["Tirisfal Glades"])}
	RecZone.vars.zones[zn(Z["Razorfen Downs"])].zones={zn(Z["The Barrens"])}
	RecZone.vars.zones[zn(Z["Uldaman"])].zones={zn(Z["Badlands"])}
	RecZone.vars.zones[zn(Z["Maraudon"])].zones={zn(Z["Desolace"])}
	RecZone.vars.zones[zn(Z["Zul'Farrak"])].zones={zn(Z["Tanaris"])}
	RecZone.vars.zones[zn(Z["The Temple of Atal'Hakkar"])].zones={zn(Z["Swamp of Sorrows"])}
	RecZone.vars.zones[zn(Z["Blackrock Depths"])].zones={zn(Z["Blackrock Mountain"]),zn(Z["Molten Core"])}
	RecZone.vars.zones[zn(Z["Blackrock Spire"])].zones={zn(Z["Blackrock Mountain"]),zn(Z["Blackwing Lair"])}
	RecZone.vars.zones[zn(Z["Stratholme"])].zones={zn(Z["Eastern Plaguelands"])}
	RecZone.vars.zones[zn(Z["Dire Maul"])].zones={zn(Z["Feralas"])}
	RecZone.vars.zones[zn(Z["Scholomance"])].zones={zn(Z["Western Plaguelands"])}
	RecZone.vars.zones[zn(Z["Warsong Gulch"])].zones={zn(Z["The Barrens"])}
	RecZone.vars.zones[zn(Z["Warsong Gulch"])].zones={zn(Z["Ashenvale"])}
	RecZone.vars.zones[zn(Z["Arathi Basin"])].zones={zn(Z["Arathi Highlands"])}
	RecZone.vars.zones[zn(Z["Alterac Valley"])].zones={zn(Z["Alterac Mountains"])}
	RecZone.vars.zones[zn(Z["Blackwing Lair"])].zones={zn(Z["Blackrock Spire"])}
	RecZone.vars.zones[zn(Z["Molten Core"])].zones={zn(Z["Blackrock Depths"])}
	RecZone.vars.zones[zn(Z["Onyxia's Lair"])].zones={zn(Z["Dustwallow Marsh"])}
	RecZone.vars.zones[zn(Z["Zul'Gurub"])].zones={zn(Z["Stranglethorn Vale"])}
	RecZone.vars.zones[zn(Z["Ahn'Qiraj"])].zones={zn(Z["Silithus"])}
	RecZone.vars.zones[zn(Z["Temple of Ahn'Qiraj"])].zones={zn(Z["Silithus"])}
	RecZone.vars.zones[zn(Z["Naxxramas"])].zones={zn(Z["Eastern Plaguelands"])}
	RecZone.vars.zones[zn(Z["Zul'Aman"])].zones={zn(Z["Ghostlands"])}

--["Hellfire Citadel"]
	RecZone.vars.zones[zn(Z["Hellfire Ramparts"])].zones={zn(Z["Hellfire Peninsula"])}
	RecZone.vars.zones[zn(Z["The Blood Furnace"])].zones={zn(Z["Hellfire Peninsula"])}
	RecZone.vars.zones[zn(Z["The Shattered Halls"])].zones={zn(Z["Hellfire Peninsula"])}
	RecZone.vars.zones[zn(Z["Magtheridon's Lair"])].zones={zn(Z["Hellfire Peninsula"])}
--["Tempest Keep"]
	RecZone.vars.zones[zn(Z["The Mechanar"])].zones={zn(Z["Netherstorm"])}
	RecZone.vars.zones[zn(Z["The Botanica"])].zones={zn(Z["Netherstorm"])}
	RecZone.vars.zones[zn(Z["The Arcatraz"])].zones={zn(Z["Netherstorm"])}
	RecZone.vars.zones[zn(Z["Eye of the Storm"])].zones={zn(Z["Netherstorm"])}
--["Coilfang Reservoir"]
	RecZone.vars.zones[zn(Z["The Slave Pens"])].zones={zn(Z["Zangarmarsh"])}
	RecZone.vars.zones[zn(Z["The Underbog"])].zones={zn(Z["Zangarmarsh"])}
	RecZone.vars.zones[zn(Z["The Steamvault"])].zones={zn(Z["Zangarmarsh"])}
	RecZone.vars.zones[zn(Z["Serpentshrine Cavern"])].zones={zn(Z["Zangarmarsh"])}
--["Auchindoun"]
	RecZone.vars.zones[zn(Z["Auchenai Crypts"])].zones={zn(Z["Terokkar Forest"])}
	RecZone.vars.zones[zn(Z["Shadow Labyrinth"])].zones={zn(Z["Terokkar Forest"])}
	RecZone.vars.zones[zn(Z["Sethekk Halls"])].zones={zn(Z["Terokkar Forest"])}
	RecZone.vars.zones[zn(Z["Mana-Tombs"])].zones={zn(Z["Terokkar Forest"])}

	RecZone.vars.zones[zn(Z["Gruul's Lair"])].zones={zn(Z["Blade's Edge Mountains"])}
	RecZone.vars.zones[zn(Z["Black Temple"])].zones={zn(Z["Shadowmoon Valley"])}

--["Isle of Quel'Danas"]
	RecZone.vars.zones[zn(Z["Magisters' Terrace"])].zones={zn(Z["Isle of Quel'Danas"])}
	RecZone.vars.zones[zn(Z["Sunwell Plateau"])].zones={zn(Z["Isle of Quel'Danas"])}

	RecZone.vars.zones[zn(Z["Gadgetzan"])].zones={zn(Z["Tanaris"])}
	RecZone.vars.zones[zn(Z["Deeprun Tram"])].zones={zn(Z["Stormwind City"]),zn(Z["Ironforge"])}
	RecZone.vars.zones[zn(Z["Theramore Isle"])].zones={zn(Z["Dustwallow Marsh"]),znx(L["Boat"],1)}
	RecZone.vars.zones[zn(Z["Booty Bay"])].zones={zn(Z["Stranglethorn Vale"]),znx(L["Boat"],4)}
	RecZone.vars.zones[zn(Z["Ratchet"])].zones={zn(Z["The Barrens"]),znx(L["Boat"],4)}
	RecZone.vars.zones[zn(Z["Menethil Harbor"])].zones={zn(Z["Wetlands"]),znx(L["Boat"],1),znx(L["Boat"],2)}
	RecZone.vars.zones[zn(Z["Auberdine"])].zones={zn(Z["Darkshore"]),znx(L["Boat"],2),znx(L["Boat"],3)}
	RecZone.vars.zones[zn(Z["Grom'gol Base Camp"])].zones={zn(Z["Stranglethorn Vale"]),znx(L["Zeppelin"],2),znx(L["Zeppelin"],3)}
	RecZone.vars.zones[zn(Z["Blackrock Mountain"])].zones={zn(Z["Searing Gorge"]),zn(Z["Burning Steppes"]),zn(Z["Blackrock Depths"]),zn(Z["Blackrock Spire"])}

	RecZone.vars.zones[znx(L["Portal"],1)].zones={zn(Z["Shattrath City"]),zn(Z["Isle of Quel'Danas"])}
	RecZone.vars.zones[znx(L["Portal"],2)].zones={zn(Z["Shattrath City"]),zn(Z["Ironforge"])}
	RecZone.vars.zones[znx(L["Portal"],3)].zones={zn(Z["Shattrath City"]),zn(Z["Stormwind City"])}
	RecZone.vars.zones[znx(L["Portal"],4)].zones={zn(Z["Shattrath City"]),zn(Z["Darnassus"])}
	RecZone.vars.zones[znx(L["Portal"],5)].zones={zn(Z["Shattrath City"]),zn(Z["Undercity"])}
	RecZone.vars.zones[znx(L["Portal"],6)].zones={zn(Z["Shattrath City"]),zn(Z["Orgrimmar"])}
	RecZone.vars.zones[znx(L["Portal"],7)].zones={zn(Z["Shattrath City"]),zn(Z["Thunder Bluff"])}
	
	RecZone.vars.zones[znx(L["Boat"],1)].zones={zn(Z["Theramore Isle"]),zn(Z["Menethil Harbor"])}
	RecZone.vars.zones[znx(L["Boat"],2)].zones={zn(Z["Menethil Harbor"]),zn(Z["Auberdine"])}
	RecZone.vars.zones[znx(L["Boat"],3)].zones={zn(Z["Darnassus"]),zn(Z["Auberdine"])}
	RecZone.vars.zones[znx(L["Boat"],4)].zones={zn(Z["Booty Bay"]),zn(Z["Ratchet"])}
	RecZone.vars.zones[znx(L["Boat"],5)].zones={zn(Z["Azuremyst Isle"]),zn(Z["Auberdine"])}
	RecZone.vars.zones[znx(L["Zeppelin"],1)].zones={zn(Z["Tirisfal Glades"]),zn(Z["Durotar"])}
	RecZone.vars.zones[znx(L["Zeppelin"],2)].zones={zn(Z["Tirisfal Glades"]),zn(Z["Grom'gol Base Camp"])}
	RecZone.vars.zones[znx(L["Zeppelin"],3)].zones={zn(Z["Durotar"]),zn(Z["Grom'gol Base Camp"])}
	RecZone.vars.zones[zn(L["Orb of Translocation"])].zones={zn(Z["Silvermoon City"]),zn(Z["Undercity"])}
	RecZone.vars.zones[zn(Z["The Dark Portal"])].zones={zn(Z["Hellfire Peninsula"]),zn(Z["Blasted Lands"])}

end

-- Font Colors
local HEX_WHITE = "|cffffffff";
local HEX_RED = "|cffff0000";
local HEX_ORANGE = "|cffff7700";
local HEX_YELLOW = "|cffffff00";
local HEX_GREEN = "|cff00ff00";
local HEX_GRAY = "|cff777777";
local HEX_LIGHTBLUE = "|cff77ccff";


function RecZone:GetZoneColor(zone)
	-- PlayerLevel <= low for zone - 4  == RED
	-- PlayerLevel <  low for zone      == ORANGE
	-- PlayerLevel <= high              == YELLOW
	-- PlayerLevel <  high + 5          == GREEN
	-- Otherwise                        == GRAY
	if (zone.type == RZ_CITY and zone.faction == self.vars.playerFaction) then
		return HEX_WHITE;
	elseif (zone.type == RZ_SANCTUARY) then
		return HEX_LIGHTBLUE;
	elseif (self.vars.playerLevel <= (zone.low-4)) then
		return HEX_RED;
	elseif (self.vars.playerLevel < zone.low) then
		return HEX_ORANGE;
	elseif (self.vars.playerLevel <= zone.high) then
		return HEX_YELLOW;
	elseif (self.vars.playerLevel < (zone.high+5)) then
		return HEX_GREEN;
	else
		return HEX_GRAY;
	end
end

function RecZone:GetInstanceText(instance, colors)
	local color = HEX_WHITE;
	local text = "";
	if ( instance == nil ) then
		return "";
	end
	if (colors) then
		color = self:GetZoneColor(instance);
	end
	if (instance.type ~= RZ_INSTANCE) then
		text = instance.name..self.vars.types[instance.type];
	elseif (instance.low == instance.high) then
		text = instance.name..self.vars.types[instance.type]..
			" ("..instance.low.."+)";
	else
		text = instance.name.." ("..instance.low.."+ "..L["to "]..instance.high.."+)";
	end
	return color..text.."|r";
end

function RecZone:GetZoneText(zone, colors)
	local color = HEX_WHITE;
	if ( zone == nil ) then
		return "";
	end
	if (colors) then
		color = self:GetZoneColor(zone);
	end

	-- No level range for friendly city zones
	if (zone.type == RZ_CITY or zone.type == RZ_TRANSPORT) and zone.faction == self.vars.playerFaction then
		text = zone.name;
		color = HEX_WHITE;
	elseif (zone.faction == RZ_SANCTUARY) then
		text = zone.name;
		color = HEX_LIGHTBLUE;
	elseif (zone.type == RZ_INSTANCE) then
		if zone.low == zone.high then
			text = zone.name.." ("..zone.low.."+)" --  (60+)
		else
			text = zone.name.." ("..zone.low.."+ - "..zone.high.."+)" --  (50+ - 58+)
		end
	elseif (zone.type == RZ_BATTLEGROUND or zone.type == RZ_RAID20 or zone.type == RZ_RAID40 or zone.type == RZ_RAID25 or zone.type == RZ_RAID10) then
		text = zone.name..self.vars.types[instance.type];
	else
		text = zone.name.." ("..zone.low.." - "..zone.high..")" -- (1 - 12)
	end
	-- Add zone name and level range.
	return color..text.."|r";
end

function RecZone:GetFactionColor(zone,colors)
	if not zone then 
		return "";
	end
	if colors then
		if ( zone.faction == RZ_CONTESTED ) then
			return HEX_YELLOW;
		elseif ( zone.faction == RZ_SANCTUARY ) then
			return HEX_LIGHTBLUE;
		elseif ( zone.faction == self.vars.playerFaction ) then
			return HEX_GREEN;
		else
			return HEX_RED;
		end
	end
	return "";
end

function RecZone:GetFactionText(zone,colors)
	local color = HEX_WHITE;
	if ( zone == nil ) then
		return "";
	end
	if (colors) then
		color = self:GetFactionColor(zone,colors);
	end
	return color..self.vars.factions[zone.faction].."|r";
end

function RecZone:GetContinentText(zone,colors)
	local color = HEX_WHITE;
	if ( zone == nil ) then
		return "";
	end
	if (colors) then
		if ( zone.continent == self.vars.current_continent ) then
			color = HEX_GREEN;
		else
			color = HEX_YELLOW;
		end
	end
	return color..self.vars.continents[zone.continent].."|r";
end

function RecZone:GetLevelText(zone,colors)
	local color = HEX_WHITE;
	if ( colors ) then
		color = self:GetZoneColor(zone);
	end
	if  zone.type == RZ_CITY and (zone.faction == self.vars.playerFaction or zone.faction == RZ_SANCTUARY) then
		return HEX_WHITE..self.vars.types[zone.type].."|r";
	elseif (zone.faction == RZ_SANCTUARY) then
		return HEX_LIGHTBLUE..self.vars.types[zone.type].."|r";
	elseif zone.type == RZ_INSTANCE then
		if zone.low == zone.high then
			return color..zone.low.."+|r"; -- 60+
		else			
			return color..zone.low.."+-"..zone.high.."+|r"; --  50+-58+
		end
	elseif zone.type == RZ_BATTLEGROUND or zone.type == RZ_RAID20 or zone.type == RZ_RAID40 or zone.type == RZ_RAID25 or zone.type == RZ_RAID10 then
		return color..self.vars.types[zone.type].."|r";
	end	
	if zone.low == zone.high then
		return color..tostring(zone.low).."|r";
	end
	return color..tostring(zone.low).."-"..tostring(zone.high).."|r";
end

function RecZone:GetPathText(zone,colors)
	local zonecolor = HEX_WHITE;
	local levelcolor = HEX_WHITE;
	if ( colors ) then
		zonecolor = self:GetFactionColor(zone,colors);
		levelcolor = self:GetZoneColor(zone);
	end
	if zone.type == RZ_CITY or zone.type == RZ_TRANSPORT then
		return zonecolor..zone.name.."|r";
	elseif zone.type == RZ_INSTANCE then
		if zone.low == zone.high then
			return zonecolor..zone.name.."|r "..levelcolor.."("..zone.low.."+)|r";
		else
			return zonecolor..zone.name.."|r "..levelcolor.."("..zone.low.."+-"..zone.high.."+)|r";
		end
	elseif zone.type == RZ_BATTLEGROUND or zone.type == RZ_RAID20 or zone.type == RZ_RAID40 or zone.type == RZ_RAID25 or zone.type == RZ_RAID10 then
		return zonecolor..zone.name.."|r"..levelcolor..self.vars.types[zone.type].."|r";
	end
	if zone.low == zone.high then
		return zonecolor..zone.name.."|r "..levelcolor.."("..zone.low..")|r";
	end
	return zonecolor..zone.name.."|r "..levelcolor.."("..zone.low.."-"..zone.high..")|r";
end

function RecZone:StartCoordsUpdate()
	local x, y = GetPlayerMapPosition("player")
	if x == 0 and y == 0 then -- instance
		self:ScheduleRepeatingEvent("RecZone", self.OnCoordUpdate, 60, self)
		self.vars.playerCoordX = 0;
		self.vars.playerCoordY = 0;
		self.vars.coordtext = '';
	else
		self:ScheduleRepeatingEvent("RecZone", self.OnCoordUpdate, 0.1, self)
	end
end

function RecZone:StopCoordsUpdate()
	if self:IsEventScheduled("RecZone") then self:CancelScheduledEvent("RecZone") end
	self.vars.playerCoordX = 0;
	self.vars.playerCoordY = 0;
	self.vars.coordtext = '';
end

RecZone.vars.playerinworld = false;
function RecZone:OnInitialize()
	if ( FuBar and self:GetProfile() ~= FuBar:GetProfile() ) then 
		local short = FuBar:GetProfile();
		self:SetProfile(short);
	end 
	self.vars.continents={ GetMapContinents() };
	self.vars.continents[4] = "Other";
	
	local mapFrame = CreateFrame("Frame", "RecZoneMapFrame", WorldMapFrame)
	mapFrame:SetScript("OnUpdate", self.MapFrame_OnUpdate)
	
	local text = mapFrame:CreateFontString("RecZoneMapText", "OVERLAY")
	local font, size = GameFontNormal:GetFont()
	text:SetFont(font, size, "OUTLINE")
	text:SetTextColor(GameFontNormal:GetTextColor())
	text:SetShadowColor(GameFontNormal:GetShadowColor())
	text:SetShadowOffset(GameFontNormal:GetShadowOffset())
	text:SetPoint("TOP", WorldMapFrameAreaLabel, "BOTTOM", 0, -5)

	local cursorCoords = mapFrame:CreateFontString("RecZoneMapFrameCursorCoords", "ARTWORK")
	cursorCoords:SetFont(GameFontNormal:GetFont())
	cursorCoords:SetTextColor(GameFontNormal:GetTextColor())
	cursorCoords:SetShadowColor(GameFontNormal:GetShadowColor())
	cursorCoords:SetShadowOffset(GameFontNormal:GetShadowOffset())
	cursorCoords:SetPoint("RIGHT", WorldMapFrame, "CENTER", -80, -367)
	
	local playerCoords = mapFrame:CreateFontString("RecZoneMapFramePlayerCoords", "ARTWORK")
	playerCoords:SetFont(GameFontNormal:GetFont())
	playerCoords:SetTextColor(GameFontNormal:GetTextColor())
	playerCoords:SetShadowColor(GameFontNormal:GetShadowColor())
	playerCoords:SetShadowOffset(GameFontNormal:GetShadowOffset())
	playerCoords:SetPoint("RIGHT", WorldMapFrame, "CENTER", 80, -367)
	
end

function RecZone:OnEnable()
	self:RegisterEvent("ZONE_CHANGED", "Update");
	self:RegisterEvent("ZONE_CHANGED_INDOORS", "Update");
	self:RegisterEvent("ZONE_CHANGED_NEW_AREA", "Update");
	self:RegisterEvent("MINIMAP_ZONE_CHANGED", "Update");
	self:RegisterEvent("PLAYER_ENTERING_WORLD", "OnEnteringWorld");
	self:RegisterEvent("PLAYER_LEVEL_UP", "Update");
	RecZoneMapFrame:Show();
	self:ToggleShowingMap(self:IsShowingMap());
	self:ToggleShowingMapCoords(self:IsShowingMapCoords());
	self:ToggleShowingCoords(self:IsShowingCoords());
	self:ToggleShowingMinimapBar(self:IsShowingMinimapBar());
	self.vars.playerinworld = true; -- Maybe not completly true, but good enough
end

function RecZone:OnDisable()
	RecZoneMapFrame:Hide();
	RecZoneMapFrameCursorCoords:Hide();
	RecZoneMapFramePlayerCoords:Hide();
	if not self:IsShowingMinimapBar() then
		self:ToggleShowingMinimapBar()
		self.db.profile.minimapBar = not self.db.profile.minimapBar
	end	
end

function RecZone:OnProfileEnable()
	if self.vars.playerinworld then
		self:ToggleShowingMap(self:IsShowingMap());
		self:ToggleShowingMapCoords(self:IsShowingMapCoords());
		self:ToggleShowingCoords(self:IsShowingCoords());
		self:Update();
	end
end

local options = {
	type = 'group',
	args = {
		label = {
			type = 'group',
			name = L["Label"],
			desc = L["Label"],
			order = 1,
			args = {
				zone = {
					type = 'toggle',
					name = L["Show Zone Name"],
					desc = L["Show Zone Name"],
					get = "IsShowingZoneName",
					set = "ToggleShowingZoneName",
					order = 1,
				},
				subzone = {
					type = 'toggle',
					name = L["Show Sub Zone Name"],
					desc = L["Show Sub Zone Name"],
					get = "IsShowingSubZoneName",
					set = "ToggleShowingSubZoneName",
					order = 2,
				},
				coords = {
					type = 'toggle',
					name = L["Show Coords"],
					desc = L["Show Coords"],
					get = "IsShowingCoords",
					set = "ToggleShowingCoords",
					order = 3,
				},
			},
		},
		tooltip = {
			type = 'group',
			name = L["Tooltip"],
			desc = L["Tooltip"],
			order = 2,
			args = {
				curinstance = {
					type = 'toggle',
					name = L["Show Instances for current zone"],
					desc = L["Show Instances for current zone"],
					get = "IsShowingCurInstance",
					set = "ToggleShowingCurInstance",
					order = 1,
				},
				faction = {
					type = 'toggle',
					name = L["Show Faction of zones"],
					desc = L["Show Faction of zones"],
					get = "IsShowingFaction",
					set = "ToggleShowingFaction",
					order = 2,
				},
				continent = {
					type = 'toggle',
					name = L["Show Continent for zones"],
					desc = L["Show Continent for zones"],
					get = "IsShowingContinent",
					set = "ToggleShowingContinent",
					order = 3,
				},
				instance = {
					type = 'toggle',
					name = L["Show Recommended Instances"],
					desc = L["Show Recommended Instances"],
					get = "IsShowingInstance",
					set = "ToggleShowingInstance",
					order = 4,
				},
				battleground = {
					type = 'toggle',
					name = L["Show Battlegrounds"],
					desc = L["Show Battlegrounds"],
					get = "IsShowingBattleground",
					set = "ToggleShowingBattleground",
					order = 5,
				},
				raid = {
					type = 'toggle',
					name = L["Show Raid Instances"],
					desc = L["Show Raid Instances"],
					get = "IsShowingRaid",
					set = "ToggleShowingRaid",
					order = 6,
				},
				loc = {
					type = 'toggle',
					name = L["Show Location of Instances"],
					desc = L["Show Location of Instances"],
					get = "IsShowingLoc",
					set = "ToggleShowingLoc",
					order = 7,
				},
				lower = {
					type = 'range',
					name = L["Recommend lower level zones"],
					desc = L["Recommend lower level zones"],
					max = 10;
					min = 0;
					step = 1;
					get = "GetLower",
					set = "SetLower",
					order = 8,
				},
				higher = {
					type = 'range',
					name = L["Recommend higher level zones"],
					desc = L["Recommend higher level zones"],
					max = 10;
					min = 0;
					step = 1;
					get = "GetHigher",
					set = "SetHigher",
					order = 9,
				},
			},
		},
		map = {
			type = 'group',
			name = L["Map"],
			desc = L["Map"],
			order = 3,
			args = {
				mapoverlay = {
					type = 'toggle',
					name = L["Show Zone Levels"],
					desc = L["Show Zone Levels"],
					get = "IsShowingMap",
					set = "ToggleShowingMap",
					order = 1,
				},
				mapcoords = {
					type = 'toggle',
					name = L["Show Coords"],
					desc = L["Show Coords"],
					get = "IsShowingMapCoords",
					set = "ToggleShowingMapCoords",
					order = 2,
				},
			},
		},
		minimapBar = {
			type = 'toggle',
			name = "Show minimap bar",
			desc = "Show the bar above the minimap that tells the location and allows you to close minimap",
			get = "IsShowingMinimapBar",
			set = "ToggleShowingMinimapBar",
		},
		color = {
			type = 'toggle',
			name = L["Show Colored Text"],
			desc = L["Show Colored Text"],
			get = "IsShowingColoredText",
			set = "ToggleShowingColoredText",
			order = 91,
		},
	}
}
--RecZone:RegisterChatCommand(L:GetTable("AceConsole-options"), options)
RecZone.OnMenuRequest = options

function RecZone:OnEnteringWorld()
	if not self.vars.playerinworld then
		self.vars.playerinworld = true;
	end
	if self:IsShowingCoords() then self:StartCoordsUpdate() end
	self:Update();
end

function RecZone:OnCoordUpdate()
	local x, y = GetPlayerMapPosition("player")
	if self:IsShowingCoords() and x ~= 0 and y ~= 0 then
		if self.vars.playerCoordX ~= x or self.vars.playerCoordY ~= y then
			self.vars.coordtext = string.format('(%.0f, %.0f) ', x*100, y*100);
			self.vars.playerCoordX = x;
			self.vars.playerCoordY = y;
			self:UpdateText();
		end
	else
		self.vars.playerCoordX = x;
		self.vars.playerCoordY = y;
		self.vars.coordtext = '';
		self:UpdateText();
	end
end

function RecZone:OnDataUpdate()
	local i;
	self.vars.playerLevel = UnitLevel("player");
	self.vars.zoneName = GetRealZoneText();
	self.vars.subZoneName = GetSubZoneText();
	if ( select(2, UnitFactionGroup("player")) == FACTION_ALLIANCE ) then
		self.vars.playerFaction = RZ_ALLIANCE;
	else
		self.vars.playerFaction = RZ_HORDE;
	end

	self.vars.zonetext = "";
	if (self:IsShowingZoneName()) then
		self.vars.zonetext = self.vars.zoneName.." ";
		if (self:IsShowingSubZoneName()) then
			if ( self.vars.subZoneName ~= "" ) then
				self.vars.zonetext = self.vars.zoneName..": "..self.vars.subZoneName.." ";
			end
		end
	elseif (self:IsShowingSubZoneName()) then
		if ( self.vars.subZoneName ~= "" ) then
			self.vars.zonetext = self.vars.subZoneName.." ";
		else
			self.vars.zonetext = self.vars.zoneName.." ";
		end
	end

	self.vars.leveltext = "";
	local found = false;		
	for i,zone in ipairs(self.vars.zones) do
		if (string.find(self.vars.zoneName, zone.name, 1, true)) then
			self.vars.current_continent = zone.continent;
			self.vars.current_zone = zone;
			self.vars.leveltext = self:GetLevelText(zone, self:IsShowingColoredText());
			found = true;
			break
		end
	end

	if not found then
		if self.vars.zoneName and self.vars.zoneName ~= "" then
			self:Print('Unknown zone detected "%s"', self.vars.zoneName )
		end
		self.vars.current_continent = self.vars.zones[1].continent;
		self.vars.current_zone = self.vars.zones[1];
		self.vars.leveltext = self:GetLevelText(self.vars.zones[1], self:IsShowingColoredText());
	end
	
	self.vars.zonetext = self:GetFactionColor(self.vars.current_zone,self:IsShowingColoredText())..self.vars.zonetext;
end

function RecZone:OnTextUpdate()
	local text = "";
	text = self.vars.zonetext..self.vars.coordtext..self.vars.leveltext;
	self:SetText(text);
end

function RecZone:OnTooltipUpdate()
	local c,i;
	local text = "";
	local lower = self:GetLower();
	local higher = self:GetHigher();
	local colorTooltip = self:IsShowingColoredText();
	
	local cat = Tablet:AddCategory('columns', 2, 
																 'child_textR', 1, 'child_textG', 1, 'child_textB', 0,
																 'child_text2R', 1, 'child_text2G', 1,	'child_text2B', 1);

	if ( self.vars.current_zone.type >= RZ_INSTANCE ) then
		cat:AddLine("text", L["Current Zone:"], "text2", self:GetInstanceText(self.vars.current_zone, false));
		if ( self.vars.subZoneName ~= "" ) then
			cat:AddLine("text", L["Current Sub Zone:"], "text2", self.vars.subZoneName);
		end
	else
		cat:AddLine("text", L["Current Zone:"], "text2", self:GetZoneText(self.vars.current_zone, false));
		if ( self.vars.subZoneName ~= "" ) then
			cat:AddLine("text", L["Current Sub Zone:"], "text2", self.vars.subZoneName);
		end
		-- Show Coords
		if self:IsShowingCoords() then
			cat:AddLine("text", L["Coords:"], "text2", string.format('%.0f, %.0f', self.vars.playerCoordX*100, self.vars.playerCoordY*100));
		end
		-- Show faction
		if self:IsShowingFaction() then
			cat:AddLine("text", L["Faction:"], "text2", self:GetFactionText(self.vars.current_zone,colorTooltip));
		end
		-- show continent
		if self:IsShowingContinent() then
			cat:AddLine("text", L["Continent:"], "text2", self:GetContinentText(self.vars.current_zone,colorTooltip));
		end
	end

	-- Show border zones for current zone.
	if self:IsShowingCurInstance() then
		if ( self.vars.current_zone.zones ) then
		  for _, i in ipairs(self.vars.current_zone.zones) do
		  	local f = self.vars.zones[i].faction;
		  	local t = self.vars.zones[i].type;
		  	if (t == RZ_ZONE or t == RZ_CITY) and (f == RZ_CONTESTED or f == self.vars.playerFaction or f == RZ_SANCTUARY) then
					cat:AddLine("text", "Border Zone:", "text2", self:GetZoneText(self.vars.zones[i], colorTooltip));
				end
			end
		end
	end

	-- Show instances for current zone.
  if self:IsShowingCurInstance() then
		if ( self.vars.current_zone.zones ) then
		  for _, i in ipairs(self.vars.current_zone.zones) do
		  	local f = self.vars.zones[i].faction;
		  	local t = self.vars.zones[i].type;
		  	if (t >= RZ_INSTANCE) and ((f == RZ_CONTESTED) or (f == self.vars.playerFaction)) then
					cat:AddLine("text", L["Instance:"], "text2", self:GetInstanceText(self.vars.zones[i], colorTooltip));
				end
			end
		end
	end
	
	-- Show recommended zones.
	cat = Tablet:AddCategory("columns", 3, "text", L["Recommended Zones:"]);
	
	for i,zone in ipairs(self.vars.zones) do
		if zone.type == RZ_ZONE and
			 (zone.low - higher) <= self.vars.playerLevel and 
			(zone.high + lower) >= self.vars.playerLevel and
			(zone.faction == RZ_CONTESTED or zone.faction == self.vars.playerFaction) then	

			-- Show faction
			local factionText;
			if ( self:IsShowingFaction() ) then
				factionText = self:GetFactionText(zone,colorTooltip);
			else
				factionText = "";
			end

			-- show continent
			local continentText;
			if ( self:IsShowingContinent() ) then
				continentText = self:GetContinentText(zone,colorTooltip);
			else
				continentText = "";
			end

			cat:AddLine("text", self:GetZoneText(zone,colorTooltip),
						"text2", factionText,
						"text3", continentText,
						"func", "OnClickZone", "arg1", self, "arg2", zone);
		end
	end
	
	-- Show recommended instances/battlegrounds/raids
	if( self:IsShowingInstance() or self:IsShowingRaid() or self:IsShowingBattleground() ) then
		cat = Tablet:AddCategory("columns", 2, "text", L["Recommended Instances:"])
		for i, instance in ipairs(self.vars.zones) do
			if (instance.low - higher) <= self.vars.playerLevel and
					(instance.high + lower) >= self.vars.playerLevel and
					(instance.faction == RZ_CONTESTED or instance.faction == self.vars.playerFaction) and
					((instance.type == RZ_INSTANCE and self:IsShowingInstance()) or 
					((instance.type == RZ_RAID20 or instance.type == RZ_RAID40 or instance.type == RZ_RAID25 or instance.type == RZ_RAID10) and self:IsShowingRaid()) or
					(instance.type == RZ_BATTLEGROUND and self:IsShowingBattleground())) then
				local text =  self:GetInstanceText(instance,colorTooltip);
				local locText = "";
				if ( self:IsShowingLoc() ) then
					if ( instance.zones ) then
						locText = "<"..self.vars.zones[instance.zones[1]].name..">";
					end
				end
				cat:AddLine("text", text, "text2", locText,
							"func", "OnClickZone", "arg1", self, "arg2", instance);
			end
		end
	end
	Tablet:SetHint(L["Hint"])
end

function RecZone:OnClick()
	if IsShiftKeyDown() then
		if ChatFrameEditBox:IsVisible() then
			local text = "";
			if (self:IsShowingZoneName()) then
				text = self.vars.zoneName.." ";
				if (self:IsShowingSubZoneName()) then
					if ( self.vars.subZoneName ~= "" ) then
						text = self.vars.zoneName..": "..self.vars.subZoneName.." ";
					end
				end
			elseif (self:IsShowingSubZoneName()) then
				if ( self.vars.subZoneName ~= "" ) then
					text = self.vars.subZoneName.." ";
				else
					text = self.vars.zoneName.." ";
				end
			end
			local x, y = GetPlayerMapPosition("player")
			text = text..string.format("%.0f, %.0f", x*100, y*100);
			ChatFrameEditBox:Insert(text);
		end
	end
end

function RecZone:OnClickZone(zone)
	local start = self:GetZoneNr(self.vars.current_zone);
	local goal = self:GetZoneNr(zone)
	local text = "";	

	self.vars.path = self:FindPath(start,goal);
	if not self.vars.path then
		self.vars.path = self:FindPath(start,goal,true); -- Try walking in opposing factions zones
	end
	self:CreateTooltip();
	if not self.vars.path then
		RecZoneTooltip:AddLine("No path to destination found!");
	else
		RecZoneTooltip:AddLine("Walk path");
		for n,i in ipairs(self.vars.path) do
			local text = self:GetPathText(self.vars.zones[i],self:IsShowingColoredText());
			if n ~= table.getn(self.vars.path) then 
				RecZoneTooltip:AddLine(text.." ->");
			else
				RecZoneTooltip:AddLine(text);
			end
		end
	end
	RecZoneTooltip:Show();
end

function RecZone:CreateTooltip()
	if not self.tooltip then
		self.tooltip = CreateFrame("GameTooltip", "RecZoneTooltip", Tablet20Frame, "GameTooltipTemplate");
	end
--	local font, size, flags = self.textFrame:GetFont()
--	for i=1,30 do
--		tfl = getglobal("RecZoneTooltipTextLeft"..i);
--		tfl:SetFont(font,size,flags);
--		tfr = getglobal("RecZoneTooltipTextRight"..i);
--		tfr:SetFont(font,size,flags);
--	end
	RecZoneTooltip:SetOwner(Tablet20Frame,"ANCHOR_NONE");
	if FuBar then
		RecZoneTooltip:SetScale(Tablet:GetFontSizePercent(FuBar.db.profile.tooltip))
	end
--	RecZoneTooltip:SetScale(Tablet20Frame:GetScale());
	RecZoneTooltip:ClearAllPoints();
	if Tablet20Frame:GetLeft() < (GetScreenWidth() / 2) then
		RecZoneTooltip:SetPoint("LEFT","Tablet20Frame","RIGHT");
	else
		RecZoneTooltip:SetPoint("RIGHT","Tablet20Frame","LEFT");
	end
end

local function copytable(tbl,newitem)
	local newtbl = {};
	for _,a in ipairs(tbl) do
		table.insert(newtbl,a);
	end
	table.insert(newtbl,newitem);
	return newtbl;
end

function RecZone:FindPath(start,goal,opposing)
	local visited={};
	local path={start};
	local paths={path};
	visited[start]=true;
	while true do
		path = paths[1];
		local c = path[table.getn(path)];
		if self.vars.zones[c].zones then
			for _,d in ipairs(self.vars.zones[c].zones) do
				if not visited[d] then
					local z = self.vars.zones[d];
					if z.type == RZ_ZONE or z.faction == RZ_CONTESTED or z.faction == self.vars.playerFaction or opposing then
						visited[d]=true;
						local newpath = copytable(path,d);
						if d == goal then
							paths = nil;
							visited = nil;
							return newpath; -- Path found
						end
						table.insert(paths,newpath);
					end
				end
			end
		end
		table.remove(paths,1);
		if table.getn(paths) == 0 then
			return; -- Nothing found
		end
	end
end

function RecZone:GetZoneNr(zone)
	for i,z in ipairs(self.vars.zones) do
		if string.find(z.name,zone.name,1,true) and z.faction==zone.faction then
			return i;
		end
	end
end

function RecZone:OnDoubleClick()
	ToggleWorldMap()
end

-- Worldmap function --

function RecZone:ToggleWorldMapText()
	if ( self:IsShowingMap()) then
		RecZoneMapFrame:Show();
	else
		RecZoneMapFrame:Hide();
	end
end

function RecZone.MapFrame_OnUpdate()
	local self = RecZone;
	local zoneText = "";
	if self:IsActive() then

		if self:IsShowingMapCoords() then
			local OFFSET_X = 0.0022
			local OFFSET_Y = -0.0262
			
			local x, y = GetCursorPosition()
			x = x / WorldMapFrame:GetScale()
			y = y / WorldMapFrame:GetScale()
		
			local px, py = GetPlayerMapPosition("player")
			local centerX, centerY = WorldMapFrame:GetCenter()
			local width = WorldMapButton:GetWidth()
			local height = WorldMapButton:GetHeight()
			local adjustedX = (x - (centerX - (width/2))) / width
			local adjustedY = (centerY + (height/2) - y ) / height
			local cx = (adjustedX + OFFSET_X)
			local cy = (adjustedY + OFFSET_Y)
			
			RecZoneMapFrameCursorCoords:SetText(format("%s %.0f, %.0f", L["Cursor:"], 100 * cx, 100 * cy))
			RecZoneMapFramePlayerCoords:SetText(format("%s %.0f, %.0f", L["Player:"], 100 * px, 100 * py))
		end

		if self:IsShowingMap() then
			if (WorldMapFrame.areaName ~= nil) then 	
				for i, zone in ipairs(self.vars.zones) do
					if (string.find(WorldMapFrame.areaName, zone.name, 1, true)) then
						zoneText = format("%s(%d-%d)|r\n\n", self:GetZoneColor(zone), zone.low, zone.high);
						if ( zone.zones ) then
							local foundfirst = false;
							for _, c  in ipairs(zone.zones) do
								if self.vars.zones[c].type >= RZ_INSTANCE and
								   (self.vars.zones[c].faction == RZ_CONTESTED or self.vars.zones[c].faction == self.vars.playerFaction) then
									if not foundfirst then
									  zoneText = zoneText .. HEX_YELLOW..L["Instances:"].."|r\n";
										foundfirst = true;
									end
									zoneText = zoneText .. self:GetInstanceText(self.vars.zones[c], true) .. "\n";
								end
							end
						end
					end
				end
			end
			RecZoneMapText:SetText(zoneText);
		
	--		if (WorldMapFrame.poiHighlight == 1) then
	--			for i,zone in ipairs(self.vars.zones) do
	--				if (string.find(WorldMapFrameAreaLabel:GetText(), zone.name)) then
	--					zoneText = "";
	--					zoneText = RZ_WHITE .. self.vars.factions[zone.faction] .. "\n\n" .. RZ_FONT_OFF;
	--					if (zone.zones ~= nil) then
	--						zoneText = zoneText .. RZ_NORMAL .. RZ_TOOLTIP_RINSTANCES .. "\n" .. RZ_FONT_OFF;
	--						for _,c in ipairs(zone.zones), 1 do
	--							zoneText = zoneText .. RZ_GetInstanceText(self.vars.zones[c], true) .. "\n";
	--						end
	--					end
	--					RecZoneMapText:SetText(zoneText);
	--				end
	--			end
	--		end
		end
	end
end

