RaidBuffFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0")
local self,RaidBuffFu=RaidBuffFu,RaidBuffFu
local dewdrop = AceLibrary("Dewdrop-2.0")
local tablet = AceLibrary("Tablet-2.0")
local BS= AceLibrary("Babble-Spell-2.2")
local BC= AceLibrary("Babble-Class-2.2")
local L = AceLibrary("AceLocale-2.2"):new("RaidBuffFu")
local G = AceLibrary("Gratuity-2.0")
RaidBuffFu.hasIcon = "Interface\\Icons\\INV_Relics_TotemofRage"
RaidBuffFu.clickableTooltip = true
RaidBuffFu.tooltipHiddenWhenEmpty=true

local focus=""
local allexpended=false

local tooltiprefresh=false

local classcolor={
	DRUID="|cffff7d0a",
	HUNTER="|cffabd473",
	MAGE="|cff69ccf0",
	PALADIN="|cfff58cba", 
	PRIEST="|cffffffff",
	ROGUE="|cfffff569",
	SHAMAN="|cff2459ff", 
	WARLOCK="|cff9482ca", 
	WARRIOR="|cffc79c6e",
}

local UnitExists=UnitExists
local UnitIsDeadOrGhost=UnitIsDeadOrGhost
local GetRaidRosterInfo=GetRaidRosterInfo
local UnitName=UnitName
local UnitClass=UnitClass
local UnitBuff=UnitBuff
local select=select
local GetWeaponEnchantInfo=GetWeaponEnchantInfo

local function tcount(tab)
	local n=0
	for _ in pairs(tab) do
		n=n+1
	end
	return n
 end

local function UnitHasBuff(name,buff,partial,tooltip,unitid,weaponbuff,weaponstring)
	if not buff then return end
	
	if weaponbuff then
		if weaponstring and string.find(weaponstring,buff,1,true) then return true end
	else
		if not self.bufftable[name] then return end
		for k,v in pairs(self.bufftable[name]) do
			if partial then 
				if string.find(v,buff,1,true) then return true end
			else if v == buff then return true end
			end
		end
		if tooltip then
			for i=1,32 do
				if not UnitBuff(unitid,i) then break end
				G:SetUnitBuff(unitid, i)
				local l=G:GetLine(1)
				if G:NumLines()>1 then
					for j=2,G:NumLines() do
						l=l.." "..G:GetLine(j)
					end
				end
				if partial then 
					if string.find(l,buff,1,true) then return true end
				else if l == buff then return true end
				end
			end
		end
	end
	return false
end

local function GetNumPlayersInEachGroup()
	local result={0,0,0,0,0,0,0,0}
	for i=1,40 do
		if UnitExists("raid"..i) and not UnitIsDeadOrGhost("raid"..i) and select(8,GetRaidRosterInfo(i)) then 
			local gnumber=select(3,GetRaidRosterInfo(i)) 
			result[gnumber]=result[gnumber]+1
		end
	end
	return result
end

local function FillBuffTable()
	self.bufftable={}
	for i=1,40 do
		if UnitExists("raid"..i) and not UnitIsDeadOrGhost("raid"..i) and select(8,GetRaidRosterInfo(i)) then 
			local name = UnitName("raid"..i)
			self.bufftable[name]={}
			
			self.bufftable[name].class=UnitClass("raid"..i)
			self.bufftable[name].class2=select(2,UnitClass("raid"..i))
			self.bufftable[name].gnumber=select(3,GetRaidRosterInfo(i)) 
			self.bufftable[name].unitid="raid"..i
			
			G:SetInventoryItem("raid"..i,16)
			local l=G:GetLine(1)
			if G:NumLines()>1 then
				for j=2,G:NumLines() do
					l=l.." "..G:GetLine(j)
				end
			end
			self.bufftable[name].weaponstring = l
			
			for j=1,32 do
				if not UnitBuff("raid"..i,j) then break end
				local buff=UnitBuff("raid"..i,j) 
				self.bufftable[name][#self.bufftable[name]+1] = buff 
			end
		end
	end
end

local function MissingBuffs()
	local missingbuffs={}
	for k,v in pairs(self.db.profile.databuffs) do
		local buffname=v.primary
		if v.active and tcount(v.secondary) > 0 then
			missingbuffs[buffname]={}
			for name,bufftable in pairs(self.bufftable) do
				local missingabuff=true
				for a,b in pairs(v.secondary) do
					if UnitHasBuff(name,b,v.partial,v.tooltip,bufftable.unitid,v.weaponbuff,bufftable.weaponstring) then 
						missingabuff=false 
						break
					end
					
				end
				if missingabuff then 
					local skip=false
					local class= bufftable.class
					local class2=bufftable.class2
					local gnumber=bufftable.gnumber
					if not v.groups[gnumber] then skip=true end
					if class then class=BC:GetReverseTranslation(class) end
					if class and not v.classes[class] then skip=true end
					if tcount(v.ignored) > 0 then
						if v.ignored[name] then skip=true end
					end
					if tcount(v.exception) > 0 then
						if v.exception[name] then skip=false end
					end
					if not skip then 
						missingbuffs[buffname][name]={}
						missingbuffs[buffname][name].class=class2
						missingbuffs[buffname][name].gnumber=gnumber
					end
				end
			end
		end
	end
	self.missingbuffs=missingbuffs
end


function RaidBuffFu:OnInitialize()
	RaidBuffFu:RegisterDB("RaidBuffFuDB")
	
	local pwf=BS["Power Word: Fortitude"]
	local ai=BS["Arcane Intellect"]
	local motw=BS["Mark of the Wild"]
	local ds=BS["Divine Spirit"]
	local bok=BS["Blessing of Kings"]
	local bom=BS["Blessing of Might"]
	local bow=BS["Blessing of Wisdom"]
	local bol=BS["Blessing of Light"]
	local sp=BS["Shadow Protection"]
	local bos=BS["Blessing of Salvation"]
	
	local tempbuffs={}
	tempbuffs[pwf]={
		primary=pwf,
		secondary={pwf, BS["Prayer of Fortitude"]},
		classes={
			Warrior=true,
			Priest=true,
			Mage=true,
			Warlock=true,
			Druid=true,
			Rogue=true,
			Hunter=true,
			Shaman=true,
			Paladin=true,
		},
		groups={	
			true,
			true,
			true,
			true,
			true,
			true,
			true,
			true,
		},
		active=true,
		count=true,
		exception={},
		ignored={}
		
	}
	tempbuffs[ai]={
		primary=ai,
		secondary={ai, BS["Arcane Brilliance"]},
		classes={
			Warrior=false,
			Priest=true,
			Mage=true,
			Warlock=true,
			Druid=true,
			Rogue=false,
			Hunter=true,
			Shaman=true,
			Paladin=true,
		},
		groups={	
			true,
			true,
			true,
			true,
			true,
			true,
			true,
			true,
		},
		active=true,
		count=true,
		exception={},
		ignored={}
	}
	tempbuffs[motw]={
		primary=motw,
		secondary={motw, BS["Gift of the Wild"] },
		classes={
			Warrior=true,
			Priest=true,
			Mage=true,
			Warlock=true,
			Druid=true,
			Rogue=true,
			Hunter=true,
			Shaman=true,
			Paladin=true,
		},
		groups={	
			true,
			true,
			true,
			true,
			true,
			true,
			true,
			true,
		},
		active=true,
		count=true,
		exception={},
		ignored={}
	}
	tempbuffs[ds]={
		primary=ds,
		secondary={ds, BS["Prayer of Spirit"]},
		classes={
			Warrior=false,
			Priest=true,
			Mage=true,
			Warlock=true,
			Druid=true,
			Rogue=false,
			Hunter=true,
			Shaman=true,
			Paladin=true,
		},
		groups={	
			true,
			true,
			true,
			true,
			true,
			true,
			true,
			true,
		},
		active=true,
		count=true,
		exception={},
		ignored={}
	}
	tempbuffs[bok]={
		primary=bok,
		secondary={bok, BS["Greater Blessing of Kings"]},
		classes={
			Warrior=true,
			Priest=true,
			Mage=true,
			Warlock=true,
			Druid=true,
			Rogue=true,
			Hunter=true,
			Shaman=true,
			Paladin=true,
		},
		groups={	
		true,
		true,
		true,
		true,
		true,
		true,
		true,
		true,
		},
		active=true,
		count=false,
		exception={},
		ignored={}
	}
	tempbuffs[bom]={
		primary=bom,
		secondary={bom,BS["Greater Blessing of Might"]},
		classes={
			Warrior=true,
			Priest=false,
			Mage=false,
			Warlock=false,
			Druid=true,
			Rogue=true,
			Hunter=true,
			Shaman=false,
			Paladin=false,
		},
		groups={	
			true,
			true,
			true,
			true,
			true,
			true,
			true,
			true,
		},
		active=true,
		count=false,
		exception={},
		ignored={}
	}
	tempbuffs[bow]={
		primary=bow,
		secondary={bow, BS["Greater Blessing of Wisdom"]},
		classes={
			Warrior=false,
			Priest=true,
			Mage=true,
			Warlock=true,
			Druid=true,
			Rogue=false,
			Hunter=true,
			Shaman=true,
			Paladin=true,
		},
		groups={	
			true,
			true,
			true,
			true,
			true,
			true,
			true,
			true,
		},
		active=true,
		count=false,
		exception={},
		ignored={}
	}
	tempbuffs[bol]={
		primary=bol,
		secondary={bol, BS["Greater Blessing of Light"]},
		classes={
			Warrior=true,
			Priest=true,
			Mage=true,
			Warlock=true,
			Druid=true,
			Rogue=true,
			Hunter=true,
			Shaman=true,
			Paladin=true,
		},
		groups={	
			true,
			true,
			true,
			true,
			true,
			true,
			true,
			true,
		},
		active=true,
		count=false,
		exception={},
		ignored={}
	}
	tempbuffs[sp]={
		primary=sp,
		secondary={sp,BS["Prayer of Shadow Protection"]},
		classes={
			Warrior=true,
			Priest=true,
			Mage=true,
			Warlock=true,
			Druid=true,
			Rogue=true,
			Hunter=true,
			Shaman=true,
			Paladin=true,
		},
		groups={	
			true,
			true,
			true,
			true,
			true,
			true,
			true,
			true,
		},
		active=true,
		count=false,
		exception={},
		ignored={}
	}
	tempbuffs[bos]={
		primary=bos,
		secondary={bos,BS["Greater Blessing of Salvation"]},
		classes={
			Warrior=true,
			Priest=true,
			Mage=true,
			Warlock=true,
			Druid=true,
			Rogue=true,
			Hunter=true,
			Shaman=true,
			Paladin=true,
		},
		groups={	
			true,
			true,
			true,
			true,
			true,
			true,
			true,
			true,
		},
		active=true,
		count=false,
		exception={},
		ignored={}
	}
	RaidBuffFu:RegisterDefaults("profile", {
		databuffs=tempbuffs,
		weaponbuff=false,
		append=true
	}
	)  
end


function RaidBuffFu:BuildOpts()
	self.OnMenuRequest=nil
	self.OnMenuRequest = {
		type='group',
		args={
			append={
				name=L["Append group number"],
				desc=L["Append group number to names in raid announce"],
				type='toggle',
				order=30,
				get=function() return self.db.profile.append end,
				set=function(v) self.db.profile.append = v end,
			},
			--[[weap={
				name=L["Check weapon buffs"],
				desc=L["Check this to search for weapon buffs on your raid members"],
				type='toggle',
				order=40,
				get=function() return self.db.profile.weaponbuff end,
				set=function(v) self.db.profile.weaponbuff = v end,
			},]]
			buff={
				name="Buffs",
				desc="Buffs",
				type='group',
				order=20,
				args={
					new={
						name=L["New buff"],
						desc=L["New buff"],
						type='text',
						set=function(passvalue) 
							local newbuff={
									primary=passvalue,
									secondary={},
									classes={
										Warrior=true,
										Priest=true,
										Mage=true,
										Warlock=true,
										Druid=true,
										Rogue=true,
										Hunter=true,
										Shaman=true,
										Paladin=true,
									},
									groups={	
										true,
										true,
										true,
										true,
										true,
										true,
										true,
										true,
									},
									active=true,
									count=true,
									exception={},
									ignored={}
								}
							self.db.profile.databuffs[passvalue]=newbuff
							local v=self.db.profile.databuffs[passvalue]
							local t={
								name=v.primary,
								desc=v.primary,
								type='group',
								onClick=function() self.db.profile.databuffs[passvalue].active = not self.db.profile.databuffs[passvalue].active end,
								isChecked=function() return self.db.profile.databuffs[passvalue].active end,
								args={	
									prim={
										name=L["Name"],
										desc=L["Buff name. This is actually only for menus and announces. Add strings matching this buff in the option below."],
										type='text',
										get=function() return v.primary end,
										set=function(v) self.db.profile.databuffs[passvalue].primary = v end,
										usage=L["Buff name"],
										order=10,
										
									},
									sec={
										name=L["Add a Buff name"],
										desc=L["Add a Buff name"],
										type='text',
										get=function() return "" end,
										set=function(value) 
											self.db.profile.databuffs[passvalue].secondary[value]=value
											self.OnMenuRequest.args.buff.args[passvalue].args.delsec.args[value] = {
												name=value,
												desc=value,
												type="execute",
												func=function() 
													self.db.profile.databuffs[passvalue].secondary[value]=nil
													self.OnMenuRequest.args.buff.args[passvalue].args.delsec.args[value]=nil
												end,
											}
											end,
										usage=L["Buff name"],
										order=20,
									},
									delsec={
										name=L["Delete a Buff name"],
										desc=L["Delete a Buff name"],
										type="group",
										args={},
										order=25,
									},
									classes={
										name=L["Classes"],
										desc=L["Classes"],
										type="group",
										args={},
										order=30,
									},
									groups={
										name=L["Groups"],
										desc=L["Groups"],
										type="group",
										args={},
										order=31,
									},
									delignore={
										name=L["Delete ignore"],
										desc=L["Delete ignore"],
										type="group",
										args={},
										order=50,
									},
									addignore={
										name=L["Add ignore"],
										desc=L["Add ignore"],
										type="text",
										get=function() return "" end,
										set=function(value) 
											self.db.profile.databuffs[passvalue].ignored[value]=value
											self.OnMenuRequest.args.buff.args[passvalue].args.delignore.args[value] = {
												name=value,
												desc=value,
												type="execute",
												func=function() 
													self.db.profile.databuffs[passvalue].ignored[value]=nil
													self.OnMenuRequest.args.buff.args[passvalue].args.delignore.args[value]=nil
												end,
											}
											end,
										usage=L["Name"],
										order=40,
									},
									delexception={
										name=L["Delete always check"],
										desc=L["Delete always check"],
										type="group",
										args={},
										order=56,
									},
									addexception={
										name=L["Always check"],
										desc=L["Always check"],
										type="text",
										get=function() return "" end,
										set=function(value) 
											self.db.profile.databuffs[passvalue].exception[value]=value
											self.OnMenuRequest.args.buff.args[passvalue].args.delexception.args[value] = {
												name=value,
												desc=value,
												type="execute",
												func=function() 
													self.db.profile.databuffs[passvalue].exception[value]=nil
													self.OnMenuRequest.args.buff.args[passvalue].args.delexception.args[value]=nil
												end,
											}
											end,
										usage=L["Name"],
										order=55,
									},
									count={
										name=L["Count"],
										desc=L["Count in buffcount and show in global raidannounce"],
										type="toggle",
										get=function() return self.db.profile.databuffs[passvalue].count end,
										set=function() self.db.profile.databuffs[passvalue].count = not self.db.profile.databuffs[passvalue].count end,
										order=60,
									},
									replace={
										name=L["Replace"],
										desc=L["Replace names with group number in raid announce when the whole group is missing the buff"],
										type="toggle",
										get=function() return self.db.profile.databuffs[passvalue].replace end,
										set=function() self.db.profile.databuffs[passvalue].replace = not self.db.profile.databuffs[passvalue].replace end,
										order=63,
									},
									partial={
										name=L["Partial"],
										desc=L["Check for buffs that partially match primary or secondary names"],
										type="toggle",
										get=function() return self.db.profile.databuffs[passvalue].partial end,
										set=function() self.db.profile.databuffs[passvalue].partial = not self.db.profile.databuffs[passvalue].partial end,
										order=65,
									},
									tooltip={
										name=L["Scan tooltip"],
										desc=L["Scans tooltips for a match too"],
										type="toggle",
										get=function() return self.db.profile.databuffs[passvalue].tooltip end,
										set=function() self.db.profile.databuffs[passvalue].tooltip = not self.db.profile.databuffs[passvalue].tooltip end,
										order=67,
									},
									weap={
										name=L["Weapon Buff"],
										desc=L["Check this if you want to check weapon buffs"],
										type="toggle",
										get=function() return self.db.profile.databuffs[passvalue].weaponbuff end,
										set=function() self.db.profile.databuffs[passvalue].weaponbuff = not self.db.profile.databuffs[passvalue].weaponbuff end,
										order=68,
									},
									deletebuff={
										name=L["Delete this buff"],
										desc=L["Delete this buff"],
										type="execute",
										confirm=true,
										func=function() 
											self.db.profile.databuffs[passvalue]=nil 
											self.OnMenuRequest.args.buff.args[passvalue]=nil
										end,
										order=70,
									}
								}
							}
							
							for l,m in pairs(v.classes) do
								local tt={
									name=BC[l],
									desc=BC[l],
									type="toggle",
									get=function() return v.classes[l] end,
									set=function() 
										self.db.profile.databuffs[passvalue].classes[l] = not self.db.profile.databuffs[passvalue].classes[l] 
									end,
								}
								table.insert(t.args.classes.args,tt)
							end
							for l,m in pairs(v.groups) do
								local tt={
									name=tostring(l),
									desc=tostring(l),
									type="toggle",
									get=function() return v.groups[l] end,
									set=function() 
										self.db.profile.databuffs[passvalue].groups[l] = not self.db.profile.databuffs[passvalue].groups[l] 
									end,
								}
								table.insert(t.args.groups.args,tt)
							end
							if tcount(v.ignored) > 0 then 
								for l,m in pairs(v.ignored) do
									local tt={
										name=m,
										desc=m,
										type="execute",
										func=function() 
											self.db.profile.databuffs[passvalue].ignored[m]=nil
										end,
									}
									t.args.delignore.args[m]=tt
								end
							end
							if tcount(v.secondary) > 0 then 
								for l,m in pairs(v.secondary) do
									local tt={
										name=m,
										desc=m,
										type="execute",
										func=function() 
											self.db.profile.databuffs[passvalue].secondary[m]=nil
										end,
									}
									t.args.delsec.args[m]=tt
								end
							end
							if tcount(v.exception) > 0 then 
								for l,m in pairs(v.exception) do
									local tt={
										name=m,
										desc=m,
										type="execute",
										func=function() 
											self.db.profile.databuffs[passvalue].exception[m]=nil
										end,
									}
									t.args.delexception.args[m]=tt
								end
							end
							self.OnMenuRequest.args.buff.args[passvalue]=t
						end,
					get=function() return "" end,
					usage=L["Buff name"],
					func=function(v) return true end,
					order=10,
					},
				},
			}
		}
	}
		
	for k,v in pairs(RaidBuffFu.db.profile.databuffs) do
		local t={
			name=v.primary,
			desc=v.primary,
			type='group',
			onClick=function() self.db.profile.databuffs[k].active = not self.db.profile.databuffs[k].active end,
			isChecked=function() return self.db.profile.databuffs[k].active end,
			args={	
				prim={
					name=L["Primary name"],
					desc=L["Buff name. This is actually only for menus and announces. Add strings matching this buff in the option below."],
					type='text',
					get=function() return v.primary end,
					set=function(v) self.db.profile.databuffs[k].primary = v end,
					usage=L["Buff name"],
					order=10,
					
				},
				sec={
					name=L["Add a Buff name"],
					desc=L["Add a Buff name"],
					type='text',
					get=function() return "" end,
					set=function(value) 
						self.db.profile.databuffs[k].secondary[value]=value
						self.OnMenuRequest.args.buff.args[k].args.delsec.args[value] = {
							name=value,
							desc=value,
							type="execute",
							func=function() 
								self.db.profile.databuffs[k].secondary[value]=nil
								self.OnMenuRequest.args.buff.args[k].args.delsec.args[value]=nil
							end,
						}
						end,
					usage=L["Buff name"],
					order=20,
				},
				delsec={
					name=L["Delete a Buff name"],
					desc=L["Delete a Buff name"],
					type="group",
					args={},
					order=25,
				},
				classes={
					name=L["Classes"],
					desc=L["Classes"],
					type="group",
					args={},
					order=30,
				},
				groups={
					name=L["Groups"],
					desc=L["Groups"],
					type="group",
					args={},
					order=31,
				},
				delignore={
					name=L["Delete ignore"],
					desc=L["Delete ignore"],
					type="group",
					args={},
					order=50,
				},
				addignore={
					name=L["Add ignore"],
					desc=L["Add ignore"],
					type="text",
					get=function() return "" end,
					set=function(value) 
						self.db.profile.databuffs[k].ignored[value]=value
						self.OnMenuRequest.args.buff.args[k].args.delignore.args[value]= {
							name=value,
							desc=value,
							type="execute",
							func=function() 
								self.db.profile.databuffs[k].ignored[value]=nil
								self.OnMenuRequest.args.buff.args[k].args.delignore.args[value]=nil
							end,
						}
						end,
					usage=L["Name"],
					order=40,
				},
				delexception={
					name=L["Delete always check"],
					desc=L["Delete always check"],
					type="group",
					args={},
					order=56,
				},
				addexception={
					name=L["Always check"],
					desc=L["Always check"],
					type="text",
					get=function() return "" end,
					set=function(value) 
						self.db.profile.databuffs[k].exception[value]=value
						self.OnMenuRequest.args.buff.args[k].args.delexception.args[value]= {
							name=value,
							desc=value,
							type="execute",
							func=function() 
								self.db.profile.databuffs[k].exception[value]=nil
								self.OnMenuRequest.args.buff.args[k].args.delexception.args[value]=nil
							end,
						}
						end,
					usage=L["Name"],
					order=55,
				},
				count={
					name=L["Count"],
					desc=L["Count in buffcount and show in global raidannounce"],
					type="toggle",
					get=function() return self.db.profile.databuffs[k].count end,
					set=function() self.db.profile.databuffs[k].count = not self.db.profile.databuffs[k].count end,
					order=60,
				},
				replace={
					name=L["Replace"],
					desc=L["Replace names with group number in raid announce when the whole group is missing the buff"],
					type="toggle",
					get=function() return self.db.profile.databuffs[k].replace end,
					set=function() self.db.profile.databuffs[k].replace = not self.db.profile.databuffs[k].replace end,
					order=63,
				},
				partial={
					name=L["Partial"],
					desc=L["Check for buffs that partially match primary or secondary names"],
					type="toggle",
					get=function() return self.db.profile.databuffs[k].partial end,
					set=function() self.db.profile.databuffs[k].partial = not self.db.profile.databuffs[k].partial end,
					order=65,
				},
				tooltip={
					name=L["Scan tooltip"],
					desc=L["Scans tooltips for a match too"],
					type="toggle",
					get=function() return self.db.profile.databuffs[k].tooltip end,
					set=function() self.db.profile.databuffs[k].tooltip = not self.db.profile.databuffs[k].tooltip end,
					order=67,
				},
				weap={
					name=L["Weapon Buff"],
					desc=L["Check this if you want to check weapon buffs instead of normal buffs. Note that the whole weapon text is scanned so be specific."],
					type="toggle",
					get=function() return self.db.profile.databuffs[k].weaponbuff end,
					set=function(v) self.db.profile.databuffs[k].weaponbuff = not self.db.profile.databuffs[k].weaponbuff end,
					order=68,
				},
				deletebuff={
					name=L["Delete this buff"],
					desc=L["Delete this buff"],
					type="execute",
					confirm=true,
					func=function() 
						self.db.profile.databuffs[k]=nil 
						self.OnMenuRequest.args.buff.args[k]=nil
					end,
					order=70,
				}
			}
		}
		
		for l,m in pairs(v.classes) do
			local tt={
				name=BC[l],
				desc=BC[l],
				type="toggle",
				get=function() return v.classes[l] end,
				set=function() 
					self.db.profile.databuffs[k].classes[l] = not self.db.profile.databuffs[k].classes[l] 
				end,
			}
			table.insert(t.args.classes.args,tt)
		end
		for l,m in pairs(v.groups) do
			local tt={
				name=tostring(l),
				desc=tostring(l),
				type="toggle",
				get=function() return v.groups[l] end,
				set=function() 
					self.db.profile.databuffs[k].groups[l] = not self.db.profile.databuffs[k].groups[l] 
				end,
			}
			table.insert(t.args.groups.args,tt)
		end
		if tcount(v.ignored) > 0 then 
			for l,m in pairs(v.ignored) do
				local tt={
					name=m,
					desc=m,
					type="execute",
					func=function() 
						self.db.profile.databuffs[k].ignored[m]=nil
						self.OnMenuRequest.args.buff.args[k].args.delignore.args[m]=nil
					end,
				}
				table.insert(t.args.delignore.args,tt)
			end
		end
		if tcount(v.secondary) > 0 then 
			for l,m in pairs(v.secondary) do
				local tt={
					name=m,
					desc=m,
					type="execute",
					func=function() 
						self.db.profile.databuffs[k].secondary[m]=nil
						self.OnMenuRequest.args.buff.args[k].args.delsec.args[m]=nil
					end,
				}
				table.insert(t.args.delsec.args,tt)
			end
		end		
		if tcount(v.exception) > 0 then 
			for l,m in pairs(v.exception) do
				local tt={
					name=m,
					desc=m,
					type="execute",
					func=function() 
						self.db.profile.databuffs[k].exception[m]=nil
						self.OnMenuRequest.args.buff.args[k].args.delexception.args[m]=nil
					end,
				}
				table.insert(t.args.delexception.args,tt)
			end
		end
		self.OnMenuRequest.args.buff.args[k]=t
	end
	AceLibrary("Dewdrop-2.0"):Refresh()
end


function RaidBuffFu:OnEnable()
	self.bufftable={}
	--[[
	self:ScheduleRepeatingEvent("raidbufffu", function() 
		if not UnitInRaid("player") then return end
		FillBuffTable()
		MissingBuffs()
		self:Update() 
	end,
	3)
	]]
	self:BuildOpts()
	local opt={
		type="group",
		args={
			reset={
				name="reset (will reloadui)",
				desc="reset (will reloadui)",
				type='execute',
				func=function() self.db.profile.databuffs=nil; ReloadUI() end
			},
		}
	}
	self:RegisterChatCommand('/rbfu', opt )
	
end

function RaidBuffFu:OnDisable()
	--self:CancelScheduledEvent("raidbufffu")
end


function RaidBuffFu:OnTextUpdate()
	--[[
	if not UnitInRaid("player") then return end
	local missingbuffs=self.missingbuffs
	if not missingbuffs then return end
	local i=0
	for k,v in pairs(missingbuffs) do
		if self.db.profile.databuffs[k] and self.db.profile.databuffs[k].count then i = i + tcount(v) end
	end
	local tempstring=""
	if not UnitInRaid("player") then tempstring=""
	else
		if i==0 then tempstring=L["Fully buffed!"] else tempstring= i..L[" missing buff(s)"] end
	end	
	self:SetText(tempstring)
	]]
end

function RaidBuffFu:OnClick()
	if not UnitInRaid("player") then return end
	if IsControlKeyDown() then 
		focus=""
		allexpended = not allexpended
		return
	end
	if not UnitInRaid("player") then return end
	local missingbuffs=self.missingbuffs
	local i=0
	for k,v in pairs(missingbuffs) do
		if self.db.profile.databuffs[k] and self.db.profile.databuffs[k].count then i = i + tcount(v) end
	end 
	if i==0 then SendChatMessage(L["Fully buffed!"],"RAID")
	else
		SendChatMessage(L["Missing buffs: "].."("..i..")","RAID")
		for k,v in pairs(missingbuffs) do
			if tcount(v) > 0 then
				if self.db.profile.databuffs[k] and self.db.profile.databuffs[k].count then
					local stringt=k.." ("..tcount(v)..") :: "
					
					local numplayersineachgroup=GetNumPlayersInEachGroup()
					local tempdata={0,0,0,0,0,0,0,0}
					for kk,vv in pairs(v) do
						tempdata[vv.gnumber]=tempdata[vv.gnumber]+1
					end
					
					local skipgroup={false,false,false,false,false,false,false,false}
					
					for kk,vv in pairs(v) do
						local stringappend=", "
						if self.db.profile.databuffs[k].replace then
							if not skipgroup[vv.gnumber] then 
								if numplayersineachgroup[vv.gnumber]==tempdata[vv.gnumber] then
									skipgroup[vv.gnumber]=true
									stringt=stringt..L["Group"]..vv.gnumber..stringappend
								else
									if self.db.profile.append then stringappend=":"..vv.gnumber..", " else stringappend=", " end
									stringt=stringt..kk..stringappend
								end
							end
						else
							if self.db.profile.append then stringappend=":"..vv.gnumber..", " else stringappend=", " end
							stringt=stringt..kk..stringappend
						end
					end
					stringt=string.sub(stringt,1,#stringt-2)
					stringt=stringt.."."
					SendChatMessage(stringt,"RAID")
				end
			end
		end
	end
end

local function filltablet(cat,buffname,buffinfo)
	if tcount(buffinfo) > 0 then
		local coloredbuffname=buffname
		local coloredinfo=tcount(buffinfo)
		if focus==buffname then 
			coloredbuffname="|cffffffff"..coloredbuffname.."|r" 
			coloredinfo="|cffffffff"..coloredinfo.."|r" 
		end
		cat:AddLine(
			'text', " "..coloredinfo,
			'text2', coloredbuffname,
			'func',function(buffname) 
				if IsShiftKeyDown() then
					local k=buffname
					local v=buffinfo
					local stringt=buffname.." ("..tcount(buffinfo)..") :: "
					local stringappend=", "
					
					local numplayersineachgroup=GetNumPlayersInEachGroup()
					local tempdata={0,0,0,0,0,0,0,0}
					for kk,vv in pairs(v) do
						tempdata[vv.gnumber]=tempdata[vv.gnumber]+1
					end
					
					local skipgroup={false,false,false,false,false,false,false,false}
					
					for kk,vv in pairs(v) do
						if self.db.profile.databuffs[k] and self.db.profile.databuffs[k].replace then
							if not skipgroup[vv.gnumber] then 
								if numplayersineachgroup[vv.gnumber]==tempdata[vv.gnumber] then
									skipgroup[vv.gnumber]=true
									stringt=stringt..L["Group"]..vv.gnumber..stringappend
								else
									if self.db.profile.append then stringappend=":"..vv.gnumber..", " else stringappend=", " end
									stringt=stringt..kk..stringappend
								end
							end
						else
							if self.db.profile.append then stringappend=":"..vv.gnumber..", " else stringappend=", " end
							stringt=stringt..kk..stringappend
						end
					end
					stringt=string.sub(stringt,1,#stringt-2)
					stringt=stringt.."."
					if UnitInRaid("player") then SendChatMessage(stringt,"RAID") end
				elseif IsAltKeyDown() then
					local missingbuffs=self.missingbuffs
					local i=0
					for k,v in pairs(missingbuffs) do
						if self.db.profile.databuffs[k].count then i = i + tcount(v) end
					end 
					if i==0 then SendChatMessage(L["Fully buffed!"],"RAID")
					else
						SendChatMessage(L["Missing buffs: "].."("..i..")","RAID")
						for k,v in pairs(missingbuffs) do
							if tcount(v) > 0 then
								if self.db.profile.databuffs[k].count then
									local stringt=k.." ("..tcount(v)..") :: "
									local stringappend=", "
									
									local numplayersineachgroup=GetNumPlayersInEachGroup()
									local tempdata={0,0,0,0,0,0,0,0}
									for kk,vv in pairs(v) do
										tempdata[vv.gnumber]=tempdata[vv.gnumber]+1
									end
									
									local skipgroup={false,false,false,false,false,false,false,false}
									
									for kk,vv in pairs(v) do
										if self.db.profile.databuffs[k].replace then
											if not skipgroup[vv.gnumber] then 
												if numplayersineachgroup[vv.gnumber]==tempdata[vv.gnumber] then
													skipgroup[vv.gnumber]=true
													stringt=stringt..L["Group"]..vv.gnumber..stringappend
												else
													if self.db.profile.append then stringappend=":"..vv.gnumber..", " else stringappend=", " end
													stringt=stringt..kk..stringappend
												end
											end
										else
											if self.db.profile.append then stringappend=":"..vv.gnumber..", " else stringappend=", " end
											stringt=stringt..kk..stringappend
										end
									end
									stringt=string.sub(stringt,1,#stringt-2)
									stringt=stringt.."."
									SendChatMessage(stringt,"RAID")
								end
							end
						end
					end
				elseif IsControlKeyDown() then
					focus=""
					allexpended = not allexpended
				else
					if focus==buffname then focus="" else focus=buffname end end
				end,
			'arg1',buffname,
			'onEnterFunc',function() return true end,
			'hasCheck',true,
			'checked',BS:GetSpellIcon(buffname),
			'checkIcon',BS:GetSpellIcon(buffname)
		)
		if focus==buffname or allexpended then
			for i=1,8 do
				for playername,playerinfo in pairs(buffinfo) do
					if playerinfo.gnumber == i then  
						cat:AddLine(
							'text', "     "..classcolor[playerinfo.class]..playername.."|r",
							'text2', "|cffffffff"..playerinfo.gnumber.."|r"
						)		
					end
				end
			end
		end
	end
end

function RaidBuffFu:OnTooltipUpdate()
	if not UnitInRaid("player") then return end

	if not self:IsEventScheduled("raidbufffu") then
		FillBuffTable()
		MissingBuffs()
		self:ScheduleEvent("raidbufffu",function()
			FillBuffTable()
			MissingBuffs()
			self:Update()
		end,
		2)
	end
	tablet:SetHint(L["|cffeda55fClick|r on the bar or |cffeda55fAlt+Click|r on any line to print missing buffs to your raid. |cffeda55fShift+Click|r on a buff to print people missing that buff. |cffeda55fCtrl+Click|r to expand all lines."])
	local cat = tablet:AddCategory(
	'columns', 2
	)
	
	local missingbuffs=self.missingbuffs
	if not missingbuffs then return end
	local notcount={}
	local check=false
	for buffname,buffinfo in pairs(missingbuffs) do
		if self.db.profile.databuffs[buffname] then
			if not self.db.profile.databuffs[buffname].count then 
				notcount[buffname]=buffinfo
				check=true
			else filltablet(cat,buffname,buffinfo)
			end
		end
	end
	if check then
		--[[cat:AddLine(
			'text', "-"
		)]]
		for buffname,buffinfo in pairs(notcount) do
			filltablet(cat,buffname,buffinfo)
		end
	end
end
