local VERSION = tonumber(("$Revision: 43882 $"):match("%d+"))

local QuestsFu = QuestsFu
local QuestsFu_Detached = QuestsFu:NewModule("Detached", "AceEvent-2.0", "AceConsole-2.0")
QuestsFu:SetModuleDefaultState('Detached', false)

if QuestsFu.revision < VERSION then
	QuestsFu.version = "r" .. VERSION
	QuestsFu.revision = VERSION
	QuestsFu.date = ("$Date: 2007-07-15 15:51:45 -0700 (Sun, 15 Jul 2007) $"):match("%d%d%d%d%-%d%d%-%d%d")
end

local tablet = AceLibrary("Tablet-2.0")
local quixote = AceLibrary("Quixote-1.0")
local dewdrop = AceLibrary("Dewdrop-2.0")

local L = AceLibrary("AceLocale-2.2"):new("QuestsFu_Detached")

QuestsFu_Detached.lname = L["Detached"]
QuestsFu_Detached.desc = L["Improved detached tooltip"]

function QuestsFu_Detached:OnInitialize()
	self.db = QuestsFu:AcquireDBNamespace("Detached")
	QuestsFu:RegisterDefaults("Detached", "profile", {
		data = {
			fontSizePercent=1.5, detached=true, transparency=1,
		},
		strata = "HIGH",
		minWidth = 150,
		maxHeight = 230,
	})
	self.menu = {
		name = L["Detached"],
		desc = L["Improved detached tooltip"],
		type = "group",
		args = {
			strata = QuestsFu.strataOption(self, 'QuestsFu_Detached', 1),
			maxHeight = QuestsFu.maxHeightOption(self, 'QuestsFu_Detached', 2),
			minWidth = QuestsFu.minWidthOption(self, 'QuestsFu_Detached', 3),
			lock = QuestsFu.lockOption(self, 'QuestsFu_Detached', 4),
		},
	}
end

function QuestsFu_Detached:OnEnable()
	if quixote.firstScanDone then
		self:RegisterEvent("Quixote_Update", "Update")
		self:RegisterEvent("PLAYER_LEVEL_UP", "Update") -- Quest difficulty colors can change on level; just redraw the tooltip in case they have it open while levelling.
		self:RegisterEvent("MINIMAP_ZONE_CHANGED", "Update")
		self:RegisterEvent("ZONE_CHANGED", "Update")
		self:RegisterEvent("ZONE_CHANGED_INDOORS", "Update")
		self:RegisterEvent("ZONE_CHANGED_NEW_AREA", "Update")
		
		self:Update()
	else
		self:RegisterEvent("Quixote_Ready", function() self:OnEnable() end, true)
	end
end

function QuestsFu_Detached:OnDisable()
	QuestsFu.toggleTablet('QuestsFu_Detached', false)
	tablet:Unregister('QuestsFu_Detached')
end

function QuestsFu_Detached:Update()
	if not tablet:IsRegistered('QuestsFu_Detached') then
		tablet:Register('QuestsFu_Detached', 'detachedData', self.db.profile.data, 'cantAttach', true, 'dontHook', true,
			'hideWhenEmpty', true,  'maxHeight', self.db.profile.maxHeight, 'minWidth', self.db.profile.minWidth, 'strata', self.db.profile.strata, 
			'menu', function() dewdrop:FeedAceOptionsTable(self.menu) end,
			'children', function() QuestsFu:OnTooltipUpdate() end)
		tablet:Open('QuestsFu_Detached')
	end
	tablet:Refresh('QuestsFu_Detached')
end
