local tablet = AceLibrary("Tablet-2.0")
PvpFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceEvent-2.0", "AceDB-2.0")
PvpFu:RegisterDB("PvpFuDB", "PvpFuPCDB")
PvpFu.hasIcon = "Interface/WorldStateFrame/" .. UnitFactionGroup("player") .. "Flag"
PvpFu:RegisterDefaults("profile", {
  text = {
    show_title = true,
    show_honor = false,
  },
  marks = {},
})

PvpFu.marks = {
-- BG Name, Mark Name, Mark Icon, min level
    {"Warsong Gulch", "Warsong Gulch Mark of Honor", "Interface/Icons/INV_Misc_Rune_07", 10, "WSG"},
    {"Arathi Basin",  "Arathi Basin Mark of Honor",  "Interface/Icons/INV_Jewelry_Amulet_07", 20, "AB"},
    {"Alterac Valley", "Alterac Valley Mark of Honor", "Interface/Icons/INV_Jewelry_Necklace_21", 51, "AV"},
    {"Eye of the Storm", "Eye of the Storm Mark of Honor", "Interface/Icons/Spell_Nature_EyeOfTheStorm", 61, "EotS"},
}
-- German
if GetLocale() == "deDE" then
	PvpFu.marks = {
	-- BG Name, Mark Name, Mark Icon, min level
		{"Kriegshymnenschlucht", "Ehrenabzeichen der Kriegshymnenschlucht", "Interface/Icons/INV_Misc_Rune_07", 10, "WSG"},
		{"Arathibecken",  "Ehrenabzeichen des Arathibeckens",  "Interface/Icons/INV_Jewelry_Amulet_07", 20, "AB"},
		{"Alteractal", "Ehrenabzeichen des Alteractals", "Interface/Icons/INV_Jewelry_Necklace_21", 51, "AV"},
		{"Auge des Sturms", "Ehrenabzeichen vom Auge des Sturms", "Interface/Icons/Spell_Nature_EyeOfTheStorm", 61, "EotS"},
	}
end

-- using an AceOptions data table
PvpFu.OnMenuRequest = {
  type = 'group',
  args = {
    show_title = {
      type = "toggle",
      name = "Show Title",
      desc = "Toggle showing the mod's title",
      get = "IsShowTitle",
      set = "ToggleShowTitle",
    },
    show_honor = {
      type = "toggle",
      name = "Show Honor",
      desc = "Toggle showing Honor in the title",
      get = "IsShowHonor",
      set = "ToggleShowHonor",
    },
    show_mark = {
      type = "group",
      name = "Show Marks",
      desc = "Show Mark Counts in the title",
      args = {
      }
    }
  }
}

function PvpFu:IsShowTitle()
  return self.db.profile.text.show_title
end

function PvpFu:ToggleShowTitle()
  self.db.profile.text.show_title = not self.db.profile.text.show_title
  self:UpdateText()
end

function PvpFu:IsShowHonor()
  return self.db.profile.text.show_honor
end

function PvpFu:ToggleShowHonor()
  self.db.profile.text.show_honor = not self.db.profile.text.show_honor
  self:UpdateText()
end

function PvpFu:OnInitialize()
end

function PvpFu:OnEnable()
  self:RegisterEvent("CHAT_MSG_COMBAT_HONOR_GAIN")
  self:RegisterEvent("PLAYER_PVP_KILLS_CHANGED")
  self:RegisterEvent("PLAYER_LOGIN")
  self:RegisterEvent("HONOR_CURRENCY_UPDATE")
end

function PvpFu:OnDisable()
end

function PvpFu:HONOR_CURRENCY_UPDATE()
  self:Update()
end

function PvpFu:CHAT_MSG_COMBAT_HONOR_GAIN()
  self:Update()
end

function PvpFu:PLAYER_PVP_KILLS_CHANGED()
  self:Update()
end

function PvpFu:PLAYER_LOGIN()
  self:Update()
end

function PvpFu:OnDataUpdate()
  local today_hk, today_hp = GetPVPSessionStats();
  local lt_hk, lt_dk, lt_rank = GetPVPLifetimeStats();
  local yd_hk, yd_dk, yd_contribution = GetPVPYesterdayStats()
  local current_honor = GetHonorCurrency();
  self.data = {
    faction = UnitFactionGroup("player"),
    today = {
      hk = today_hk,
      hp = today_hp,
    },
    yesterday = {
      hk = yd_hk,
      hp = yd_contribution,
    },
    lifetime = {
      hk = lt_hk,
    },
    current = {
      hp = current_honor,
    },
    marks = {},
  }

  PvpFu.OnMenuRequest.args.show_mark.args = {}
  foreachi(PvpFu.marks, function(k,e)
    if(UnitLevel("player") >= e[4]) then
      local count = GetItemCount(e[2], true)
      PvpFu.OnMenuRequest.args.show_mark.args["show_" .. e[5]] = {
        type = 'toggle',
        name = e[1],
        desc = "Toggle showing " .. e[1] .. " in title",
        get = "IsShowMark",
        set = "ToggleShowMark",
        passValue = e[5],
      }
      tinsert(self.data.marks, {
        name = e[1],
        mark = e[2],
        count = count,
        icon = e[3],
        short = e[5],
      })
    end
  end)
end

function PvpFu:IsShowMark(mark)
  if self.db.profile.marks[mark] then
    return self.db.profile.marks[mark]
  else
    return false
  end
end

function PvpFu:ToggleShowMark(mark)
  if self.db.profile.marks[mark] then
    self.db.profile.marks[mark] = not self.db.profile.marks[mark]
  else
    self.db.profile.marks[mark] = true
  end
  self:UpdateText()
end

function PvpFu:OnTextUpdate()
  local title = ""
  if self:IsShowTitle() then
    title = self.title
  end
  if self:IsShowHonor() then
--    |cffffffffPvP|r|cff00ff00Fu|r
    title = title .. " |cffffffffHonor|r " .. self.data.current.hp
    if self.data.today.hp > 0 then
      title = title .. " (|c00ff00ff+" .. self.data.today.hp .. "|r)"
    end
  end
  marks = ""
  foreachi(self.data.marks, function(k,e)
    if self:IsShowMark(e.short) then
      marks = marks .. "|cff00ff00" .. e.short .. "|r " .. e.count .. "|cffffffff|||r"
    end
  end)
  if strlen(marks) > 0 then
    marks = "|cffffffff|||r" .. marks
    title = title .. " " .. marks
  end
  self:SetText(title)
end

function PvpFu:OnTooltipUpdate()
  local cat = tablet:AddCategory(
    'text2', "Kills",
    'text3', "Honor",
    'columns', 3,
    'child_textR', 1,
    'child_textG', 1,
    'child_textB', 0,
    'child_text2R', 1,
    'child_text2G', 1,
    'child_text2B', 1,
    'child_text3R', 1,
    'child_text3G', 1,
    'child_text3B', 1
  )

  cat:AddLine(
    'text', "Today",
    'text2', self.data.today.hk,
    'text3', self.data.today.hp
  )

  cat:AddLine(
    'text', "Yesterday",
    'text2', self.data.yesterday.hk,
    'text3', self.data.yesterday.hp
  )

  cat:AddLine(
    'text', "Lifetime",
    'text2', self.data.lifetime.hk,
    'text3', '-'
  )

  local cat = tablet:AddCategory(
    'columns', 2,
    'child_textR', 1,
    'child_textG', 1,
    'child_textB', 0,
    'child_text2R', 1,
    'child_text2G', 1,
    'child_text2B', 1
)

  cat:AddLine(
    'text', "Honor",
    'text2', self.data.current.hp,
    'hasCheck', true,
    'checked', true,
    'checkIcon', "Interface/GroupFrame/UI-Group-PVP-" .. self.data.faction,
    'checkCoordLeft', 0.15,
    'checkCoordRight', 0.85,
    'checkCoordTop', 0.15,
    'checkCoordBottom', 0.85
  )

  local cat = tablet:AddCategory(
    'text', "Marks",
    'columns', 2,
    'child_textR', 1,
    'child_textG', 1,
    'child_textB', 0,
    'child_text2R', 1,
    'child_text2G', 1,
    'child_text2B', 1
  )

  foreachi(self.data.marks, function(k,e)
    cat:AddLine(
      'text', e.name,
      'text2', e.count,
      'hasCheck', true,
      'checked', true,
      'checkIcon', e.icon,
      'checkCoordLeft', 0.1,
      'checkCoordRight', 0.9,
      'checkCoordTop', 0.1,
      'checkCoordBottom', 0.9
    )
  end)


end
