PuntFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceConsole-2.0", "AceDB-2.0", "AceEvent-2.0")

PuntFu.hasIcon = "Interface\\Icons\\Ability_Warrior_BattleShout"
PuntFu.clickableTooltip = true
PuntFu.hideWithoutStandby = true
PuntFu.tooltipHiddenWhenEmpty = true

PuntFu:RegisterDB("PuntFuDB", "PuntFuPCDB")

PuntFu:RegisterDefaults('profile', {
	hideActive = false,
	hideEmpty = false
})
PuntFu:RegisterDefaults('char', { buffs = {} })

local Dewdrop = AceLibrary("Dewdrop-2.0")
local Spell = AceLibrary("Babble-Spell-2.2")
local Aura = AceLibrary("SpecialEvents-Aura-2.0")
local Tablet = AceLibrary("Tablet-2.0")

PuntFu:RegisterChatCommand({"/pufu", "/puntfu"})

function PuntFu:OnEnable()
	self:RegisterEvent("SpecialEvents_PlayerBuffGained", "CheckBuffs")
	self:RegisterEvent("SpecialEvents_PlayerBuffLost", "CheckBuffs")

	self:Update()
end

function PuntFu:OnMenuRequest(level, value, inTooltip)
	local dbc = self.db.char
	local listEmpty

	if (getn(dbc.buffs) > 0) then
		listEmpty = false
	else
		listEmpty = true
	end

	if (level == 1) then
		Dewdrop:AddLine(
			'text', "Add Buff",
			'tooltipTitle', "Add Buff",
			'tooltipText', "Type in the exact name of the buff.",
			'hasArrow', true,
			'hasEditBox', true,
			'editBoxFunc', function(buffName)
				for k, v in pairs(dbc.buffs) do
					if (v == buffName) then return end
				end
				table.insert(dbc.buffs, buffName)
				self:Update()
			end,
	    	'editBoxValidateFunc', function(v) return Spell:GetSpellIcon(v) end
		)
		Dewdrop:AddLine(
			'text', "Delete Buff",
			'tooltipTitle', "Delete Buff",
			'tooltipText', "Remove a currently monitored buff from the list.",
			'hasArrow', true,
			'value', "dblist",
			'disabled', listEmpty
		)
		Dewdrop:AddLine()
		Dewdrop:AddLine(
			'text', "Hide Active Buffs",
    		'tooltipTitle', "Hide Active Buffs",
    		'tooltipText', "Toggle the display whether to show active buffs.",
			'checked', self.db.profile.hideActive,
			'func', function() self:ToggleHideActive() end
		)
		Dewdrop:AddLine(
			'text', "Hide When Empty",
    		'tooltipTitle', "Hide When Empty",
    		'tooltipText', "Toggle the display whether to show when buff list is empty.",
			'checked', self.db.profile.hideEmpty,
			'func', function() self:ToggleHideEmpty() end
		)
		Dewdrop:AddLine()
	elseif (level == 2) then
		if (value == "dblist") then
			for k, v in pairs(dbc.buffs) do
				Dewdrop:AddLine(
					'text', v,
					'checked', true,
					'checkIcon', Spell:GetSpellIcon(v),
					'func', function(v)
						table.remove(dbc.buffs, k)
						self:Update()
					end
				)
			end
		end
	end
end

function PuntFu:ToggleHideActive()
	self.db.profile.hideActive = not self.db.profile.hideActive
	self:Update()
end

function PuntFu:ToggleHideEmpty()
	self.db.profile.hideEmpty = not self.db.profile.hideEmpty
	self:Update()
end

function PuntFu:CheckBuffs(buffName)
	local dbc = self.db.char

	for k, v in pairs(dbc.buffs) do
		if (buffName == v) then
			self:Update()
		end
	end
end

function PuntFu:OnDataUpdate()
	local dbc = self.db.char

    self.maxbuffs = getn(self.db.char.buffs)
    self.activebuffs = 0
    
    for k, v in pairs(dbc.buffs) do
    	if (Aura:UnitHasBuff("player", Spell[v])) then self.activebuffs = self.activebuffs + 1 end
    end
end

function PuntFu:OnTextUpdate()
	if (self.maxbuffs > 0) then
		if self:IsTextColored() then
			local fullness = 1 - (self.activebuffs / self.maxbuffs)
			local r, g
			r = math.min(1, fullness * 2)
			g = math.min(1, (1 - fullness) * 2)
			color = ("|cff%2X%2X00"):format(r * 255, g * 255)
		else
			color = ""
		end
		self:SetText(string.format("%s%d/%d", color, self.activebuffs, self.maxbuffs))
	else
		self:SetText("None")
	end
end

function PuntFu:OnTooltipUpdate()
	local dbc = self.db.char

	if (getn(dbc.buffs) == 0) then
		if (not self.db.profile.hideEmpty) then
			local cat = Tablet:AddCategory()
			cat:AddLine('text', "No buffs configured")
		end
	else
		local cat = Tablet:AddCategory(
			'columns', 2,
			'textR', 1,
			'textG', 1,
			'textB', 0,
			'child_textR', 1,
			'child_textG', 1,
			'child_textB', 1,
			'child_text2B', 0
		)

		--cat:AddLine(
		--	'text', "Buff status",
		--	'noInherit', true
		--)

		local i = getn(dbc.buffs)

		table.foreachi(dbc.buffs, function(k, v)
			local c = {}

			if (Aura:UnitHasBuff("player", Spell[v])) then
				if (self.db.profile.hideActive) then
					i = i - 1
					return
				end
				status = "on"
				c.r = 0
				c.g = 1
			else
				status = "off"
				c.r = 1
				c.g = 0
			end

			cat:AddLine(
				'text', v,
				'text2', status,
				'text2R', c.r,
				'text2G', c.g,
   				'hasCheck', true,
   				'checked', true,
   				'checkIcon', Spell:GetSpellIcon(v)
			)
		end)

		if (not self.db.profile.hideEmpty) and (i == 0) then
			cat:AddLine(
				'text', "All buffs active",
				'textR', 0,
				'textG', 1,
				'textB', 0
			)
		end
	end

    Tablet:SetHint("Type in the name of the buff you want to monitor from the drop-down menu e.g. Fel Armor")
end