local L = AceLibrary("AceLocale-2.2"):new("ProfessionsFu")

ProfessionsFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceConsole-2.0")
local tablet = AceLibrary("Tablet-2.0")

-- Arrays containing all professions available in WoW
local mainprof = {L["Alchemy"], L["Blacksmithing"], L["Enchanting"], L["Engineering"], L["Jewelcrafting"], L["Leatherworking"], L["Mining"], L["Tailoring"] }
local secprof = { L["Cooking"], L["First Aid"], L["Poisons"] }
local gathering = { L["Fishing"], L["Herbalism"], L["Skinning"] }

-- Arrays containing professions known by the character and their skill levels
local mainprof_user = {}
local mainprof_userskill = {}
local secprof_user = {}
local secprof_userskill = {}
local gathering_user = {}
local gathering_userskill = {}

ProfessionsFu.hasIcon = true
ProfessionsFu.hideTitle = OptionsDB


 ProfessionsFu.OnMenuRequest = {
   type = 'group',
	args = {
       hideTitle = {
           type = "toggle",
           name = L["Hide title"],
           desc = L["Hide title and display icon only."],
           get = "IsValue",
           set = "ToggleValue",
       }
   }
 }

function ProfessionsFu:IsValue()
	return self.hideTitle
 end
 
 function ProfessionsFu:ToggleValue()
   self.hideTitle = not self.hideTitle
   OptionsDB = self.hideTitle
   self:Update()
 end

function ProfessionsFu:OnTextUpdate()
	self.hideTitle = OptionsDB
	if self.hideTitle ~= true then
		self:SetText(L["Professions"])
	else
		self:SetText("")
	end
	self.clickableTooltip = true
end

function ProfessionsFu:OpenProfession(prof)
	-- Opening alchemy is broken since 2.2.0. This is a work around.
	if prof ~= L["Alchemy"] then
		CastSpellByName(prof)
	else
		CastSpell(1, "spell")
	end
end

function ProfessionsFu:OpenGathering(prof)
	-- Nothing to do here yet.
end

function ProfessionsFu:OpenProfessionsBook()
	ProfessionsBook:ShowFrame()
end

function ProfessionsFu:OnTooltipUpdate()
	local key, value
	local skillIndex
	local skillName, isHeader, skillRank

	mainprof_user = {}
	mainprof_userskill = {}
	secprof_user = {}
	secprof_userskill = {}
	gathering_user = {}
	gathering_userskill = {}
	
	-- Fill character profession arrays. 
	for skillIndex = 1, GetNumSkillLines() do
		skillName, isHeader, _, skillRank, _, _, _, _, _, _, _, _, _ = GetSkillLineInfo(skillIndex)
		if isHeader == nil then
			for key,value in pairs(mainprof) do  
				if value == skillName then
					if value == L["Mining"] then
						value = L["Smelting"]
					end
					table.insert(mainprof_user, value)
					table.insert(mainprof_userskill, skillRank)
				end
			end
			for key,value in pairs(secprof) do  
				if value == skillName then
					table.insert(secprof_user, value)
					table.insert(secprof_userskill, skillRank)
				end
			end
			for key,value in pairs(gathering) do
				if value == skillName then
					table.insert(gathering_user, value)
					table.insert(gathering_userskill, skillRank)
				end
			end
		end
	end

	-- Fill FuBar tooltip with professions
	local cat = tablet:AddCategory(
		'text', L["Main Professions"],
		'columns', 2,
		'child_textR', 1,
		'child_textG', 1,
		'child_textB', 0,
		'child_textR2', 1,
		'child_textG2', 1,
		'child_textB2', 1
	)
	for key,value in pairs(mainprof_user) do  
		cat:AddLine(
			'text', value,
			'text2', mainprof_userskill[key],
			'func', "OpenProfession",
			'arg1', self,
			'arg2', value
		)
    end
		cat = tablet:AddCategory(
			'text', L["Secondary Professions"],
			'columns', 2,
			'child_textR', 1,
			'child_textG', 1,
			'child_textB', 0,
			'child_textR2', 1,
			'child_textG2', 1,
			'child_textB2', 1
		)

	for key,value in pairs(secprof_user) do  
		cat:AddLine(
			'text', value,
			'text2', secprof_userskill[key],
			'func', "OpenProfession",
			'arg1', self,
			'arg2', value
		)
	end	
	
			cat = tablet:AddCategory(
			'text', L["Gathering"],
			'columns', 2,
			'child_textR', 1,
			'child_textG', 1,
			'child_textB', 0,
			'child_textR2', 1,
			'child_textG2', 1,
			'child_textB2', 1
		)

	for key,value in pairs(gathering_user) do  
		cat:AddLine(
			'text', value,
			'text2', gathering_userskill[key],
			'func', "OpenGathering",
			'arg1', self,
			'arg2', value
		)
	end	
	
	-- Add category "ProfessionsBook" if that addon is installed and active.
	if (IsAddOnLoaded("ProfessionsBook")) then
		cat = tablet:AddCategory(
			'text', "ProfessionsBook",
			'columns', 1,
			'child_textR', 1,
			'child_textG', 1,
			'child_textB', 0,
			'child_textR2', 1,
			'child_textG2', 1,
			'child_textB2', 1
		)

		cat:AddLine(
			'text', L["Open ProfessionsBook"],
			'func', "OpenProfessionsBook",
			'arg1', self
		)
	end
end

