local dewdrop = AceLibrary("Dewdrop-2.0")
local tablet = AceLibrary("Tablet-2.0")
local crayon = AceLibrary("Crayon-2.0")
local gratuity = AceLibrary('Gratuity-2.0')
local L = AceLibrary("AceLocale-2.2"):new("PotHerbFu")

PotHerbFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0", "AceHook-2.1")

local currentRealm = GetRealmName(); 

optionsTable = {
	type = 'group',
	args = {
		hideLabel = {
			order = 1,
			type = 'toggle',
			name = L["Hide label"],
			desc = L["Hide the label in front of text in FuBar"],
			get = function()
				return PotHerbFu.db.profile.hideLabel
			end,
			set = function(value)
				PotHerbFu.db.profile.hideLabel = value;
				PotHerbFu:UpdateText();
			end,
		},
		showMakeableInfo = {
			order = 2,
			type = 'toggle',
			name = L["Show Makeable"],
			desc = L["Shows the full detailed info on pots you can make - in the detailed pot description, otherwise hides this info."],
			get = function()
				return PotHerbFu.db.profile.showMakeableInfo
			end,
			set = function(value)
				PotHerbFu.db.profile.showMakeableInfo = value;
			end,
		},
		showUsableInfo = {
			order = 3,
			type = 'toggle',
			name = L["Show Useable"],
			desc = L["Shows the full detailed info on which pots this ingreedient is needed for - in the detailed herb / misc description, otherwise hides this info."],
			get = function()
				return PotHerbFu.db.profile.showUsableInfo
			end,
			set = function(value)
				PotHerbFu.db.profile.showUsableInfo = value;
			end,
		},		
		hideOverview = {
			order = 4,
			type = 'toggle',
			name = L["Hide in Overview"],
			desc = L["If this is checked the info will be displayed on top of tooltip rather than in a different tooltip when unchecked."],
			get = function()
				return PotHerbFu.db.profile.hideOverview
			end,
			set = function(value)
				PotHerbFu.db.profile.hideOverview = value;
			end,
		},				
		showHideDetails = {
			order = 5,
			type = 'toggle',
			name = L["Hide Details button"],
			desc = L["Shows a 'Hide details' button below the details to hide them in normal tooltip if 'Hide in Overview' is not used (otherwise CTRL + SHIFT click any item to hide it)"],
			get = function()
				return PotHerbFu.db.profile.showHideDetails
			end,
			set = function(value)
				PotHerbFu.db.profile.showHideDetails = value;
			end,
			disabled = function()
				if PotHerbFu.db.profile.hideOverview then
					return true;
				else
					return false;
				end
			end,									
		},						
		limits = {
			order = 9,
			type = 'group', 
			name = L["Set limits"],
			desc = L["Set all limits for the pots and herbs to show green, orange, red color - if value is above green value it shows green, between green and orange a gradient will be calculated, below orange it shows red."],
			args = {
				limitpots = {
					order = 1,
					type = 'group', 
					name = L["Pot limits"],
					desc = L["Set pot limits to show green, orange, red color"],
					pass = true,
					func = function(key)
						--dewdrop:Close()
						PotHerbFu:Print(key)
					end,
					
					args = {
					}
				},				
				limitherbs = {
					order = 2,
					type = 'group', 
					name = L["Herb limits"],
					desc = L["Set herb limits to show green, orange, red color"],
					args = {
					}
				},				
				limitmisc = {
					order = 3,
					type = 'group', 
					name = L["Misc limits"],
					desc = L["Set misc limits to show green, orange, red color"],
					args = {
					}
				}								
			}
		},		
		manualItems = {
			order = 15,
			type = 'group', 
			name = L["Add Items"],
			desc = L["Manually add pots / herbs / mist stuff to the lists."],
			args = {
					fromBag = {
						order = 5,
						name = L["From Bag"],
						type = 'group',
						desc = L["Manually add an item from the bag. (should always work)"],
						hasArrow = true,
						args = {						
						},
					},																					
					IDInput = {
						order = 10,
						name = L["ID Input"],
						type = 'text',
						desc = L["Manually type in what item ID you wish to add. (Does mostly work)"],
						get = false,
						set = function(value)
							PotHerbFu:ManualAddItemID(value)
						end,
						usage = L["<text to test>"],
					},																		
					textInput = {
						order = 15,
						name = L["Text Input"],
						type = 'text',
						desc = L["Manually type in what you wish to add. (Does not always work)"],
						get = false,
						set = function(value)
							PotHerbFu:ManualAddItem(value)
						end,
						usage = L["<text to test>"],
					},								
					changeCategory = {
						order = 20,
						name = L["Change category"],
						type = 'group',
						desc = L["Manually change the category the last item was placed into to something else. (this will affect the last manual added item)"],
						hasArrow = true,
						args = {						
						},
						disabled = function()
							if PotHerbFu.lastManualItemName and PotHerbFu.lastManualItemSubGroup then
								return false;
							else
								return true;
							end
						end,															
					},													
				}
		},		
		manualCD = {
			order = 20,
			type = 'group', 
			name = L["Data Aquiring"],
			desc = L["Certain functions to acquire data needed."],
			args = {
				manualDRS = {
					order = 1,
					type = "execute",
					name = L["Gather Data"],
					desc = L["Refresh the data gathered from OneView (also performed by a regular click on text)"],
					func = "OnClick";
				},
				manualSB = {
					order = 2,
					type = "execute",
					name = L["Calculate Pots"],
					desc = L["Calculate the makeable amount of pots from the present data (also performed by a SHIFT click on text)"],
					func = "CalcMakeablePots";
				},			
				scanAlchy = {
					order = 3,
					type = "execute",
					name = L["Scan Recipes"],
					desc = L["Will open you alchemy window and scan all recipes you got (also performed by a CTRL click on text)"],
					func = "OpenAndImportCrafts",
				},
				clearLabel = {
					order = 4,
					type = "execute",
					name = L["Reset ALL Settings"],
					desc = L["Clear all settings including limits set (also performed by an ALT click on text)"],
					func = "ClearConfirm",
				},					
			}
		},		
	}
}

--PotHerbFu.OnMenuRequest = optionsTable
PotHerbFu:RegisterChatCommand( { "/PotHerbfu" }, optionsTable )
PotHerbFu.clickableTooltip = true
PotHerbFu.hasIcon = true
PotHerbFu.charDisplaystring = "c";
PotHerbFu.clearSelectionString = "x";

PotHerbFu:RegisterDB("PotHerbFuDB")
PotHerbFu:RegisterDefaults('profile', {
	hideLabel = 1,
	filterVials = 1,
	filterPots = 1,
	limitSelectionChanged = 1, -- 1 for startup, will always be set to 1 when pots/herbs/misc selections have been changed for menu to update
	displayCat = nil,
	displayItem = nil,
	showMakeableInfo = 1, -- show the info for makeable pots in tt detail view
	showUsableInfo = 1, -- show the info for makeable pots in tt detail view
	hideOverview = 1, -- hide the overview, when in detailed view
	showHideDetails = nil, -- if this is on there is an extra line .. hide details below details
	tipOrder = { 
		[1]= "pots",
		[2]= "herbs",
		[3]= "misc",
	},
	fuckedHerbs = { 
		["13465"]= 1,
	},
	--[[herbList = {"Grave Moss","Mountain Silversage","Sungrass","Firebloom","Goldthorn","Fadeleaf","Dreamfoil","Khadgar's Whisker","Swiftthistle",
		"Liferoot","Icecap","Plaguebloom","Gromsblood","Stranglekelp","Golden Sansam","Arthas' Tears","Blindweed","Purple Lotus","Mageroyal",
		"Ghost Mushroom","Kingsblood","Bruiseweed","Earthroot","Briarthorn","Silverleaf","Peacebloom","Felweed","Netherbloom","Nightmare Vine",
		"Ancient Lichen","Terocone","Dreaming Glory","Ragveil","Mana Thistle","Fel Lotus"},]]
	--addMisc = {"Whipper Root Tuber","Night Dragon's Breath","Heavy Netherweave Bandage","Warp Burger","Ravager Dog","Mote of Fire","Mote of Mana","Mote of Water","Mote of Air","Mote of Earth","Mote of Life","Primal Fire","Primal Water","Primal Mana","Primal Earth","Primal Air","Primal Life"},			
	mailbox = {}, -- stuff thats in mailbox
	valueMin = 1, --- min value for orange and green
	valueMax = 100, --- max value for orange and green
	valueStep = 1, --- step value for orange and green
})

function PotHerbFu:showMsg(msg,error)	
	self:Print(msg); 
end

function PotHerbFu:MAIL_INBOX_UPDATE()		
	self:InboxFrame_Update();
  self:Update();
end

function PotHerbFu:CHAT_MSG_LOOT()	
  self:Update();
end

function PotHerbFu:OnInitialize()
	self:SetIcon("Interface\\Icons\\Trade_Alchemy.blp");
end

function PotHerbFu:OnEnable()
  -- Events
  --self:RegisterEvent("PLAYER_ENTERING_WORLD");  
  
  --self:ScheduleRepeatingEvent(self.OnUpdate, 5, self);
  
  -- Variables   
  self:Hook("InboxFrame_Update",true)
  	
	self:CreateData();
	self:CreateSortedTables();
	self.db.profile.displayCat = nil;
	self.db.profile.displayItem = nil;	
	
	--self:CreateOptionsTable();
	--self:ClearData()
  self:showMsg("Initialized successfully !");	
end

function PotHerbFu:OnDisable()
end

function PotHerbFu:InboxFrame_Update()
	self.hooks["InboxFrame_Update"]()
	--DEFAULT_CHAT_FRAME:AddMessage("Frame Update"); 	
	local index = GetInboxNumItems();	
	if index > 0 then	
		if (self.db.profile.mailbox) then
			local nm = UnitName("player");
			self.db.profile.mailbox[nm] = nil;
			self.db.profile.mailbox[nm] = {};
	
			for i=1,index do
				local _, _, _, subject, _, _, _, hasItem, _, _, _, _ = GetInboxHeaderInfo(i);
				--DEFAULT_CHAT_FRAME:AddMessage("ID "..i.." -"..subject);	
				if (hasItem) then
					_,_,mbitem, amount = string.find(subject, "%[(.+) x(%d+)")	
					if mbitem and amount then
						--DEFAULT_CHAT_FRAME:AddMessage("ID "..i.." -"..mbitem.."-"..amount);	
						if (self.db.profile.mailbox[nm][mbitem]) then
							self.db.profile.mailbox[nm][mbitem] = self.db.profile.mailbox[nm][mbitem] + amount;
						else
							self.db.profile.mailbox[nm][mbitem] = amount;
						end
					end
				end
			end
		end
	else
		if (self.db.profile.mailbox) then
			local nm = UnitName("player");
			self.db.profile.mailbox[nm] = nil;
		end		
	end
	--self:showMsg("Mailbox scanned !"); 
end

function PotHerbFu:OnItemCtrlClick(i,j) 
	if (not self.db.profile.data[i][j]) then
		return;
	end
	if (IsAltKeyDown()) then
		if (self.db.profile.data[i][j].isUsed) then
			self:Print(j..L[" is used in some recipes. Can not be deleted ! Delete the recipes first, then you can delete the reagent !"]);			
			return;
		end
		self.db.profile.data[i][j] = nil;
		self:CalculatedUsedInRecipes();
		return;
	end		
	self.db.profile.limitSelectionChanged = 1;
	if (self.db.profile.data[i][j].checked) then
		self.db.profile.data[i][j].checked = nil;
	else
		self.db.profile.data[i][j].checked = 1;
	end
end

function PotHerbFu:OnItemClick(i,j)
	if (IsAltKeyDown()) or (i == self.clearSelectionString) then
		self.db.profile.displayCat = nil;
		self.db.profile.displayItem = nil;
		--DEFAULT_CHAT_FRAME:AddMessage("Reset"); 
		return;
	end			
	if (i ~= self.charDisplaystring) and (not self.db.profile.data[i][j]) then
		return;
	end
	self.db.profile.displayCat = i;
	self.db.profile.displayItem = j;
	--DEFAULT_CHAT_FRAME:AddMessage("Item "..i.."-"..j); 
end

function PotHerbFu:OnTextUpdate()		
	local retval;    		
	for _,ct in ipairs(self.db.profile.tipOrder) do
		if (self.db.profile.data[ct]) then
			--DEFAULT_CHAT_FRAME:AddMessage("Item "..ct); 
			local i = 0;						
			for j,_ in pairs(self.db.profile.data[ct]) do			
				if (self.db.profile.data[ct][j].checked) then
					i = i + 1;
				end
			end
			if (not retval) then
				if (self.db.profile.hideLabel) then
					retval = i;
				else
					retval = "PHM: "..i;
				end
			else
				retval = retval.."/"..i;
			end			
		end
	end		
	if (not retval) then
		if (self.db.profile.hideLabel) then		
  		self:SetText("");
  	else
  		self:SetText("PHM");
  	end
  else
  	self:SetText(retval);
  end  	
end

function PotHerbFu:ItemColor(i,j,val)
	if (not self.db.profile.data[i]) or (not self.db.profile.data[i][j]) then
		return 1,1,1;
	end
	local ora = self.db.profile.data[i][j].orange;
	local gre = self.db.profile.data[i][j].green;
	
	if (not ora) or (not gre) or (not val) then
		return 1,1,1;
	end
	
	if (ora >= gre) then -- ora may not be greater green
		ora = gre - self.db.profile.valueStep;		
		if (ora < self.db.profile.valueMin) then
			ora = self.db.profile.valueMin;
		end
		self.db.profile.data[i][j].orange = ora;
	end	
	
	local q = (gre - ora) / 4;
	
	local r,g,b = crayon:GetThresholdColor(val,ora,ora+q,ora+2*q,ora+3*q,gre);

--[[	local r,g,b;
	r = 1;
	g = 1;
	b = 0;	
	if (val < self.db.profile.data[i][j].orange) then
		r = 1;
		g = 0;
		b = 0;			
	elseif (val > self.db.profile.data[i][j].green) then
		r = 0;
		g = 1;
		b = 0;					
	end			]]--
	return r,g,b;
end

function PotHerbFu:OnTooltipUpdate()
	local useShift = nil;
	local useCtrl = nil;
	local useAlt = nil;

	if (IsShiftKeyDown()) then
		useShift = 1;		
	end
	if (IsControlKeyDown()) then
		useCtrl = 1;		
	end
	if (IsAltKeyDown()) then
		useAlt = 1;
	end	
	local cat = tablet:AddCategory(
		'columns', 4
	)
	
	cat:AddLine(
		'text', ""
	)
		
	if (useShift) and not (useAlt) and not useCtrl then -- CTRL tooltip , show overall data
		self:GatherTotalStats();
		local line = {};						
		line['text'] = L["Last Item Scan"];
		line['text4'] = self.db.profile.lastItemScan
		line['hasCheck'] = false								
		cat:AddLine(line);		
		
		line['text'] = L["Last Pot Calculation"];
		line['text4'] = self.db.profile.lastPotCalculation
		line['hasCheck'] = false								
		cat:AddLine(line);						

		if (self.db.profile.totalStats) then
			
			line['text'] = " ";
			line['text4'] = " "
			line['hasCheck'] = false								
			cat:AddLine(line);														
			
			if (self.db.profile.totalStats.players) then
				line['text'] = L["Total players scanned"];
				line['text4'] = self.db.profile.totalStats.players
				line['hasCheck'] = false								
				cat:AddLine(line);										
			end
			
			if (self.db.profile.totalStats.bags) then
				line['text'] = L["Total bags scanned "];
				line['text4'] = self.db.profile.totalStats.bags
				line['hasCheck'] = false								
				cat:AddLine(line);														
			end
			
			line['text'] = L["Total items listed"];
			line['text4'] = self.db.profile.totalStats.items
			line['hasCheck'] = false								
			cat:AddLine(line);														

			line['text'] = L["Total items selected"];
			line['text4'] = self.db.profile.totalStats.selectedItems
			line['hasCheck'] = false								
			cat:AddLine(line);																

			line['text'] = L["Total found items"];
			line['text4'] = self.db.profile.totalStats.itemCount
			line['hasCheck'] = false								
			cat:AddLine(line);														

			line['text'] = L["Total makeable items"];
			line['text4'] = self.db.profile.totalStats.makeAble
			line['hasCheck'] = false								
			cat:AddLine(line);																
		end
		
		tablet:SetHint(L["SHIFT click icon to calculate makeable pots. CTRL click icon to collect data from alchemist book. ALT click to erase all data. NORMAL click gathers new data from all chars bags."])	
		return;
	end	
	
	if (useCtrl) then -- show selection tooltip with shift		
		for _,ct in ipairs(self.db.profile.tipOrder) do
			--DEFAULT_CHAT_FRAME:AddMessage(ct); 
			if (self.db.profile.data[ct]) then
				--DEFAULT_CHAT_FRAME:AddMessage(i); 
				local line = {};						
				line['text'] = L[ct]
				line['hasCheck'] = false								
				cat:AddLine(line);
						
				for _,j in ipairs(self.tempData[ct]) do			
					--DEFAULT_CHAT_FRAME:AddMessage(j); 
					if (self.db.profile.data[ct][j]) then
						local line = {};				
						line['text'] = j
						line['textR'] = 1
						line['textG'] = 1
						line['textB'] = 1																				
						line['text2'] = self.db.profile.data[ct][j].orange;
						line['text3'] = self.db.profile.data[ct][j].green;
						line['func'] = 'OnItemCtrlClick'
						line['arg1'] = self			
						line['arg2'] = ct
						line['arg3'] = j
						line['hasCheck'] = true
						line['checked'] = self.db.profile.data[ct][j].checked;
						cat:AddLine(line);				
					end
				end
			end			
		end		
		tablet:SetHint(L["Use CTRL+ALT click to delete items permanently from list."])	
		self:UpdateText();
		return;
	end
	
	if self.db.profile.displayCat and self.db.profile.displayItem then -- display some detailed item info if both things are set
		
		if (self.db.profile.displayCat == self.charDisplaystring) then
			local line = {};						
			line['text'] = self.db.profile.displayItem..L[" (total)"]
			line['text2'] = L["bags"];	
			line['text3'] = L["box"];	
			line['text4'] = L["bank"];	
			line['func'] = 'OnItemClick'
			line['arg1'] = self			
			line['arg2'] = self.charDisplaystring;
			line['arg3'] = self.db.profile.displayItem;								
			
			--line['text2'] = item.total;	
			--line['text3'] = item.make.count;				
			--line['text3R'],line['text3G'],line['text3B'] = self:ItemColor(self.db.profile.displayCat,self.db.profile.displayItem,item.make.count);				
			--	line['text4'] = item.make.count+item.total;				
				--line['text4R'],line['text4G'],line['text4B'] = self:ItemColor(self.db.profile.displayCat,self.db.profile.displayItem,item.make.count+item.total);							
			cat:AddLine(line);			
			
			for _,ct in ipairs(self.db.profile.tipOrder) do
				--DEFAULT_CHAT_FRAME:AddMessage(ct); 
				if (self.db.profile.data[ct]) then
					local hasItems = nil;
						
					for _,j in ipairs(self.tempData[ct]) do			
						local item = self.db.profile.data[ct][j];
						if (item) and ((item.checked) or (useAlt) and not useShift and not useCtrl) then							
							for k,_ in pairs(item.charData) do
								if (k == self.db.profile.displayItem) then -- items on that char
									hasItems = 1;
									local line = {};						
									line['text'] = "   "..j.." ("..item.total..")"
									line['textR'],line['textG'],line['textB'] = self:ItemColor(ct,j,item.total);				
									line['text2'] = item.charData[k].bags;	
									line['text2R'],line['text2G'],line['text2B'] = self:ItemColor(ct,j,item.charData[k].bags*3);				
									line['text3'] = item.charData[k].box;	
									line['text3R'],line['text3G'],line['text3B'] = self:ItemColor(ct,j,item.charData[k].box*3);				
									line['text4'] = item.charData[k].bank;	
									line['text4R'],line['text4G'],line['text4B'] = self:ItemColor(ct,j,item.charData[k].bank*3);				
									line['func'] = 'OnItemClick'
									line['arg1'] = self			
									line['arg2'] = ct;
									line['arg3'] = j;								
									cat:AddLine(line);					
								end
							end							
						end
					end
					
					if (hasItems) and (i ~= table.getn(self.db.profile.tipOrder)) then -- dont show on last item
						local line = {};						
						line['text'] = " "
						line['hasCheck'] = false								
						cat:AddLine(line);
					end
				end
			end
			if (not useAlt) then
				tablet:SetHint(L["Hold ALT move in and out to see all items stored on this char. Presently only the selected ones are shown."])				
			end
		else		
			local item = self.db.profile.data[self.db.profile.displayCat][self.db.profile.displayItem];
			if (item) then
				--DEFAULT_CHAT_FRAME:AddMessage("Showing :"..self.db.profile.displayCat.."-"..self.db.profile.displayItem); 
				local line = {};						
				line['text'] = self.db.profile.displayItem
				line['textR'],line['textG'],line['textB'] = self:ItemColor(self.db.profile.displayCat,self.db.profile.displayItem,item.total);
				line['text2R'] = line['textR']
				line['text2G'] = line['textG']
				line['text2B'] = line['textB']													
				line['text2'] = item.total;	
				if (self.db.profile.displayCat ~= "herbs") then									
					if (item.make) then
						line['text3'] = item.make.count;				
						line['text3R'],line['text3G'],line['text3B'] = self:ItemColor(self.db.profile.displayCat,self.db.profile.displayItem,item.make.count);				
						line['text4'] = item.make.count+item.total;				
						line['text4R'],line['text4G'],line['text4B'] = self:ItemColor(self.db.profile.displayCat,self.db.profile.displayItem,item.make.count+item.total);				
					else
						line['text3'] = "N/A";				
						line['text3R'],line['text3G'],line['text3B'] = self:ItemColor(self.db.profile.displayCat,self.db.profile.displayItem,0);				
						line['text4'] = "N/A";				
						line['text4R'],line['text4G'],line['text4B'] = self:ItemColor(self.db.profile.displayCat,self.db.profile.displayItem,0);									
					end
				end			
				cat:AddLine(line);
			
				if (item.charData) then
					local display = nil;
					for i,_ in pairs(item.charData) do
						display = 1;
						break;
					end
					if (display) then
						local line = {};						
						line['text'] = L["   Name"]
						line['text2'] = L["bags"];	
						line['text3'] = L["box"];	
						line['text4'] = L["bank"];	
						cat:AddLine(line);					
					
						for i,_ in pairs(item.charData) do
							local line = {};						
							line['text'] = "   "..i
							line['text2'] = item.charData[i].bags;	
							line['text2R'],line['text2G'],line['text2B'] = self:ItemColor(self.db.profile.displayCat,self.db.profile.displayItem,item.charData[i].bags*3);				
							line['text3'] = item.charData[i].box;	
							line['text3R'],line['text3G'],line['text3B'] = self:ItemColor(self.db.profile.displayCat,self.db.profile.displayItem,item.charData[i].box*3);				
							line['text4'] = item.charData[i].bank;	
							line['text4R'],line['text4G'],line['text4B'] = self:ItemColor(self.db.profile.displayCat,self.db.profile.displayItem,item.charData[i].bank*3);				
							line['func'] = 'OnItemClick'
							line['arg1'] = self			
							line['arg2'] = self.charDisplaystring;
							line['arg3'] = i;								
							cat:AddLine(line);					
						end
					end
				end
			end
			
			cat:AddLine(
				'text', " "
			)			
			
			if (self.db.profile.showMakeableInfo) and (item) and (item.req) and (item.make) and (item.make.count) then
				local line = {};						
				line['text'] = L["   MakeInfo"]
				line['textR'] = 0
				line['textG'] = 0.8
				line['textB'] = 1																								
				line['text2'] = item.make.count;	
				line['text2R'],line['text2G'],line['text2B'] = self:ItemColor(self.db.profile.displayCat,self.db.profile.displayItem,item.make.count);				
				line['text3'] = item.make.limit;	
				line['text3R'],line['text3G'],line['text3B'] = self:ItemColor(item.make.limitCat,item.make.limit,item.make.limitCount);				
				line['text4'] = item.make.limitCount;	
				line['text4R'],line['text4G'],line['text4B'] = self:ItemColor(item.make.limitCat,item.make.limit,item.make.limitCount);				
				cat:AddLine(line);					
				
				for i,_ in pairs(item.req) do
					--DEFAULT_CHAT_FRAME:AddMessage("Req :"..i); 
					local line = {};						
					line['text'] = "     "..i
					line['text2'] = item.req[i].count;	
					line['text2R'] = 1
					line['text2G'] = 1
					line['text2B'] = 0																													
					--line['text2R'],line['text2G'],line['text2B'] = self:ItemColor(self.db.profile.displayCat,self.db.profile.displayItem,item.make.count);				
					line['text3'] = " ";	
					--line['text3R'],line['text3G'],line['text3B'] = self:ItemColor(item.make.limitCat,item.make.limit,item.make.limitCount);				
					--DEFAULT_CHAT_FRAME:AddMessage("Req :"..item.req[i].cat.."-"..i); 
					line['text4'] = self.db.profile.data[item.req[i].cat][i].total;	
					line['text4R'],line['text4G'],line['text4B'] = self:ItemColor(item.req[i].cat,i,self.db.profile.data[item.req[i].cat][i].total);				
					line['textR'] = line['text4R']
					line['textG'] = line['text4G']
					line['textB'] = line['text4B']																					
					line['func'] = 'OnItemClick'
					line['arg1'] = self			
					line['arg2'] = item.req[i].cat
					line['arg3'] = i												
					cat:AddLine(line);										
				end

				cat:AddLine(
					'text', " "
				)							
			end			
			
			if (self.db.profile.data[self.db.profile.displayCat][self.db.profile.displayItem].isUsed) and (self.db.profile.showUsableInfo) and ( (self.db.profile.displayCat ~= "pots") or (self.db.profile.data[self.db.profile.displayCat][self.db.profile.displayItem].isReagent == true) ) then									

				local line = {};						
				line['text'] = L["   Used in"];
				line['text2'] = L["amount"];	
				line['text3'] = L["avail"];	
				line['text4'] = L["make"];					
				cat:AddLine(line);					

				for _,ct in ipairs(self.db.profile.tipOrder) do
					if (ct ~= "herbs") then				
						for i,_ in pairs(self.db.profile.data[ct]) do
							if (self.db.profile.data[ct][i].req) then
								for j,_ in pairs(self.db.profile.data[ct][i].req) do
									if (j == self.db.profile.displayItem) then
										--DEFAULT_CHAT_FRAME:AddMessage("Found in :"..i); 
										local line = {};						
										line['text'] = "   "..i
										line['text2'] = self.db.profile.data[ct][i].req[j].count;	
										line['text2R'] = 1
										line['text2G'] = 1
										line['text2B'] = 0																															
										line['text3'] = self.db.profile.data[ct][i].total;	
										line['text3R'],line['text3G'],line['text3B'] = self:ItemColor(ct,i,self.db.profile.data[ct][i].total);											
										line['textR'] = line['text3R']
										line['textG'] = line['text3G']
										line['textB'] = line['text3B']											
										line['func'] = 'OnItemClick'
										line['arg1'] = self			
										line['arg2'] = ct
										line['arg3'] = i							
										if (self.db.profile.data[ct][i].make) and (self.db.profile.data[ct][i].make.count) then
											line['text4'] = self.db.profile.data[ct][i].make.count;										
											line['text4R'],line['text4G'],line['text4B'] = self:ItemColor(ct,i,self.db.profile.data[ct][i].make.count);																			
										end							
										cat:AddLine(line);												
									end
								end
							end
						end
					end 
				end

				cat:AddLine(
					'text', " "
				)											
			end			
		end
		
		if (self.db.profile.showHideDetails) and (not self.db.profile.hideOverview) then
			local line = {};						
		
			line['text'] = ""
			cat:AddLine(line);
		
			line['text'] = L["   clear details <-"]
			line['textR'] = 1;
			line['textG'] = 0;
			line['textB'] = 0;
			line['func'] = 'OnItemClick'
			line['arg1'] = self			
			line['arg2'] = self.clearSelectionString
			line['arg3'] = "";
			cat:AddLine(line);			
		end
	end
	
	if self.db.profile.hideOverview and self.db.profile.displayCat and self.db.profile.displayItem then
		local line = {};						
		
		line['text'] = ""
		cat:AddLine(line);
		
		line['text'] = L["   back <-"]
		line['textR'] = 1;
		line['textG'] = 0;
		line['textB'] = 0;
		line['func'] = 'OnItemClick'
		line['arg1'] = self			
		line['arg2'] = self.clearSelectionString
		line['arg3'] = "";
		cat:AddLine(line);
	else		
		for _,ct in ipairs(self.db.profile.tipOrder) do
			--DEFAULT_CHAT_FRAME:AddMessage(ct); 
			if (self.db.profile.data[ct]) then
				--DEFAULT_CHAT_FRAME:AddMessage(i); 
				local line = {};						
				line['text'] = L[ct]
				if (ct == "pots") then					
					line['text2'] = L["avail"];	
					line['text3'] = L["make"];				
					line['text4'] = L["total"];				
				end			
				line['hasCheck'] = false								
				cat:AddLine(line);
						
				for _,j in ipairs(self.tempData[ct]) do			
					if (self.db.profile.data[ct][j]) and ((self.db.profile.data[ct][j].checked) or (useAlt) and not useShift) then
						local line = {};	
				
						line['text'] = "   "..j
						line['textR'],line['textG'],line['textB'] = self:ItemColor(ct,j,self.db.profile.data[ct][j].total);
						line['text2R'] = line['textR']
						line['text2G'] = line['textG']
						line['text2B'] = line['textB']					
						line['text2'] = self.db.profile.data[ct][j].total;					
						if (ct == "pots") and (self.db.profile.data[ct][j].make) then
							if (self.db.profile.data[ct][j].req) then -- only if you know the requirements, you can make some
								line['text3'] = self.db.profile.data[ct][j].make.count;								
							else
								line['text3'] = "";
							end
							line['text3R'],line['text3G'],line['text3B'] = self:ItemColor(ct,j,self.db.profile.data[ct][j].make.count);
												
							local all =	self.db.profile.data[ct][j].total + self.db.profile.data[ct][j].make.count;						
							line['text4'] = all;						
							line['text4R'],line['text4G'],line['text4B'] = self:ItemColor(ct,j,all);						
						end
						line['func'] = 'OnItemClick'
						line['arg1'] = self			
						line['arg2'] = ct
						line['arg3'] = j
						if (self.db.profile.data[ct][j].icon) then
							line['checkIcon'] = self.db.profile.data[ct][j].icon
							line['hasCheck'] = true
							line['checked'] = true							
						end					
						cat:AddLine(line);				
					end
				end
			end			
		end				
		tablet:SetHint(L["Click any entry to get more info! Hold CTRL / ALT / SHIFT when accessing tooltip for different data displays."])	
		if (not self.db.profile.showHideDetails) and (not self.db.profile.hideOverview) and self.db.profile.displayCat and self.db.profile.displayItem then
			tablet:SetHint(L["ALT + SHIFT click any item to remove the detail section from tooltip again."])	
		end
	end	
end


function PotHerbFu:GatherTotalStats()
	if (not self.db.profile.totalStats) then
		self.db.profile.totalStats = {};
	end	
	self.db.profile.totalStats.selectedItems = 0;
	self.db.profile.totalStats.items = 0;
	self.db.profile.totalStats.itemCount = 0;
	self.db.profile.totalStats.makeAble = 0;
	
	for l,_ in pairs(self.db.profile.data) do --herbs/pots/misc
		for k,_ in pairs(self.db.profile.data[l]) do --names of above
			self.db.profile.totalStats.items = self.db.profile.totalStats.items + 1;
			if (self.db.profile.data[l][k].total) then
				self.db.profile.totalStats.itemCount= self.db.profile.totalStats.itemCount + self.db.profile.data[l][k].total;
			end
			if (self.db.profile.data[l][k].make) and (self.db.profile.data[l][k].make.count) then
				self.db.profile.totalStats.makeAble = self.db.profile.totalStats.makeAble + self.db.profile.data[l][k].make.count;
			end
			if (self.db.profile.data[l][k].checked) then
				self.db.profile.totalStats.selectedItems = self.db.profile.totalStats.selectedItems + 1;
			end
		end
	end	
end

function PotHerbFu:OnClick()

	if (IsShiftKeyDown()) then
		self:CalcMakeablePots();
		return;
	end
	if (IsControlKeyDown()) then
		local success = self:OpenAndImportCrafts();
		if (success == false) then
			return;
		end
	end
		
	if (IsAltKeyDown()) then
		self:ClearConfirm();
	end		
	
	if (not self.db.profile.totalStats) then
		self.db.profile.totalStats = {};
	end	
	
	self.db.profile.totalStats.players = 0;
	self.db.profile.totalStats.bags = 0;	
	
	
	for l,_ in pairs(self.db.profile.data) do --herbs/pots/misc
		for k,_ in pairs(self.db.profile.data[l]) do --names of above
			if (not self.db.profile.data[l][k].charData) then
				self.db.profile.data[l][k].charData = {};
			end
			for m,_ in pairs(self.db.profile.data[l][k].charData) do -- user names
				--DEFAULT_CHAT_FRAME:AddMessage(l.."-"..k.."-"..m); 
				self.db.profile.data[l][k].charData[m].bank = 0;
				self.db.profile.data[l][k].charData[m].bags = 0;
				self.db.profile.data[l][k].charData[m].box = 0;
			end
			self.db.profile.data[l][k].total = 0;
		end
	end
	
	--DEFAULT_CHAT_FRAME:AddMessage("Stuff Cleared"); 
	
	--[[if not (OneView) and BagnonDB and (BagnonDB.GetBagData) and (BagnonDB.GetItemData) then	
		for k in BagnonForeverData[currentRealm] do 
			--DEFAULT_CHAT_FRAME:AddMessage(k); 
			for j=-2,11,1 do
				local size,baglink,bagcount = BagnonDB.GetBagData(k,j);
				if (size) then
					--DEFAULT_CHAT_FRAME:AddMessage("Bag ID : "..j.." Size : "..size.." Count : "..bagcount); 
					for i=1,size,1 do
						local itemlink,itemcount,_,_ = BagnonDB.GetItemData(k,j,i);
						if (itemlink) and (itemcount) then
							local itemname, _, _, _, _, _, _, _, _ = GetItemInfo(itemlink);
							--DEFAULT_CHAT_FRAME:AddMessage("Slot ID : "..i.." Name : "..itemname.." Count : "..itemcount); 							 
							for l in self.db.profile.data do 
								if (self.db.profile.data[l][itemname]) then
									if ( not self.db.profile.data[l][itemname].charData[k]) then
									  self.db.profile.data[l][itemname].charData[k]= {};
									  self.db.profile.data[l][itemname].charData[k].bank = 0;
									  self.db.profile.data[l][itemname].charData[k].bags = 0;
									end
									self.db.profile.data[l][itemname].total = self.db.profile.data[l][itemname].total + itemcount;
									if (j <=4) and (j >= 0) then
										self.db.profile.data[l][itemname].charData[k].bags = self.db.profile.data[l][itemname].charData[k].bags + itemcount;
									else
										self.db.profile.data[l][itemname].charData[k].bank = self.db.profile.data[l][itemname].charData[k].bank + itemcount;
									end
								end
							end
						end
					end
				end
			end			
		end
	end	]]--
	
	if (OneView) and (OneView.storage) then
		--DEFAULT_CHAT_FRAME:AddMessage("starting Char list"); 
		local list = OneView.storage:GetCharListByServerId()
		
		for _, v in pairs(list) do
			for k, v2 in pairs(v) do
				local fact = faction
				local _, _, charName, charId = string.find(v2, "([^%-]+) . (.+)")
				if charName then
	      	--DEFAULT_CHAT_FRAME:AddMessage("server "..server.." fact "..faction); 
					self.db.profile.totalStats.players = self.db.profile.totalStats.players +1;
					--DEFAULT_CHAT_FRAME:AddMessage("name "..charName.." id "..charId); 
					if (OneView.BuildFrame) then
						--DEFAULT_CHAT_FRAME:AddMessage("loading char "..fact.." id "..charId); 
						--OneView:LoadCharacter(fact, charId);					
						OneView.faction = fact
						OneView.charId = charId	
						OneView:BuildFrame();
						OneView:OrganizeFrame()
						OneView:FillBags()					
					
						for bag = -1, 11 do
							self.db.profile.totalStats.bags = self.db.profile.totalStats.bags + 1;
							local curBag = OneView.frame.bags[bag]
							--DEFAULT_CHAT_FRAME:AddMessage("bag id "..bag); 
							if curBag and curBag.size and curBag.size > 0 then
								--DEFAULT_CHAT_FRAME:AddMessage("size "..curBag.size); 
								for slot = 1, curBag.size do
									local itemId, qty = OneView.storage:SlotInfo(OneView.faction, OneView.charId, bag, slot)
									if itemId then
										local itemName, _, _, _, _, _, _, _, _ = GetItemInfo(itemId)									
	--									if (charName == "Sandrielle") then
		--									DEFAULT_CHAT_FRAME:AddMessage("Slot ID : "..slot.." Name : "..itemName.." : "..qty); 							 
				--						end
										--implement structures here							
										if (itemName) then
--											DEFAULT_CHAT_FRAME:AddMessage("item/char "..itemName.."/"..charName); 
											for l,_ in pairs(self.db.profile.data) do 
												if (self.db.profile.data[l][itemName]) then
													if ( not self.db.profile.data[l][itemName].charData[charName]) then
													  self.db.profile.data[l][itemName].charData[charName]= {};
													  self.db.profile.data[l][itemName].charData[charName].bank = 0;
													  self.db.profile.data[l][itemName].charData[charName].bags = 0;
													  self.db.profile.data[l][itemName].charData[charName].box = 0;
													end
													self.db.profile.data[l][itemName].total = self.db.profile.data[l][itemName].total + qty;
													if (bag <=4) and (bag >= 0) then
														self.db.profile.data[l][itemName].charData[charName].bags = self.db.profile.data[l][itemName].charData[charName].bags + qty;
													else
														self.db.profile.data[l][itemName].charData[charName].bank = self.db.profile.data[l][itemName].charData[charName].bank + qty;
													end
												end
											end
										end
									end									
								end
							end
						end
					end						
				end
			end
		end
	end
	
	if (self.db.profile.mailbox) then
		for cname,_ in pairs(self.db.profile.mailbox) do			
			for mbitem,_ in pairs(self.db.profile.mailbox[cname]) do
				for l,_ in pairs(self.db.profile.data) do 
					if (self.db.profile.data[l][mbitem]) then
						--DEFAULT_CHAT_FRAME:AddMessage("item : "..mbitem.." bag "..l.." Name : "..cname); 							 
						if (not self.db.profile.data[l][mbitem].charData[cname]) then
						  self.db.profile.data[l][mbitem].charData[cname]= {};
						  self.db.profile.data[l][mbitem].charData[cname].bank = 0;
						  self.db.profile.data[l][mbitem].charData[cname].bags = 0;
						  self.db.profile.data[l][mbitem].charData[cname].box = 0;
						end
						self.db.profile.data[l][mbitem].total = self.db.profile.data[l][mbitem].total + self.db.profile.mailbox[cname][mbitem];
						self.db.profile.data[l][mbitem].charData[cname].box = self.db.profile.data[l][mbitem].charData[cname].box + self.db.profile.mailbox[cname][mbitem];
					end
				end													
			end
		end
	end		
	
	self.db.profile.lastItemScan = date("%A, %B %d, %Y - %H:%M");
	self:showMsg("Data collected successfully !");		
	HideDropDownMenu(1);
end

function PotHerbFu:CalcMakeablePots()
	for _,ct in ipairs(self.db.profile.tipOrder) do
		if (ct ~= "herbs") then
			for k,_ in pairs(self.db.profile.data[ct]) do
				--DEFAULT_CHAT_FRAME:AddMessage("-"..k); 
				local presentPot = self.db.profile.data[ct][k];
		
				local makeAmount = 99999999;
				local makeLimit = "";
				local makeLimitCat = "";
				local limitAmount = 0;
		
				if (presentPot["req"]) then
					for j,_ in pairs(presentPot["req"]) do
						local ing = presentPot["req"][j];
						--DEFAULT_CHAT_FRAME:AddMessage("->"..j.." - "..ing.count.." - "..ing.cat); 			
						if (self.db.profile.data[ing.cat]) and (self.db.profile.data[ing.cat][j]) and (self.db.profile.data[ing.cat][j].total) then				  --  and (self.db.profile.data[ing.cat][j].total > 0) 
						  local amt = math.floor(self.db.profile.data[ing.cat][j].total / ing.count);				  
						  --DEFAULT_CHAT_FRAME:AddMessage("--->"..j.." - "..self.db.profile.data[ing.cat][j].total.." - "..amt);
						  if (amt < makeAmount) then
						  	makeAmount = amt;
				  			makeLimit = j;
						  	makeLimitCat = ing.cat;
						  	limitAmount = self.db.profile.data[ing.cat][j].total;				  	
						  end
						end
				  end
				end					
						
				if (not presentPot.make) then
					presentPot.make = {};			
				end
				if (makeAmount > 999999) then
					presentPot.make.count = 0;
					presentPot.make.limit = "";
					presentPot.make.limitCount = "";
					presentPot.make.limitCat = 0;			
				else
					presentPot.make.count = makeAmount;
					presentPot.make.limit = makeLimit;
					presentPot.make.limitCount = limitAmount;
					presentPot.make.limitCat = makeLimitCat;
				end
			end
		end
	end	
	HideDropDownMenu(1);
	self.db.profile.lastPotCalculation = date("%A, %B %d, %Y - %H:%M");
	self:showMsg("Makeable potions calculated !"); 
end

function PotHerbFu:ClearConfirm()
	HideDropDownMenu(1);
	StaticPopupDialogs["FUBARPotHerb_CLEAR"] = {
		text = "Confirm you want to reset ALL settings ?",
		button1 = TEXT(OKAY),
		button2 = TEXT(CANCEL),
		OnAccept = function()
			self.db.profile.limitSelectionChanged = 1;
			self:ClearData();
		end,
		timeout = 0,
		exclusive = 1
	};
	StaticPopup_Show("FUBARPotHerb_CLEAR");
	PotHerbFu:UpdateText();
end

function PotHerbFu:GetValue(key)
	--IsOpen(parent)
	local _,_,ct,_ = string.find(self.db.profile.lastMenuVal,"(.+)_(.+)");
	if (not ct) then
		return
	end
	if (self.db.profile.lastMenuVal) and (self.db.profile.tableValues[self.db.profile.lastMenuVal]) then
		--DEFAULT_CHAT_FRAME:AddMessage("Get of "..self.db.profile.tableValues[self.db.profile.lastMenuVal].."-"..self.db.profile.rangeType); 
		if (self.db.profile.rangeType) then
			--DEFAULT_CHAT_FRAME:AddMessage("Value "..self.db.profile.data["herbs"][self.db.profile.tableValues[self.db.profile.lastMenuVal]][self.db.profile.rangeType]); 			
			return self.db.profile.data[ct][self.db.profile.tableValues[self.db.profile.lastMenuVal]][self.db.profile.rangeType];
		end
	end		
	--DEFAULT_CHAT_FRAME:AddMessage("None "); 			
end

function PotHerbFu:SetValue(value)
	local _,_,ct,_ = string.find(self.db.profile.lastMenuVal,"(.+)_(.+)");
	if (not ct) then
		return
	end	
	if (self.db.profile.lastMenuVal) and (self.db.profile.tableValues[self.db.profile.lastMenuVal]) then
		--DEFAULT_CHAT_FRAME:AddMessage("Set of "..self.db.profile.tableValues[self.db.profile.lastMenuVal].."-"..self.db.profile.rangeType); 
		if (value) then
			--DEFAULT_CHAT_FRAME:AddMessage("Value "..value); 
			self.db.profile.data[ct][self.db.profile.tableValues[self.db.profile.lastMenuVal]][self.db.profile.rangeType] = value;
			self:ItemColor(ct,self.db.profile.tableValues[self.db.profile.lastMenuVal],5); -- just to check if new selection is in range
		end
	end		
end

function PotHerbFu:OnMenuRequest(level, value, x, valueN_1, valueN_2, valueN_3, valueN_4)	
	self.db.profile.displayCat = nil;
	self.db.profile.displayItem = nil;
	
	if (self.db.profile.limitSelectionChanged) then
		self:CreateOptionsTable();	
		self.db.profile.limitSelectionChanged = nil;
		--dewdrop:FeedAceOptionsTable(PotHerbFu.newOptions)
	end
	if (value) then
		self.db.profile.lastMenuVal = value;
		--DEFAULT_CHAT_FRAME:AddMessage("Set of "..value); 
	end	
	--dewdrop:FeedAceOptionsTable(self.newOptions)
	--dewdrop:InjectAceOptionsTable(self, optionsTable);
	--self:Print(type(self.newOptions));
	--self:Print(type(optionsTable));
	if (value == "fromBag") then
		self:updateDynamicARDTables();
	end

	if (value == "changeCategory") then	
		optionsTable.args.manualItems.args.changeCategory.args = {};
		for i, _ in pairs(self.db.profile.tipOrder) do
			--self:Print(self.db.profile.tipOrder[i]);
			newTable2 = {
				order = 1,
				type = "execute",					
				name = self.db.profile.tipOrder[i],
				desc = "move to "..self.db.profile.tipOrder[i],
				hasCheck = true,					
				checked = true,												
				func = function() PotHerbFu:ManualChangeCategory(self.db.profile.tipOrder[i]); end,						
			},
			table.insert(optionsTable.args.manualItems.args.changeCategory.args, newTable2);
		end
	end
	
	dewdrop:FeedAceOptionsTable(optionsTable)
end

function PotHerbFu:ManualChangeCategory(newCat)	
	if (newCat) then
		if (self.lastManualItemName) and (self.lastManualItemSubGroup) then	-- both entries need to exist
			if (newCat ~= self.lastManualItemSubGroup) then -- no need to change if in same group as wanted
				if (self.db.profile.data[self.lastManualItemSubGroup]) and (self.db.profile.data[self.lastManualItemSubGroup][self.lastManualItemName]) and (self.db.profile.data[newCat]) then -- the item itself and the new category ahve to exist								
					self.db.profile.data[newCat][self.lastManualItemName] = self.db.profile.data[self.lastManualItemSubGroup][self.lastManualItemName]
					self.db.profile.data[self.lastManualItemSubGroup][self.lastManualItemName] = nil;
					self.lastManualItemSubGroup = newCat; -- its now in this group
					self:Print(self.lastManualItemName..L[" successfully moved to "]..newCat);
					self:CreateSortedTables();
					self:CreateOptionsTable();
				end				
			end
		end	
	end	
end

function PotHerbFu:CreateOptionsTable()
	--DEFAULT_CHAT_FRAME:AddMessage("new newOptions table "); 
	optionsTable.args.detachTooltip = nil;
	optionsTable.args.text = nil;
	optionsTable.args.about = nil;
	optionsTable.args.position = nil;
	optionsTable.args.minimapAttach = nil;
	optionsTable.args.icon = nil;
	optionsTable.args.colorText = nil;
	optionsTable.args.standby = nil;
	optionsTable.args.donate = nil;
	optionsTable.args.lockTooltip = nil;
	--optionsTable.args.hide = nil; -- this is a seperator
	optionsTable.args.limits.args.limitherbs.args = {};
	optionsTable.args.limits.args.limitpots.args = {};
	optionsTable.args.limits.args.limitmisc.args = {};
	if (optionsTable.args.limits.args.limitherbs.args) then
		self.db.profile.tableValues = {};
		for k,_ in pairs(self.db.profile.data) do
			local j = 1;
			for i,_ in pairs(self.db.profile.data[k]) do
				--self:Print(k.."-"..i);
				if (not self.db.profile.data[k][i].green) then
					self.db.profile.data[k][i].green = 20;
					self.db.profile.data[k][i].orange = 10;
					--self:Print("resetting values");
				end
				if (self.db.profile.data[k][i].checked) then
					--self:Print("checked");
					--DEFAULT_CHAT_FRAME:AddMessage("setting newOptions table "..i); 
					local rangeLine = {
						type = 'group',
						name = i,
						desc = i,
						args = {
							[""..k.."Green"..j] = {				
								type = 'range',
								name = "Green",
								desc = "If you have more items than this value the entry will show green",
								get = function(key)
									PotHerbFu.db.profile.rangeType = "green";
									return PotHerbFu:GetValue(key);
								end,
								set = function(v)
									PotHerbFu.db.profile.rangeType = "green";
									PotHerbFu:SetValue(v);
								end,
								min = PotHerbFu.db.profile.valueMin,
								max = PotHerbFu.db.profile.valueMax,
								step = PotHerbFu.db.profile.valueStep,
								order = j				
							},
							[""..k.."Orange"..j] = {				
								type = 'range',
								name = "Orange",
								desc = "If you have more items than this value the entry will show orange (must be smaller than green value or will be set to green)",
								get = function()
									PotHerbFu.db.profile.rangeType = "orange";
									return PotHerbFu:GetValue();
								end,
								set = function(v)
									PotHerbFu.db.profile.rangeType = "orange";
									PotHerbFu:SetValue(v);
								end,
								min = PotHerbFu.db.profile.valueMin,
								max = PotHerbFu.db.profile.valueMax,
								step = PotHerbFu.db.profile.valueStep,
								order = j				
							}					
						}					
					}
					optionsTable.args.limits.args["limit"..k].args[""..k.."_Line"..j] = rangeLine;
					self.db.profile.tableValues[""..k.."_Line"..j] = i;
					j= j + 1;			
				end
			end				
		end
	else
		DEFAULT_CHAT_FRAME:AddMessage("Error in options table"); 
		return nil;
	end		
end

function PotHerbFu:OpenAndImportCrafts()	
	self:CreateData();
	self.lastManualItemName = nil;
	self.lastManualItemSubGroup = nil;
	local imported = false;
	local i=1;
	while true do
		local spellName, spellRank = GetSpellName(i, "spell" ) 
		if (not spellName) then
			break;
		end
		if (spellName == "Alchemy") then
			if (GetNumTradeSkills() > 0) then
				--DEFAULT_CHAT_FRAME:AddMessage("Something Open : "); 
				CloseTradeSkill();
			end
			CastSpell(i, "spell");
			self:ImportCrafts()
			imported = true;
			-- getcrafts here				
			break;
		end
		i = i + 1;
	end	
	CloseTradeSkill();
	self:CreateSortedTables();
	self:CreateOptionsTable();	
	self.db.profile.limitSelectionChanged = nil;	
	PotHerbFu:UpdateText();
	if (imported == false) then
		self:showMsg("Failed to import recipes - You are not an Alchemist !"); 
		return false;
	end
	return true;	
end

function PotHerbFu:CalculatedUsedInRecipes()
	for _,ictg in ipairs(self.db.profile.tipOrder) do -- go through all categories
		for itemN,_ in pairs(self.db.profile.data[ictg]) do -- go through all item names
			local checkItem = self.db.profile.data[ictg][itemN]; -- item to check if it will be used in any recipes	
			checkItem.isUsed = nil; -- set to nil first
			for _,ct in ipairs(self.db.profile.tipOrder) do -- now run again through all possible recipes and see where it is used
				if (ct ~= "herbs") then -- no reagents are used for herbs
					for i,_ in pairs(self.db.profile.data[ct]) do
						if (self.db.profile.data[ct][i].req) then -- recipe requires stuff
							for j,_ in pairs(self.db.profile.data[ct][i].req) do
								if (j == itemN) then -- if what it is requires equals the name if our item we check then its used in some recipe
									checkItem.isUsed = 1;
								end
							end
						end
					end
				end
			end
		end 
	end
end


function PotHerbFu:ImportCrafts()
	self.specialReagents = {};
	if (not self.db.profile.data["pots"]) then
		self.db.profile.data["pots"] = {};
	end				
	if (not self.db.profile.data["misc"]) then
		self.db.profile.data["misc"] = {};
	end					
	local importedRecipeCount = 0;
	--DEFAULT_CHAT_FRAME:AddMessage("Importing : "..GetNumTradeSkills()); 
	for i=1, GetNumTradeSkills(), 1 do		
		local name, skillType, numAvailable, isExpanded = GetTradeSkillInfo(i);		
		local itemLink = GetTradeSkillItemLink(i);		
		local num = GetTradeSkillNumReagents(i);
		--DEFAULT_CHAT_FRAME:AddMessage("Craft : "..i.." : "..name.." SN : "..skillType.." TY : "..num); 				
		if (num > 0) then -- dont get headers
			local itemName, _, _, _, _, itemType, itemSubType, _,_, itemTexture = GetItemInfo(itemLink);
			if (itemName) and (not string.find(itemName,L["Philosopher's Stone"])) then						
				importedRecipeCount = importedRecipeCount +1;
				local subGroup;
				if (itemSubType == "Potion") or (itemSubType == "Elixir") or (itemSubType == "Flask") then
					subGroup = "pots"
				else
					--DEFAULT_CHAT_FRAME:AddMessage("Craft : "..itemName.." : "..itemType.." ST : "..itemSubType); 				
					subGroup = "misc"
				end
				if (not self.db.profile.data[subGroup][itemName]) then
					self.db.profile.data[subGroup][itemName] = {};						
				end
				self.db.profile.data[subGroup][itemName].req = {};
				self.db.profile.data[subGroup][itemName].itemType = itemType;
				self.db.profile.data[subGroup][itemName].itemSubType = itemSubType;
				self.db.profile.data[subGroup][itemName].icon = itemTexture;
				for j=1, num, 1 do
					local _, _, reagentCount = GetTradeSkillReagentInfo(i, j);
					local rlink = GetTradeSkillReagentItemLink(i, j);
					local rItemName, _, _, _, _, itemType, itemSubType, _,_, itemTexture = GetItemInfo(rlink);
					local found, _, itemString = string.find(rlink, "^|c%x+|H(.+)|h%[.+%]")
					if ((found) and (itemString)) then
						local _, itemId, enchantId, jewelId1, jewelId2, jewelId3, jewelId4, suffixId, uniqueId = strsplit(":", itemString);			
						--DEFAULT_CHAT_FRAME:AddMessage("ID "..name.." Reagent : "..rItemName.." : is supposed to be a herb, so make it one"); 				
						if (self.db.profile.fuckedHerbs[itemId] == 1) then -- some herbs may be trade goods, dunno why, probably blizzard bug, but fix it here
							--DEFAULT_CHAT_FRAME:AddMessage("Pot "..name.." Reagent : "..rItemName.." : is supposed to be a herb, so make it one"); 				
							itemSubType = "Herb";
						end
					end					
					if (rItemName) then -- add it to req list
						local subGroupReagent = nil;
						if (itemSubType == "Herb") then -- is a herb
							subGroupReagent = "herbs";							
						else
							if (not string.find(rItemName,L["(%a+) Vial"])) then -- no vials please
								--DEFAULT_CHAT_FRAME:AddMessage("Reagent : "..rItemName.." : "..itemType.." ST : "..itemSubType); 				
								subGroupReagent = "misc";								
								table.insert(self.specialReagents,rItemName); -- list all special reagents and see later if they can be created by yourself								
							end
						end
						if (subGroupReagent) then
							self.db.profile.data[subGroup][itemName].req[rItemName] = {};
							self.db.profile.data[subGroup][itemName].req[rItemName].count = reagentCount;
							self.db.profile.data[subGroup][itemName].req[rItemName].itemType = itemType;
							self.db.profile.data[subGroup][itemName].req[rItemName].itemSubType = itemSubType;
							self.db.profile.data[subGroup][itemName].req[rItemName].icon = itemTexture;																				
							self.db.profile.data[subGroup][itemName].req[rItemName].cat = subGroupReagent;
							
							if (not self.db.profile.data[subGroupReagent][rItemName]) then
								self.db.profile.data[subGroupReagent][rItemName] = {};
							end
							self.db.profile.data[subGroupReagent][rItemName].itemType = itemType;
							self.db.profile.data[subGroupReagent][rItemName].itemSubType = itemSubType;
							self.db.profile.data[subGroupReagent][rItemName].icon = itemTexture;																			
						end
					end
					--DEFAULT_CHAT_FRAME:AddMessage("        : "..i.." : "..itemName.." x : "..reagentCount); 
				end
			end
		end
	end
	for i,v in pairs(self.specialReagents) do
		--DEFAULT_CHAT_FRAME:AddMessage("SR : "..i.." - "..v); 				
		if (self.db.profile.data["pots"][v]) then
			--DEFAULT_CHAT_FRAME:AddMessage("Is a creatable Pot !"); 				
			self.db.profile.data["pots"][v].isReagent = true;
		end
		if (self.db.profile.data["misc"][v]) then
			--DEFAULT_CHAT_FRAME:AddMessage("Is a creatable Misc !"); 				
			self.db.profile.data["misc"][v].isReagent = true;
		end				
	end
	self:CalculatedUsedInRecipes();

	self:showMsg(""..importedRecipeCount.." recipes imported successfully !"); 
end

function PotHerbFu:CreateData()
	if (not self.db.profile.data) then
		self.db.profile.data = {};
	end
	if (not self.db.profile.data["herbs"]) then
		self.db.profile.data["herbs"] = {};
		--DEFAULT_CHAT_FRAME:AddMessage("Recreating herbs"); 				
	end		
	if (not self.db.profile.data["pots"]) then
		self.db.profile.data["pots"] = {};
	end			
	if (not self.db.profile.data["misc"]) then
		self.db.profile.data["misc"] = {};
	end						
end

function PotHerbFu:CreateSortedTables()
	if (not self.tempData) then
		self.tempData = {};
	end
	for i,_ in pairs(self.db.profile.data) do
		--DEFAULT_CHAT_FRAME:AddMessage(""..i); 
		self.tempData[i] = {};
		for j,_ in pairs(self.db.profile.data[i]) do
			--DEFAULT_CHAT_FRAME:AddMessage("  "..j); 
			table.insert(self.tempData[i],j);
		end
		table.sort(self.tempData[i]);
	end
end

function PotHerbFu:ClearData()	
	self.db.profile.data = {};
	self.db.profile.data["herbs"] = {};
	self.db.profile.data["pots"] = {};
	self.db.profile.data["misc"] = {};
	HideDropDownMenu(1);
end

function PotHerbFu:GetTimeString(timestamp)		
	local retval = {};
  retval.d = 0;
  retval.h = 0;
  retval.m = 0;
  retval.s = 0;
  -- 1 day: 86,400 seconds
  if ( timestamp >= 86400 ) then
  	retval.d = floor(timestamp / 86400);
    timestamp = (timestamp - (retval.d * 86400));
	end        
  -- 1 hour: 3,600 seconds
  if ( timestamp >= 3600 ) then
  	retval.h = floor(timestamp / 3600);
    timestamp = (timestamp - (retval.h * 3600));
  end
  -- 1 minute: 60 seconds
  if ( timestamp >= 60 ) then
  retval.m = floor(timestamp / 60);
  timestamp = (timestamp - (retval.m * 60));
  end
  retval.s = timestamp;

  return string.format("%dd %dh %dm %ds", retval.d, retval.h, retval.m, retval.s);
end

function PotHerbFu:ManualAddItem(value)
	if (value) then
		--self:Print(value);
		local _, itemLink = GetItemInfo(value);
		if (itemLink) then
			self:AddItemFromLink(itemLink);
		else
			self:Print(value..L[" - Couldn't get item link. Try the 'Add item from bag' feature"]);
		end
	end
end

function PotHerbFu:ManualAddItemID(value)
	if (value) then
		--self:Print(value);
		local _, itemLink = GetItemInfo(tonumber(value));
		if (itemLink) then
			self:AddItemFromLink(itemLink);
		else
			self:Print(value..L[" - Couldn't get item link. Try the 'Add item from bag' feature"]);
		end
	end
end

function PotHerbFu:AddItemFromLink(itemLink)
	if (itemLink) then
		--self:Print(itemLink);
		local itemName, _, _, _, _, itemType, itemSubType, _,_, itemTexture = GetItemInfo(itemLink);
		if (itemName) then						
			local subGroup;
			if (itemSubType == "Potion") or (itemSubType == "Elixir") or (itemSubType == "Flask") then
				subGroup = "pots"
			elseif (itemSubType == "Herb") then
				subGroup = "herbs"
			else
				subGroup = "misc"
			end
			if (not self.db.profile.data[subGroup][itemName]) then
				self.db.profile.data[subGroup][itemName] = {};						
			else
				self:Print(itemName..L[" is already listed."]);
				return;
			end
			self.db.profile.data[subGroup][itemName].itemType = itemType;
			self.db.profile.data[subGroup][itemName].itemSubType = itemSubType;
			self.db.profile.data[subGroup][itemName].icon = itemTexture;		
			self:Print(itemName..L[" added successfully."]);
			self.lastManualItemName = itemName;
			self.lastManualItemSubGroup = subGroup;
			self:CreateSortedTables();
			self:CreateOptionsTable();
		end
	end
end

--[[----------------------------------------------------------------------------
  Local Processing
------------------------------------------------------------------------------]]
-- Bag iterator, shamelessly stolen from PeriodicTable-2.0 (written by Tekkub)
local iterbag, iterslot
local function iter()
	if iterslot > GetContainerNumSlots(iterbag) then iterbag, iterslot = iterbag + 1, 1 end
	if iterbag > NUM_BAG_SLOTS then return end
	for b = iterbag,NUM_BAG_SLOTS do
		for s = iterslot,GetContainerNumSlots(b) do
			iterslot = s + 1
			local link = GetContainerItemLink(b,s)
			if link then return b, s, link end
		end
		iterbag, iterslot = b + 1, 1
	end
end
local function bagIter()
	iterbag, iterslot = 0, 1
	return iter
end

local dupeCheck = {}
function PotHerbFu:updateDynamicARDTables()
	--DEFAULT_CHAT_FRAME:AddMessage("Creating Table"); 
	optionsTable.args.manualItems.args.fromBag.args = {};
	for k in pairs(dupeCheck) do dupeCheck[k] = nil end
	-- Mailable items in bags
	for bag, slot, item in bagIter() do
		local itemID = tonumber(string.match(item or '', "item:(%d+)"))
		if itemID and not dupeCheck[itemID] then
			dupeCheck[itemID] = true
			gratuity:SetBagItem(bag, slot)
			if not gratuity:MultiFind(2, 4, nil, true, ITEM_BIND_QUEST, ITEM_CONJURED) or gratuity:Find(ITEM_BIND_ON_EQUIP, 2, 4, nil, true, true) then
			--if not gratuity:MultiFind(2, 4, nil, true, ITEM_SOULBOUND, ITEM_BIND_QUEST, ITEM_CONJURED, ITEM_BIND_ON_PICKUP) or gratuity:Find(ITEM_BIND_ON_EQUIP, 2, 4, nil, true, true) then	
				local itemName = GetItemInfo(itemID);
				--self:Print(itemName);
				newTable = {
					order = 1,
					type = "execute",					
					name = select(2, GetItemInfo(itemID)),
					desc = select(6, GetItemInfo(itemID)).." - "..select(7, GetItemInfo(itemID)),
					checkIcon = select(10, GetItemInfo(itemID)),
					hasCheck = true,					
					checked = true,					
					func = function() PotHerbFu:ManualAddItemID(itemID); end,
				},
				table.insert(optionsTable.args.manualItems.args.fromBag.args, newTable);
			end
		end
	end
end

function PotHerbFu:GetItemUrgencyValue(itemName) -- returns a number from 0-100 where 100 is the most urgent (red) and 0 is no urgency at all (green) and the date of the last item scan in format date("%A, %B %d, %Y - %H:%M"), returns -1 if item not found
	local value = -1;
	--self:Print(itemName);
	for _,i in ipairs(self.db.profile.tipOrder) do
		if (self.db.profile.data[i]) then
			--self:Print("category : "..i);
			if (self.db.profile.data[i][itemName]) then
				local ora = self.db.profile.data[i][itemName].orange;
				local gre = self.db.profile.data[i][itemName].green;						
				local avail = self.db.profile.data[i][itemName].total;									
				local make = 0;
				if (self.db.profile.data[i][itemName].make) and (self.db.profile.data[i][itemName].make.count) then
					make = self.db.profile.data[i][itemName].make.count;
				end				
				local total = avail; -- maybe change here on settins what total value to use
				if (total <= ora) then -- value is red
					value = 100; -- very urgent now
				elseif (total >= gre) then -- value is green
					value = 0; -- not urgent at all
				else -- between red and green
					local scale = 100 / (gre-ora); -- how to scale each point
					value = 100 - ((total - ora) * scale);					
				end
				--self:Print(value);
				return value,self.db.profile.lastItemScan;	
			end
		end
	end	
	return value,self.db.profile.lastItemScan;	
end