﻿function PoisonReminderFu:PoisonUpdate()
	if IsResting() or UnitIsDeadOrGhost("player") or InCombatLockdown() then return end
	local Main, _, _, Off = GetWeaponEnchantInfo()
	local Windfury = self.db.profile.windfury and self:IsRaidingWithShaman()
	if Main then self.HasMainHand = true end
	if Off then self.HasOffHand = true end
	if not Main and not Windfury and self.HasMainHand then
		self.HasMainHand = nil
		PoisonReminderFu:Warning("Main")
	end
	if not Off and OffhandHasWeapon() and self.HasOffHand then
		self.HasOffHand = nil
		PoisonReminderFu:Warning("Off")
	end
end 

function PoisonReminderFu:Warning(hand)
	if hand == "Main" then
		if self.db.profile.last then
			poison = self.db.profile.MainHandPoison
		else
			poison = self.db.profile.preset
		end
		self:SetupFrames(hand, poison)
		if self.db.profile.keep then self:ScheduleEvent(function() self.HasMainHand = true end, 400) end
	elseif hand == "Off" then 
		if self.db.profile.last then
			poison = self.db.profile.OffHandPoison
		else
			poison = self.db.profile.preset
		end
		self:SetupFrames(hand, poison)
		if self.db.profile.keep then self:ScheduleEvent(function() self.HasOffHand = true end, 400) end
	end
end

function PoisonReminderFu:CastPoison(timestamp, event, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, ...)
	if not sourceName == UnitName("player") then return end
	if event == "ENCHANT_APPLIED" then
		local Poison = select(1, ...)
		local Weapon =  select(3, ...)
		if Poison and Weapon then
			if string.find(GetInventoryItemLink("player", 16), Weapon) then
				self.db.profile.MainHandPoison = Poison
			elseif string.find(GetInventoryItemLink("player", 17), Weapon) then
				self.db.profile.OffHandPoison = Poison
			end
		end 
	elseif event == "ENCHANT_REMOVED" then
		local Poison = select(1, ...)
		local Weapon =  select(3, ...)	
		if string.find(GetInventoryItemLink("player", 16), Weapon) or string.find(GetInventoryItemLink("player", 17), Weapon) then		
			UIErrorsFrame:AddMessage(Poison.." fades from "..Weapon, 0.7, 1, 0.6, 1, 1.75);			
			PoisonReminderFu:PoisonUpdate()
		end
	end
end

function PoisonReminderFu:IsRaidingWithShaman()
	if UnitInRaid("player") then
		for i = 1, 4 do
			local className, class = UnitClass("party" .. i)
			if class == "SHAMAN" then return true end
		end
	end
	return false
end