﻿PoisonReminderFu.frames = {}
function PoisonReminderFu:SetupFrames(hand, item)
	if self.frames[hand] then
		local frame = self.frames[hand]
		frame.leftbutton:SetAttribute("item", item)
		frame:SetAttribute("state", 1)
		return
	end
	
	local f = GameFontNormal:GetFont()

	
	local frame = CreateFrame("Frame", nil, UIParent, "SecureStateHeaderTemplate")
	frame:SetAttribute("statemap-anchor-click", "1-0")
	
	local anchor = CreateFrame("Frame", nil, frame)
	frame.anchor = anchor
	anchor:SetAttribute("hidestates", 0)
	anchor:SetWidth(175)
	anchor:SetHeight(75)
	anchor:SetBackdrop({
		bgFile = "Interface\\DialogFrame\\UI-DialogBox-Background", tile = true, tileSize = 16,
		edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", edgeSize = 16,
		insets = {left = 4, right = 4, top = 4, bottom = 4},
		})
	anchor:SetBackdropBorderColor(.5, .5, .5)
	anchor:SetBackdropColor(0,0,0)
	anchor:ClearAllPoints()
	anchor:SetPoint("CENTER", UIParent)
	anchor:EnableMouse(true)
	anchor:RegisterForDrag("LeftButton")
	anchor:SetMovable(true)
	anchor:SetScript("OnDragStart", function() this:StartMoving() end)
	anchor:SetScript("OnDragStop", function() this:StopMovingOrSizing() self:SavePosition(hand) end)
	
	frame:SetAttribute("addchild", anchor)

	local cframe = anchor:CreateFontString(nil,"OVERLAY")
	frame.ctext = cframe
	cframe:SetFont(f, 14)
	cframe:SetWidth(150)
	cframe:SetText(hand.." Hand Poison Expired!")
	cframe:SetTextColor(1, .8, 0)
	cframe:ClearAllPoints()
	cframe:SetPoint("TOP", anchor, "TOP", 0, -10)	

	local leftbutton = CreateFrame("Button", nil, anchor, "SecureActionButtonTemplate")
	frame.leftbutton = leftbutton
	leftbutton:RegisterForClicks("AnyUp")
	leftbutton:SetAttribute("type", "item")
	leftbutton:SetAttribute("target-slot", hand == "Main" and 16 or 17)
	leftbutton:SetAttribute("item", item)
	leftbutton:SetWidth(70)
	leftbutton:SetHeight(25)
	leftbutton:SetPoint("RIGHT", anchor, "CENTER", 0, -15)
	leftbutton:SetScript("PostClick", function() self:ScheduleLeaveCombatAction(function() frame:SetAttribute("state", 0) end) end )

		
	local t = leftbutton:CreateTexture()
	leftbutton.NormalTexture = t
	t:SetWidth(70)
	t:SetHeight(32)
	t:SetPoint("CENTER", leftbutton, "CENTER")
	t:SetTexture("Interface\\Buttons\\UI-Panel-Button-Up")
	t:SetTexCoord(0, 0.625, 0, 0.6875)
	leftbutton:SetNormalTexture(t)
	
	local text = leftbutton:CreateFontString(nil,"OVERLAY")
	leftbutton.text = text
	text:SetFontObject(GameFontHighlight)
	text:SetText("Re-Apply")
	text:SetAllPoints(leftbutton)

	
	local rightbutton = CreateFrame("Button", nil, anchor, "SecureAnchorButtonTemplate")
	frame.rightbutton = rightbutton
	rightbutton:SetWidth(40)
	rightbutton:SetHeight(25)
	rightbutton:SetPoint("LEFT", anchor, "CENTER", 20, -15)
	rightbutton:RegisterForClicks("AnyDown")
	rightbutton:SetAttribute("*childraise*", true)
	rightbutton:SetAttribute("*childstate*", "^click")
	rightbutton:SetAttribute("anchorchild", frame)
	
	local t = rightbutton:CreateTexture()
	rightbutton.NormalTexture = t
	t:SetWidth(50)
	t:SetHeight(32)
	t:SetPoint("CENTER", rightbutton, "CENTER")
	t:SetTexture("Interface\\Buttons\\UI-Panel-Button-Up")
	t:SetTexCoord(0, 0.625, 0, 0.6875)
	rightbutton:SetNormalTexture(t)
	
	local text = rightbutton:CreateFontString(nil,"OVERLAY")
	rightbutton.text = text
	text:SetFontObject(GameFontHighlight)
	text:SetText("Close")
	text:SetAllPoints(rightbutton)
	
	frame:SetAttribute("state", 1)
	
	self.frames[hand] = frame

	self:RestorePosition(hand)
end

function PoisonReminderFu:SavePosition(hand)
	local f = self.frames[hand].anchor
	local s = f:GetEffectiveScale()

	self.db.profile["posx"..hand] = f:GetLeft() * s
	self.db.profile["posy"..hand] = f:GetTop() * s
end

function PoisonReminderFu:RestorePosition(hand)
	local x = self.db.profile["posx"..hand]
	local y = self.db.profile["posy"..hand]

	if not x or not y then return end

	local f = self.frames[hand].anchor
	local s = f:GetEffectiveScale()

	f:ClearAllPoints()
	f:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT", x / s, y / s)
end
