﻿PoisonReminderFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceDB-2.0", "AceEvent-2.0", "AceConsole-2.0")
local Tablet = AceLibrary("Tablet-2.0")
local Crayon = AceLibrary("Crayon-2.0")

PoisonReminderFu.hasIcon = "Interface\\Icons\\Ability_Rogue_DualWeild"
PoisonReminderFu.hideWithoutStandby = true

function PoisonReminderFu:OnInitialize()
	self:RegisterDB("PoisonReminderFuDB")
	self:RegisterDefaults('profile', {
		last = true,
		MainHandPoison = "Instant Poison",
		preset = "Instant Poison",
		keep = true,
		windfury = false
	})
	self.revision = tonumber(string.sub("$Rev: 23237 $", 7, -3))
	self.version = PoisonReminderFu.version .. " |cffff8888r"..self.revision.."|r"
	local _, englishClass = UnitClass("player")
	if englishClass ~= "ROGUE" then
		self:ToggleActive(false)
	else
		self:ToggleActive(true)
	end
	self.Menu = {
		type = "group",
		args = {
			["Set Preset"] = {
				type = "text",
				order = 3,
				name = "Set Preset",
				desc = "Set the preset to re-apply",
				get = function() return self.db.profile.preset end,
				set = function(v) self.db.profile.preset = v end,
				validate = {"Instant Poison", "Crippling Poison", "Deadly Poison", "Mind-numbing Poison", "Wound Poison", "Anesthetic Poison",
							"Consecrated Sharpening Stone", "Elemental Sharpening Stone", "Coarse Sharpening Stone",
							"Dense Sharpening Stone", "Heavy Sharpening Stone", "Rough Sharpening Stone", "Solid Sharpening Stone"},
				hidden = function() return self.db.profile.last end,
			},
			["Use Preset"] = {
				type = "toggle",
				name = "Use Preset",
				order = 2,
				desc = "Use a preset poison for re-applications",
				get = function() return not self.db.profile.last end,
				set =  function(v) self.db.profile.last = not v end,
				map = { [false] = "Disabled", [true] = "Enabled" },
			},
			["Use Last Applied"] = {
				type = "toggle",
				name = "Use Last Applied",
				order = 1,
				desc = "Use a Last Applied poison for re-applications",
				get = function() return self.db.profile.last end,
				set = function(v) self.db.profile.last = v end,
				map = { [false] = "Disabled", [true] = "Enabled" },
			},
			["Keep Asking"] = {
				type = "toggle",
				name = "Keep Asking",
				order = 4,
				desc = "Keep asking for re-apply every 5mins",
				set = function(v) self.db.profile.keep = v end,
				get = function() return self.db.profile.keep end,
				map = { [false] = "Disabled", [true] = "Enabled" },
			},
			["Enable Windfury in Raid"] = {
				type = "toggle",
				name = "Enable Windfury in Raid",
				order = 5,
				desc = "Assume Windfury totem is present when raiding with a Shaman in your group",
				set = function(v) self.db.profile.windfury = v end,
				get = function() return self.db.profile.windfury end,
				map = { [false] = "Disabled", [true] = "Enabled" },
			},
		}
	}
	self.OnMenuRequest = self.Menu
	self:RegisterChatCommand({"/PoisonReminderFu", "/pmf"}, self.Menu)
end

function PoisonReminderFu:OnEnable()
	self:ScheduleRepeatingEvent(self.Update, 1, self)
	self:ScheduleRepeatingEvent(self.PoisonUpdate, 1, self)
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED", "CastPoison")
	self.HasMainHand = true
	self.HasOffHand = true
end

function PoisonReminderFu:OnTooltipUpdate()
	local cat = Tablet:AddCategory(
		'columns', 2,
		'child_textR', 1,
		'child_textG', 1,
		'child_textB', 0
	)
	cat:AddLine(
		'text', "Main Hand",
		'text2', PoisonReminderFu:GetText(16)
	)
	cat:AddLine(
		'text', "Off Hand",
		'text2', PoisonReminderFu:GetText(17)
	)
end 

function PoisonReminderFu:GetText(wep)
	local hasMainHandEnchant, mainHandExpiration, mainHandCharges, hasOffHandEnchant, offHandExpiration, offHandCharges = GetWeaponEnchantInfo()
	if wep == 16 then
		if not hasMainHandEnchant then return "|cffff0000No Poison!|r" end 
		return PoisonReminderFu:time(mainHandExpiration/1000)
	elseif wep == 17 then
		if not hasOffHandEnchant then return "|cffff0000No Poison!|r" end 
		return PoisonReminderFu:time(offHandExpiration/1000)
	end
end	

function PoisonReminderFu:time(t)
	local m = floor(t/60)
	local s = t - (m*60)
	if m > 0 then
		timetext = string.format("|cff%s%d:%02d|r mins",Crayon:GetThresholdHexColor(m, 3, 6, 10, 20, 30) ,m, floor(s))
	else
		timetext = string.format("|cffff0000%.0f |rsecs", floor(s))
	end
return timetext 
end 

function PoisonReminderFu:OnTextUpdate()
local Main, _, _, Off = GetWeaponEnchantInfo()
if Main and Off then self:SetText("|cff00ff00Poisons are Fine|r") end
if not Main and Off then self:SetText("|cffff7f00Main Hand Expired!|r") end
if Main and not Off then self:SetText("|cffff7f00Off Hand Expired!|r") end
if not Main and not Off then self:SetText("|cffff0000Both Expired!!|r") end
end 