-- binding labels
BINDING_HEADER_PETINFOHEADER = 'PetInfoFu'
BINDING_NAME_PETINFONAME     = 'Train your pet'

local AceLocale = AceLibrary("AceLocale-2.2"):new("PetInfoFu")

AceLocale:RegisterTranslations("enUS", function() 
    return {
		["NAME"] = "PetInfoFu",
		["DESCRIPTION"] = "Displays pet info.",
		["CMD_OPTIONS"] = {"/pifu", "/petinfofu"},
        
        -- tool tips
		["TOOLTIP_TITLE"] = "|cffffffffPetInfo|r|cff00ff00Fu|r",
		["TOOLTIP_HINT_TEXT"] = "|cffeda55fClick|r to Train your pet.",
        
		["PI_TOOLTIP_HINT"] = "Pet Info.",
		["PI_TOOLTIP_HINT_HUNTER"] = "Pet Info. |cffeda55fClick|r to Train your pet.\n|cffeda55fCtrl-click|r to reset the XP timer.",                      
		
        -- format strings
		["PI_FORMAT"] = "%d",
        ["PI_FORMAT_HAPPINESS"] = " (%d)",
		["PI_PLUS_PERCENT_FORMAT"] = "%d (%.1f%%)",
		["PI_AS_FORMAT"] = "%.2f",
		["PI_DPS_FORMAT"] = "%.1f",
        ["PI_PERCENT_FORMAT"] = "%.1f%%",
        ["PI_TIME_FORMAT"] = "%02d:%02d",

        -- unknown entity
        ["UO"] = "UO",
        
        -- labels
		["PI_PETINFO"] = "Pet:",
		["PI_PETNAME"] = "Name:",
		["PI_PETLEVEL"] = "Level:",
        
        -- categories
        ["CATEGORY_PET_INFO"] = "Pet Info",
        ["CATEGORY_PET_COMBAT_INFO"] = "Pet Combat Info",
        ["CATEGORY_PET_ATTRIBUTES"] = "Pet Attributes",
        ["CATEGORY_PET_STABLED"] = "Stabled Pets",
        ["CATEGORY_PET_HISTORY"] = "History of Pets",        
        ["CATEGORY_DEMONIC_KNOWLEDGE"] = "Demonic Knowledge",
        ["CATEGORY_PET_SKILLS"] = "Pet Skills",
        ["CATEGORY_PET_NETHER"] = "Nethered Demons",
        
        -- hunter labels
		["PI_TYPE"] = "Type:",
		["PI_NOPET"] = "No pet",
		["PI_FOOD"] = "Eats:",
		["PI_LOYALTY"] = "Loyalty:",
		["PI_HAPPINESS"] = "Happiness:",
		["PI_DAMAGEPERCT"] = "Damage Percentage:",
		["PI_LOYALTYRATE"] = "Loyalty Rate:",
		["PI_TRAINING_POINTS"] = "Training Points:",
		["PI_ARMOR_CLASS"] = "Armor:",
		["PI_ATTACK_SPEED"] = "Attack Speed:",
        ["PI_ATTACK_SKILL"] = "Attack Skill:",
		["PI_ATTACK_POWER"] = "Attack Power:",
		["PI_DPS_LISTED"] = "Listed DPS:",
		["PI_CURRENT_XP"] = "Current XP:",
		["PI_NEEDED_XP"] = "Needed XP:",
		["PI_TOTAL_XP"] = "Required XP:",
		["PI_NOLEVEL"] = "Not gaining XP due to level restriction",
        ["To go: "] = true,
        
        -- warlock labels
        ["PI_NODEMON"] = "No demon",
        ["PI_NOTALENT"] = "You are not talented in ",
        ["PI_BONUSDAMAGE"] = "Bonus Damage:",

        -- attribute names
        ["SPELL_STAT0_NAME"] = "Strength:",
        ["SPELL_STAT1_NAME"] = "Agility:",
        ["SPELL_STAT2_NAME"] = "Stamina:",
        ["SPELL_STAT3_NAME"] = "Intelligence:",
        ["SPELL_STAT4_NAME"] = "Spirit:",
        
        -- happiness values
        ["Unhappy"] = true,
		["Content"] = true,
		["Happy"] = true,        
		["Gaining Loyalty"] = true,
		["Losing Loyalty"] = true,
        
        -- menus
		["Show pet's name"] = true,
		["Show pet's level"] = true,
        ["Show experience"] = true,                     -- hunter
        ["By amount"] = true,                           -- hunter
        ["By kill"] = true,                             -- hunter
        ["By percentage"] = true,                       -- hunter
        ["By time"] = true,                             -- hunter
        ["Reset timer"] = true,                         -- hunter
        ["Show on bar"] = true,                         -- hunter
        ["Play sound"] = true,                          -- hunter
        ["On TP gain"] = true,                          -- hunter
        ["On new skill available"] = true,              -- hunter
        ["On Happiness level change"] = true,           -- hunter
        ["Show pet's attributes"] = true,
        ["Show pet's combat statistics"] = true,        
        ["Show pet's skills"] = true,
        ["MapNotes"] = true,                            -- hunter
        ["Enable Stable mapnotes"] = true,              -- hunter
        ["Show stabled pets"] = true,                   -- hunter
        ["Show loyalty"] = true,                        -- hunter
        ["Track pet history"] = true,                   -- hunter
        ["Track pet happiness"] = true,                 -- hunter
        ["Show pet happiness frame"] = true,            -- hunter
        ["Show Mend Pet frame"] = true,                 -- hunter
        ["Show nethered demons"] = true,                -- warlock        
                
        -- other
        ["Please visit a stable to initialise."] = true,
        [" can learn a new skill."] = true,
        [" has gained Training Points."] = true,
        ["Stable"] = true,
        ["NA"] = true,
        ["1D+"] = true,
        -- happiness tracking
        ["Happiness"] = true,
        
        -- warlock pets
        ["Imp"] = true,
        ["Felguard"] = true,
        ["Felhunter"] = true,
        ["Succubus"] = true,
        ["Voidwalker"] = true,
        ["Infernal"] = true,
     }

end)
