PetInfoFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0",
                                           "AceConsole-2.0",
                                           "AceDB-2.0",
                                           "AceEvent-2.0"
                                          )

 -- variables
local L          = AceLibrary("AceLocale-2.2"):new("PetInfoFu")
local BS         = AceLibrary("Babble-Spell-2.2")
local BST        = AceLibrary("Babble-SpellTree-2.2")
local crayon     = AceLibrary("Crayon-2.0")
local dewdrop    = AceLibrary("Dewdrop-2.0")
local tablet     = AceLibrary("Tablet-2.0")

-- hunter specific variables
local prevHappiness = 0                 -- tracks happiness level (0-3)
-- happiness tracking
-- local DECAY_RATE = 22/16                -- up to 2.4.2 11/16 -- previously 5/8
local DECAY_RATE = 11/16                -- up to 2.4.2 11/16 -- previously 5/8
local estimatedPetHappiness = 350       -- set to zero
local isFeedingPet = false
-- level timers
local timerZero = 0
local petXPZero = 0
local prevXPToLevel = 0
local lastKillXP = 0
local prevTP = 0
local prevPetLevel = 0

-- warlock specific variables
local demonicKnowledgeRank = 0
local demonicKnowledgeTalentTab = 0
local demonicKnowledgeTalentIndex = 0

-- properties
PetInfoFu.clickableTooltip = true
PetInfoFu.canHideText      = true
PetInfoFu.defaultPosition  = "RIGHT"
PetInfoFu.hasIcon          = true
PetInfoFu.hasNoColor       = false

-- register database stuff
PetInfoFu:RegisterDB("PetInfoFuDB")
PetInfoFu:RegisterDefaults("account", {
                                        stables = {},
                                      }
                          )
                          
PetInfoFu:RegisterDefaults("char", {
                                    -- flags
                                    showPetName = true,
                                    showPetLevel = true,
                                    showPetXP = 0,
                                    showPetXPOnBar = false,
                                    showAttributes = true,
                                    showCombatStats = true,
                                    showSkills = true,
                                    showStableMapNotes = false,
                                    showStabledPets = false,
                                    showLoyalty = false,
                                    trackPetHistory = false,
                                    trackPetHappiness = false,
                                    trackPetSkills = true,
                                    showMendPetFrame = false,
                                    showHappinessFrame = false,
                                    xpFrameIsShowing = false,
                                    -- sound play
                                    playSoundOnGainTP = false,
                                    playSoundOnSkillTrainable = false,
                                    playSoundHappinessLevelChange = false,
                                    hasPlayedSoundOnGainTP = false,
                                    hasPlayedSoundOnSkillTrainable =false,
                                    -- frame locations
                                    petInfoFramePoint = { point = "CENTER", x = 0, y = 0},
                                    petExperienceFramePoint = { point = "CENTER", x = 0, y = 0},
                                    petMendFramePoint = { point = "CENTER", x = 0, y = 0},
                                    petHappinessFramePoint = { point = "CENTER", x = 0, y = 0},
                                    -- lists
                                    hidden = {},
                                    stabledPets = {},       -- stores currently stabled pets
                                    petHistory = {},        -- stores list of all pets ever stabled
                                    beastTraining = {},     -- stores hunter known training spells
                                    petInfo = {},           -- stores pet skills and similar info
                                    netheredDemons = {},    -- stores info about all demons
                                   } 
                         )
                         
PetInfoFu:RegisterChatCommand(L["CMD_OPTIONS"])

-- menu methods

function PetInfoFu:IsShowingPetName()
	return self.db.char.showPetName
end

function PetInfoFu:ToggleIsShowingPetName()
	self.db.char.showPetName = not self.db.char.showPetName
    if not (self.db.char.showPetName or self.db.char.showPetLevel) then self:ShowIcon() end
	self:UpdateText()
	return self.db.char.showPetName
end

function PetInfoFu:IsShowingPetLevel()
	return self.db.char.showPetLevel
end

function PetInfoFu:ToggleIsShowingPetLevel()
	self.db.char.showPetLevel = not self.db.char.showPetLevel
    if not (self.db.char.showPetName or self.db.char.showPetLevel) then self:ShowIcon() end
	self:UpdateText()
	return self.db.char.showPetLevel
end

function PetInfoFu:IsShowingXPByAmount()
	return self.db.char.showPetXP == 1
end

function PetInfoFu:ToggleIsShowingXPByAmount()
	if self.db.char.showPetXP == 1 then 
        self.db.char.showPetXP = 0
    else
        self.db.char.showPetXP = 1
    end
	self:UpdateText()
	return self.db.char.showPetXP == 1
end

function PetInfoFu:IsShowingXPByPercentage()
	return self.db.char.showPetXP == 2
end

function PetInfoFu:ToggleIsShowingXPByPercentage()
	if self.db.char.showPetXP == 2 then 
        self.db.char.showPetXP = 0
    else
        self.db.char.showPetXP = 2
    end
	self:UpdateText()
	return self.db.char.showPetXP == 2
end

function PetInfoFu:IsShowingXPByTime()
	return self.db.char.showPetXP == 3
end

function PetInfoFu:ToggleIsShowingXPByTime()
	if self.db.char.showPetXP == 3 then 
        self.db.char.showPetXP = 0
    else
        self.db.char.showPetXP = 3
        self:ResetXPTimer()
    end
	self:UpdateText()
	return self.db.char.showPetXP == 3
end

function PetInfoFu:IsShowingXPByKill()
	return self.db.char.showPetXP == 4
end

function PetInfoFu:ToggleIsShowingXPByKill()
	if self.db.char.showPetXP == 4 then 
        self.db.char.showPetXP = 0
    else
        self.db.char.showPetXP = 4
    end
	self:UpdateText()
	return self.db.char.showPetXP == 4
end

function PetInfoFu:IsShowingXPOnBar()
	return self.db.char.showPetXPOnBar
end

function PetInfoFu:ToggleIsShowingXPOnBar()
	self.db.char.showPetXPOnBar = not self.db.char.showPetXPOnBar 
	self:UpdateText()
	return self.db.char.showPetXPOnBar
end
function PetInfoFu:IsShowingAttributes()
	return self.db.char.showAttributes
end

function PetInfoFu:ToggleIsShowingAttributes()
	self.db.char.showAttributes = not self.db.char.showAttributes
	self:UpdateTooltip()
	return self.db.char.showAttributes
end

function PetInfoFu:IsShowingCombatStats()
	return self.db.char.showCombatStats
end

function PetInfoFu:ToggleIsShowingCombatStats()
	self.db.char.showCombatStats = not self.db.char.showCombatStats
	self:UpdateTooltip()
	return self.db.char.showCombatStats
end

function PetInfoFu:IsShowingSkills()
	return self.db.char.showSkills
end

function PetInfoFu:ToggleIsShowingSkills()
	self.db.char.showSkills = not self.db.char.showSkills
	self:UpdateTooltip()
	return self.db.char.showSkills
end

function PetInfoFu:IsShowingMendPetFrame()
	return self.db.char.showMendPetFrame
end

function PetInfoFu:ToggleIsShowingMendPetFrame()
	self.db.char.showMendPetFrame = not self.db.char.showMendPetFrame
        if not self.db.char.showMendPetFrame and self.petMendFrame then
            self.petMendFrame:Hide()
        end 
	return self.db.char.showMendPetFrame
end

function PetInfoFu:IsShowingHappinessFrame()
	return self.db.char.showHappinessFrame
end

function PetInfoFu:ToggleIsShowingHappinessFrame()
	self.db.char.showHappinessFrame = not self.db.char.showHappinessFrame
        if self.db.char.showHappinessFrame then
            self:PetHappinessFrame()
        else 
            if self.petHappinessFrame then self.petHappinessFrame:Hide() end
        end
	return self.db.char.showHappinessFrame
end

function PetInfoFu:IsShowingStableMapNotes()
	return self.db.char.showStableMapNotes
end

function PetInfoFu:ToggleIsShowingStableMapNotes()
	self.db.char.showStableMapNotes = not self.db.char.showStableMapNotes
	self:UpdateTooltip()
	return self.db.char.showStableMapNotes
end

function PetInfoFu:IsShowingStabledPets()
	return self.db.char.showStabledPets
end

function PetInfoFu:ToggleIsShowingStabledPets()
	self.db.char.showStabledPets = not self.db.char.showStabledPets
	self:UpdateTooltip()
	return self.db.char.showStabledPets
end

function PetInfoFu:IsShowingLoyalty()
	return self.db.char.showLoyalty
end

function PetInfoFu:ToggleIsShowingLoyalty()
	self.db.char.showLoyalty = not self.db.char.showLoyalty
	self:UpdateTooltip()
	return self.db.char.showLoyalty
end

function PetInfoFu:IsTrackingPetHistory()
	return self.db.char.trackPetHistory
end

function PetInfoFu:ToggleIsTrackingPetHistory()
	self.db.char.trackPetHistory = not self.db.char.trackPetHistory
	self:UpdateText()
	return self.db.char.trackPetHistory
end

function PetInfoFu:IsTrackingPetHappiness()
	return self.db.char.trackPetHappiness
end

function PetInfoFu:ToggleIsTrackingPetHappiness()
	self.db.char.trackPetHappiness = not self.db.char.trackPetHappiness
	self:UpdateText()
	return self.db.char.trackPetHappiness
end

function PetInfoFu:ResetXPTimer()
	timerZero = time()
    _, _, petXPZero = self:PetInfo_GetPetExperience()
end

-- sound toggles

function PetInfoFu:IsPlayingSoundOnGainTP()
	return self.db.char.playSoundOnGainTP
end

function PetInfoFu:TogglePlaySoundOnGainTP()
	self.db.char.playSoundOnGainTP = not self.db.char.playSoundOnGainTP
	return self.db.char.playSoundOnGainTP
end

function PetInfoFu:IsPlayingSoundOnSkillTrainable()
	return self.db.char.playSoundOnSkillTrainable
end

function PetInfoFu:TogglePlaySoundOnSkillTrainable()
	self.db.char.playSoundOnSkillTrainable = not self.db.char.playSoundOnSkillTrainable
	return self.db.char.playSoundOnSkillTrainable
end
       
function PetInfoFu:IsPlayingSoundHappinessLevelChange()
	return self.db.char.playSoundHappinessLevelChange
end

function PetInfoFu:TogglePlaySoundOnHappinessLevelChange()
	self.db.char.playSoundHappinessLevelChange = not self.db.char.playSoundHappinessLevelChange
	return self.db.char.playSoundHappinessLevelChange
end    
   
-- init/exit functions

function PetInfoFu:OnInitialize()
  --nothing here
end

function PetInfoFu:OnEnable()
    -- update
    self:RegisterEvent("PLAYER_ENTERING_WORLD","Update")
	self:RegisterEvent("PLAYER_LEVEL_UP","Update")
    ---- seems not to catch a change in demon, possibly obsolete
    ---- self:RegisterEvent("PLAYER_PET_CHANGED","Update")
    -- UNIT_PET: arg1 = who, if arg1=='player' then it's our pet
    self:RegisterEvent("UNIT_PET")
    
    -- local event handlers
    if self:IsHunter() then
        self:RegisterEvent("CRAFT_CLOSE")
        self:RegisterEvent("PET_STABLE_CLOSED")
        self:RegisterEvent("PET_STABLE_SHOW")
    	self:RegisterEvent("UNIT_HAPPINESS")
	    self:RegisterEvent("UNIT_PET_EXPERIENCE")
    	self:RegisterEvent("UNIT_PET_TRAINING_POINTS")
        -- combat log tracking
        self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
        --      
        self:ScheduleRepeatingEvent(self.name, self.UpdateText, 60, self)         
    end
    
    if self:IsWarlock() then
        self:GetDemonicKnowledgeRank()
        self:RegisterEvent("CHARACTER_POINTS_CHANGED")
    end
    
    self:SetIcon(select(3, GetSpellInfo(2641)))  -- Dismiss Pet icon
    
    -- mapnotes
 	if Cartographer_Notes then
    	Cartographer_Notes:RegisterIcon("Stable", {text = L["Stable"], 
                                                   path = "Interface\\AddOns\\FuBar_PetInfoFu\\icons\\stable.tga"
                                                }
                                        )
        Cartographer_Notes:RegisterNotesDatabase('PetInfoFu', self.db.account.stables, self)
    end
    
    -- set timers and other global variables
    self:ResetXPTimer()
    self:CheckForNextLevelSkill()
    if self.db.char.xpFrameIsShowing then self:PetExperienceFrame() end
    if self.db.char.showHappinessFrame then self:PetHappinessFrame() end 
end

function PetInfoFu:OnDisable()
    if Cartographer_Notes then
		Cartographer_Notes:UnregisterIcon("Stable")  
        Cartographer_Notes:UnregisterNotesDatabase('PetInfoFu')
    end
    self:UnregisterAllEvents()
end

-- events (sorted alphabetically)
function PetInfoFu:CHARACTER_POINTS_CHANGED()
    self:GetDemonicKnowledgeRank()
end

function PetInfoFu:COMBAT_LOG_EVENT_UNFILTERED(_, eventType, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags, spellId, spellName, spellSchool, amount, powerType, ...)
    -- pet as destination
    if (dstName ~= nil) and 
       (dstName == UnitName("pet")) then
        if eventType == "SPELL_AURA_APPLIED" then
            -- self:Print('CLE AURA APPLIED '..crayon:Orange(spellName)..' '..crayon:Orange(auraType))
            if self.db.char.showMendPetFrame then
                if spellName == GetSpellInfo(19572) or      -- Improved Mend Pet
                   spellName == GetSpellInfo(136) then      -- Mend Pet
                   self:PetMendFrame()
                end
            end        
            -- if spellName == GetSpellInfo(75) then        -- Feed Pet Effect; feeding pet, start tracking
            --     isFeedingPet = true
            -- end           
        elseif eventType == "SPELL_AURA_REMOVED" then
            -- self:Print('CLE AURA REMOVED '..crayon:Orange(spellName)..' '..crayon:Orange(auraType)) 
            if spellName == GetSpellInfo(19572) or      -- Improved Mend Pet
               spellName == GetSpellInfo(136) then      -- Mend Pet
                if self.petMendFrame ~= nil then 
                    self.petMendFrame:Hide()
                end
            end
            -- if spellName == GetSpellInfo(75) then        -- Feed Pet Effect
            --    isFeedingPet = false
            -- end           
        elseif eventType == "SPELL_CAST_SUCCESS" then
            if spellName == GetSpellInfo(24443) or          -- Improved Revive Pet; pet has died and is ressed
               spellName == GetSpellInfo(982) then          -- Revive Pet
                self:CalculateEstimatedHappiness(-350)
            end
        elseif eventType == "SPELL_PERIODIC_ENERGIZE" then
            -- powerType 4 is pet happiness
            if powerType == 4 then 
                -- self:Print('CLE '..crayon:Orange(eventType)..' '..crayon:Orange(auraType)..' '..crayon:Orange(spellName)..' '..crayon:Orange(spellID))
                -- amount will contain the numer of happiness gained
                self:CalculateEstimatedHappiness(amount)
                self:UpdateText()
            end            
        else
            -- self:Print('CLE '..crayon:Orange(eventType)) 
        end
    end
    
    -- pet as source
    if (srcName ~= nil) and 
       (srcName == UnitName("pet")) then
        -- seems not to be recognised...
        if eventType == "UNIT_DIED" then
            self:Print('CLE DIED '..crayon:Orange(eventType)..' pet died')
            self:CalculateEstimatedHappiness(-350)       
        end
    end
    
    -- player as destination
    if (dstName ~= nil) and 
       (dstName == UnitName("player")) then
        if eventType == "SPELL_AURA_APPLIED" then
            -- strangely dismiss pet is applying an aura to the player
            if spellName == GetSpellInfo(2641) then         -- Dismiss Pet; substract 50
                self:CalculateEstimatedHappiness(-50)
            end
        end
    end    
    -- self:Print('CLE '..crayon:Orange(srcName)..' '..crayon:Orange(dstName)..' '..crayon:Orange(eventType)..' '..crayon:Orange(spellName))  
end

function PetInfoFu:CRAFT_CLOSE()
    -- make sure we don't get enchanting items in here
    if GetCraftSkillLine(1) == BS["Beast Training"] then
    -- write pet skills known by hunter to database
        for i = 1, GetNumCrafts() do
            local craftName, craftSubSpellName, _, _, _, _, requiredLevel = GetCraftInfo(i)
            if craftName ~= nil then
                if self.db.char.beastTraining[craftName] == nil then
                    self.db.char.beastTraining[craftName] = {}                        
                end
                if self.db.char.beastTraining[craftName][craftSubSpellName] == nil then 
                    self.db.char.beastTraining[craftName][craftSubSpellName] = {
                        RequiredLevel = requiredLevel
                    }
                end
            end
        end
    end    
end    

function PetInfoFu:PET_STABLE_CLOSED()
    self:GetStabledPets()
    if self.db.char.trackPetHistory then
        self:TrackPetHistory()
    end
    if Cartographer_Notes and 
       self.db.char.showStableMapNotes then
        self:AddStableMapNote()
    end
end

function PetInfoFu:PET_STABLE_SHOW()
    if self.db.char.trackPetSkills then self:StoreCurrentPet() end
end

function PetInfoFu:UNIT_HAPPINESS()
    -- update happiness state (unhappy, content, happy)
    local happinessLevel = GetPetHappiness()
    if happinessLevel ~= nil then        
        if happinessLevel ~= prevHappiness then        
            if prevHappiness ~= 0 then                
                if happinessLevel < prevHappiness then
                    -- make noise if pet loses happiness level
                    if self.db.char.playSoundHappinessLevelChange then
                        PlaySound('HumanExploration') -- ('AuctionWindowOpen')
                        -- for twidget so s/he can play his/her preferred sound file
                        -- PlaySoundFile('Interface\\AddOns\\FuBar_PetInfoFu\\xxx.wav')                        
                    end
                end
            else 
                -- initiate numerical happiness to mid level
                estimatedPetHappiness = 350 + (happinessLevel *350) - 175
            end 
            -- set tracking variable and update everything                
            prevHappiness = happinessLevel            
            self:Update()
        end
        
        -- update the numerical happiness value
        if not isFeedingPet then
            self:CalculateEstimatedHappiness(-DECAY_RATE)
            self:UpdateText()
        end
    end
end    
        
-- add code to reset pet specific globals in here
function PetInfoFu:UNIT_PET()
    if arg1 == 'player' then 
        self:Update()
    end
end

function PetInfoFu:UNIT_PET_EXPERIENCE()
    if self.db.char.showPetXP == 4 then
        local _, _, toLevelXP = self:PetInfo_GetPetExperience()                    
        if prevXPToLevel == 0 then prevXPToLevel = toLevelXP end
        lastKillXP = prevXPToLevel - toLevelXP
        if lastKillXP < 0 then lastKillXP = toLevelXP end
        prevXPToLevel = toLevelXP      
    end
    self:Update()
    self:UpdatePetExperienceFrame()
end

-- add functionality for training points warning in here
function PetInfoFu:UNIT_PET_TRAINING_POINTS()
    if self:IsHunter() then
        self:CheckForTPGain()
        self:CheckForNextLevelSkill() 
        self:Update()
    end
end

-- frame functions
function PetInfoFu:UpdatePetHappinessFrame()
	if self.petHappinessFrame then
        local text = L["NA"]
        local happiness = GetPetHappiness()
        if happiness ~= nil then
            -- estimatedPetHappiness 350 - 1400, 
            -- unhappy     [ 351 -  700] - 1*350 = [1 - 350]
            -- content     [ 701 - 1050] - 2*350 = [1 - 350]
            -- happy       [1051 - 1400] - 3*350 = [1 - 350]
            text = format('%d',estimatedPetHappiness - (happiness * 350)) 
            if happiness == 1 then
                text = crayon:Red(text)     -- unhappy
            elseif happiness == 2 then
                text = crayon:Yellow(text)  -- content              
            elseif happiness == 3 then
                text = crayon:Green(text)   -- happy
            end
        end
        self.petHappinessFrame.petText:SetText(text)            
    end
end

function PetInfoFu:PetHappinessFrame()
    -- hide other frames, destroy if same frame is called again
	if self.petHappinessFrame then 
        self.db.char.showHappinessFrame = false
		self.petHappinessFrame:Hide()
		if self.petHappinessFrame.name ==UnitName("pet") then
			self.petHappinessFrame = nil
			return
		end
	end	
       
    -- create frame
	local frame = CreateFrame("Frame", "PetInfoFuExperienceFrame", UIParent)
	frame:SetPoint(self.db.char.petHappinessFramePoint.point, self.db.char.petHappinessFramePoint.x, self.db.char.petHappinessFramePoint.y)
	frame:SetFrameStrata("TOOLTIP")
	frame:SetFrameLevel(99)
	frame:EnableMouse(true)
	frame:SetMovable(true)
	frame:SetClampedToScreen(true)
	frame:RegisterForDrag("LeftButton")
	frame:SetScript("OnDragStart", function()
		this:StartMoving()
	end)
	frame:SetScript("OnDragStop", function()
		this:StopMovingOrSizing()
		local point,relativeTo,relativePoint,xOfs,yOfs = this:GetPoint()
		self.db.char.petHappinessFramePoint.point = point
		self.db.char.petHappinessFramePoint.x = xOfs
		self.db.char.petHappinessFramePoint.y = yOfs
	end)

	frame:SetBackdrop({
		bgFile = "Interface\\ChatFrame\\ChatFrameBackground", tile = true, tileSize = 16,
		edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", edgeSize = 16,
		insets = {left = 4, right = 4, top = 4, bottom = 4},
	})
	frame:SetBackdropBorderColor(.5, .5, .5, 1)
	frame:SetBackdropColor(0, 0, 0, .3)

	-- create pet icon
    local petIcon = frame:CreateTexture(nil, "ARTWORK")
    frame.petIcon = petIcon
    petIcon:SetTexture(GetPetIcon())
    petIcon:SetWidth(26)
    petIcon:SetHeight(26)
    petIcon:SetPoint("TOPRIGHT", frame, "TOPLEFT", 1, -3)

	-- create close button
	local closeButton = CreateFrame("Button", "PetInfoFuExpCloseButton", frame)
	closeButton:SetPoint("TOPRIGHT", frame, "TOPRIGHT", 0, 0)
	closeButton:SetWidth(30)
	closeButton:SetHeight(30)
	closeButton:SetNormalTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Up")
	closeButton:SetPushedTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Down")
	closeButton:SetHighlightTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Highlight")
	closeButton:SetScript("OnClick", function()
        self.db.char.showHappinessFrame = false
		frame:Hide()
	end)

    -- set actual tooltip text
    local text = L["NA"]
	local petText = frame:CreateFontString(nil, "ARTWORK", "GameFontNormal")
	frame.petText = petText
	petText:SetText(text)
	petText:SetPoint("TOPLEFT", frame, "TOPLEFT", 10, -10)
	petText:SetWidth(60)
	petText:SetJustifyH("CENTER")
	petText:SetJustifyV("MIDDLE")

    self:UpdatePetHappinessFrame()

    -- activate frame
	frame.name = UnitName("pet")
	self.petHappinessFrame = frame
	frame:SetWidth(petText:GetWidth() + 20)
	frame:SetHeight(petText:GetHeight() + 20)
    self.db.char.showHappinessFrame = true    
	frame:Show()    
end

function PetInfoFu:UpdatePetExperienceFrame()
	if self.petExperienceFrame then
        local text = ''
        -- show XP
        local petLevel = UnitLevel("pet")
        local toonLevel = UnitLevel("player")        
        if petLevel ~= toonLevel then       
            if self.db.char.showPetXP == 1 then                                             -- show by amount
                local _, _, toLevelXP = self:PetInfo_GetPetExperience()                    
                text = L["To go: "]..format(L["PI_FORMAT"], toLevelXP)
            elseif self.db.char.showPetXP == 2 then                                         -- show by percent 
                local _, totalXP, toLevelXP = self:PetInfo_GetPetExperience()
                local toLevelXPPercent = toLevelXP / totalXP * 100                   
                text = L["To go: "]..format(L["PI_PERCENT_FORMAT"],toLevelXPPercent)
            elseif self.db.char.showPetXP == 3 then                                         -- show by time
                local _, _, toLevelXP = self:PetInfo_GetPetExperience()                    
                text = L["To go: "]..self:GetTimeToLevel(toLevelXP)
            elseif self.db.char.showPetXP == 4 then                                         -- show by kill
                if lastKillXP > 0 then 
                    local _, _, toLevelXP = self:PetInfo_GetPetExperience()
                    text = L["To go: "]..self:GetKillsToLevel(toLevelXP)
                end
            end
        end
        self.petExperienceFrame.petText:SetText(text)            
    end
end

function PetInfoFu:PetExperienceFrame()
    -- hide other frames, destroy if same frame is called again
	if self.petExperienceFrame then 
        self.db.char.xpFrameIsShowing = false
		self.petExperienceFrame:Hide()
		if self.petExperienceFrame.name ==UnitName("pet") then
			self.petExperienceFrame = nil
			return
		end
	end	
    
    local text = 'Pet Experience'
    
    -- create frame
	local frame = CreateFrame("Frame", "PetInfoFuExperienceFrame", UIParent)
	frame:SetPoint(self.db.char.petExperienceFramePoint.point, self.db.char.petExperienceFramePoint.x, self.db.char.petExperienceFramePoint.y)
	frame:SetFrameStrata("TOOLTIP")
	frame:SetFrameLevel(99)
	frame:EnableMouse(true)
	frame:SetMovable(true)
	frame:SetClampedToScreen(true)
	frame:RegisterForDrag("LeftButton")
	frame:SetScript("OnDragStart", function()
		this:StartMoving()
	end)
	frame:SetScript("OnDragStop", function()
		this:StopMovingOrSizing()
		local point,relativeTo,relativePoint,xOfs,yOfs = this:GetPoint()
		self.db.char.petExperienceFramePoint.point = point
		self.db.char.petExperienceFramePoint.x = xOfs
		self.db.char.petExperienceFramePoint.y = yOfs
	end)

	frame:SetBackdrop({
		bgFile = "Interface\\ChatFrame\\ChatFrameBackground", tile = true, tileSize = 16,
		edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", edgeSize = 16,
		insets = {left = 4, right = 4, top = 4, bottom = 4},
	})
	frame:SetBackdropBorderColor(.5, .5, .5, 1)
	frame:SetBackdropColor(0, 0, 0, .3)
    
	-- create pet icon
    local petIcon = frame:CreateTexture(nil, "ARTWORK")
    frame.petIcon = petIcon
    petIcon:SetTexture(GetPetIcon())
    petIcon:SetWidth(26)
    petIcon:SetHeight(26)
    petIcon:SetPoint("TOPRIGHT", frame, "TOPLEFT", 1, -3)

	-- create close button
	local closeButton = CreateFrame("Button", "PetInfoFuExpCloseButton", frame)
	closeButton:SetPoint("TOPRIGHT", frame, "TOPRIGHT", 0, 0)
	closeButton:SetWidth(30)
	closeButton:SetHeight(30)
	closeButton:SetNormalTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Up")
	closeButton:SetPushedTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Down")
	closeButton:SetHighlightTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Highlight")
	closeButton:SetScript("OnClick", function()
        self.db.char.xpFrameIsShowing = false
		frame:Hide()
	end)

    -- set actual tooltip text
	local petText = frame:CreateFontString(nil, "ARTWORK", "GameFontNormal")
	frame.petText = petText
	petText:SetText(text)
	petText:SetPoint("TOPLEFT", frame, "TOPLEFT", 10, -10)
	petText:SetWidth(140)
	petText:SetJustifyH("LEFT")
	petText:SetJustifyV("TOP")

    -- update text
    self:UpdatePetExperienceFrame()
    
    -- activate frame
	frame.name = UnitName("pet")
	self.petExperienceFrame = frame
	frame:SetWidth(petText:GetWidth() + 20)
	frame:SetHeight(petText:GetHeight() + 20)
    self.db.char.xpFrameIsShowing = true    
	frame:Show()    
end

function PetInfoFu:PetMendFrame()
 	if self.petMendFrame ~= nil then 
        self.petMendFrame:Show()
        return
	end	
    
    -- create frame
	local frame = CreateFrame("Frame", "PetInfoFuMendFrame", UIParent)
	frame:SetPoint(self.db.char.petMendFramePoint.point, self.db.char.petMendFramePoint.x, self.db.char.petMendFramePoint.y)
	frame:SetFrameStrata("TOOLTIP")
	frame:SetFrameLevel(99)
	frame:EnableMouse(true)
	frame:SetMovable(true)
	frame:SetClampedToScreen(true)
	frame:RegisterForDrag("LeftButton")
	frame:SetScript("OnDragStart", function()
		this:StartMoving()
	end)
    
	frame:SetScript("OnDragStop", function()
		this:StopMovingOrSizing()
		local point,relativeTo,relativePoint,xOfs,yOfs = this:GetPoint()
		self.db.char.petMendFramePoint.point = point
		self.db.char.petMendFramePoint.x = xOfs
		self.db.char.petMendFramePoint.y = yOfs
	end)

	frame:SetBackdrop({
		bgFile = "Interface\\ChatFrame\\ChatFrameBackground", tile = true, tileSize = 16,
		edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", edgeSize = 16,
		insets = {left = 4, right = 4, top = 4, bottom = 4},
	})
	frame:SetBackdropBorderColor(.5, .5, .5, 1)
	frame:SetBackdropColor(0, 0, 0, .3)
    
	-- create heal icon
    local spellIcon = frame:CreateTexture(nil, "ARTWORK")
    frame.spellIcon = spellIcon
    spellIcon:SetTexture(BS:GetSpellIcon("Mend Pet"))
    spellIcon:SetWidth(26)
    spellIcon:SetHeight(26)
    spellIcon:SetPoint("TOPLEFT", frame, "TOPLEFT", 7, -7)
   
    -- activate frame
	frame.name = UnitName("pet")
	self.petMendFrame = frame
	frame:SetWidth(40)
	frame:SetHeight(40)
    frame:Show()    
end

function PetInfoFu:PetInfoFrame(petInfo)
    -- with kind thanks to TrainerFu for the basic routine
    
    -- hide other frames, destroy if same frame is called again
	if self.petInfoFrame then 
		self.petInfoFrame:Hide()
		if self.petInfoFrame.name == petInfo.PetName then
			self.petInfoFrame = nil
			return
		end
	end	
   
    local text = crayon:Green(petInfo.PetName..' ('..petInfo.PetLevel..')\n')..petInfo.PetType
    if petInfo.PetLoyalty ~= nil then text = text..' - '..petInfo.PetLoyalty end   
	
    local petSaveKey = petInfo.PetType.."|"..petInfo.PetName
    -- if available add list of pet skills
    if self.db.char.petInfo[petSaveKey] ~= nil then
        if self.db.char.petInfo[petSaveKey]['petSkills'] ~= nil then
            text = text..'\n'
            -- create a sorted table of pet skills
            sortedPetSkills = {}
            for k,v in pairs(self.db.char.petInfo[petSaveKey]['petSkills']) do
                -- self:Print('PetInfoFu: Adding'..crayon:Red(k)..' '..v.SpellRank)
                if v.SpellRank == '' then
                    table.insert(sortedPetSkills, k)                
                else
                    table.insert(sortedPetSkills, k..' - '..v.SpellRank)
                end
            end
            table.sort(sortedPetSkills, function (a, b) return a < b end)
            -- list sorted pet skills
            for i = 1, #sortedPetSkills do  
                text = text..'\n'..sortedPetSkills[i]
            end
         end
    end
	
    -- create frame
	local frame = CreateFrame("Frame", "PetInfoFuPetFrame", UIParent)
	frame:SetPoint(self.db.char.petInfoFramePoint.point, self.db.char.petInfoFramePoint.x, self.db.char.petInfoFramePoint.y)
	frame:SetFrameStrata("TOOLTIP")
	frame:SetFrameLevel(99)
	frame:EnableMouse(true)
	frame:SetMovable(true)
	frame:SetClampedToScreen(true)
	frame:RegisterForDrag("LeftButton")
	frame:SetScript("OnDragStart", function()
		this:StartMoving()
	end)
	frame:SetScript("OnDragStop", function()
		this:StopMovingOrSizing()
		local point,relativeTo,relativePoint,xOfs,yOfs = this:GetPoint()
		self.db.char.petInfoFramePoint.point = point
		self.db.char.petInfoFramePoint.x = xOfs
		self.db.char.petInfoFramePoint.y = yOfs
	end)

	frame:SetBackdrop({
		bgFile = "Interface\\ChatFrame\\ChatFrameBackground", tile = true, tileSize = 16,
		edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", edgeSize = 16,
		insets = {left = 4, right = 4, top = 4, bottom = 4},
	})
	frame:SetBackdropBorderColor(.5, .5, .5, 1)
	frame:SetBackdropColor(0, 0, 0, .3)
    
	-- create pet icon
    if self.db.char.petInfo[petSaveKey].PetIcon ~= nil then        
        local petIcon = frame:CreateTexture(nil, "ARTWORK")
        frame.petIcon = petIcon
        petIcon:SetTexture(self.db.char.petInfo[petSaveKey].PetIcon)
        petIcon:SetWidth(40)
        petIcon:SetHeight(40)
        petIcon:SetPoint("TOPRIGHT", frame, "TOPLEFT", 1, -3)
    end
	
	-- create close button
	local closeButton = CreateFrame("Button", "PetInfoFuCloseButton", frame)
	closeButton:SetPoint("TOPRIGHT", frame, "TOPRIGHT", 0, 0)
	closeButton:SetWidth(30)
	closeButton:SetHeight(30)
	closeButton:SetNormalTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Up")
	closeButton:SetPushedTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Down")
	closeButton:SetHighlightTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Highlight")
	closeButton:SetScript("OnClick", function()
		frame:Hide()
	end)

    -- set actual tooltip text
	local petText = frame:CreateFontString(nil, "ARTWORK", "GameFontNormal")
	frame.petText = petText
	petText:SetText(text)
	petText:SetPoint("TOPLEFT", frame, "TOPLEFT", 10, -10)
	petText:SetWidth(280)
	petText:SetJustifyH("LEFT")
	petText:SetJustifyV("TOP")

    -- activate frame
	frame.name = petInfo.petName
	self.petInfoFrame = frame
	frame:SetWidth(petText:GetWidth() + 20)
	frame:SetHeight(petText:GetHeight() + 20)
	frame:Show()    
end

-- functions 

function PetInfoFu:StoreCurrentPet()
    local petName = UnitName("pet")
    
    if petName ~= nil and 
        petName ~= UNKNOWNOBJECT then        
        -- self:Print('PetInfoFu: Storing '..crayon:Red(petName))    
        local petType = UnitCreatureFamily("pet")
        local petSaveKey = petType.."|"..petName    
        -- init list item if not exists
        if self.db.char.petInfo[petSaveKey] == nil then
            self.db.char.petInfo[petSaveKey] = {}        
        end
        self.db.char.petInfo[petSaveKey] = {
            PetName = petName,
            PetType = petType,
            PetLevel = UnitLevel("pet"),
            PetHappiness = GetPetHappiness(),
            PetIcon = GetPetIcon()
        }
        -- list pet skills, reset curent list
        self.db.char.petInfo[petSaveKey]['petSkills'] = {}
        local i = 1
        while true do
            local spellName, spellRank = GetSpellName(i, BOOKTYPE_PET)
            if not spellName then
                do break end
            end
            self.db.char.petInfo[petSaveKey]['petSkills'][spellName]  = {
                SpellRank = spellRank
            }
            i = i + 1
        end
    end
end

function PetInfoFu:CalculateEstimatedHappiness(delta)
    -- redo with happiness as a single range: 350 - 1400
    if delta == nil then delta = 0 end          -- catch nil
    if delta == 0 or delta == 1 then            -- pet is filled up (2.4.2 returns 1 as lowest number of effect)
        estimatedPetHappiness = 1400
    else
        local happinessLevel = GetPetHappiness()
        if happinessLevel == nil then happinessLevel = max(1,prevHappiness - 1) end
        -- happiness should be more than the minimum (L*350) and less than the maximum ((L+1)*350) at each level L
        estimatedPetHappiness = min(max(estimatedPetHappiness + delta,happinessLevel * 350),(happinessLevel +1) * 350)
    end
end

function PetInfoFu:GetStabledPets()
    self.db.char.stabledPets = nil
    self.db.char.stabledPets = {}
    
    for i = 1, GetNumStableSlots() do  -- i = 0 for current pet
        local _, petName, petLevel, petType, petLoyalty = GetStablePetInfo(i);
        if petName ~= nil then
            -- self:Print('PetInfoFu: Stabling '..crayon:Red(petName)..' '..format(i))         
            self.db.char.stabledPets[i] = {
                PetName = petName,
                PetType = petType,
                PetLoyalty = petLoyalty,
                PetLevel = petLevel
            }
        end
    end
    self:Update()
end

function PetInfoFu:TrackPetHistory()
    -- store each pet only once, with type and name as key
    -- this will get messed up if you don't name your pets 
    -- and stable a new pet of the same type or rename 
    -- a pet with the same name as an existing pet of that type
    for i = 1, GetNumStableSlots() do  -- i = 0 for current pet
        local _, petName, petLevel, petType, petLoyalty = GetStablePetInfo(i);
        if petName ~= nil then
            if self.db.char.petHistory[petType.."|"..petName] == nil then
                self.db.char.petHistory[petType.."|"..petName] = {
                    PetName = petName,
                    PetType = petType,
                    PetLevel = petLevel,
                    HunterLevel = UnitLevel("player")                
                }
            end
        end
    end
    self:Update()
end

function PetInfoFu:GetDemonicKnowledgeRank()   
     if (demonicKnowledgeTalentTab == 0 or demonicKnowledgeTalentIndex == 0) then
		for i = 1, GetNumTalentTabs() do
			local tabName = GetTalentTabInfo(i)
			if (tabName == BST["Demonology"]) then
				demonicKnowledgeTalentTab = i
				for j = 1, GetNumTalents(i) do
					local talentName, _, _, _, currentRank = GetTalentInfo(demonicKnowledgeTalentTab, j)
					if talentName == GetSpellInfo(36691) then   -- Demonic Knowledge
						demonicKnowledgeTalentIndex = j
						--set currentRank
                        demonicKnowledgeRank = currentRank
                        
					end
				end
			end
		end
	else
		local _, _, _, _, currentRank = GetTalentInfo(demonicKnowledgeTalentTab, demonicKnowledgeTalentIndex)
		-- set currentRank
        demonicKnowledgeRank = currentRank
	end
    self:Update()
end

function PetInfoFu:UpdateNetheredDemon(petName,petType,spellName,spellRank)
    if petName ~= nil then   
        if self.db.char.netheredDemons[petName] == nil then
            self.db.char.netheredDemons[petName] = {}
        end
        self.db.char.netheredDemons[petName].PetName = petName
        self.db.char.netheredDemons[petName].PetType = petType
        if self.db.char.netheredDemons[petName][spellName] == nil then
            self.db.char.netheredDemons[petName][spellName] = {}
        end
        self.db.char.netheredDemons[petName][spellName] = {
            SpellName = spellName,
            SpellRank = spellRank
        }      
    end
end

function PetInfoFu:ToggleCategory(id, button)
    -- hidden is character specific data
    self.db.char.hidden[id] = not self.db.char.hidden[id]
	-- refresh in place
	self:UpdateTooltip()
end    
    
function PetInfoFu:PetInfo_GetPetExperience()
	local currentXP, totalXP = GetPetExperience()
	local toLevelXP = totalXP - currentXP
	return currentXP, totalXP, toLevelXP
end

function PetInfoFu:GetTimeToLevel(petXPToLevel)
    if timerZero == 0 then return L["NA"] end

    local petXPGained = petXPZero - petXPToLevel
    if petXPGained < 0 then 
        self:ResetXPTimer()
        petXPGained = petXPZero - petXPToLevel
    end

    local timeRemaining = {}
          timeRemaining.d = 0
          timeRemaining.h = 0
          timeRemaining.m = 0
          timeRemaining.s = 0
    local timeDelta = (petXPToLevel/petXPGained) * (time() - timerZero)
    
    -- 86,400 seconds equals one day
    if (timeDelta >= 86400) then
        timeRemaining.d = floor(timeDelta / 86400)
        timeDelta = (timeDelta - (timeRemaining.d * 86400))
    end
    if timeRemaining.d > 0 then return L["1D+"] end
    
    -- 3,600 seconds equals one hour
    if (timeDelta >= 3600) then
        timeRemaining.h = floor(timeDelta / 3600)
        timeDelta = (timeDelta - (timeRemaining.h * 3600))
    end
    -- 60 seconds equals one minute
    if ( timeDelta >= 60 ) then
        timeRemaining.m = floor(timeDelta / 60)
        timeDelta = (timeDelta - (timeRemaining.m * 60))
    end
    -- add remaining seconds
    timeRemaining.s = timeDelta
    
    return string.format(L["PI_TIME_FORMAT"], timeRemaining.h, timeRemaining.m)

end
    
function PetInfoFu:GetKillsToLevel(petXPToLevel)
    return lastKillXP..' ('..format(L["PI_FORMAT"], petXPToLevel/lastKillXP)..')'
end
    
-- is class functions
    
function PetInfoFu:IsHunter()
	local _, englishClass = UnitClass("player")
	return englishClass == "HUNTER"
end
	
function PetInfoFu:IsWarlock()
	local _, englishClass = UnitClass("player")
	return englishClass == "WARLOCK" 
end

-- play sound on higher level skill available

function PetInfoFu:CheckForNextLevelSkill()
    local petLevel = UnitLevel("pet") 
    if petLevel > prevPetLevel then
        if self.db.char.playSoundOnSkillTrainable and not self.db.char.hasPlayedSoundOnSkillTrainable then
            i = 1
            local petName = UnitName("pet")
            while true do
                local spellName, spellRank = GetSpellName(i, BOOKTYPE_PET)
                if not spellName then
                    do break end
                end
                -- check if higher skill is available
                if self.db.char.beastTraining[spellName] ~= nil then
                    if self.db.char.beastTraining[spellName][spellRank] ~= nil then
                        if string.find(spellRank,' ') then                   
                            local rankNo = string.sub(spellRank,string.find(spellRank,' ') + 1)
                            local nextRank = string.sub(spellRank,1,string.find(spellRank,' '))..rankNo + 1
                            if self.db.char.beastTraining[spellName][nextRank] ~= nil then
                                local requiredLevel = self.db.char.beastTraining[spellName][nextRank].RequiredLevel
                                if requiredLevel <= petLevel then 
                                    PlaySound('AuctionWindowOpen')                              
                                    self.db.char.hasPlayedSoundOnSkillTrainable = true
                                    self:Print(crayon:Green(L["NAME"]..': '..petName..L[" can learn a new skill."]))
                                end
                            end
                        end
                    end
                end
                i = i + 1
            end
        end
    end
    prevPetLevel = petLevel
end

function PetInfoFu:CheckForTPGain()
    local totalTP, usedTP = GetPetTrainingPoints()
    local freeTP = totalTP - usedTP
    
    if prevTP == 0 then prevTP = freeTP end
    -- play sound if pet has gained training points since last update
    if freeTP > prevTP then
        if self.db.char.playSoundOnGainTP and
           not self.db.char.hasPlayedSoundOnGainTP then
            PlaySound('AuctionWindowOpen')
            self.db.char.hasPlayedSoundOnGainTP = true
            local petName = UnitName("pet")
            self:Print(crayon:Green(L["NAME"]..': '..petName..L[" has gained Training Points."]));                       
        end
        prevTP = freeTP
    end
end	
    
-- map notes

function PetInfoFu:AddStableMapNote()
	--get coordinates and name of stable owner
	local x, y = GetPlayerMapPosition("player")
    local stableName, _ = UnitName("target")

    -- check if we have an existing note, if not add one
	if not Cartographer_Notes:GetNearbyNote(GetRealZoneText(), x, y, 0.05, 'PetInfoFu') then
        Cartographer_Notes:SetNote(GetRealZoneText(), x, y, L["Stable"], "PetInfoFu",'title',  stableName)
    end
end    
    
-- menus
	
function PetInfoFu:OnMenuRequest(level, value)
	if level == 1 then
		if self:IsHunter() then
            dewdrop:AddLine(
                'text', BS["Beast Training"],
                'func', function() CastSpellByName(BS["Beast Training"])
                        end,
                'closeWhenClicked', true
            )
            dewdrop:AddLine()
		end
        -- label options
        dewdrop:AddLine(
            'text', L["Show pet's name"],
    		'func', 'ToggleIsShowingPetName',
 			'arg1', self,
            'closeWhenClicked', true,                
			'checked', self:IsShowingPetName()
        )
        dewdrop:AddLine(
            'text', L["Show pet's level"],
    		'func', 'ToggleIsShowingPetLevel',
 			'arg1', self,
            'closeWhenClicked', true,                
			'checked', self:IsShowingPetLevel()
        )
        if self:IsHunter() then
            dewdrop:AddLine(
                'text', L["Show experience"],        -- stub for popup
                'arg1', self,
                'hasArrow', true,
                'value', "SHOWXP"
            )                
        end
        if self:IsHunter() then
            dewdrop:AddLine(
                'text', L["Play sound"],             -- stub for popup
                'arg1', self,
                'hasArrow', true,
                'value', "PLAYSOUND"
            )
        end            
        -- tooltip options
        dewdrop:AddLine(
            'text', L["Show pet's attributes"],
    		'func', 'ToggleIsShowingAttributes',
 			'arg1', self,
            'closeWhenClicked', true,                
			'checked', self:IsShowingAttributes()
        )
        dewdrop:AddLine(
            'text', L["Show pet's combat statistics"],
    		'func', 'ToggleIsShowingCombatStats',
 			'arg1', self,
            'closeWhenClicked', true,                
			'checked', self:IsShowingCombatStats()
        )
        dewdrop:AddLine(
            'text', L["Show pet's skills"],
    		'func', 'ToggleIsShowingSkills',
 			'arg1', self,
            'closeWhenClicked', true,                
			'checked', self:IsShowingSkills()
        )
       if self:IsHunter() then
            dewdrop:AddLine(
                'text', L["Track pet happiness"],
                'func', 'ToggleIsTrackingPetHappiness',
                'arg1', self,
                'closeWhenClicked', true,                
                'checked', self:IsTrackingPetHappiness()
            )
            dewdrop:AddLine(
                'text', L["Show pet happiness frame"],
                'func', 'ToggleIsShowingHappinessFrame',
                'arg1', self,
                'closeWhenClicked', true,                
                'checked', self:IsShowingHappinessFrame()
            )
            dewdrop:AddLine(
                'text', L["Show Mend Pet frame"],
                'func', 'ToggleIsShowingMendPetFrame',
                'arg1', self,
                'closeWhenClicked', true,                
                'checked', self:IsShowingMendPetFrame()
            )
            dewdrop:AddLine(
                'text', L["CATEGORY_PET_STABLED"],  -- stub for popup
                'arg1', self,
                'hasArrow', true,
                'value', "STABLEDPETS"
            )        
            dewdrop:AddLine(
                'text', L["Track pet history"],
                'func', 'ToggleIsTrackingPetHistory',
                'arg1', self,
                'closeWhenClicked', true,                
                'checked', self:IsTrackingPetHistory()
            )
            dewdrop:AddLine(
                'text', L["MapNotes"],              -- stub for popup
                'arg1', self,
                'hasArrow', true,
                'value', "MAPNOTES"
            )        
        end
        if self:IsWarlock() then
            dewdrop:AddLine(
                'text', L["Show nethered demons"],
                'func', 'ToggleIsShowingStabledPets',
                'arg1', self,
                'closeWhenClicked', true,         
                'checked', self:IsShowingStabledPets()
            )        
        end        
        dewdrop:AddLine()
	end
    if level == 2 then
        if value == "STABLEDPETS" then
            dewdrop:AddLine(
                'text', L["Show stabled pets"],
                'func', 'ToggleIsShowingStabledPets',
                'arg1', self,
                'closeWhenClicked', true,         
                'checked', self:IsShowingStabledPets()
            )
            dewdrop:AddLine(
                'text', L["Show loyalty"],
                'func', 'ToggleIsShowingLoyalty',
                'arg1', self,
                'closeWhenClicked', true,         
                'checked', self:IsShowingLoyalty()
            )        
        end
        if value == "MAPNOTES" then
            dewdrop:AddLine(
                'text', L["Enable Stable mapnotes"],
                'func', 'ToggleIsShowingStableMapNotes',
                'arg1', self,
                'closeWhenClicked', true,                
                'checked', self:IsShowingStableMapNotes()
            )
        end
        if value == "SHOWXP" then
            dewdrop:AddLine(
                'text', L["By amount"],
                'func', 'ToggleIsShowingXPByAmount',
                'arg1', self,
                'closeWhenClicked', true,                
                'checked', self:IsShowingXPByAmount()
            )
            dewdrop:AddLine(
                'text', L["By kill"],
                'func', 'ToggleIsShowingXPByKill',
                'arg1', self,
                'closeWhenClicked', true,                
                'checked', self:IsShowingXPByKill()
            )
            dewdrop:AddLine(
                'text', L["By percentage"],
                'func', 'ToggleIsShowingXPByPercentage',
                'arg1', self,
                'closeWhenClicked', true,                
                'checked', self:IsShowingXPByPercentage()
            )
            dewdrop:AddLine(
                'text', L["By time"],
                'func', 'ToggleIsShowingXPByTime',
                'arg1', self,
                'closeWhenClicked', true,                
                'checked', self:IsShowingXPByTime()
            )
            dewdrop:AddLine(
                'text', L["Reset timer"],
                'func', 'ResetXPTimer',
                'arg1', self,
                'closeWhenClicked', true
            )
            dewdrop:AddLine(
                'text', L["Show on bar"],
                'func', 'ToggleIsShowingXPOnBar',
                'arg1', self,
                'closeWhenClicked', true
            )
        end 
        if value == "PLAYSOUND" then
            dewdrop:AddLine(
                'text', L["On TP gain"],
                'func', 'TogglePlaySoundOnGainTP',
                'arg1', self,
                'closeWhenClicked', true,                
                'checked', self:IsPlayingSoundOnGainTP()
            )
            dewdrop:AddLine(
                'text', L["On new skill available"],
                'func', 'TogglePlaySoundOnSkillTrainable',
                'arg1', self,
                'closeWhenClicked', true,                
                'checked', self:IsPlayingSoundOnSkillTrainable()
            )
            dewdrop:AddLine(
                'text', L["On Happiness level change"],
                'func', 'TogglePlaySoundOnHappinessLevelChange',
                'arg1', self,
                'closeWhenClicked', true,                
                'checked', self:IsPlayingSoundHappinessLevelChange()
            ) 
        end       
    end
end
	
-- updates    

function PetInfoFu:AddStabledPets()
    local tooltipLine = tablet:AddCategory('id', L["CATEGORY_PET_STABLED"], 'columns', 2,
                                           'text', L["CATEGORY_PET_STABLED"],
                                           'func', 'ToggleCategory', 'arg1', self, 'arg2', L["CATEGORY_PET_STABLED"],
                                           'child_textR', 0, 'child_textG', 1, 'child_textB', 0,
                                           'showWithoutChildren', true,
                                           'checked', true, 'hasCheck', true, 'checkIcon',
                                           self.db.char.hidden[L["CATEGORY_PET_STABLED"]] and 
                                           'Interface\\Buttons\\UI-PlusButton-Up' or 'Interface\\Buttons\\UI-MinusButton-Up'
    )        
    if not self.db.char.hidden[L["CATEGORY_PET_STABLED"]] then
        local petsFound
        
        for k, v in pairs(self.db.char.stabledPets) do  
            local label = v.PetLevel
            if self.db.char.showLoyalty then label = label..' ('..v.PetLoyalty..')' end 
            tooltipLine:AddLine(
                'text', v.PetName..' ('..v.PetType..')',
                'text2', label,
                'text2R', 1, 'text2G', 1, 'text2B', 0,
                'func', 'PetInfoFrame', 'arg1', self, 'arg2', v
            )              
            petsFound = true
        end
        if not petsFound then
                tooltipLine:AddLine(
                    'text', L["Please visit a stable to initialise."]
                )
        end
    end
end
	
function PetInfoFu:AddPetHistory()
    local tooltipLine = tablet:AddCategory('id', L["CATEGORY_PET_HISTORY"], 'columns', 2,
                                           'text', L["CATEGORY_PET_HISTORY"],
                                           'func', 'ToggleCategory', 'arg1', self, 'arg2', L["CATEGORY_PET_HISTORY"],
                                           'child_textR', 0, 'child_textG', 1, 'child_textB', 0,
                                           'showWithoutChildren', true,
                                           'checked', true, 'hasCheck', true, 'checkIcon',
                                           self.db.char.hidden[L["CATEGORY_PET_HISTORY"]] and 
                                           'Interface\\Buttons\\UI-PlusButton-Up' or 'Interface\\Buttons\\UI-MinusButton-Up'
    )        
    if not self.db.char.hidden[L["CATEGORY_PET_HISTORY"]] then
        -- create a sorted table of pets
        sortedPets = {}
        for k,v in pairs(self.db.char.petHistory) do
            if v.HunterLevel == nil then
                v.HunterLevel = UnitLevel("player")
                self.db.char.petHistory[k].HunterLevel = v.HunterLevel
            end
            table.insert(sortedPets, v)
        end
        table.sort(sortedPets, function (a, b) return a.HunterLevel < b.HunterLevel end)
        -- list sorted pets
        for i = 1, #sortedPets do  
            tooltipLine:AddLine(
                'text', sortedPets[i].PetName..' ('..sortedPets[i].PetType..')',
                'text2', sortedPets[i].PetLevel..' ('..sortedPets[i].HunterLevel..')',
                'text2R', 1, 'text2G', 1, 'text2B', 0
            )              
        end
    end
end


function PetInfoFu:ShowSkills()
    local tooltipLine = tablet:AddCategory('id', L["CATEGORY_PET_SKILLS"], 'columns', 2,
                                           'text', L["CATEGORY_PET_SKILLS"],
                                           'func', 'ToggleCategory', 'arg1', self, 'arg2', L["CATEGORY_PET_SKILLS"],
                                           'child_textR', 0, 'child_textG', 1, 'child_textB', 0,
                                           'showWithoutChildren', true,
                                           'checked', true, 'hasCheck', true, 'checkIcon',
                                           self.db.char.hidden[L["CATEGORY_PET_SKILLS"]] and 
                                           'Interface\\Buttons\\UI-PlusButton-Up' or 'Interface\\Buttons\\UI-MinusButton-Up'
    )        
    if not self.db.char.hidden[L["CATEGORY_PET_SKILLS"]] then
        local petName = UnitName("pet")    
        local petType = UnitCreatureFamily("pet")
        local petLevel = UnitLevel("pet") 
        local i = 1
        while true do
            local spellName, spellRank = GetSpellName(i, BOOKTYPE_PET)
            if not spellName then
                do break end
            end
            -- check if higher skill is available
            if self:IsHunter() then
                if self.db.char.beastTraining[spellName] ~= nil then
                    if self.db.char.beastTraining[spellName][spellRank] ~= nil then
                        if string.find(spellRank,' ') then
                            local rankNo = string.sub(spellRank,string.find(spellRank,' ') + 1)
                            local nextRank = string.sub(spellRank,1,string.find(spellRank,' '))..rankNo + 1
                            if self.db.char.beastTraining[spellName][nextRank] ~= nil then
                                local requiredLevel = self.db.char.beastTraining[spellName][nextRank].RequiredLevel
                                if requiredLevel > petLevel then 
                                    spellRank = spellRank..' ('..crayon:Red(format(requiredLevel))..')'
                                else
                                    spellRank = spellRank..' ('..format(requiredLevel)..')'
                                end
                            end
                        end
                    end
                end
            end
            if self:IsWarlock() then
                self:UpdateNetheredDemon(petName,petType,spellName,spellRank)
            end
            tooltipLine:AddLine(
                'text', spellName,
                'text2', spellRank,
                'text2R', 1, 'text2G', 1, 'text2B', 0
            )
            i = i + 1
        end
     end
end     

function PetInfoFu:AddNetheredDemons()
    local tooltipLine = tablet:AddCategory('id', L["CATEGORY_PET_NETHER"], 'columns', 2,
                                           'text', L["CATEGORY_PET_NETHER"],
                                           'func', 'ToggleCategory', 'arg1', self, 'arg2', L["CATEGORY_PET_NETHER"],
                                           'child_textR', 0, 'child_textG', 1, 'child_textB', 0,
                              			   'child_indentation', 20,                                           
                                           'showWithoutChildren', true,
                                           'checked', true, 'hasCheck', true, 'checkIcon',
                                           self.db.char.hidden[L["CATEGORY_PET_NETHER"]] and 
                                           'Interface\\Buttons\\UI-PlusButton-Up' or 'Interface\\Buttons\\UI-MinusButton-Up'
    )        
    
    if not self.db.char.hidden[L["CATEGORY_PET_NETHER"]] then
        -- create a sorted table of pets
        local sortedPets = {}
        for k,v in pairs(self.db.char.netheredDemons) do
             table.insert(sortedPets, v)
        end
        table.sort(sortedPets, function (a, b) return a.PetType < b.PetType end)
        -- list sorted pets
        for i = 1, #sortedPets do
            if sortedPets[i].PetName ~= UnitName('pet') then
                local tooltipLine = tablet:AddCategory('id', sortedPets[i].PetName, 'columns', 2,
                                                       'text', sortedPets[i].PetName..' ('..sortedPets[i].PetType..')',
                                                       'func', 'ToggleCategory', 'arg1', self, 'arg2', sortedPets[i].PetName,
                                                       'indentation', 10,
                                                       'child_textR', 0, 'child_textG', 1, 'child_textB', 0,
                                                       'child_indentation', 25,
                                                       'showWithoutChildren', true,
                                                       'hideBlankLine', true,                                           
                                                       'checked', true, 'hasCheck', true, 'checkIcon',
                                                       self.db.char.hidden[sortedPets[i].PetName] and 
                                                       'Interface\\Buttons\\UI-PlusButton-Up' or 'Interface\\Buttons\\UI-MinusButton-Up'
                )        
                if not self.db.char.hidden[sortedPets[i].PetName] then
                    -- create a sorted table of skills
                    local sortedSkills = {}
                    for k,v in pairs(self.db.char.netheredDemons[sortedPets[i].PetName]) do
                        if v.SpellName ~= nil then 
                            table.insert(sortedSkills, v)
                        end
                    end
                    table.sort(sortedSkills, function (a, b) return a.SpellName < b.SpellName end)
                    -- list sorted skills
                    for j = 1, #sortedSkills do
                        tooltipLine:AddLine(
                            'text', sortedSkills[j].SpellName,
                            'text2', sortedSkills[j].SpellRank,
                            'text2R', 1, 'text2G', 1, 'text2B', 0
                        ) 
                    end                    
                end
            end
        end
    end
end
 
function PetInfoFu:OnTooltipUpdate()

    if HasPetUI() then

        if self:IsHunter() then
	        tablet:SetHint(L["PI_TOOLTIP_HINT_HUNTER"])
        else
            tablet:SetHint(L["PI_TOOLTIP_HINT"])       
        end

        
        local toolTip = tablet:AddCategory(
            'columns', 2,
            'child_textR', 0,
            'child_textG', 1,
            'child_textB', 0,
            'child_text2R', 1,
            'child_text2G', 1,
            'child_text2B', 0
        )
        
        local petName = UnitName("pet")
        toolTip:AddLine(
            'text', L["PI_PETNAME"],
            'text2', petName
        )        
        local petLevel = UnitLevel("pet")
        toolTip:AddLine(
            'text', L["PI_PETLEVEL"],
            'text2', petLevel
        )
        if self:IsHunter() then        
            -- general pet info            
            local tooltipLine = tablet:AddCategory('id', L["CATEGORY_PET_INFO"], 'columns', 2,
                                                   'text', L["CATEGORY_PET_INFO"],
                                                   'func', 'ToggleCategory', 'arg1', self, 'arg2', L["CATEGORY_PET_INFO"],
                                                   'child_textR', 0, 'child_textG', 1, 'child_textB', 0,
                                                   'showWithoutChildren', true,
                                                   'checked', true, 'hasCheck', true, 'checkIcon',
                                                   self.db.char.hidden[L["CATEGORY_PET_INFO"]] and 
                                                   'Interface\\Buttons\\UI-PlusButton-Up' or 'Interface\\Buttons\\UI-MinusButton-Up'
            )
            if not self.db.char.hidden[L["CATEGORY_PET_INFO"]] then
            
                local petType = UnitCreatureFamily("pet")
                
                tooltipLine:AddLine(
                    'text', L["PI_TYPE"],
                    'text2', petType,
                    'text2R', 1, 'text2G', 1, 'text2B', 0
                )
                tooltipLine:AddLine(
                    'text', L["PI_FOOD"],
                    'text2', BuildListString(GetPetFoodTypes()),
                    'text2R', 1, 'text2G', 1, 'text2B', 0
                )
                tooltipLine:AddLine(
                    'text', L["PI_LOYALTY"],
                    'text2', GetPetLoyalty(),
                    'text2R', 1, 'text2G', 1, 'text2B', 0
                )
                tooltipLine:AddLine() tooltipLine:AddLine() tooltipLine:AddLine()
                
                -- happiness info
                local happiness, damagePercentage, loyaltyRate = GetPetHappiness()
                local happyText = ''
                local loyaltyText = ''
                local rHappy = 1 
                local gHappy = 1
                local bHappy = 0

                if happiness == 1 then
                    happyText = L["Unhappy"]
                    rHappy = 1
                    gHappy = 0
                elseif happiness == 2 then
                    happyText = L["Content"]              
                elseif happiness == 3 then
                    happyText = L["Happy"]
                    rHappy = 0
                    gHappy = 1
                end
                
                if loyaltyRate > 0 then
                    loyaltyText = L["Gaining Loyalty"]
                else
                    loyaltyText = L["Losing Loyalty"]
                end
                tooltipLine:AddLine(
                    'text', L["PI_HAPPINESS"],
                    'text2', happyText,
                    'text2R', rHappy, 'text2G', gHappy, 'text2B', bHappy
                )            
                tooltipLine:AddLine(
                    'text', L["PI_DAMAGEPERCT"],
                    'text2', damagePercentage..'%',
                    'text2R', rHappy, 'text2G', gHappy, 'text2B', bHappy
                )
                tooltipLine:AddLine(
                    'text', L["PI_LOYALTYRATE"],
                    'text2', loyaltyText,
                    'text2R', 1, 'text2G', 1, 'text2B', 0
                )
                tooltipLine:AddLine() tooltipLine:AddLine() tooltipLine:AddLine()
                
                -- experience info          
                local currentXP, totalXP, toLevelXP = self:PetInfo_GetPetExperience()
                local currentXPPercent = currentXP / totalXP * 100
                local toLevelXPPercent = toLevelXP / totalXP * 100
                
                if petLevel < UnitLevel("player") then
                    tooltipLine:AddLine(
                        'text', L["PI_CURRENT_XP"], 
                        'text2', format(L["PI_PLUS_PERCENT_FORMAT"], currentXP, currentXPPercent),
                        'text2R', 1, 'text2G', 1, 'text2B', 0
                    )
                    tooltipLine:AddLine(
                        'text', L["PI_NEEDED_XP"], 
                        'text2', format(L["PI_PLUS_PERCENT_FORMAT"], toLevelXP, toLevelXPPercent),
                        'text2R', 1, 'text2G', 1, 'text2B', 0,
                        'func', 'PetExperienceFrame', 'arg1', self
                    )
                    tooltipLine:AddLine(
                        'text', L["PI_TOTAL_XP"], 
                        'text2', totalXP,
                        'text2R', 1, 'text2G', 1, 'text2B', 0
                    )
                else
                    tooltipLine:AddLine(
                        'text', L["PI_NOLEVEL"]
                    )
                end
                tooltipLine:AddLine() tooltipLine:AddLine() tooltipLine:AddLine()
                
                -- training info
                local totalTP, usedTP = GetPetTrainingPoints()
                local freeTP = totalTP - usedTP            
                tooltipLine:AddLine(
                    'text', L["PI_TRAINING_POINTS"], 
                    'text2', freeTP,
                    'text2R', 1, 'text2G', 1, 'text2B', 0
                )
            end
        end
        
        if self:IsWarlock() then
            -- demonic knowledge
            -- skip section if not talented in demonic knowledge
            if demonicKnowledgeRank > 0 then
                local tooltipLine = tablet:AddCategory('id', L["CATEGORY_DEMONIC_KNOWLEDGE"], 'columns', 2,
                                                       'text', L["CATEGORY_DEMONIC_KNOWLEDGE"],
                                                       'func', 'ToggleCategory', 'arg1', self, 'arg2', L["CATEGORY_DEMONIC_KNOWLEDGE"],                                                   
                                                       'child_textR', 0, 'child_textG', 1, 'child_textB', 0,
                                                       'showWithoutChildren', true,
                                                       'checked', true, 'hasCheck', true, 'checkIcon',
                                                       self.db.char.hidden[L["CATEGORY_DEMONIC_KNOWLEDGE"]] and 
                                                       'Interface\\Buttons\\UI-PlusButton-Up' or 'Interface\\Buttons\\UI-MinusButton-Up'                                                  
                )
            
                if UnitExists("pet") then
                    local demonSta, demonInt
                    _, demonSta = UnitStat("pet", 3) -- stamina
                    _, demonInt = UnitStat("pet", 4) -- intelligence
                    tooltipLine:AddLine(
                        'text', L["PI_BONUSDAMAGE"]..' ('..demonicKnowledgeRank..')',
                        'text2', floor((demonSta + demonInt) * 0.05 * demonicKnowledgeRank),
                        'text2R', 1, 'text2G', 1, 'text2B', 0
                    )
                else
                    tooltipLine:AddLine(
                        'text', L["PI_NODEMON"]
                    )            
                end
            end
        end
        
        -- combat info
        if self.db.char.showCombatStats then        
            local tooltipLine = tablet:AddCategory('id', L["CATEGORY_PET_COMBAT_INFO"], 'columns', 2,
                                           'text', L["CATEGORY_PET_COMBAT_INFO"],
                                           'func', 'ToggleCategory', 'arg1', self, 'arg2', L["CATEGORY_PET_COMBAT_INFO"],
                                           'child_textR', 0, 'child_textG', 1, 'child_textB', 0,
                                           'showWithoutChildren', true,
                                           'checked', true, 'hasCheck', true, 'checkIcon',
                                           self.db.char.hidden[L["CATEGORY_PET_COMBAT_INFO"]] and 
                                           'Interface\\Buttons\\UI-PlusButton-Up' or 'Interface\\Buttons\\UI-MinusButton-Up'
            )
            if not self.db.char.hidden[L["CATEGORY_PET_COMBAT_INFO"]] then

                local baseArmor, effectiveArmor, armor, posArmorBuff, negArmorBuff = UnitArmor("pet");
                if posArmorBuff - negArmorBuff < 0 then
                    effectiveArmor = crayon:Red(format(effectiveArmor))..' ('..format(baseArmor)..crayon:Red("-"..format(baseArmor - effectiveArmor))..')'
                elseif baseArmor < effectiveArmor then 
                    effectiveArmor = crayon:Green(format(effectiveArmor))..' ('..format(baseArmor)..crayon:Green("+"..format(effectiveArmor - baseArmor))..')'
                end
-- self:Print(baseArmor.." "..effectiveArmor.." "..armor.." "..posArmorBuff.." ".." "..negArmorBuff)                

                tooltipLine:AddLine(
                    'text', L["PI_ARMOR_CLASS"], 
                    'text2', effectiveArmor,
                    'text2R', 1, 'text2G', 1, 'text2B', 0
                )
              
                local atkBase, atkMod = UnitAttackBothHands("pet");        
                tooltipLine:AddLine(
                    'text', L["PI_ATTACK_SKILL"],
                    'text2', atkBase,
                    'text2R', 1, 'text2G', 1, 'text2B', 0
                )

                local atkPowerbase, atkPowerPosBuff, atkPowerNegBuff = UnitAttackPower("pet");
                if atkPowerPosBuff - atkPowerNegBuff < 0 then
                    atkPowerbase = crayon:Red(format(atkPowerbase + atkPowerPosBuff + atkPowerNegBuff))..' ('..format(atkPowerbase)..crayon:Red("-"..format(atkPowerPosBuff + atkPowerNegBuff))..')'
                elseif atkPowerPosBuff - atkPowerNegBuff > 0 then
                    atkPowerbase = crayon:Green(format(atkPowerbase + atkPowerPosBuff + atkPowerNegBuff))..' ('..format(atkPowerbase)..crayon:Green("+"..format(atkPowerPosBuff + atkPowerNegBuff))..')'
                end
                tooltipLine:AddLine(
                    'text', L["PI_ATTACK_POWER"],
                    'text2', atkPowerbase,
                    'text2R', 1, 'text2G', 1, 'text2B', 0                
                )
                
                local atkSpeed = UnitAttackSpeed("pet")       
                tooltipLine:AddLine(
                    'text', L["PI_ATTACK_SPEED"], 
                    'text2', format(L["PI_AS_FORMAT"], atkSpeed),
                    'text2R', 1, 'text2G', 1, 'text2B', 0
                )

                local lowDmg, hiDmg, offlowDmg, offhiDmg, posBuff, negBuff, percentMod = UnitDamage("pet");
                local listedDPS = (((lowDmg + hiDmg) * .5 + posBuff + negBuff) * percentMod) / atkSpeed;
                tooltipLine:AddLine(
                    'text', L["PI_DPS_LISTED"], 
                    'text2', format(L["PI_DPS_FORMAT"], listedDPS),
                    'text2R', 1, 'text2G', 1, 'text2B', 0
                )
            end
        end
        
        -- show stats info if showing
        if self.db.char.showAttributes then        
            local tooltipLine = tablet:AddCategory('id', L["CATEGORY_PET_ATTRIBUTES"], 'columns', 2,
                                                   'text', L["CATEGORY_PET_ATTRIBUTES"],
                                                   'func', 'ToggleCategory', 'arg1', self, 'arg2', L["CATEGORY_PET_ATTRIBUTES"],
                                                   'child_textR', 0, 'child_textG', 1, 'child_textB', 0,
                                                   'showWithoutChildren', true,
                                                   'checked', true, 'hasCheck', true, 'checkIcon',
                                                   self.db.char.hidden[L["CATEGORY_PET_ATTRIBUTES"]] and 
                                                   'Interface\\Buttons\\UI-PlusButton-Up' or 'Interface\\Buttons\\UI-MinusButton-Up'
            )        
            if not self.db.char.hidden[L["CATEGORY_PET_ATTRIBUTES"]] then         
                for i = 1, NUM_PET_STATS, 1 do                  
                    local attrbStr = L["SPELL_STAT"..format(i-1).."_NAME"]                   
                    local baseStat, effectiveStat, posBuff, negBuff = UnitStat("pet", i)
            
                    if posBuff == 0 and negBuff == 0 then
                        baseStat = effectiveStat
                    else 
                        -- if there are any negative buffs then show the main number in red even if there are
                        -- positive buffs. otherwise show in green.
                        if negBuff < 0 then
                            baseStat = crayon:Red(baseStat)..' ('..baseStat-negBuff..""..crayon:Red(negBuff+posBuff)..')'
                        else
                            baseStat = crayon:Green(effectiveStat)..' ('..baseStat-posBuff.."+"..crayon:Green(posBuff)..')'
                        end
                    end
                    tooltipLine:AddLine(
                        'text', attrbStr,
                        'text2', baseStat,
                        'text2R', 1, 'text2G', 1, 'text2B', 0
                    )
                end
            end
        end
        
        -- show skills info
        if self.db.char.showSkills then          
            self:ShowSkills()
        end

        -- add other demons if showing
        if self:IsWarlock() and self.db.char.showStabledPets then
            self:AddNetheredDemons()
        end   
        
        -- add other pets if showing
        if self:IsHunter() and self.db.char.showStabledPets then          
            self:AddStabledPets()
        end   
        -- add pet history
        if self:IsHunter() and self.db.char.trackPetHistory then
            self:AddPetHistory()
        end           
    else
        -- no pet found
        local toolTip = tablet:AddCategory(
            'columns', 1,
            'child_textR', 0,
            'child_textG', 1,
            'child_textB', 0
        )      
        toolTip:AddLine(
            'text', L["PI_NOPET"]
        )
        -- add stabled pets
        if self:IsHunter() and self.db.char.showStabledPets then
            self:AddStabledPets()
        end   
        -- add pet history
        if self:IsHunter() and self.db.char.trackPetHistory then
            self:AddPetHistory()
        end    
        -- add other demons if showing
        if self:IsWarlock() and self.db.char.showStabledPets then          
            self:AddNetheredDemons()
        end   
    end
end

function PetInfoFu:UpdateText()
    -- sound checks
    if self:IsHunter() then
        self:CheckForTPGain()
        self:CheckForNextLevelSkill() 
    end

    if  self:IsTextShown() then
        if self.db.char.showPetName or self.db.char.showPetLevel then
            if UnitName("pet") ~= nil then
                local petName = UnitName("pet")
                local petLevel = UnitLevel("pet")
                local toonLevel = UnitLevel("player")
                local petIcon = GetPetIcon()
                local happiness = GetPetHappiness()
                local label = ''
                
                if petName ~= nil and petLevel ~= nil then  
                
                    if petName == UNKNOWNOBJECT then
                        petName = L["UO"]
                        self:ScheduleEvent(self.UpdateText,2, self)
                    end
                
                    -- set pet icon for warlock
                    if self:IsWarlock() then
                        if (UnitCreatureFamily("pet") == L["Imp"]) then            petIcon = select(3, GetSpellInfo(688))   -- "Interface\\Icons\\Spell_Shadow_SummonImp"
                        elseif (UnitCreatureFamily("pet") == L["Felguard"]) then   petIcon = select(3, GetSpellInfo(30146)) -- "Interface\\Icons\\Spell_Shadow_SummonFelGuard"
                        elseif (UnitCreatureFamily("pet") == L["Felhunter"]) then  petIcon = select(3, GetSpellInfo(691))   -- "Interface\\Icons\\Spell_Shadow_SummonFelHunter"
                        elseif (UnitCreatureFamily("pet") == L["Succubus"]) then   petIcon = select(3, GetSpellInfo(712))   -- "Interface\\Icons\\Spell_Shadow_SummonSuccubus"
                        elseif (UnitCreatureFamily("pet") == L["Voidwalker"]) then petIcon = select(3, GetSpellInfo(697))   -- "Interface\\Icons\\Spell_Shadow_SummonVoidWalker"
                        elseif (UnitCreatureFamily("pet") == L["Infernal"]) then   petIcon = select(3, GetSpellInfo(1122))  --"Interface\\Icons\\Spell_Shadow_SummonInfernal" 
                        end
                    end 
                    
                    if petIcon ~= nil then
                        self:SetIcon(petIcon)        
                    end
                    -- show name and/or level
                    if self.db.char.showPetName then                   
                        if self.db.char.showPetLevel then                        
                            label = petName..' ('..petLevel..')'
                        else
                            label = petName
                        end
                    else
                        if self.db.char.showPetLevel then    
                            label = petLevel
                        else
                                                
                        end 
                    end
                    
                    -- show XP if flag is true (otherwise assume XP tool tip is showing)
                    if self.db.char.showPetXPOnBar  then
                        if petLevel ~= toonLevel then
                            if self.db.char.showPetXP == 1 then
                                local _, _, toLevelXP = self:PetInfo_GetPetExperience()                    
                                label = label..' - '..format(L["PI_FORMAT"], toLevelXP)
                            elseif self.db.char.showPetXP == 2 then
                                local _, totalXP, toLevelXP = self:PetInfo_GetPetExperience()
                                local toLevelXPPercent = toLevelXP / totalXP * 100                   
                                label = label..' - '..format(L["PI_PERCENT_FORMAT"],toLevelXPPercent)
                            elseif self.db.char.showPetXP == 3 then
                                local _, _, toLevelXP = self:PetInfo_GetPetExperience()                    
                                label = label..' - '..self:GetTimeToLevel(toLevelXP)
                            elseif self.db.char.showPetXP == 4 then
                                if lastKillXP > 0 then 
                                    local _, _, toLevelXP = self:PetInfo_GetPetExperience()
                                    label = label..' - '..self:GetKillsToLevel(toLevelXP)
                                end
                            end
                        end
                    end
                    
                    -- set colour
                    if happiness == nil then                -- non hunter pet
                        self:SetText(label)
                    else
                        if self.db.char.trackPetHappiness then
                            -- estimatedPetHappiness 350 - 1400, 
                            -- unhappy     [ 351 -  700] - 1*350 = [1 - 350]
                            -- content     [ 701 - 1050] - 2*350 = [1 - 350]
                            -- happy       [1051 - 1400] - 3*350 = [1 - 350]
                            label = label..format(L["PI_FORMAT_HAPPINESS"],estimatedPetHappiness - (happiness * 350)) 
                        end
                        if happiness == 1 then
                            self:SetText(crayon:Red(label))     -- unhappy
                        elseif happiness == 2 then
                            self:SetText(crayon:Yellow(label))  -- content              
                        elseif happiness == 3 then
                            self:SetText(crayon:Green(label))   -- happy
                        end
                        if self.petHappinessFrame then self:UpdatePetHappinessFrame() end
                    end
                else
                    -- pet name and level are nil which means there shouldn't have been a pet ui in the first place
                        self:SetText(L["PI_NOPET"])
                        self:SetIcon(select(3, GetSpellInfo(2641))) -- dismiss pet
                end
            else 
                -- no pet ui found
                self:SetText(L["PI_NOPET"])
                self:SetIcon(select(3, GetSpellInfo(2641))) -- dismiss pet
            end
        else
            if UnitName("pet") ~= nil then
                local petIcon = GetPetIcon()
                if petIcon ~= nil then
                    self:SetIcon(petIcon)        
                end
            end
            self:SetText("")                    
        end
    end
end	

-- event handlers

function PetInfoFu:OnClick()
    if self:IsHunter() then
        if IsControlKeyDown() then
            -- initialise timer for show time til next level
            if self.db.char.showPetXP == 3 then
                self:ResetXPTimer()
            -- initialise XP counter for show kills til next level
            elseif self.db.char.showPetXP == 4 then
                local _, _, toLevelXP = self:PetInfo_GetPetExperience()                    
                prevXPToLevel = toLevelXP
            end            
        else
            self.db.char.hasPlayedSoundOnGainTP = false
            self.db.char.hasPlayedSoundOnSkillTrainable = false
            CastSpellByName(BS["Beast Training"])
        end
    end
end
