﻿assert( PaladinTimerFu, "PaladinTimerFu not found!")
local BS = AceLibrary("Babble-Spell-2.2")
local L = AceLibrary("AceLocale-2.2"):new("PaladinTimerFu")
local parser = ParserLib:GetInstance("1.1")

PaladinTimerFu_Rules = PaladinTimerFu:NewModule("Rules")
PaladinTimerFu_Rules.Rules = {}
PaladinTimerFu_Rules.defaults = {}
PaladinTimerFu_Rules.timers = {}
PaladinTimerFu_Rules.Menu = {}
PaladinTimerFu_Rules.done = {}

function PaladinTimerFu_Rules:OnInitialize()
self.settings = PaladinTimerFu:AcquireDBNamespace("BuffTimer")
for _, v in pairs(self.timers) do
		v(self)
end
PaladinTimerFu:RegisterDefaults("BuffTimer", "profile", self.defaults)
for k in pairs(self.Menu) do
PaladinTimerFu.Menu.args[L[k]] = {
	type = "group",
	order = 4,
	name = L[k],
	desc = L["Which Buffs to show."],
	args = {}
}
for v in pairs(self.Menu[k]) do
local name = self:Translation(v)
	PaladinTimerFu.Menu.args[L[k]].args[name] = {
		order = 3,
		type = 'toggle',
		name = name,
	    desc = L["Enable/Dissable the timer"],
	    get = function()
	        return self.settings.profile[self:Translation(v)]
	    end,
	    set = function()
			self.settings.profile[self:Translation(v)] = not self.settings.profile[self:Translation(v)]
		end,
		map = { [false] = "Disabled", [true] = "Enabled" }
}
end
end
self.Menu = nil
end

function PaladinTimerFu_Rules:OnEnable()
--Spell Events
self:RegisterEvent("UNIT_SPELLCAST_SENT", "spell")
self:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED", "spellSent")
--Damage
parser:RegisterEvent("PaladinTimerFu_Stun", "CHAT_MSG_SPELL_PERIODIC_CREATURE_DAMAGE", self.Attack)
parser:RegisterEvent("PaladinTimerFu_Stun", "CHAT_MSG_SPELL_PERIODIC_HOSTILEPLAYER_DAMAGE", self.Attack)
parser:RegisterEvent("PaladinTimerFu_Stun", "CHAT_MSG_SPELL_SELF_DAMAGE", self.Attack)
-- Other Break aura
parser:RegisterEvent("PaladinTimerFu_Stun", "CHAT_MSG_SPELL_AURA_GONE_OTHER", self.Fade)
parser:RegisterEvent("PaladinTimerFu_Stun", "CHAT_MSG_SPELL_BREAK_AURA", self.Fade)
--Self Buffs
parser:RegisterEvent("PaladinTimerFu_Stun", "CHAT_MSG_SPELL_PERIODIC_SELF_BUFFS", self.Buff)
-- Self Fades
parser:RegisterEvent("PaladinTimerFu_Stun", "CHAT_MSG_SPELL_AURA_GONE_SELF", self.Fade_Self)
end

function PaladinTimerFu_Rules:AddRule(group, name, table)
if not table.d then table.d = {} end
if not self.Menu[group] then self.Menu[group] = {} end
self.Menu[group][name] = table
self.Rules[self:Translation(name)] = table
self.defaults[self:Translation(name)] = true
end

function PaladinTimerFu_Rules:OnDisable()
parser:UnregisterAllEvents("PaladinTimerFu_Stun")
end

--Parsing
function PaladinTimerFu_Rules:spell()
	self.Target = arg4
end

function PaladinTimerFu_Rules:spellSent()
if not self.settings.profile[arg2]or self.Rules[arg2].parse then return end
if self.Rules[arg2].buff then
	self:Bars(arg2, nil, ParserLib_SELF)
	return
else
self.done[arg2] = {r=arg3, t=self.Target}
self:ScheduleEvent(self.CompleteCast, 0.5, self, arg2)
end
end

function PaladinTimerFu_Rules:CompleteCast(spell)
	local active = self.done[spell]
	if active and active.t then
		self:Bars(spell, active.r, active.t, -0.25)
		self.done[spell] = nil
	end
end

function PaladinTimerFu_Rules:Attack(info)
local self = PaladinTimerFu_Rules
if info.skill == self:Translation("Dazed") then info.skill = self:Translation("Blade Twisting") end
if info.type == "miss" then
	self.done[info.skill] = nil
end
if info.type == "debuff" and self.Rules[info.skill] and self.Rules[info.skill].parse then
	if self.settings.profile[info.skill] then
		self:Bars(info.skill, nil, info.victim)
	end
end
end

function PaladinTimerFu_Rules:Buff(info)
local self = PaladinTimerFu_Rules
if info.type == "buff" and self.Rules[info.skill] and self.Rules[info.skill].parse then
	if self.settings.profile[info.skill] then 
		self:Bars(info.skill, self.Rank, info.victim)
	end
end
end

function PaladinTimerFu_Rules:Fade(info)
local self = PaladinTimerFu_Rules
		PaladinTimerFu_Bars:PaladinTimerFu_StopBar(self, info.skill, info.victim)
end

function PaladinTimerFu_Rules:Fade_Self(info)
local skill = info.skill == BS["Remorseless"] and BS["Remorseless Attacks"] or info.skill
local self = PaladinTimerFu_Rules
	PaladinTimerFu_Bars:PaladinTimerFu_StopBar(self, skill, info.victim)
end

--Bars
function PaladinTimerFu_Rules:Bars(move, rank, target, dur)
local B, dur = self.Buffs, dur or 0
local time = self:GetDuration(self.Rules[move].d, self.Rules[move].time, combo, rank) + dur
if time < 1 then return end
local path = BS:GetSpellIcon(move)
PaladinTimerFu_Bars:PaladinTimerFu_StartBar(self, move, target, time, path)
end

function PaladinTimerFu_Rules:GetDuration(record, duration, cp, rank)
	if record.rs then duration = duration + (self:NumRank(rank)-1) * record.rs end
	if record.tn then
		local _,_,_,_, tr = GetTalentInfo(unpack(record.tn))
		if record.to == 1 and tr < 1 then return 0 end
		if tr > 0 and record.to ~= 1 then
			local gain = record.tt and record.tt[tr] or (record.tb + (tr-1) * (record.ts or record.tb))
			duration = duration + (record.tp and (duration/100) * gain or gain)
		end
	end
	if record.p and UnitIsPlayer("target") then duration = record.p end
	return duration
end 

function PaladinTimerFu_Rules:Translation(arg)
if not arg then return end
if BS:HasTranslation(arg) then
	return BS[arg]
elseif L:HasTranslation(arg) then
	return L[arg]
end
return arg
end

function PaladinTimerFu_Rules:NumRank(rank)
local _, _, _, rank = string.find(rank, "(.+) (%d+)")
return rank
end 