﻿--Texture registering
local surface = AceLibrary("Surface-1.0")
surface:Register("Otravi", "Interface\\AddOns\\FuBar_PaladinTimerFu\\Textures\\otravi")
surface:Register("Smooth", "Interface\\AddOns\\FuBar_PaladinTimerFu\\Textures\\smooth")
surface:Register("Glaze", "Interface\\AddOns\\FuBar_PaladinTimerFu\\Textures\\glaze")
surface:Register("Charcoal", "Interface\\AddOns\\FuBar_PaladinTimerFu\\Textures\\Charcoal")
surface:Register("BantoBar", "Interface\\AddOns\\FuBar_PaladinTimerFu\\Textures\\default")
 
--Locals 
local L = AceLibrary("AceLocale-2.2"):new("PaladinTimerFu")

--Ace2 Registering
PaladinTimerFu = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0", "AceModuleCore-2.0", "FuBarPlugin-2.0")
PaladinTimerFu:SetModuleMixins("AceEvent-2.0", "CandyBar-2.0")

--Mod Options
PaladinTimerFu.Menu = { 
    type ="group",
    args = {
		[L["Bars To Show"]] = {
			type = "header",
			name = L["Bars To Show"],
			order = 1,
		},
		["spacer1"] = {
			type = "header",
			name = " ",
			order = 10,
		},
		["spacer2"] = {
			type = "header",
			name = " ",
			order = 100,
		},
		[L["Reset settings"]] = {
			type = "execute",
			order = 102,
			name = L["Reset settings"],
			desc = L["Reset settings for this profile"],
			func = function() PaladinTimerFu:ResetDB("profile") end,
		},	
	},
} 

--Dissable if not Paladin
function PaladinTimerFu:OnInitialize()
--Saved Information
self:RegisterDB("PaladinTimerFuDB")
--Revision 
self.revision = tonumber(string.sub("$Rev: 36436 $", 7, -3))
self.version = self.version .. " |cffff8888r"..self.revision.."|r"
local playerClass, englishClass = UnitClass("player");
	if (englishClass == "PALADIN") then
	self:ToggleActive(true)
	else
	self:ToggleActive(false)
end
self:RegisterChatCommand({"/PaladinTimerFu", "/ptf"}, self.Menu)
end

function PaladinTimerFu:OnEnable()
StaticPopupDialogs["New_Major_Version"] = {
	text = "There is a new version of the FuBar_xxTimerFu addons using the new api, it is called ClassTimer and is available from wowace",
	button1 = "Ok", 
	timeout = 0,
	whileDead = 1
} 
StaticPopup_Show("New_Major_Version")
for name, module in self:IterateModules() do
	self:ToggleModuleActive(module, true)
end
end

function PaladinTimerFu:OnDisable()
	for name, module in self:IterateModules() do
		self:ToggleModuleActive(module, false)
	end
end
 
--FuBar Stuff
PaladinTimerFu.OnMenuRequest = PaladinTimerFu.Menu
PaladinTimerFu.hasNoColor = true
PaladinTimerFu.hasIcon = "Interface\\Icons\\Spell_Holy_SealOfBlood"
PaladinTimerFu.defaultMinimapPosition = 180
PaladinTimerFu.cannotDetachTooltip = true
PaladinTimerFu.hideWithoutStandby = true 