﻿assert( PaladinTimerFu, "PaladinTimerFu not found!")
local parser = ParserLib:GetInstance("1.1")
local L = AceLibrary("AceLocale-2.2"):new("PaladinTimerFu")
local candy = AceLibrary("CandyBar-2.0")
local PaintChips = AceLibrary("PaintChips-2.0")

PaladinTimerFu_Bars = PaladinTimerFu:NewModule("Bars")
local minscale, maxscale = 0.25, 2
local surface = AceLibrary("Surface-1.0")

function PaladinTimerFu_Bars:OnInitialize()
self.settings = PaladinTimerFu:AcquireDBNamespace("Bars")
    PaladinTimerFu:RegisterDefaults("Bars", "profile", {
	--Bar Settings
	growup = false,
	scale = 1.0,
	texture = "BantoBar",
	darken = true,
	Reversed = false,
	Size = 11,
	name = true,
	safe = false,
	colors = {}
})	
PaladinTimerFu.Menu.args[L["Bar Options"]] = {
	type = "header",
	name = L["Bar Options"],
	order = 11,
}
PaladinTimerFu.Menu.args[L["Show Anchor"]] = {
	type = "execute",
	order = 12,
	name = L["Show Anchor"],
	desc = L["Show the bar anchor frame."],
	func = function() self:PaladinTimerFu_ShowAnchors() end,
}
PaladinTimerFu.Menu.args[L["Safe Mode"]] = {
	type = "toggle",
	order = 12,
	name = L["Safe Mode"],
	desc = L["Toggle safe mode"],
	get = function() return self.settings.profile.Safe end,
	set = function() self:Safe() end,
	map = {[true] = "Up", [false] = "Down"},
}
PaladinTimerFu.Menu.args[L["Visuals"]] = {
	type = "group",
	desc = L["Visual options for bars"],
	order = 13,
	name = L["Visuals"],
	args = {
		[L["Grow upwards"]] = {
			type = "toggle",
			order = 1,
			name = L["Grow upwards"],
			desc = L["Toggle bars grow upwards/downwards from anchor."],
			get = function() return self.settings.profile.growup end,
			set = function(v) self.settings.profile.growup = v end,
			message = "Bars now grow %2$s",
			current = "Bars now grow %2$s",
			map = {[true] = "Up", [false] = "Down"},
		},
		[L["Fill Bars"]] = {
			type = "toggle",
			order = 2,
			name = L["Fill Bars"],
			desc = L["Set the bars to fill."],
			get = function() return self.settings.profile.Reversed end,
			set = function() self.settings.profile.Reversed = not self.settings.profile.Reversed end,
		},
		[L["Text"]] = {
			type = "group",
			order = 3,
			name = L["Text"],
			desc = L["Options for text."],
			args = {	
				[L["Font Size"]] = {
					type = "range",
					name = L["Font Size"],
					desc = L["Set the bar font size."],
					min = 5,
					max = 20,
					step = 0.5,
					get = function() return self.settings.profile.Size end,
					set = function(v) self.settings.profile.Size = v end,
				},
				[L["Target"]] = {
					type = "toggle",
					name = L["Target"],
					desc = L["Toggle showing the target of the stun"],
					get = function() return self.settings.profile.name end,
					set = function() self.settings.profile.name = not self.settings.profile.name end,
				},
			},
		},
		[L["Scale"]] = {
			type = "range",
			order = 4,
			name = L["Scale"],
			desc = L["Set the bar scale."],
			min = 0.2,
			max = 2.0,
			step = 0.1,
			get = function() return self.settings.profile.scale end,
			set = function(v) self.settings.profile.scale = v end,
		},
		[L["Texture"]] = {
			type = "text",
			order = 5,
			name = L["Texture"],
			desc = L["Set the texture for the timer bars."],
			get = function() return self.settings.profile.texture end,
			set = function(v) self.settings.profile.texture = v end,
			validate = surface:List(),
		},
		[L["Colors"]] = {
			type = "group",
			order = 6,
			name = L["Colors"],
			desc = L["Colors of messages and bars."],
			args = {
				[L["Background"]] = {
					name = L["Background"],
					type = "color",
					desc = L["Change the bar background color."],
					hasAlpha = true,
					get = function() if self.settings.profile.colors.bgc then local _, r, g, b = PaintChips:GetRGBPercent(self.settings.profile.colors.bgc); return r, g, b, self.settings.profile.colors.bga else return  0, .5, .5, .5 end end,
					set = function(r, g, b, a) local hex = self:RGBToHex(r, g, b); PaintChips:RegisterHex(hex); self.settings.profile.colors.bgc = hex; self.settings.profile.colors.bga = a end,
				},
				[L["Text"]] = {
					name = L["Text"],
					type = "color",
					desc = L["Change the bar text color."],
					get = function() if self.settings.profile.colors.txtc then local _, r, g, b = PaintChips:GetRGBPercent(self.settings.profile.colors.txtc); return r, g, b else return  1, 1, 1 end end,
					set = function(r, g, b, a) local hex = self:RGBToHex(r, g, b); PaintChips:RegisterHex(hex); self.settings.profile.colors.txtc = hex end,
				},
				[L["Darken"]] = {
				name = L["Darken"],
				desc = L["Darken the bars as the time left decreases"],
				order = 1,
				type = 'toggle',
				get = function()
				        return self.settings.profile.darken
				    end,
				    set = function(v)
						self.settings.profile.darken = not self.settings.profile.darken
					end,
					map = { [false] = "Disabled", [true] = "Enabled" },
					},
				[L["Main Color"]] = {
				name = L["Main Color"],
				desc = L["Main color of bar if static color is set"],
				order = 2,
				type = "color",
				get = function() if self.settings.profile.colors.mainc then local _, r, g, b = PaintChips:GetRGBPercent(self.settings.profile.colors.mainc); return r, g, b else return  1, 1, 0 end end,
				set = function(r, g, b, a) local hex = self:RGBToHex(r, g, b); PaintChips:RegisterHex(hex); self.settings.profile.colors.mainc = hex end,
				disabled = function() return self.settings.profile.darken end, 
				},
			},
		},
	},
}
end

function PaladinTimerFu_Bars:RegHex(hex)
	if type(hex) == "string" then
		PaintChips:RegisterHex(hex)
	elseif type(hex) == "table" then
		for _,hexx in pairs(hex) do
			self:RegHex(hexx)
		end
	end
end

function PaladinTimerFu_Bars:OnEnable()
	if not surface:Fetch(self.settings.profile.texture) then self.settings.profile.texture = "BantoBar" end
	self:SetupFrames()
	if not self:IsEventRegistered("Surface_Registered") then
		self:RegisterEvent("Surface_Registered", function()
			PaladinTimerFu.Menu.args[L["Visuals"]].args[L["Texture"]].validate = surface:List()
		end)
	end
self:RegisterEvent("PLAYER_DEAD", "Death")
parser:RegisterEvent("PaladinTimerFu_Bars", "CHAT_MSG_COMBAT_HOSTILE_DEATH", self.DeathOther)
self:RegHex(self.settings.profile.colors)

end

function PaladinTimerFu_Bars:OnDisable()
parser:UnregisterAllEvents("PaladinTimerFu_Bars")
end

function PaladinTimerFu_Bars:Safe()
self.settings.profile.Safe = not self.settings.profile.Safe
if not self.settings.profile.Safe then
parser:RegisterEvent("self", "CHAT_MSG_COMBAT_HOSTILE_DEATH", self.DeathOther)
else
parser:UnregisterEvent("self", "CHAT_MSG_COMBAT_HOSTILE_DEATH")
end
end

function PaladinTimerFu_Bars:Death()
if candy.groups["PaladinTimerFuGroup"]==nil then return end
for _,v in ipairs(candy.groups["PaladinTimerFuGroup"].bars) do
	candy:StopCandyBar(v)
	end
end

function PaladinTimerFu_Bars:DeathOther(info)
for k,v in pairs(candy.handlers) do
   if string.find(v.text, info.victim) then candy:StopCandyBar(k) end
end
end

function PaladinTimerFu_Bars:RGBToHex(r, g, b)
	return format("%02x%02x%02x", r*255, g*255, b*255)
end

function PaladinTimerFu_Bars:PaladinTimerFu_ShowAnchors()
	self.frames.anchor:Show()
end

function PaladinTimerFu_Bars:PaladinTimerFu_HideAnchors()
	self.frames.anchor:Hide()
end

function PaladinTimerFu_Bars:PaladinTimerFu_StartBar(module, text, target, time, icon, otherc)
	if not text or not time then return end
	local id = "PaladinTimerFuBar "..text
	if self.settings.profile.Safe and (target ~= ParserLib_SELF or target == nil) then
		local i = 1
		while candy.handlers[id] do 
		i = i + 1
		id = "PaladinTimerFuBar "..text..i
		end	
	end
	local u = self.settings.profile.growup
	local d = self.settings.profile.darken
	if self.settings.profile.name and target and target ~= "" and target ~= ParserLib_SELF then text = text.." ("..target..")" end
	-- yes we try and register every time, we also set the point every time since people can change their mind midbar.
	module:RegisterCandyBarGroup("PaladinTimerFuGroup")
	module:SetCandyBarGroupPoint("PaladinTimerFuGroup", u and "BOTTOM" or "TOP", self.frames.anchor, u and "TOP" or "BOTTOM", 0, 0)
	module:SetCandyBarGroupGrowth("PaladinTimerFuGroup", u)
	
	bc, balpha, txtc = self.settings.profile.colors.bgc, self.settings.profile.colors.bga, self.settings.profile.colors.txtc
	if d then 
		module:RegisterCandyBar(id, time, text, icon, "Green", "Red")
	else
		module:RegisterCandyBar(id, time, text, icon, self.settings.profile.colors.mainc)
	end
	module:SetCandyBarFontSize(id, self.settings.profile.Size)
	module:SetCandyBarReversed(id, self.settings.profile.Reversed)
	module:RegisterCandyBarWithGroup(id, "PaladinTimerFuGroup")
	module:SetCandyBarTexture( id, surface:Fetch( self.settings.profile.texture) )
	if bc then module:SetCandyBarBackgroundColor(id, bc, balpha) end
	if txtc then module:SetCandyBarTextColor(id, txtc) end

	module:SetCandyBarScale(id, self.settings.profile.scale or 1)
	module:SetCandyBarFade(id, .5)
	module:StartCandyBar(id, true)
end

function PaladinTimerFu_Bars:PaladinTimerFu_StopBar(module, text, text2)
	if (not text or self.settings.profile.Safe) and text2 ~= ParserLib_SELF then return end
	module:UnregisterCandyBar("PaladinTimerFuBar "..text)
	module:UnregisterCandyBar("PaladinTimerFuBar "..text.." ("..text2..")")
end

function PaladinTimerFu_Bars:SetScale(msg, supressreport)
	local scale = tonumber(msg)
	if scale and scale >= minscale and scale <= maxscale then
		self.settings.profile.scale = scale
		if not supressreport then PaladinTimerFu:Print("Scale is set to %s", scale) end
	end
end

function PaladinTimerFu_Bars:ToggleUp(supressreport)
	self.settings.profile.growup = not self.settings.profile.growup
	local t = self.settings.profile.growup
	if not supressreport then PaladinTimerFu:Print("Bars now grow %s", (t and "Up" or "Down")) end
end


function PaladinTimerFu_Bars:SetupFrames()
	local f, t

	f, _, _ = GameFontNormal:GetFont()

	self.frames = {}
	self.frames.anchor = CreateFrame("Frame", "PaladinTimerFuAnchor", UIParent)
	self.frames.anchor.owner = self
	self.frames.anchor:Hide()

	self.frames.anchor:SetWidth(175)
	self.frames.anchor:SetHeight(75)
	self.frames.anchor:SetBackdrop({
		bgFile = "Interface\\DialogFrame\\UI-DialogBox-Background", tile = true, tileSize = 16,
		edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", edgeSize = 16,
		insets = {left = 4, right = 4, top = 4, bottom = 4},
		})
	self.frames.anchor:SetBackdropBorderColor(.5, .5, .5)
	self.frames.anchor:SetBackdropColor(0,0,0)
	self.frames.anchor:ClearAllPoints()
	self.frames.anchor:SetPoint("CENTER", UIParent, "CENTER", 0, 0)
	self.frames.anchor:EnableMouse(true)
	self.frames.anchor:RegisterForDrag("LeftButton")
	self.frames.anchor:SetMovable(true)
	self.frames.anchor:SetScript("OnDragStart", function() this:StartMoving() end)
	self.frames.anchor:SetScript("OnDragStop", function() this:StopMovingOrSizing() this.owner:SavePosition() end)

	self.frames.cfade = self.frames.anchor:CreateTexture(nil, "BORDER")
	self.frames.cfade:SetWidth(169)
	self.frames.cfade:SetHeight(25)
	self.frames.cfade:SetTexture("Interface\\ChatFrame\\ChatFrameBackground")
	self.frames.cfade:SetPoint("TOP", self.frames.anchor, "TOP", 0, -4)
	self.frames.cfade:SetBlendMode("ADD")
	self.frames.cfade:SetGradientAlpha("VERTICAL", .1, .1, .1, 0, .25, .25, .25, 1)
	self.frames.anchor.Fade = self.frames.fade

	self.frames.cheader = self.frames.anchor:CreateFontString(nil,"OVERLAY")
	self.frames.cheader:SetFont(f, 14)
	self.frames.cheader:SetWidth(150)
	self.frames.cheader:SetText("Bars")
	self.frames.cheader:SetTextColor(1, .8, 0)
	self.frames.cheader:ClearAllPoints()
	self.frames.cheader:SetPoint("TOP", self.frames.anchor, "TOP", 0, -10)

	self.frames.leftbutton = CreateFrame("Button", nil, self.frames.anchor)
	self.frames.leftbutton.owner = self
	self.frames.leftbutton:SetWidth(40)
	self.frames.leftbutton:SetHeight(25)
	self.frames.leftbutton:SetPoint("RIGHT", self.frames.anchor, "CENTER", -10, -15)
	self.frames.leftbutton:SetScript( "OnClick", function()  self:Test() end )

	t = self.frames.leftbutton:CreateTexture()
	t:SetWidth(50)
	t:SetHeight(32)
	t:SetPoint("CENTER", self.frames.leftbutton, "CENTER")
	t:SetTexture("Interface\\Buttons\\UI-Panel-Button-Up")
	t:SetTexCoord(0, 0.625, 0, 0.6875)
	self.frames.leftbutton:SetNormalTexture(t)

	t = self.frames.leftbutton:CreateTexture(nil, "BACKGROUND")
	t:SetTexture("Interface\\Buttons\\UI-Panel-Button-Down")
	t:SetTexCoord(0, 0.625, 0, 0.6875)
	t:SetAllPoints(self.frames.leftbutton)
	self.frames.leftbutton:SetPushedTexture(t)

	t = self.frames.leftbutton:CreateTexture()
	t:SetTexture("Interface\\Buttons\\UI-Panel-Button-Highlight")
	t:SetTexCoord(0, 0.625, 0, 0.6875)
	t:SetAllPoints(self.frames.leftbutton)
	t:SetBlendMode("ADD")
	self.frames.leftbutton:SetHighlightTexture(t)
	self.frames.leftbuttontext = self.frames.leftbutton:CreateFontString(nil,"OVERLAY")
	self.frames.leftbuttontext:SetFontObject(GameFontHighlight)
	self.frames.leftbuttontext:SetText("Test")
	self.frames.leftbuttontext:SetAllPoints(self.frames.leftbutton)

	self.frames.rightbutton = CreateFrame("Button", nil, self.frames.anchor)
	self.frames.rightbutton.owner = self
	self.frames.rightbutton:SetWidth(40)
	self.frames.rightbutton:SetHeight(25)
	self.frames.rightbutton:SetPoint("LEFT", self.frames.anchor, "CENTER", 10, -15)
	self.frames.rightbutton:SetScript( "OnClick", function() self:PaladinTimerFu_HideAnchors() end )

	t = self.frames.rightbutton:CreateTexture()
	t:SetWidth(50)
	t:SetHeight(32)
	t:SetPoint("CENTER", self.frames.rightbutton, "CENTER")
	t:SetTexture("Interface\\Buttons\\UI-Panel-Button-Up")
	t:SetTexCoord(0, 0.625, 0, 0.6875)
	self.frames.rightbutton:SetNormalTexture(t)

	t = self.frames.rightbutton:CreateTexture(nil, "BACKGROUND")
	t:SetTexture("Interface\\Buttons\\UI-Panel-Button-Down")
	t:SetTexCoord(0, 0.625, 0, 0.6875)
	t:SetAllPoints(self.frames.rightbutton)
	self.frames.rightbutton:SetPushedTexture(t)

	t = self.frames.rightbutton:CreateTexture()
	t:SetTexture("Interface\\Buttons\\UI-Panel-Button-Highlight")
	t:SetTexCoord(0, 0.625, 0, 0.6875)
	t:SetAllPoints(self.frames.rightbutton)
	t:SetBlendMode("ADD")
	self.frames.rightbutton:SetHighlightTexture(t)
	self.frames.rightbuttontext = self.frames.rightbutton:CreateFontString(nil,"OVERLAY")
	self.frames.rightbuttontext:SetFontObject(GameFontHighlight)
	self.frames.rightbuttontext:SetText("Close")
	self.frames.rightbuttontext:SetAllPoints(self.frames.rightbutton)

	self:RestorePosition()
end

function PaladinTimerFu_Bars:SavePosition()
	local f = self.frames.anchor
	local s = f:GetEffectiveScale()

	self.settings.profile.posx = f:GetLeft() * s
	self.settings.profile.posy = f:GetTop() * s
end

function PaladinTimerFu_Bars:RestorePosition()
	local x = self.settings.profile.posx
	local y = self.settings.profile.posy

	if not x or not y then return end

	local f = self.frames.anchor
	local s = f:GetEffectiveScale()

	f:ClearAllPoints()
	f:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT", x / s, y / s)
end


function PaladinTimerFu_Bars:Test()
self:PaladinTimerFu_StartBar(self, L["Testing..."], nil, 15)
self:PaladinTimerFu_StartBar(self, L["Wait! a Test!"], nil, 5)
end 