OmenFu = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "FuBarPlugin-2.0")
local Threat = AceLibrary("Threat-2.0")
local tablet = AceLibrary("Tablet-2.0")

local OmenFuText = "OmenFu"
local ThreatText = OmenFuText
local ThreatColor = {
	below100 = "ff00ff00",
	over100	 = "ff00ffff",
	aggro	 = "ffff0000",
}
local LastThreatText = ""

function OmenFu:OnEnable()
	self:RegisterEvent("PLAYER_TARGET_CHANGED")
	self:ScheduleRepeatingEvent(self.DataUpdate, 0.25, self)
end

function OmenFu:OnDisable()
	self:UnRegisterEvent("PLAYER_TARGET_CHANGED")
	self:CancelScheduledEvent(self.DataUpdate)
end

function OmenFu:PLAYER_TARGET_CHANGED()
	self:DataUpdate()
end

function OmenFu:DataUpdate()
	ThreatText = OmenFuText
	if UnitName("target") and UnitCanAttack("player", "target") and not (UnitIsDead("target") or UnitIsFriend("player", "target") or UnitPlayerControlled("target"))
	then
		TankThreat = Threat:GetThreat(UnitGUID("targettarget"), UnitGUID("target") )
		if TankThreat ~= 0
		then
			MyThreat = floor(Threat:GetThreat(UnitGUID("player"), UnitGUID("target")) * 100 / TankThreat )
			if UnitGUID("targettarget") == UnitGUID("player")
			then
				ThreatText = string.format("|c%s%s : AGGRO|r", ThreatColor.aggro, UnitName("target") )
			else if MyThreat > 100
			then
				ThreatText = string.format("|c%s%s : %d %%|r", ThreatColor.over100, UnitName("target"), MyThreat )
			else
				ThreatText = string.format("|c%s%s : %d %%|r", ThreatColor.below100, UnitName("target"), MyThreat )
			end
			end
		end
	end
	if LastThreatText ~= ThreatText
	then
		self:Update()
	end
end

function OmenFu:OnTextUpdate()
	self:SetText(ThreatText)
	LastThreatText = ThreatText
end

function OmenFu:OnTooltipUpdate()
	local cat = tablet:AddCategory(
		'columns', 1,
		'child_textR', 1,
		'child_textG', 1,
		'child_textB', 0
	)
	cat:AddLine(
		'text', ThreatText == OmenFuText and "No Target" or ThreatText
	)
end
