local class = select(2, UnitClass("player"))
if class ~= "ROGUE" then
	-- TODO: Figure out if addons can be disabled per char, if so do that here
	-- DisableAddOn("FuBar_NinjutFu") -- Needs more testing. Sometimes disables for all chars.
	return
end

local AceLibrary = AceLibrary
local L = AceLibrary("AceLocale-2.2"):new("NinjutFu")
local crayon = AceLibrary("Crayon-2.0")
local dewdrop = AceLibrary("Dewdrop-2.0")
local tablet = AceLibrary("Tablet-2.0")
local SM = LibStub:GetLibrary("LibSharedMedia-3.0", true)

if SM then
	SM:Register("sound", "Flute", [[Sound\Spells\FluteRun.wav]])
end

local str_find = string.find
local select = select
local tonumber = tonumber

local NinjutFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceDB-2.0", "AceEvent-2.0", "Sink-1.0")
_G.NinjutFu = NinjutFu
NinjutFu.hasIcon = "Interface\\Icons\\Ability_Vanish"

NinjutFu:RegisterDB("NinjutFuDB")
NinjutFu:RegisterDefaults("profile", {
	threshCount = 20,
	teaCount = 10,
	buyFlash = true,
	showFlash = true,
	showTea = true,
	compactMode = false,
	showTipTitles = true,
	tooltipSkipCategories = "",
	highend = false,
	items = "all",
	warnPoisonExpire = true,
	warnPlaySound = true,
	warnSound = [[Sound\Spells\FluteRun.wav]],
})

-- A long string with itemids of all supported items sorted into categories in the format
-- ";Category1:1234:1235;Category2:2345:2346:2347;"
--[[
local items = ";Reagents:5140" -- Flash Powder
	.. ";Energy:7676:27553" -- Thistle Tea and Crimson Steer
	.. ";Poisons"
	.. ":21835" -- Anastethic
	.. ":3775:3776" -- Crippling
	.. ":2892:2893:8984:8985:20844:22053:22054" -- Deadly Poison
	.. ":6947:6949:6950:8926:8927:8928:21927" -- Instant Poison
	.. ":5237:6951:9186" -- Mind-numbing
	.. ":10918:10920:10921:10922:22055" -- Wound Poison
	.. ";Stones"
	-- Rough Sharpening Stone, Rough Weightstone, Coarse Sharpening Stone, Coarse Weightstone, Heavy Sharpening Stone, Heavy Weightstone, 
	-- Solid Sharpening Stone, Solid Weightstone, Dense Sharpening Stone, Dense Weightstone, Consecrated Sharpening Stone, 
	-- Elemental Sharpening Stone, Fel Sharpening Stone, Fel Weightstone, Adamantite Sharpening Stone, Adamantite Weightstone
	-- in that order...
	.. ":2862:3239:2863:3240:2871:3241:7964:7965:12404:12643:23122:18262:23528:28420:23529:28421;"
]]--
-- Same string as commented above. Better to assign it in one row.
local items = ";Reagents:5140;Energy:7676:27553;Poisons:21835:3775:3776:2892:2893:8984:8985:20844:22053:22054:6947:6949:6950:8926:8927:8928:21927:5237:6951:9186:10918:10920:10921:10922:22055;Stones:2862:3239:2863:3240:2871:3241:7964:7965:12404:12643:23122:18262:23528:28420:23529:28421;"

-- A few functions using the string items above

local _ -- Don't want to use the global...

-- Returns the category for a given itemid
-- (not used anywhere atm, just wrote it while I had luas magic patterns fresh in the head :P)
--[[
function NinjutFu:GetCategoryForItem(itemid)
	local found, category
	found, _, category = string.find(items, ";([^:]+)[:%d]+:"..itemid.."[:;]")
	return found ~= nil and category or nil
end
]]--

-- To iterate all categories of items:
-- for category in NinjutFu:IterItemCategories() do
function NinjutFu:IterItemCategories()
	local pos = 0
	return function()
		local category
		pos, _, category = str_find(items, ";([^:]+):", pos+1)
		return pos ~= nil and category or nil
	end
end

-- To iterate all itemids in items:
-- for itemid in NinjutFu:IterAllItems() do
function NinjutFu:IterAllItems()
	local pos = 0
	return function()
		local item
		pos, _, item = str_find(items, ":(%d+)[:;]", pos+1)
		return pos ~= nil and tonumber(item) or nil
	end
end

-- To iterate all itemids in for example the category "Poisons":
-- for itemid in NinjutFu:IterCategoryItems("Poisons") do
function NinjutFu:IterCategoryItems(category)
	local pos = 0
	local items = select(3, str_find(items, ";"..category.."(:[%d:]+;)"))
	return function()
		local item
		pos, _, item = str_find(items, ":(%d+)[:;]", pos+1)
		return pos ~= nil and tonumber(item) or nil
	end
end

function NinjutFu:PopulateItemCounts()
	local set = self.db.profile.items

	self.itemCounts = {}

	if set == "all" then
		for itemid in self:IterAllItems() do
			self.itemCounts[itemid] = 0
		end
		return
	elseif set == "none" then
		return
	elseif set == "he60" then
		set = "5140 7676 3775 3776 20844 8928 9186 10922 12404 12643 23122 18262"
	elseif set == "he70" then
		set = "5140 7676 27553 21835 3775 3776 22054 21927 9186 22055 23528 28420 23529 28421"
	end

	local itemid
	local pos = 0
	while true do
		pos, itemid = select(2, str_find(set, "^ *([^%s]+) *", pos + 1))
		if not itemid then
			break
		end
		self.itemCounts[tonumber(itemid)] = 0
	end
end

function NinjutFu:OnInitialize()
end

function NinjutFu:OnEnable()
	self:PopulateItemCounts()

	if self.poisonSpell == nil then
		self:RegisterEvent("PLAYER_LOGIN", "GetPoisonSpell")
	end
	self:RegisterBucketEvent("BAG_UPDATE", 0.5, "Update")
	self:RegisterEvent("MERCHANT_SHOW", "RefillFlash")
	self:PoisonWatchChanged()
end

function NinjutFu:OnDisable()
	self.itemCounts = nil
end

function NinjutFu:GetPoisonSpell()
	if GetLocale() == "enUS" then
		self.poisonSpell = "Poisons"
		return true
	else
		-- Search the spellbook for the Poisons-button
		local numSpells = select(4, GetSpellTabInfo(1)) -- Only need to search the General-tab
		for i = 1, numSpells do
			local texture = GetSpellTexture(i, BOOKTYPE_SPELL)
			if str_find(texture, "Trade_BrewPoison") then
				self.poisonSpell = GetSpellName(i, BOOKTYPE_SPELL) -- Get the localized spellname
				self:UnregisterEvent("PLAYER_LOGIN")
				return true
			end
		end
	end
	return nil
end

function NinjutFu:OnDataUpdate()
	self:CountItems()
end

function NinjutFu:OnTextUpdate()
	local p = self.db.profile

	if p.showFlash and p.showTea then
		self:SetText(self:Colorize(self.itemCounts[5140], p.threshCount) .. (p.compactMode and "/" or "F ") .. self:Colorize(self.itemCounts[7676], 10) .. (p.compactMode and "" or "B"))
	elseif p.showFlash then
		self:SetText(self:Colorize(self.itemCounts[5140], p.threshCount) .. (p.compactMode and "" or "F"))
	elseif p.showTea then
		self:SetText(self:Colorize(self.itemCounts[7676], 10) .. (p.compactMode and "" or "B"))
	else
		self:SetText(self:GetTitle())
	end
end

function NinjutFu:Colorize(count, stacksize)
	return crayon:Colorize(crayon:GetThresholdHexColor(count, stacksize/4, stacksize/2, stacksize*0.65, stacksize*0.8, stacksize*0.95), count)
end

local linktext
local function GetItemID(bag, slot)
	linktext = GetContainerItemLink(bag, slot)
	if linktext then
		local itemid = select(3, str_find(linktext, "item:(%d+):"))
		return tonumber(itemid)
	else
		return nil
	end
end

local itemid, count
function NinjutFu:CountItems()
	local itemCounts = self.itemCounts

	-- Reset all counts to zero
	for itemid in pairs(itemCounts) do
		itemCounts[itemid] = 0
	end

	-- Iterate all bagslots
	for i = NUM_BAG_FRAMES, 0, -1 do
		for j = GetContainerNumSlots(i), 1, -1 do
			itemid = GetItemID(i, j)
			if (itemCounts[itemid]) then
				count = select(2, GetContainerItemInfo(i, j))
				itemCounts[itemid] = itemCounts[itemid] + count
			end
		end
	end
end

function NinjutFu:OnClick()
	if self.poisonSpell == nil then
		-- If the spell wasn't found at login, try again on click
		if self:GetPoisonSpell() then CastSpellByName(self.poisonSpell) end
	else
		self.GetPoisonSpell = nil --Don't need it anymore :P
		CastSpellByName(self.poisonSpell)
	end
end

function NinjutFu:RefillFlash()
	if self.db.profile.buyFlash then
		local numItems = GetMerchantNumItems()
		local currentCount = self.itemCounts[5140]
		local diff = self.db.profile.threshCount - currentCount
		if (diff > 0) then
			local link
			for i=0, numItems do
				link = GetMerchantItemLink(i)
				if (link) then
					itemid = select(3, str_find(link, "item:(%d+):"))
					if tonumber(itemid) == 5140 then
						while (diff > 20) do
							BuyMerchantItem(i, 20)
							diff = diff - 20
						end
						BuyMerchantItem(i, diff)
					end
				end
			end
		end
	end
end

--local function print(text)
--	DEFAULT_CHAT_FRAME:AddMessage("|cffffff78NinjutFu:|r " .. text)
--end

function NinjutFu:PoisonWatchChanged()
	if self.db.profile.warnPoisonExpire then
		if AceLibrary:HasInstance("SpecialEvents-Aura-2.0") or LoadAddon("SpecialEvents-Aura-2.0") then
			self:RegisterEvent("SpecialEvents_PlayerItemBuffLost", "ItemBuffLost")
			self:RegisterEvent("SpecialEvents_PlayerItemBuffGained", "ItemBuffGained")
			self:RegisterEvent("PLAYER_LEAVING_WORLD", "PauseWarning")
			self:RegisterEvent("PLAYER_ENTERING_WORLD", "DelayResume")
		else
			-- Forgot that NinjutFu don't use AceConsole -.-
			-- Ghetto-print ftw
			DEFAULT_CHAT_FRAME:AddMessage("|cffffff78NinjutFu:|r " .. L["Missing library SpecialEvents-Aura-2.0. Won't be able to warn when poisons expire without it."])
		end
	elseif self:IsEventScheduled("SpecialEvents_PlayerItemBuffLost") then
		self:UnregisterEvent("SpecialEvents_PlayerItemBuffLost")
		self:UnregisterEvent("SpecialEvents_PlayerItemBuffGained")
		self:UnregisterEvent("PLAYER_LEAVING_WORLD")
		self:UnregisterEvent("PLAYER_ENTERING_WORLD")
	end
end

local paused = false
function NinjutFu:PauseWarning()
	paused = true
end

function NinjutFu:DelayResume()
	self:ScheduleEvent(self.ResumeWarning, 0.5)
end

function NinjutFu:ResumeWarning()
	paused = false
end

local shortMHBuff = false
local shortOHBuff = false
function NinjutFu:ItemBuffLost(name, rank, mh)
	if paused then return end
	if mh then
		if shortMHBuff then
			shortMHBuff = false
			return
		end
	else
		if shortOHBuff then
			shortOHBuff = false
			return
		end
	end
	self:Pour(L["%s poison faded"]:format(L[mh and "MH" or "OH"]), 1, 0, 0)
	if self.db.profile.warnPlaySound then
		PlaySoundFile(self.db.profile.warnSound)
	end
--	print(string.format("%s lost on %s", name, L[mh and "MH" or "OH"]))
end

function NinjutFu:ItemBuffGained(name, rank, mh)
	if paused then return end
	local timeleft = select(mh and 2 or 5, GetWeaponEnchantInfo())
--	print(string.format("%s gained on %s", name, L[mh and "MH" or "OH"]))
	if timeleft <= 10000 then
		if mh then
			shortMHBuff = true
		else
			shortOHBuff = true
		end
	end
end

---------------------------------------
-- Tooltip
---------------------------------------
function NinjutFu:OnTooltipUpdate()
	local cat = tablet:AddCategory(
		'columns', 2,
		'child_textR', 1,
		'child_textG', 1,
		'child_textB', 1,
		'child_textR2', 1,
		'child_textG2', 1,
		'child_textB2', 1
	)
	
	local p = self.db.profile
	local itemCounts = self.itemCounts
	for category in self:IterItemCategories() do
		local first = true
		if str_find(p.tooltipSkipCategories, category .. ":") == nil then
			for itemid in self:IterCategoryItems(category) do
				if itemCounts[itemid] and itemCounts[itemid] ~= 0 then
					if first and p.showTipTitles then
						cat:AddLine('text', crayon:Green(L[category]))
						first = false
					end
					cat:AddLine('text', GetItemInfo(itemid), 'text2', self:Colorize(itemCounts[itemid], (itemid == 5140) and p.threshCount or (itemid == 7676 and 10 or 20)))
				end
			end
			if not first then
				cat:AddLine()
			end
		end
	end
	tablet:SetHint(L["Hint"])
end

---------------------------------------
-- Menu
---------------------------------------
function NinjutFu:OnMenuRequest(level, value, inTooltip, valueN_1, valueN_2, valueN_3, valueN_4)
	if level == 1 then
		dewdrop:AddLine(
			'text', L["Options"],
			'tooltipTitle', L["Options"],
			'tooltipText', L["OptionsDesc"],
			'hasArrow', true,
			'value', "options"
		)
		dewdrop:AddLine()
	elseif level == 2 then
		if value == "options" then
			dewdrop:AddLine(
				'text', L["buyFlash"],
				'tooltipTitle', L["buyFlash"],
				'tooltipText', L["buyFlashDesc"],
				'checked', NinjutFu.db.profile.buyFlash,
				'func', function() NinjutFu.db.profile.buyFlash = not NinjutFu.db.profile.buyFlash end,
				'hasArrow', true,
				'hasSlider', true,
				'sliderMax', 100,
				'sliderValue', NinjutFu.db.profile.threshCount,
				'sliderStep', 5,
				'sliderFunc', function(v) NinjutFu.db.profile.threshCount = v end
			)
			dewdrop:AddLine(
				'text', L["warnPoisonExpire"],
				'tooltipTitle', L["warnPoisonExpire"],
				'tooltipText', L["warnPoisonExpireDesc"],
				'checked', NinjutFu.db.profile.warnPoisonExpire,
				'func', function() NinjutFu.db.profile.warnPoisonExpire = not NinjutFu.db.profile.warnPoisonExpire; NinjutFu:PoisonWatchChanged() end,
				'hasArrow', true,
				'value', "warnPoisonExpire"
			)
			dewdrop:AddLine()
			dewdrop:AddLine(
				'text', L["Text Options"],
				'tooltipTitle', L["Text Options"],
				'tooltipText', L["TextOptsDesc"],
				'isTitle', true
			)
			dewdrop:AddLine(
				'text', L["Show Flash Powder"],
				'tooltipTitle', L["Show Flash Powder"],
				'tooltipText', L["ShowFlashDesc"],
				'checked', NinjutFu.db.profile.showFlash,
				'func', function() NinjutFu.db.profile.showFlash = not NinjutFu.db.profile.showFlash; NinjutFu:UpdateText() end
			)
			dewdrop:AddLine(
				'text', L["Show Thistle Tea"],
				'tooltipTitle', L["Show Thistle Tea"],
				'tooltipText', L["ShowTeaDesc"],
				'checked', NinjutFu.db.profile.showTea,
				'func', function() NinjutFu.db.profile.showTea = not NinjutFu.db.profile.showTea; NinjutFu:UpdateText() end
			)
			dewdrop:AddLine(
				'text', L["Compact Mode"],
				'tooltipTitle', L["Compact Mode"],
				'tooltipText', L["CompactModeDesc"],
				'checked', NinjutFu.db.profile.compactMode,
				'func', function() NinjutFu.db.profile.compactMode = not NinjutFu.db.profile.compactMode; NinjutFu:UpdateText() end
			)
			dewdrop:AddLine()
			dewdrop:AddLine(
				'text', L["Tooltip Options"],
				'tooltipTitle', L["Tooltip Options"],
				'tooltipText', L["TooltipOptsDesc"],
				'isTitle', true
			)
			dewdrop:AddLine(
				'text', L["Show Titles"],
				'tooltipTitle', L["Show Titles"],
				'tooltipText', L["ShowTitlesDesc"],
				'checked', NinjutFu.db.profile.showTipTitles,
				'func', function() NinjutFu.db.profile.showTipTitles = not NinjutFu.db.profile.showTipTitles; NinjutFu:UpdateTooltip() end
			)
			for category in NinjutFu:IterItemCategories() do
				dewdrop:AddLine(
					'text', string.format(L["Show %s"], L[category]),
					'tooltipTitle', string.format(L["Show %s"], L[category]),
					'tooltipText', string.format(L["ShowCatDesc"], L[category]),
					'checked', not str_find(NinjutFu.db.profile.tooltipSkipCategories, category .. ":"),
					'func', function()
							if str_find(NinjutFu.db.profile.tooltipSkipCategories, category .. ":") == nil then
								NinjutFu.db.profile.tooltipSkipCategories = NinjutFu.db.profile.tooltipSkipCategories .. category .. ":"
							else
								NinjutFu.db.profile.tooltipSkipCategories = string.gsub(NinjutFu.db.profile.tooltipSkipCategories, category .. ":", "")
							end
						end
				)
			end
		end
	elseif level == 3 then
		if value == "warnPoisonExpire" then
			if not SM then
				-- Check if SharedMedia have been loaded
				SM = LibStub:GetLibrary("LibSharedMedia-3.0", true)
				if SM then
					SM:Register("sound", "Flute", [[Sound\Spells\FluteRun.wav]])
				end
			end
			dewdrop:AddLine(
				'text', L["Play Sound"],
				'tooltipTitle', L["Play Sound"],
				'tooltipText', L["PlaySoundDesc"],
				'checked', NinjutFu.db.profile.warnPlaySound,
				'func', function() NinjutFu.db.profile.warnPlaySound = not NinjutFu.db.profile.warnPlaySound end,
				'hasArrow', SM and NinjutFu.db.profile.warnPlaySound,
				'value', "warnPlaySound"
			)
			if not SM and NinjutFu.db.profile.warnSound ~= [[Sound\Spells\FluteRun.wav]] then
				dewdrop:AddLine(
					'text', L["Reset Sound"],
					'tooltipTitle', L["Reset Sound"],
					'tooltipText', L["ResetSoundDesc"],
					'func', function() NinjutFu.db.profile.warnSound = [[Sound\Spells\FluteRun.wav]] end
				)
			end
		end
	elseif level == 4 then
		if value == "warnPlaySound" then
			for k, v in ipairs(SM:List("sound")) do
				dewdrop:AddLine(
					'text', v,
					'tooltipTitle', v,
					'tooltipText', L["Ctrl-Click to listen"],
					'checked', NinjutFu.db.profile.warnSound == SM:Fetch("sound", v),
					'func', function()
						PlaySoundFile(SM:Fetch("sound", v))
						if not IsControlKeyDown() then
							NinjutFu.db.profile.warnSound = SM:Fetch("sound", v)
						end
					end
				)
			end
		end
	end
end

