FuBar_NameToggle = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceDB-2.0")
FuBar_NameToggle:RegisterDB("FuBar_NameToggleDB")
FuBar_NameToggle.hasIcon = "Interface\\Icons\\Ability_Hunter_Pathfinding"
FuBar_NameToggle.clickableTooltip = true

local tablet = AceLibrary("Tablet-2.0")
local dewdrop = AceLibrary("Dewdrop-2.0")
local L = AceLibrary("AceLocale-2.2"):new("FuBar_NameToggleFu")
L:RegisterTranslations("enUS", function()
	return {
		["menupnames"] = "Show player names",
		["menupguild"] = "Show player guilds",
		["menuptitle"] = "Show player titles",
		["menunpcnames"] = "Show NPC names",
		["menunpcplates"] = "Show NPC nameplates",
		["menuownname"] = "Show own name",
		["menufriendlyplates"] = "Show friendly nameplates",
		["menufriendlypetnames"] = "Show friendly pets",
		["menufriendlycreations"] = "Show friendly creations",
		["menuenemyplayernames"] = "Show enemy player names",
		["menuenemypetnames"] = "Show enemy pet names",
		["menuenemycreations"] = "Show enemy creations",
		["menucompanions"] = "Show companions",

		["tipshown"] = "|cff00ff00Shown",
		["tiphidden"] = "|cffff0000Hidden",
		["tipplayers"] = "Players",
		["tipnpcs"] = "NPCs",
		["tipnames"] = "Names:",
		["tipguild"] = "Guilds:",
		["tiptitle"] = "Titles:",
		["tipplates"] = "Nameplates:",
		["tipownname"] = "Own Name:",
		["tipfriendlyplates"] = "Friendly Nameplates:",
		["tipfriendlypetnames"] = "Friendly Pet Names:",
		["tipfriendlycreations"] = "Friendly Creations:",
		["tipenemyplayernames"] = "Enemy Names:",
		["tipenemypetnames"] = "Enemy Pet Names:",
		["tipenemycreations"] = "Enemy Creations:",
		["tipcompanions"] = "Companions:",

		["hint"] = "Click to toggle player names.\nShift-Click to toggle NPC names.\nAlt-Click to toggle enemy names.\nCtrl-Click to toggle own name.",
	}
end)

L:RegisterTranslations("deDE", function()
	return {
		["menupnames"] = "Zeige Spielernamen",
		["menupguild"] = "Zeige Spielergilden",
		["menuptitle"] = "Zeige Spielertitel",
		["menunpcnames"] = "Zeige NSC-Namen",
		["menunpcplates"] = "Zeige NSC-Namensschilder",
		["menuownname"] = "Zeige eigenen Namen",
		["menufriendlyplates"] = "Zeige befreundete Namensschilder",

		["tipshown"] = "|cff00ff00Angezeigt",
		["tiphidden"] = "|cffff0000Versteckt",
		["tipplayers"] = "Spieler",
		["tipnpcs"] = "NSCs",
		["tipnames"] = "Namen:",
		["tipguild"] = "Gilden:",
		["tiptitle"] = "Titel:",
		["tipplates"] = "Namensschilder:",
		["tipownname"] = "Eigener Name:",
		["tipfriendlyplates"] = "Befreundete Namensschilder:",

		["hint"] = "Klicken um Spielernamen ein/aus zu schalten.\nShift-Klicken um NSC-Namen ein/aus zu schalten.\nStrg-Klicken um eigenen Namen ein/aus zu schalten.",
	}
end)

L:RegisterTranslations("frFR", function()
	return {
		["menupnames"] = "Afficher le nom des joueurs",
		["menupguild"] = "Afficher la guilde des joueurs",
		["menuptitle"] = "Afficher le titre des joueurs",
		["menunpcnames"] = "Afficher le nom des PNJ",
		["menunpcplates"] = "Afficher les barres de vie des PNJ",
		["menuownname"] = "Afficher son nom",
		["menufriendlyplates"] = "Afficher les barres de vie des alli\195\169s",

		["tipshown"] = "|cff00ff00Affich\195\169",
		["tiphidden"] = "|cffff0000Cach\195\169",
		["tipplayers"] = "Joueurs",
		["tipnpcs"] = "PNJs",
		["tipnames"] = "Noms:",
		["tipguild"] = "Guildes:",
		["tiptitle"] = "Titres:",
		["tipplates"] = "Barres de vie:",
		["tipownname"] = "Son nom:",
		["tipfriendlyplates"] = "Barres de vie des alli\195\169s:",

		["hint"] = "Cliquer pour afficher/masquer le nom des joueurs.\nMaj-Clic pour afficher/masquer le nom des PNJs.\nCtrl-Clic pour afficher/masquer son nom.",
	}
end)

L:RegisterTranslations("esES", function()
	return {
		["menupnames"] = "Mostrar nombres de jugadores",
		["menupguild"] = "Mostrar hermandades de jugadores",
		["menuptitle"] = "Mostrar t\195\173tulos de jugadores",
		["menunpcnames"] = "Mostrar nombres de PNJs",
		["menunpcplates"] = "Mostrar placas identificativas de PNJs",
		["menuownname"] = "Mostrar el propio nombre",
		["menufriendlyplates"] = "Mostrar placas identificativas de aliados",

		["tipshown"] = "|cff00ff00Mostrado",
		["tiphidden"] = "|cffff0000Oculto",
		["tipplayers"] = "Jugadores",
		["tipnpcs"] = "PNJs",
		["tipnames"] = "Nombres:",
		["tipguild"] = "Hermandades:",
		["tiptitle"] = "T\195\173tulos:",
		["tipplates"] = "Placas Identificativas:",
		["tipownname"] = "Tu Nombre:",
		["tipfriendlyplates"] = "Placas Identificativas de Aliados:",

		["hint"] = "Clic para conmutar los nombres de jugadores.\nClic+May\195\186sculas para conmutar nombres de PNJ.\nClic+Ctrl para conmutar tu nombre.",
	}
end)

function FuBar_NameToggle:OnTooltipUpdate()
	local cat = tablet:AddCategory("text", L["tipplayers"], "columns", 2)
	cat:AddLine(
		"text", L["tipnames"],
		"text2", GetCVar("UnitNameFriendlyPlayerName") == "1" and L["tipshown"] or L["tiphidden"],
		"func", "ToggleCVar",
		"arg1", self,
		"arg2", "UnitNameFriendlyPlayerName"
	)
	cat:AddLine(
		"text", L["tipguild"],
		"text2", GetCVar("UnitNamePlayerGuild") == "1" and L["tipshown"] or L["tiphidden"],
		"func", "ToggleCVar",
		"arg1", self,
		"arg2", "UnitNamePlayerGuild"
	)
	cat:AddLine(
		"text", L["tiptitle"],
		"text2", GetCVar("UnitNamePlayerPVPTitle") == "1" and L["tipshown"] or L["tiphidden"],
		"func", "ToggleCVar",
		"arg1", self,
		"arg2", "UnitNamePlayerPVPTitle"
	)
	cat:AddLine(
		"text", L["tipownname"],
		"text2", GetCVar("UnitNameOwn") == "1" and L["tipshown"] or L["tiphidden"],
		"func", "ToggleCVar",
		"arg1", self,
		"arg2", "UnitNameOwn"
	)
	cat:AddLine(
		"text", L["tipfriendlyplates"],
		"text2", GetCVar("nameplateShowFriends") == "1" and L["tipshown"] or L["tiphidden"],
		"func", "ToggleCVar",
		"arg1", self,
		"arg2", "nameplateShowFriends"
	)
	cat:AddLine(
		"text", L["tipenemyplayernames"],
		"text2", GetCVar("UnitNameEnemyPlayerName") == "1" and L["tipshown"] or L["tiphidden"],
		"func", "ToggleCVar",
		"arg1", self,
		"arg2", "UnitNameEnemyPlayerName"
	)
	cat:AddLine(
		"text", L["tipenemypetnames"],
		"text2", GetCVar("UnitNameEnemyPetName") == "1" and L["tipshown"] or L["tiphidden"],
		"func", "ToggleCVar",
		"arg1", self,
		"arg2", "UnitNameEnemyPetName"
	)
	cat:AddLine(
		"text", L["tipenemycreations"],
		"text2", GetCVar("UnitNameEnemyCreationName") == "1" and L["tipshown"] or L["tiphidden"],
		"func", "ToggleCVar",
		"arg1", self,
		"arg2", "UnitNameEnemyCreationName"
	)

	cat = tablet:AddCategory("text", L["tipnpcs"], "columns", 2)
	cat:AddLine(
		"text", L["tipnames"],
		"text2", GetCVar("UnitNameNPC") == "1" and L["tipshown"] or L["tiphidden"],
		"func", "ToggleCVar",
		"arg1", self,
		"arg2", "UnitNameNPC"
	)
	cat:AddLine(
		"text", L["tipcompanions"],
		"text2", GetCVar("UnitNameCompanionName") == "1" and L["tipshown"] or L["tiphidden"],
		"func", "ToggleCVar",
		"arg1", self,
		"arg2", "UnitNameCompanionName"
	)
	cat:AddLine(
		"text", L["tipplates"],
		"text2", GetCVar("nameplateShowEnemies") == "1" and L["tipshown"] or L["tiphidden"],
		"func", "ToggleCVar",
		"arg1", self,
		"arg2", "nameplateShowEnemies"
	)

	tablet:SetHint(L["hint"])
end


function FuBar_NameToggle:ToggleCVar(var)
	SetCVar(var, GetCVar(var) == "1" and 0 or 1)
end

function FuBar_NameToggle:ToggleClickable()
	if self.db.profile.clickableTooltip then
		self.clickableTooltip = false
		self.db.profile.clickableTooltip = false
	else
		self.clickableTooltip = true
		self.db.profile.clickableTooltip = true
	end
end

function FuBar_NameToggle:OnClick()
	if IsShiftKeyDown() then
		self:ToggleCVar("UnitNameNPC")
	elseif IsControlKeyDown() then
		self:ToggleCVar("UnitNameOwn")
	elseif IsAltKeyDown() then
		self:ToggleCVar("UnitNameEnemyPlayerName")
	else
		self:ToggleCVar("UnitNameFriendlyPlayerName")
	end
end

function FuBar_NameToggle:OnMenuRequest()
	dewdrop:AddLine(
		"text", L["menupnames"],
		"func", "ToggleCVar",
		"arg1", self,
		"arg2", "UnitNameFriendlyPlayerName",
		"checked", GetCVar("UnitNameFriendlyPlayerName") == "1",
		"keepShownOnClick", true
	)
	dewdrop:AddLine(
		"text", L["menupguild"],
		"func", "ToggleCVar",
		"arg1", self,
		"arg2", "UnitNamePlayerGuild",
		"checked", GetCVar("UnitNamePlayerGuild") == "1",
		"keepShownOnClick", true
	)
	dewdrop:AddLine(
		"text", L["menuptitle"],
		"func", "ToggleCVar",
		"arg1", self,
		"arg2", "UnitNamePlayerPVPTitle",
		"checked", GetCVar("UnitNamePlayerPVPTitle") == "1",
		"keepShownOnClick", true
	)
	dewdrop:AddLine(
		"text", L["menuownname"],
		"func", "ToggleCVar",
		"arg1", self,
		"arg2", "UnitNameOwn",
		"checked", GetCVar("UnitNameOwn") == "1",
		"keepShownOnClick", true
	)
	dewdrop:AddLine(
		"text", L["menufriendlyplates"],
		"func", "ToggleCVar",
		"arg1", self,
		"arg2", "nameplateShowFriends",
		"checked", GetCVar("nameplateShowFriends") == "1",
		"keepShownOnClick", true
	)
	dewdrop:AddLine(
		"text", L["menufriendlypetnames"],
		"func", "ToggleCVar",
		"arg1", self,
		"arg2", "UnitNameFriendlyPetName",
		"checked", GetCVar("UnitNameFriendlyPetName") == "1",
		"keepShownOnClick", true
	)
	dewdrop:AddLine(
		"text", L["menufriendlycreations"],
		"func", "ToggleCVar",
		"arg1", self,
		"arg2", "UnitNameFriendlyCreationName",
		"checked", GetCVar("UnitNameFriendlyCreationName") == "1",
		"keepShownOnClick", true
	)
	dewdrop:AddLine(
		"text", L["menuenemyplayernames"],
		"func", "ToggleCVar",
		"arg1", self,
		"arg2", "UnitNameEnemyPlayerName",
		"checked", GetCVar("UnitNameEnemyPlayerName") == "1",
		"keepShownOnClick", true
	)
	dewdrop:AddLine(
		"text", L["menuenemypetnames"],
		"func", "ToggleCVar",
		"arg1", self,
		"arg2", "UnitNameEnemyPetName",
		"checked", GetCVar("UnitNameEnemyPetName") == "1",
		"keepShownOnClick", true
	)
	dewdrop:AddLine(
		"text", L["menuenemycreations"],
		"func", "ToggleCVar",
		"arg1", self,
		"arg2", "UnitNameEnemyCreationName",
		"checked", GetCVar("UnitNameEnemyCreationName") == "1",
		"keepShownOnClick", true
	)

	dewdrop:AddLine()

	dewdrop:AddLine(
		"text", L["menunpcnames"],
		"func", "ToggleCVar",
		"arg1", self,
		"arg2", "UnitNameNPC",
		"checked", GetCVar("UnitNameNPC") == "1",
		"keepShownOnClick", true
	)
	dewdrop:AddLine(
		"text", L["menucompanions"],
		"func", "ToggleCVar",
		"arg1", self,
		"arg2", "UnitNameCompanionName",
		"checked", GetCVar("UnitNameCompanionName") == "1",
		"keepShownOnClick", true
	)
	dewdrop:AddLine(
		"text", L["menunpcplates"],
		"func", "ToggleCVar",
		"arg1", self,
		"arg2", "nameplateShowEnemies",
		"checked", GetCVar("nameplateShowEnemies") == "1",
		"keepShownOnClick", true
	)
end
