MonkeyQuestFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0","AceDB-2.0","AceEvent-2.0")

-- variables
local L          = AceLibrary("AceLocale-2.2"):new("MonkeyQuestFu")
local tablet     = AceLibrary("Tablet-2.0")
local metro      = AceLibrary("Metrognome-2.0")

-- set properties                                             
MonkeyQuestFu.canHideText         = true
MonkeyQuestFu.defaultPosition     = "LEFT"
MonkeyQuestFu.hasIcon             = true
MonkeyQuestFu.cannotDetachTooltip = true
MonkeyQuestFu.hasNoColor          = true

-- register stuff
MonkeyQuestFu:RegisterDB("MonkeyQuestFuDB")
-- profile --> settings are shared by characters who use the same (fubar)profile
MonkeyQuestFu:RegisterDefaults("profile", {  
                                  -- MQ settings that have been overridden
                                  HideTitleButtons = nil,
                                  HideTitleText = nil,
                                  ShowQuestNumber = nil,
				  MQFrameLeft = nil,
				  MQFrameTop = nil,
				  MQFrameBottom = nil,
				  GrowUp = nil,
				  Lock = nil,
				  Minimized = nil,
				  -- MQFU settings
				  SettingsSaved = false,
				  OpenMQonClick = false,  -- default
                               }
)

MonkeyQuestFu.OnMenuRequest = {
	type = 'group',
	name = MonkeyQuestFu.name,
	desc = MonkeyQuestFu.notes,
	args = {
		-- toggles
		hiddenitems = {
			type = 'toggle',
			name = L["SHOWHIDDEN"],
			desc = L["SHOWHIDDEN_MSG"],
			get = function() if not MonkeyQuestFu:get_OpenMQonClick() then
						MonkeyQuestSlash_CmdOpen(false) -- needed to hide MQframe when accessing menu
					 end
					 return MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bShowHidden
			      end,
			set = function(v) MonkeyQuestSlash_CmdShowHidden(v) end,
			order = 1,
		},
		useoverviews = {
			type = 'toggle',
			name = L["USEOVERVIEWS"],
			desc = L["USEOVERVIEWS_MSG"],
			get = function() return MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bObjectives end,
			set = function(v) MonkeyQuestSlash_CmdUseOverviews(v) end,
			order = 5,
		},
		hidezoneheaders = {
			type = 'toggle',
			name = L["HIDEHEADERS"],
			desc = L["HIDEHEADERS_MSG"],
			get = function() return MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bNoHeaders end,
			set = function(v) MonkeyQuestSlash_CmdHideHeaders(v) end,
			order = 10,
		},
		hideborder = {
			type = 'toggle',
			name = L["HIDEBORDER"],
			desc = L["HIDEBORDER_MSG"],
			get = function() return MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bNoBorder end,
			set = function(v) MonkeyQuestSlash_CmdHideBorder(v) end,
			order = 15,
		},
		colorquests = {
			type = 'toggle',
			name = L["COLOURTITLEON"],
			desc = L["COLOURTITLEON_MSG"],
			get = function() return MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bColourTitle end,
			set = function(v) MonkeyQuestSlash_CmdColourTitleOn(v) end,
			order = 20,
		},
		hidecompquests = {
			type = 'toggle',
			name = L["HIDECOMPLETEDQUESTS"],
			desc = L["HIDECOMPLETEDQUESTS_MSG"],
			get = function() return MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bHideCompletedQuests end,
			set = function(v) MonkeyQuestSlash_CmdHideCompletedQuests(v) end,
			order = 25,
		},
		hidecompobjectives = {
			type = 'toggle',
			name = L["HIDECOMPLETEDOBJECTIVES"],
			desc = L["HIDECOMPLETEDOBJECTIVES_MSG"],
			get = function() return MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bHideCompletedObjectives end,
			set = function(v) MonkeyQuestSlash_CmdHideCompletedObjectives(v) end,
			order = 30,
		},
		showobjintooltip = {
			type = 'toggle',
			name = L["SHOWTOOLTIPOBJECTIVES"],
			desc = L["SHOWTOOLTIPOBJECTIVES_MSG"],
			get = function() return MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bShowTooltipObjectives end,
			set = function(v) MonkeyQuestSlash_CmdShowTooltipObjectives(v) end,
			order = 35,
		},
		useskinnyfont = {
			type = 'toggle',
			name = L["CRASHFONT"],
			desc = L["CRASHFONT_MSG"],
			get = function() return MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bCrashFont end,
			set = function(v) MonkeyQuestInit_Font(v) end,
			order = 40,
		},
		usegoldenborder = {
			type = 'toggle',
			name = L["CRASHBORDER"],
			desc = L["CRASHBORDER_MSG"],
			get = function() return MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bCrashBorder end,
			set = function(v) MonkeyQuestInit_Border(v) end,
			order = 45,
		},
		shownoobtips = {
			type = 'toggle',
			name = L["SHOWNOOBTIPS"],
			desc = L["SHOWNOOBTIPS_MSG"],
			get = function() return MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bShowNoobTips end,
			set = function(v) MonkeyQuestSlash_CmdShowNoobTips(v) end,
			order = 50,
		},
		highlightquestzone = {
			type = 'toggle',
			name = L["SHOWZONEHIGHLIGHT"],
			desc = L["SHOWZONEHIGHLIGHT_MSG"],
			get = function() return MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bShowZoneHighlight end,
			set = function(v) MonkeyQuestSlash_CmdShowZoneHighlight(v) end,
			order = 55,
		},
		showquestlevels = {
			type = 'toggle',
			name = L["SHOWQUESTLEVEL"],
			desc = L["SHOWQUESTLEVEL_MSG"],
			get = function() return MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bShowQuestLevel end,
			set = function(v) MonkeyQuestSlash_CmdShowQuestLevel(v) end,
			order = 57,
		},
		showzoneheaders = {
			type = 'toggle',
			name = L["ALWAYSHEADERS"],
			desc = L["ALWAYSHEADERS_MSG"],
			get = function() return MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bAlwaysHeaders end,
			set = function(v) MonkeyQuestSlash_CmdAlwaysHeaders(v) end,
			order = 60,
		},
		-- hidden/disabled items when mode is 'display MQ in fubar'
		-- enabled when mode is 'click to open MQ'
		growup = {
			type = 'toggle',
			name = L["GROWUP"],
			desc = L["GROWUP_MSG"],
			get = function() return MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bGrowUp end,
			set = function(v) MonkeyQuestSlash_CmdGrowUp(v) end,
			disabled = function() return not MonkeyQuestFu:get_OpenMQonClick() end,
			order = 61,
		},
		shownumquests = {
			type = 'toggle',
			name = L["SHOWNUMQUESTS"],
			desc = L["SHOWNUMQUESTS_MSG"],
			get = function() return MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bShowNumQuests end,
			set = function(v) MonkeyQuestSlash_CmdShowNumQuests(v) end,
			disabled = function() return not MonkeyQuestFu:get_OpenMQonClick() end,
			order = 62,
		},
		lock = {
			type = 'toggle',
			name = L["LOCK"],
			desc = L["LOCK_MSG"],
			get = function() return MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bLocked end,
			set = function(v) MonkeyQuestSlash_CmdLock(v) end,
			disabled = function() return not MonkeyQuestFu:get_OpenMQonClick() end,
			order = 63,
		},
		hidetitlebuttons = {
			type = 'toggle',
			name = L["HIDETITLEBUTTONS"],
			desc = L["HIDETITLEBUTTONS_MSG"],
			get = function() return MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bHideTitleButtons end,
			set = function(v) MonkeyQuestSlash_CmdHideTitleButtons(v) end,
			disabled = function() return not MonkeyQuestFu:get_OpenMQonClick() end,
			order = 64,
		},
		hidetitle = {
			type = 'toggle',
			name = L["HIDETITLE"],
			desc = L["HIDETITLE_MSG"],
			get = function() return MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bHideTitle end,
			set = function(v) MonkeyQuestSlash_CmdHideTitle(v) end,
			disabled = function() return not MonkeyQuestFu:get_OpenMQonClick() end,
			order = 65,
		},
		blank1 = {
			order = 69,
			type = 'header',
		},
		-- colour 
		questtitlecolour = {
			type = 'color',
			name = L["QUESTTITLECOLOUR"],
			desc = L["QUESTTITLECOLOUR_MSG"],
			get = function() return MonkeyQuestFu:get_ColourStrToARGB(MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_strQuestTitleColour) end,
			set = function(r,g,b)	MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_strQuestTitleColour = MonkeyLib_ARGBToColourStr(1.0, r, g, b)
						MonkeyQuest_Refresh()
						-- check for MonkeyBuddy
						if (MonkeyBuddyQuestFrame_Refresh ~= nil) then
							MonkeyBuddyQuestFrame_Refresh()
						end
				end,
			order = 70,
		},
		headeropencolour = {
			type = 'color',
			name = L["HEADEROPENCOLOUR"],
			desc = L["HEADEROPENCOLOUR_MSG"],
			get = function() return MonkeyQuestFu:get_ColourStrToARGB(MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_strHeaderOpenColour) end,
			set = function(r,g,b)	MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_strHeaderOpenColour = MonkeyLib_ARGBToColourStr(1.0, r, g, b)
						MonkeyQuest_Refresh()
						-- check for MonkeyBuddy
						if (MonkeyBuddyQuestFrame_Refresh ~= nil) then
							MonkeyBuddyQuestFrame_Refresh()
						end
				end,
			order = 72,
		},
		headerclosedcolour = {
			type = 'color',
			name = L["HEADERCLOSEDCOLOUR"],
			desc = L["HEADERCLOSEDCOLOUR_MSG"],
			get = function() return MonkeyQuestFu:get_ColourStrToARGB(MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_strHeaderClosedColour) end,
			set = function(r,g,b)	MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_strHeaderClosedColour = MonkeyLib_ARGBToColourStr(1.0, r, g, b)
						MonkeyQuest_Refresh()
						-- check for MonkeyBuddy
						if (MonkeyBuddyQuestFrame_Refresh ~= nil) then
							MonkeyBuddyQuestFrame_Refresh()
						end
				end,
			order = 74,
		},
		overviewcolour = {
			type = 'color',
			name = L["OVERVIEWCOLOUR"],
			desc = L["OVERVIEWCOLOUR_MSG"],
			get = function() return MonkeyQuestFu:get_ColourStrToARGB(MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_strOverviewColour) end,
			set = function(r,g,b)	MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_strOverviewColour = MonkeyLib_ARGBToColourStr(1.0, r, g, b)
						MonkeyQuest_Refresh()
						-- check for MonkeyBuddy
						if (MonkeyBuddyQuestFrame_Refresh ~= nil) then
							MonkeyBuddyQuestFrame_Refresh()
						end
				end,
			order = 76,
		},
		specialobjectivecolour = {
			type = 'color',
			name = L["SPECIALOBJECTIVECOLOUR"],
			desc = L["SPECIALOBJECTIVECOLOUR_MSG"],
			get = function() return MonkeyQuestFu:get_ColourStrToARGB(MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_strSpecialObjectiveColour) end,
			set = function(r,g,b)	MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_strSpecialObjectiveColour = MonkeyLib_ARGBToColourStr(1.0, r, g, b)
						MonkeyQuest_Refresh()
						-- check for MonkeyBuddy
						if (MonkeyBuddyQuestFrame_Refresh ~= nil) then
							MonkeyBuddyQuestFrame_Refresh()
						end
				end,
			order = 78,
		},
		initialobjectivecolour = {
			type = 'color',
			name = L["INITIALOBJECTIVECOLOUR"],
			desc = L["INITIALOBJECTIVECOLOUR_MSG"],
			get = function() return MonkeyQuestFu:get_ColourStrToARGB(MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_strInitialObjectiveColour) end,
			set = function(r,g,b)	MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_strInitialObjectiveColour = MonkeyLib_ARGBToColourStr(1.0, r, g, b)
						MonkeyQuest_Refresh()
						-- check for MonkeyBuddy
						if (MonkeyBuddyQuestFrame_Refresh ~= nil) then
							MonkeyBuddyQuestFrame_Refresh()
						end
				end,
			order = 80,
		},
		midobjectivecolour = {
			type = 'color',
			name = L["MIDOBJECTIVECOLOUR"],
			desc = L["MIDOBJECTIVECOLOUR_MSG"],
			get = function() return MonkeyQuestFu:get_ColourStrToARGB(MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_strMidObjectiveColour) end,
			set = function(r,g,b)	MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_strMidObjectiveColour = MonkeyLib_ARGBToColourStr(1.0, r, g, b)
						MonkeyQuest_Refresh()
						-- check for MonkeyBuddy
						if (MonkeyBuddyQuestFrame_Refresh ~= nil) then
							MonkeyBuddyQuestFrame_Refresh()
						end
				end,
			order = 82,
		},
		completeobjectivecolour = {
			type = 'color',
			name = L["COMPLETEOBJECTIVECOLOUR"],
			desc = L["COMPLETEOBJECTIVECOLOUR_MSG"],
			get = function() return MonkeyQuestFu:get_ColourStrToARGB(MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_strCompleteObjectiveColour) end,
			set = function(r,g,b)	MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_strCompleteObjectiveColour = MonkeyLib_ARGBToColourStr(1.0, r, g, b)
						MonkeyQuest_Refresh()
						-- check for MonkeyBuddy
						if (MonkeyBuddyQuestFrame_Refresh ~= nil) then
							MonkeyBuddyQuestFrame_Refresh()
						end
				end,
			order = 84,
		},
		zonehighlightcolour = {
			type = 'color',
			name = L["ZONEHIGHLIGHTCOLOUR"],
			desc = L["ZONEHIGHLIGHTCOLOUR_MSG"],
			get = function() return MonkeyQuestFu:get_ColourStrToARGB(MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_strZoneHighlightColour) end,
			set = function(r,g,b)	MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_strZoneHighlightColour = MonkeyLib_ARGBToColourStr(1.0, r, g, b)
						MonkeyQuest_Refresh()
						-- check for MonkeyBuddy
						if (MonkeyBuddyQuestFrame_Refresh ~= nil) then
							MonkeyBuddyQuestFrame_Refresh()
						end
				end,
			order = 86,
		},
		blank2 = {
			order = 90,
			type = 'header',
		},
		-- sliders
		globalalpha = {
			type = 'range',
			name = L["FRAMEALPHASLIDER"],
			desc = L["FRAMEALPHASLIDER_MSG"],
			get = function() return MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_iFrameAlpha end,
			set = function(v) MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_iFrameAlpha = v
					  MonkeyQuest_SetFrameAlpha(v)
				  	-- check for MonkeyBuddy
					if (MonkeyBuddyQuestFrame_Refresh ~= nil) then
						slider = getglobal("MonkeyBuddyQuestSlider1")
						slider:SetValue(v)
						MonkeyBuddyQuestFrame_Refresh()
					end
			      end,
			min = 0.0,
			max = 1.0,
			step = 0.01,
			isPercent = true,
			order = 100
		},
		backgroundalpha = {
			type = 'range',
			name = L["ALPHASLIDER"],
			desc = L["ALPHASLIDER_MSG"],
			get = function() return MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_iAlpha end,
			set = function(v) MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_iAlpha = v
					  MonkeyQuest_SetAlpha(v)
				  	-- check for MonkeyBuddy
					if (MonkeyBuddyQuestFrame_Refresh ~= nil) then
						slider = getglobal("MonkeyBuddyQuestSlider2")
						slider:SetValue(v)
						MonkeyBuddyQuestFrame_Refresh()
					end
			      end,
			min = 0.0,
			max = 1.0,
			step = 0.01,
			isPercent = true,
			order = 105
		},
		framewidth = {
			type = 'range',
			name = L["WIDTHSLIDER"],
			desc = L["WIDTHSLIDER_MSG"],
			get = function() return MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_iFrameWidth end,
			set = function(v) MonkeyQuestSlash_CmdWidth(v)
				  	-- check for MonkeyBuddy
					if (MonkeyBuddyQuestFrame_Refresh ~= nil) then
						slider = getglobal("MonkeyBuddyQuestSlider3")
						slider:SetValue(v)
						MonkeyBuddyQuestFrame_Refresh()
					end
				end,
			min = 200,
			max = 600,
			step = 1,
			order = 110
		},
		fontsize = {
			type = 'range',
			name = L["FONTSLIDER"],
			desc = L["FONTSLIDER_MSG"],
			get = function() return MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_iFontHeight end,
			set = function(v) MonkeyQuestSlash_CmdFontHeight(v)
				  	-- check for MonkeyBuddy
					if (MonkeyBuddyQuestFrame_Refresh ~= nil) then
						slider = getglobal("MonkeyBuddyQuestSlider4")
						slider:SetValue(v)
						MonkeyBuddyQuestFrame_Refresh()
					end
				end,
			min = 8,
			max = 48,
			step = 0.5,
			order = 115
		},
		questpadding = {
			type = 'range',
			name = L["PADDINGSLIDER"],
			desc = L["PADDINGSLIDER_MSG"],
			get = function() return MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_iQuestPadding end,
			set = function(v) MonkeyQuestSlash_CmdSetQuestPadding(v)
				  	-- check for MonkeyBuddy
					if (MonkeyBuddyQuestFrame_Refresh ~= nil) then
						slider = getglobal("MonkeyBuddyQuestSlider5")
						slider:SetValue(v)
						MonkeyBuddyQuestFrame_Refresh()
					end
				end,
			min = 0,
			max = 32,
			step = 1,
			order = 120
		},
		blank3 = {
			order = 150,
			type = 'header',
		},
		-- mode toggle
		openmqonclick = {
			type = 'toggle',
			name = L["OPENMQONCLICK"],
			desc = L["OPENMQONCLICK_MSG"],
			get = "get_OpenMQonClick",
			set = "set_OpenMQonClick",
			order = 200,
		},
		blank4 = {
			order = 250,
			type = 'header',
		},
		-- reset button
		resetbutton = {
			type = 'execute',
			name = L["RESET"],
			desc = L["RESET_MSG"],
			func = "reset_MQvariables",
			order = 300,
		},

	}
}


function MonkeyQuestFu:reset_MQvariables()
	-- call MQ reset function
	MonkeyQuestInit_ResetConfig()
	-- check which mode we are in
	if self:get_OpenMQonClick() then
		-- true, so open MonkeyQuest on click
		MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bMinimized = false  --> frame must not be minimized

	else
		-- false, so attach MQ frame to fubar
		-- save the original MQ settings
		self:BackupMonkeyQuestSettings()

		-- overide MQ values (needed to make mqframe look better on FuBar
		self:FubaredMonkeyQuestSettings()

		--set framestrata to FULLSCREEN because else MonkeyQuest may be hidden behind (default) bars
		MonkeyQuestFrame:SetFrameStrata("FULLSCREEN")

		-- hide monkeyquest on screen
		MonkeyQuestSlash_CmdOpen(false)
	end
end


--copy of MonkeyLib_ColourStrToARGB with a different return sequence for the ACE options table
function MonkeyQuestFu:get_ColourStrToARGB(strColour)
	-- "|cFFFFFFFF"
	local i = 3;
	
	local iAlpha = tonumber(string.sub(strColour, i, i + 1), 16);
	local iRed = tonumber(string.sub(strColour, i + 2, i + 3), 16);
	local iGreen = tonumber(string.sub(strColour, i + 4, i + 5), 16);
	local iBlue = tonumber(string.sub(strColour, i + 6, i + 7), 16);
	
	iAlpha = iAlpha / 255;
	iRed = iRed / 255;
	iGreen = iGreen / 255;
	iBlue = iBlue / 255;
	
	return iRed, iGreen, iBlue, iAlpha;
end


function MonkeyQuestFu:set_OpenMQonClick(option)
	self.db.profile.OpenMQonClick = option
	if self.db.profile.OpenMQonClick then
		-- reset location and show/enable MQtitle/menu etc. option in menu
		-- restore the original MQ settings
		self:RestoreMonkeyQuestSettings()

		MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bMinimized = false  --> frame must not be minimized

		--set framestrata back to HIGH (MQ default)
		MonkeyQuestFrame:SetFrameStrata("HIGH")

		-- show monkeyquest on screen
		MonkeyQuestSlash_CmdOpen(true)

	else
		-- save the original MQ settings
		self:BackupMonkeyQuestSettings()

		-- overide MQ values (needed to make mqframe look better on FuBar
		self:FubaredMonkeyQuestSettings()

		--set framestrata to FULLSCREEN because else MonkeyQuest may be hidden behind (default) bars
		MonkeyQuestFrame:SetFrameStrata("FULLSCREEN")

		-- hide monkeyquest on screen
		MonkeyQuestSlash_CmdOpen(false)
	end
	self:Update()
end


function MonkeyQuestFu:get_OpenMQonClick()
	return self.db.profile.OpenMQonClick
end


function MonkeyQuestFu:BackupMonkeyQuestSettings()
	-- store the current values, MQ value will be overidden
	self.db.profile.HideTitleButtons = MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bHideTitleButtons
	self.db.profile.HideTitleText    = MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bHideTitle
	self.db.profile.ShowQuestNumber  = MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bShowNumQuests
	self.db.profile.GrowUp           = MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bGrowUp
	self.db.profile.Lock             = MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bLocked
	self.db.profile.Minimized        = MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bMinimized


	-- save the position
	self.db.profile.MQFrameLeft   = MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_iFrameLeft
	self.db.profile.MQFrameTop    = MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_iFrameTop
	self.db.profile.MQFrameBottom = MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_iFrameBottom

	self.db.profile.SettingsSaved = true
end


function MonkeyQuestFu:RestoreMonkeyQuestSettings()
	-- restore default monkeyquest settings
	MonkeyQuestSlash_CmdHideTitleButtons(self.db.profile.HideTitleButtons)
	MonkeyQuestSlash_CmdHideTitle(self.db.profile.HideTitleText)
	MonkeyQuestSlash_CmdShowNumQuests(self.db.profile.ShowQuestNumber)
	MonkeyQuestSlash_CmdGrowUp(self.db.profile.GrowUp)
	MonkeyQuestSlash_CmdLock(self.db.profile.Lock)
	MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bMinimized	= self.db.profile.Minimized

	-- restore the position
	MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_iFrameLeft    = self.db.profile.MQFrameLeft
	MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_iFrameTop     = self.db.profile.MQFrameTop
	MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_iFrameBottom  = self.db.profile.MQFrameBottom

	MonkeyQuest_Refresh()

	self.db.profile.SettingsSaved = false
end


function MonkeyQuestFu:RegisterTimer()
	metro:Register("Hover Timer", self.CheckHover, 0.5, self)
end


function MonkeyQuestFu:UnregisterTimer()
	metro:Unregister("Hover Timer")
end


function MonkeyQuestFu:FubaredMonkeyQuestSettings()
	-- overide MQ values (needed to make mqframe look better on FuBar
	MonkeyQuestSlash_CmdHideTitleButtons(true)
	MonkeyQuestSlash_CmdHideTitle(true)
	MonkeyQuestSlash_CmdShowNumQuests(false)
	MonkeyQuestSlash_CmdLock(true)
	MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bMinimized = false  --> frame must not be minimized

	MonkeyQuest_Refresh()
end


function MonkeyQuestFu:OnEnable()
	-- register for event. so i can update the questnumbers
	self:RegisterEvent("QUEST_LOG_UPDATE", "Update")
	-- this will catch mobs needed for quests
	self:RegisterEvent("UPDATE_MOUSEOVER_UNIT", "Update")

	-- register timer
--	DEFAULT_CHAT_FRAME:AddMessage("Hover Timer REGISTERED")
	self:RegisterTimer()

	-- check which mode we are in
	if self:get_OpenMQonClick() then
		-- true, so open MonkeyQuest on click
		MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bMinimized = false  --> frame must not be minimized

	else
		-- false, so attach MQ frame to fubar
		if not self.db.profile.SettingsSaved then
			-- save the original MQ settings
			self:BackupMonkeyQuestSettings()

			-- overide MQ values (needed to make mqframe look better on FuBar
			self:FubaredMonkeyQuestSettings()

			--set framestrata to FULLSCREEN because else MonkeyQuest may be hidden behind (default) bars
			MonkeyQuestFrame:SetFrameStrata("FULLSCREEN")

			-- hide monkeyquest on screen
			MonkeyQuestSlash_CmdOpen(false)
		end
	end
end


function MonkeyQuestFu:OnDisable()
	-- unregister timer
	self:UnregisterTimer()

	-- check which mode we are in
	if self:get_OpenMQonClick() then
		-- true, so open MonkeyQuest on click
		-- do nothing atm
	else
		-- false, so attach MQ frame to fubar
		-- restore the original MQ settings
		self:RestoreMonkeyQuestSettings()

		--set framestrata back to HIGH (MQ default)
		MonkeyQuestFrame:SetFrameStrata("HIGH")

		-- show monkeyquest on screen
		MonkeyQuestSlash_CmdOpen(true)
	end
end


-- checks if the mousepointer is still over the MonkeyQuest or MonkeyQuestFuButton frame
function MonkeyQuestFu:CheckHover()
	local MonkeyQuestFuFrame = self:GetFrame()

	if not ((MouseIsOver(MonkeyQuestFrame)) or (MouseIsOver(MonkeyQuestFuFrame))) then
		metro:Stop("Hover Timer")
		MonkeyQuestSlash_CmdOpen(false)
	end
end


function MonkeyQuestFu:OnTooltipUpdate()
	-- check if MonkeyQuestFu has become a minimap button
	local attached = self:IsMinimapAttached()

	if attached and self:get_OpenMQonClick()then
		if MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bDisplay then
			tablet:SetHint(L["TOOLTIP_HINT_OPENMQONCLICK_CLOSE"])
		else
			tablet:SetHint(L["TOOLTIP_HINT_OPENMQONCLICK_OPEN"])
		end
	elseif attached and not self:get_OpenMQonClick() then
		tablet:SetHint(L["TOOLTIP_HINT_NOT_OPENMQONCLICK"])
	elseif not attached and self:get_OpenMQonClick() then
		if MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bDisplay then
			tablet:SetHint(L["TOOLTIP_HINT_OPENMQONCLICK_CLOSE"])
		else
			tablet:SetHint(L["TOOLTIP_HINT_OPENMQONCLICK_OPEN"])
		end
	end
end


function MonkeyQuestFu:OnEnter()
	-- check if the option to open MonkeyQuest on click has been chosen
	if not self:get_OpenMQonClick() then
		-- get the frame to which to attach the MonkeyQuest frame onto
		local MonkeyQuestFuFrame = self:GetFrame()

		-- start timer which will check every 0.5 sec if the mouse pointer is hovering over the MonkeyQuestFrame or MonkeyQuestFuFrame
		metro:Start("Hover Timer")

		-- hide the tooltip with the plugin name you get, no matter if you want it or not
		if (tablet:IsRegistered(MonkeyQuestFuFrame)) then
			tablet:Unregister(MonkeyQuestFuFrame)
		end

		MonkeyQuestSlash_CmdOpen(true)

		MonkeyQuestFrame:ClearAllPoints();

		if (MonkeyQuestFuFrame:GetLeft() > 512) then
			-- on the right
			if (MonkeyQuestFuFrame:GetTop() > 384) then
				-- on the top
				MonkeyQuestFrame:SetPoint("TOPRIGHT", MonkeyQuestFuFrame, "BOTTOMRIGHT", 0, 0)
				MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_strAnchor = "ANCHOR_BOTTOMLEFT"
				MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bGrowUp = false
			else
				MonkeyQuestFrame:SetPoint("BOTTOMRIGHT", MonkeyQuestFuFrame, "TOPRIGHT", 0, 0)
				MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_strAnchor = "ANCHOR_TOPLEFT"
				MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bGrowUp = true
			end
		else
			-- on the left
			if (MonkeyQuestFuFrame:GetTop() > 384) then
				-- on the top
				MonkeyQuestFrame:SetPoint("TOPLEFT", MonkeyQuestFuFrame, "BOTTOMLEFT", 0, 0)
				MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_strAnchor = "ANCHOR_BOTTOMRIGHT"
				MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bGrowUp = false
			else
				MonkeyQuestFrame:SetPoint("BOTTOMLEFT", MonkeyQuestFuFrame, "TOPLEFT", 0, 0)
				MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_strAnchor = "ANCHOR_TOPRIGHT"
				MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bGrowUp = true
			end
		end

		-- save the position
		MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_iFrameLeft = MonkeyQuestFrame:GetLeft()
		MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_iFrameTop = MonkeyQuestFrame:GetTop()
		MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_iFrameBottom = MonkeyQuestFrame:GetBottom()
	end
end


-- update the number of quests your currently on, displayed in the fubar button
function MonkeyQuestFu:OnTextUpdate()
	local iNumEntries, iNumQuests = GetNumQuestLogEntries()
	self:SetText(iNumQuests .. "/" .. MAX_QUESTLOG_QUESTS)
end


function MonkeyQuestFu:OnDataUpdate()
	if MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bShowTooltipObjectives then
	-- update mousepointer with quest info
		MonkeyQuest_Refresh()  -- this is the only i found to update the mousepointer. it is memory consuming regretfully
	end
end


function MonkeyQuestFu:OnClick()
	-- check if the option to open MonkeyQuest on click has been chosen
	if self.db.profile.OpenMQonClick then
		-- check if MQframe is hidden
		if MonkeyQuestConfig[MonkeyQuest.m_strPlayer].m_bDisplay then
			MonkeyQuestSlash_CmdOpen(false)
			self:Update()
		else
			MonkeyQuestSlash_CmdOpen(true)
			self:Update()
		end
	end
end