﻿--[[
    MiniClockFu!
        "I just need a clock mate, not an all-in-one uber-configurable clockmaster =P"

    Based on ClockFu
--]]

MiniClockFu = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceDB-2.0", "FuBarPlugin-2.0")

local dewdrop = AceLibrary("Dewdrop-2.0")

MiniClockFu:RegisterDB("MiniClockFuDB")
MiniClockFu:RegisterDefaults('profile', { LocalTimeInPanel = true })

local L = { -- L for Locals!
	CONFIG_LOCALTIMEINPANEL = "Show Local Time in Panel",
	LOCALTIME = "Local Time",
	GAMETIME = "Game Time",
}

MiniClockFu.hasIcon = false
MiniClockFu.defaultPosition = 'RIGHT'
MiniClockFu.blizzardTooltip = true
MiniClockFu.cannotDetachTooltip = true

local db
function MiniClockFu:OnProfileEnable()
	db = self.db.profile -- update shortcut to db now that it's changed
end

function MiniClockFu:OnInitialize()
	db = self.db.profile
end

function MiniClockFu:OnEnable()
	-- Get rid of the time minimap button if GroupCalendar is not installed
	if IsAddOnLoaded("GroupCalendar") then
		GameTimeFrame:Show()
	else
		GameTimeFrame:Hide()
	end

	self:ScheduleRepeatingEvent(self.Update, 1, self)
end

function MiniClockFu:OnDisable()
	GameTimeFrame:Show()
end

function MiniClockFu:OnMenuRequest()
	dewdrop:AddLine(
		'text', L.CONFIG_LOCALTIMEINPANEL,
		'func', function()
			db.LocalTimeInPanel = not db.LocalTimeInPanel
			MiniClockFu:Update()
		end,
		'checked', db.LocalTimeInPanel
	)
end

local lastMinute, secondsDifference
local serverFormat = "|cffffffff%.2d:%.2d:%.2d|r"
function MiniClockFu:GetServerTime()
	local _
	local hour, minute = GetGameTime()

	if lastMinute ~= minute then
		_, lastMinute = GetGameTime()
		secondsDifference = mod(time(), 60)
	end

	local second = mod(time() - secondsDifference, 60)
	return string.format(serverFormat, hour, minute, second)
end

local localTime, gameTime
local dateFormat = "|cffffffff%X|r"
function MiniClockFu:OnDataUpdate()
	localTime = date(dateFormat)
	gameTime = self:GetServerTime()
end

function MiniClockFu:OnTextUpdate()
	self:SetText(db.LocalTimeInPanel and localTime or gameTime)
end

local fullDate = "%A, %B %d, %Y"
local tipName = "MiniClockFu"
function MiniClockFu:OnTooltipUpdate()
	GameTooltip:AddLine( tipName )
	GameTooltip:AddDoubleLine( L.LOCALTIME, localTime )
	GameTooltip:AddDoubleLine( L.GAMETIME, gameTime )
	GameTooltip:AddLine( date(fullDate) )
end
