local dewdrop = AceLibrary("Dewdrop-2.0")
local tablet = AceLibrary("Tablet-2.0")
local L = AceLibrary("AceLocale-2.2"):new("MCPFu")

ADDON_LOADED = L["LOADED"];
ADDON_WILL_NOT_LOAD = L["WILL_NOT_LOAD"];
ADDON_REFUSE_TO_LOAD = L["DISABLED_IN_MCP"];

local queuedForDelete = nil;
local lastEquippedSet = nil
local sortedSets = {}

local function IsEmpty()
	return next(MCPFu.OnMenuRequest.args.wear.args) == nil
end

local optionsTable = {
	type = 'group',	
	args = {
		add = {
			type = "execute",
			name = L["Add"],
			desc = L["Creates a new set, or updates an existing one."],
			func = "CreateOrUpdateSet",
			order = 101,
		},
		wear = {
			type = "group",
			name = L["Use"],
			desc = L["Use this set of addons."],
			pass = true,
			func = function(key)
				dewdrop:Close()
				MCPFu:UseSet(key)
			end,
			args = {},
			order = 102,
			disabled = IsEmpty
		},
		autoLoad = {
			order = 103,
			type = 'toggle',
			name = L["Auto load"],
			desc = L["Automatically reload UI when sets are changed"],
			get = function()
				return MCPFu.db.profile.autoReloadUI
			end,
			set = function(value)
				MCPFu.db.profile.autoReloadUI = value;				
				MCPFu:UpdateText();
			end,
			disabled = function()
					return false;
			end						
		},								
		spacer = { type = "header", order = 104 },
		delete = {
			type = "group",
			name = L["Delete"],
			desc = L["Delete a set."],
			pass = true,
			func = "DeleteSet",
			args = {},
			order = 107,
			disabled = IsEmpty
		},
		spacer = { type = "header", order = 110 },	
		showSecurity = {
			order = 130,
			type = 'toggle',
			name = L["OPT_SHOW_SECURITY"],
			desc = L["OPT_SHOW_SECURITY_DESC"],
			get = function()
				return MCPFu.db.profile.showSecurity
			end,
			set = function(value)
				MCPFu.db.profile.showSecurity = value;				
			end
		},				
		showNotes = {
			order = 140,
			type = 'toggle',
			name = L["OPT_SHOW_NOTES"],
			desc = L["OPT_SHOW_NOTES_DESC"],
			get = function()
				return MCPFu.db.profile.showNotes
			end,
			set = function(value)
				MCPFu.db.profile.showNotes = value;				
			end
		},		
		maxNoteLength = {
			type = 'range',
			name = L["OPT_NOTE_LEN"],
			desc = L["OPT_NOTE_LEN_DESC"],
			get = function()
				return MCPFu.db.profile.maxChars;
			end,
			set = function(v)
				MCPFu.db.profile.maxChars = v
			end,
			disabled = function()
				if MCPFu.db.profile.showNotes then
					return false;
				else
					return true;
				end
			end,			
			min = 20,
			max = 100,
			step = 5,
			order = 150
		},		
		showEnabled = {
			order = 155,
			type = 'toggle',
			name = L["OPT_SHOW_ENABLED"],
			desc = L["OPT_SHOW_ENABLED_DESC"],
			get = function()
				return MCPFu.db.profile.showEnabled
			end,
			set = function(value)
				MCPFu.db.profile.showEnabled = value;				
				MCPFu:UpdateText();
			end,
			disabled = function()
				if MCPFu.db.profile.showText then
					return false;
				else
					return true;
				end
			end						
		},								
	}	
}

MCPFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0", "AceHook-2.1")
MCPFu.hasIcon = true
MCPFu.clickableTooltip = true

MCPFu.OnMenuRequest = optionsTable
MCPFu:RegisterChatCommand( { "/MCPFu" }, optionsTable )

MCPFu:RegisterDB("MCPFuDB")
MCPFu:RegisterDefaults('profile', {
	showNotes = false,
	maxChars = 20,
	showSecurity = nil,
	showEnabled = 1,
	autoReloadUI = 0,
	addonConfig = {},
	blizzard_addons = { 
	"Blizzard_AuctionUI",
	"Blizzard_BattlefieldMinimap",
	"Blizzard_BindingUI",
	"Blizzard_CraftUI",
	"Blizzard_InspectUI",
	"Blizzard_MacroUI",
	"Blizzard_RaidUI",
	"Blizzard_TalentUI",
	"Blizzard_TradeSkillUI",
	"Blizzard_TrainerUI",
	};
	blizzard_addons_titles = { 
	"Blizzard: Auction",
	"Blizzard: Battlefield Minimap",
	"Blizzard: Binding",
	"Blizzard: Craft",
	"Blizzard: Inspect",
	"Blizzard: Macro",
	"Blizzard: Raid",
	"Blizzard: Talent",
	"Blizzard: Trade Skill",
	"Blizzard: Trainer",
	};	
})

local _G = getfenv(0)

local function reclaim(t)
	if type(t) ~= "table" then return end
	for k, v in pairs(t) do
		if type(v) == "table" then
			t[k] = reclaim(v)
		else
			t[k] = nil
		end
	end
	t = nil
	return nil
end

-- Methods
function MCPFu:OnInitialize()
	self:RegisterDefaults("char", {
		set = {},
	})	

	self.options = optionsTable
	
	-- XXX We're keeping this property for compability for a little while.
	--self.OnMenuRequest = self.options
end

local function updateSortedSets()
	for i in ipairs(sortedSets) do sortedSets[i] = nil end
	for k in pairs(MCPFu.db.char.set) do table.insert(sortedSets, k) end
	table.sort(sortedSets)
end
	
function MCPFu:OnEnable()
	if type(_G.StaticPopupDialogs) ~= "table" then
		_G.StaticPopupDialogs = {}
	end
	if not StaticPopupDialogs["MCPFuAdd"] then
		StaticPopupDialogs["MCPFuAdd"] = {
			text = L["Enter the name for your saved Config here !"],
			button1 = L["Add"],
			button2 = L["Cancel"],
			OnCancel = function() self:CancelCreateSet() end,
			sound = "levelup2",
			whileDead = 1,
			hideOnEscape = 1,
			timeout = 0,
			OnShow = function()
				-- We have to do this onshow to reset the previous text
				_G[this:GetName().."EditBox"]:SetText("")
			end,
			OnHide = function()
				_G[this:GetName().."EditBox"]:SetText("")
			end,
			EditBoxOnEnterPressed = function()
				local name = _G[this:GetParent():GetName().."EditBox"]:GetText()
				self:CreateSet(name)
				this:GetParent():Hide()
			end,
			EditBoxOnEscapePressed = function()
				self:CancelCreateSet()
				this:GetParent():Hide()
			end,
			OnAccept = function()
				local name = _G[this:GetParent():GetName().."EditBox"]:GetText()
				self:CreateSet(name)
			end,
			hasEditBox = 1,
		}
	end
	
	if not StaticPopupDialogs["MCPFuDelete"] then
		StaticPopupDialogs["MCPFuDelete"] = {
			text = L["Are you sure you want to delete the set %s?"],
			button1 = L["Delete"],
			button2 = L["Cancel"],
			whileDead = 1,
			showAlert = 1,
			timeout = 0,
			OnAccept = function() self:DeleteSet(queuedForDelete, true) end,
			OnCancel = function() queuedForDelete = nil end,
		}
	end	
	
	local function updateLatest(set)
		updateSortedSets()
		self:UpdateDisplay()
	end
	self:RegisterEvent("MCPFu_AddSet", updateLatest)
	self:RegisterEvent("MCPFu_UseSet", updateLatest)
	self:RegisterEvent("MCPFu_DeleteSet", updateLatest)
	
	self:UpdateSetOptions();

  --self:SecureHook("LoadAddOn");  
  --self:Hook("LoadAddOn", true)
end

function MCPFu:UseSet(...)
	name = select(1, ...)
	setToUse = self.db.char.set[name]
	if type(setToUse) ~= "table" then return false end
	self:TriggerEvent("MCPFu_UseSet", name);	
	
	for k, _ in pairs(setToUse) do
		if (setToUse[k] == 1) then
			EnableAddOn(k);
		else
			DisableAddOn(k);
		end
	end
	
	if (self.db.profile.autoReloadUI) then
		ReloadUI();		
	end
end

function MCPFu:CancelCreateSet()
	StaticPopup_Hide("MCPFuAdd");
end

function MCPFu:CreateOrUpdateSet(name)
	if UnitAffectingCombat("player") or InCombatLockdown() then return end
	StaticPopup_Show("MCPFuAdd");
end

function MCPFu:CreateSet(name)	
	self:AddSet(name);
	StaticPopup_Hide("MCPFuAdd");
end

function MCPFu:HasSet(name)
	return self.db.char.set[name] ~= nil
end

function MCPFu:AddSet(name)
	local concatedName = name:gsub(" ", "")
	if not name or name == "" or concatedName == "" then
		self:Print(L["Please use a proper name for your set."])
		return
	end
	if self:HasSet(concatedName) then name = concatedName end

	local text = L["Added set: %s."]:format(name)
	local event = "ClosetGnome_AddSet"
	if self:HasSet(name) then
		text = L["Updating set: %s."]:format(name)
		event = "ClosetGnome_UpdateSet"
		reclaim(self.db.char.set[name]);
	end
	
	--add the set items now
	if not self.db.char.set[name] then self.db.char.set[name] = {} end
	local numAddons = GetNumAddOns();
	for i = 1, numAddons, 1 do		
		local aname, title, notes, enabled, loadable, reason, security = GetAddOnInfo(i);
		if (enabled) then
			self.db.char.set[name][aname] = 1;
		else
			self.db.char.set[name][aname] = 0;
		end
	end
	--self.db.char.set[name][slot] = currentItem
	
	if not self.db.char.set[name] then return end

	self:TriggerEvent("MCPFu_AddSet", name)
	--self:Print(text)

	self:UpdateSetOptions()
	dewdrop:Close()
end

function MCPFu:DeleteSet(name, verified)
	self:Print("Deleting Test")
	if not verified and not IsShiftKeyDown() then
		queuedForDelete = name
		self:Print("Showing Popup")
		StaticPopup_Show("MCPFuDelete", name)
		return
	end

	queuedForDelete = nil
	if self.db.char.set[name] then
		self.db.char.set[name] = reclaim(self.db.char.set[name])

		self:TriggerEvent("MCPFu_DeleteSet", name)
		self:Print(L["Deleted set: %s."]:format(name))

		self:UpdateSetOptions()
		dewdrop:Refresh()
	end
end

function MCPFu:UpdateSetOptions()
	local opt = self.OnMenuRequest.args

	opt.wear.args = reclaim(opt.wear.args)
	opt.delete.args = reclaim(opt.delete.args)

	opt.wear.args = {}
	opt.delete.args = {}

	for k, v in pairs(self.db.char.set) do
		opt.wear.args[k] = {
			type = "execute",
			name = k,
			desc = L["Equip %s, or hold down Shift to edit this set."]:format(k),
			icon = icon,
		}
		opt.delete.args[k] = {
			type = "execute",
			name = k,
			desc = L["Deletes the equipment set %s."]:format(k),
			icon = icon,
		}
	end
end

--[[
function MCPFu:LoadAddOn(name)
	if (not IsAddOnLoaded(name) and self.db.profile.addonConfig and self.db.profile.addonConfig[name]) then
		--DEFAULT_CHAT_FRAME:AddMessage("MCPFu : Refusing to load : "..name)
		return nil, "REFUSE_TO_LOAD";
	else
		--DEFAULT_CHAT_FRAME:AddMessage("MCPFu : Allowing to load : "..name)
		--return self.hooks.LoadAddOn(name);
		return self.hooks["LoadAddOn"](name);
	end
end
]]

function MCPFu:OnDisable()
	-- you do not need to unregister the event here, all events/hooks are unregistered on disable implicitly.
end
	
function MCPFu:OnTextUpdate()
	self:SetText("MCP");
	
	if (not self.db.profile.showEnabled) or (not self.db.profile.showText) then
		return;
	end
	
	local numEnabled = 0;
	local numAddons = GetNumAddOns();
	local origNumAddons = numAddons;
	numAddons = numAddons + #self.db.profile.blizzard_addons;
	
	for i = 1, numAddons, 1 do		
		
		local name, enabled;
		if (i > origNumAddons) then
			name = self.db.profile.blizzard_addons[(i-origNumAddons)];
			if (self.db.profile.addonConfig and self.db.profile.addonConfig[name]) then
			else
				numEnabled = numEnabled + 1;
			end
		else
			name, title, notes, enabled, loadable, reason, security = GetAddOnInfo(i);
		end
						
		if (enabled) then
			numEnabled = numEnabled + 1;
		end	
	end
	self:SetText(numEnabled.."/"..numAddons);
end

function MCPFu:OnItemClick(index,enabled)
	--DEFAULT_CHAT_FRAME:AddMessage("Checking : "..index)
	if (IsShiftKeyDown()) then
		UIParentLoadAddOn(index);
		return;
	end
	
	if (type(index) == "number") then
		--DEFAULT_CHAT_FRAME:AddMessage("Addon : "..index);
		if (not enabled) then
			EnableAddOn(index)
		else
			DisableAddOn(index)
		end
	else
		--DEFAULT_CHAT_FRAME:AddMessage("Blizzard 1 : "..index)
		if (not enabled) then
			if (self.db.profile.addonConfig) then
				self.db.profile.addonConfig[index] = nil;
			end
		else
			--DEFAULT_CHAT_FRAME:AddMessage("Blizzard 2 : "..index)
			if (not self.db.profile.addonConfig) then self.db.profile.addonConfig = {}; end
			self.db.profile.addonConfig[index] = true;
		end
	end
end

function MCPFu:OnTooltipUpdate()
	
	local cat = tablet:AddCategory(
		'columns', 4,
		'child_textR', 1,
		'child_textG', 1,
		'child_textB', 1
	)
	
	local numAddons = GetNumAddOns();
	local origNumAddons = numAddons;
	numAddons = numAddons + #self.db.profile.blizzard_addons;
	
	for i = 1, numAddons, 1 do		
		local line = {};	
			
		line['func'] = 'OnItemClick'
		line['arg1'] = self			
		line['arg2'] = i												
		
		local name, title, notes, enabled, loadable, reason, security;
		if (i > origNumAddons) then
			name = self.db.profile.blizzard_addons[(i-origNumAddons)];
			title = self.db.profile.blizzard_addons_titles[(i-origNumAddons)];
			notes = "";
			line['arg2'] = name
			if (self.db.profile.addonConfig and self.db.profile.addonConfig[name]) then
				--DEFAULT_CHAT_FRAME:AddMessage("Blizzard : "..name)
				enabled = nil;
				loadable = nil;
				reason = "WILL_NOT_LOAD";
			else
				enabled = 1;
				loadable = 1;
			end
			if (IsAddOnLoaded(name)) then
				reason = "LOADED";
				loadable = 1;
			end
			security = "SECURE";
		else
			name, title, notes, enabled, loadable, reason, security = GetAddOnInfo(i);
		end
		
		--if title and notes then
			--DEFAULT_CHAT_FRAME:AddMessage("Adding : "..title.." - "..notes)
		--end
		local loaded = IsAddOnLoaded(name);
		local ondemand = IsAddOnLoadOnDemand(name);
		if (loadable) then
			line['textR'] = 1;
			line['textG'] = 0.78;
			line['textB'] = 0;								
		elseif (enabled and reason ~= "DEP_DISABLED") then
			line['textR'] = 1;
			line['textG'] = 0.1;
			line['textB'] = 0.1;								
		else
			line['textR'] = 0.5;
			line['textG'] = 0.5;
			line['textB'] = 0.5;								
		end
		if (title) then
			line['text'] = title;
		else
			line['text'] = name;
		end
		if (title == "FuBar - |cffffffffMCP|r|cff00ff00Fu|r") then
			line['hasCheck'] = false							
		else
			line['hasCheck'] = true										
		end
		if (enabled) then
			line['checked'] = true			
		else
			line['checked'] = false
		end
		if (title == "FuBar - |cffffffffMCP|r|cff00ff00Fu|r") then
			line['hasCheck'] = false							
			line['checked'] = false -- make sure it cant be clicked off
		else
			line['hasCheck'] = true										
		end		
		if (self.db.profile.showSecurity) then
			if (security == "SECURE") then
				line['text3'] = L["SECURE"];				
			elseif (security == "INSECURE") then
				line['text3'] = L["INSECURE"];				
			elseif (security == "BANNED") then -- wtf?
				line['text3'] = L["BANNED"];				
			end
		end
		if (self.db.profile.showNotes) and notes then
			if (string.len(notes) > self.db.profile.maxChars) then
				line['text2'] = string.sub(notes,1,self.db.profile.maxChars-2).."..";				
			else
				line['text2'] = notes;				
			end
		end
		if (reason) then			
			line['text4'] = TEXT(getglobal("ADDON_"..reason));				
			if (reason == "DISABLED") or (reason == "WILL_NOT_LOAD") then
				line['checked'] = false				
--			else
	--			DEFAULT_CHAT_FRAME:AddMessage("Adding : "..title.." - "..reason)
			end			
		elseif (loaded) then
			line['text4'] = TEXT(ADDON_LOADED);				
		elseif (ondemand) then
			line['text4'] = L["ONDEMAND"];								
			line['text4R'] = 0;
			line['text4G'] = 1;
			line['text4B'] = 0;											
		else
			line['text4'] = "";												
		end
		if (not loaded and enabled and ondemand) then
			--loadnow:Show();
		else
			--loadnow:Hide();
		end
		line['arg3'] = line['checked']
		cat:AddLine(line)					
	end
	cat:AddLine(
		'text', ""
	)	
	
	cat:AddLine(
		'text', ""
	)			

	tablet:SetHint(L["HINT"])
end
	
function MCPFu:OnClick()
	--PlaySound("SHEATHINGSHIELDSHEATHE");
	if (IsAltKeyDown()) then
		ReloadUI();		
	end
end