﻿local tablet = AceLibrary("Tablet-2.0")
local dewdrop = AceLibrary("Dewdrop-2.0")

local L = AceLibrary("AceLocale-2.2"):new("LogFu2")

LogFu2 = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceHook-2.1", "AceConsole-2.0", "AceDB-2.0", "FuBarPlugin-2.0")
LogFu2:RegisterDB("LogFu2DB")
LogFu2:RegisterDefaults(
    'profile', {
		ChatLogging = false,
		CombatLogging = false,
    }
)

LogFu2.name = L["Name"]
LogFu2.title = L["Name"]
LogFu2.notes = L["Description"]
LogFu2.version = tonumber(string.sub("5", 12, -3))
LogFu2.date = string.sub("$Date: 2008-07-22 17:05:40 -0500 (Tue, 22 Jul 2008) $", 8, 17)
LogFu2.category = "Chat/Communication"
LogFu2.email = "mjewbank@curse.com"
LogFu2.website = "http://www.curseforge.com"

LogFu2.hasIcon = L["DefaultIcon"]
LogFu2.clickableTooltip = true


-- Build the menu
LogFu2.OptionsTable = {
    type = 'group',
    args = {
        CombatLog = {
            type = 'toggle',
            name = L["MenuCombatLog"],
            desc = L["MenuCombatLog"],
            get  = "IsCombatLogging",
            set  = "ToggleCombatLogging"
        },
        ChatLog = {
            type = 'toggle',
            name = L["MenuChatLog"],
            desc = L["MenuChatLog"],
            get  = "IsChatLogging",
            set  = "ToggleChatLogging"
        }
    }
}

-- On Plugin Initialization ie when FuBar Loads
function LogFu2:OnInitialize() 
    self:Print(L["ChatStartupBanner"])
	
	-- Set initial logging to preferences
	if self.db.profile.CombatLogging == true then
		self:Print(L["ChatCombatEnabled"])
		LoggingCombat(1)
	else
		self:Print(L["ChatCombatDisabled"])
		LoggingCombat(0)
	end
	if self.db.profile.ChatLogging == true then
		self:Print(L["ChatChatEnabled"])
		LoggingChat(1)
	else
		self:Print(L["ChatChatDisabled"])
		LoggingChat(0)
	end
end

-- Toggle the CombatLogging variable and spam chat window
function LogFu2:ToggleCombatLogging()
	self.db.profile.CombatLogging = not self.db.profile.CombatLogging
	if self.db.profile.CombatLogging == true then
		self:Print(L["ChatCombatEnabled"])
		LoggingCombat(1)
	else
		self:Print(L["ChatCombatDisabled"])
		LoggingCombat(0)
	end
	self:Update()
end

-- Get the current value of the CombatLogging variable
function LogFu2:IsCombatLogging()
	return self.db.profile.CombatLogging
end

-- Toggle the ChatLogging variable and spam chat window
function LogFu2:ToggleChatLogging()
	self.db.profile.ChatLogging = not self.db.profile.ChatLogging
	if self.db.profile.ChatLogging == true then
		self:Print(L["ChatChatEnabled"])
		LoggingChat(1)
	else
		self:Print(L["ChatChatDisabled"])
		LoggingChat(0)
	end
	self:Update()
end

-- Get the current value of the ChatLogging variable
function LogFu2:IsChatLogging()
    	return self.db.profile.ChatLogging
end

-- Register the menu
LogFu2.OnMenuRequest = LogFu2.OptionsTable

-- register the slash command
LogFu2:RegisterChatCommand({ "/logfu", "/lfu" }, LogFu2.OptionsTable)

-- Bar Text Update Handler
function LogFu2:OnTextUpdate()
	if self.db.profile.CombatLogging and self.db.profile.ChatLogging then
		self:SetText(L["BarBoth"])
	elseif self.db.profile.CombatLogging then
		self:SetText(L["BarCombat"])
	elseif self.db.profile.ChatLogging then
		self:SetText(L["BarChat"])
	else
		self:SetText(L["BarDisabled"])
	end
end

-- Tooltip Update handler
function LogFu2:OnTooltipUpdate()
	
	-- Display Combat Log Info
	local combatcat = tablet:AddCategory(
		'text', L["TTipCatCombat"],
		'columns', 2,
		'child_textR', 1,
		'child_textG', 1,
		'child_textB', 0,
		'child_text2R', 1,
		'child_text2G', 1,
		'child_text2B', 1
	)

	if self.db.profile.CombatLogging then
		combatcat:AddLine(
			'text', L["TTipState"] .. ":",
			'text2', L["TTipEnabled"]
		)
		combatcat:AddLine(
			'text', L["TTipPath"] .. ":",
			'text2', L["TTipFilePath"] .. "\\" .. L["TTipFileNameCombat"]
		)
	else
		combatcat:AddLine(
			'text', L["TTipState"] .. ":",
			'text2', L["TTipDisabled"]
		)
	end

	-- Display Chat Log Info
	local chatcat = tablet:AddCategory(
		'text', L["TTipCatChat"],
		'columns', 2,
		'child_textR', 1,
		'child_textG', 1,
		'child_textB', 0,
		'child_text2R', 1,
		'child_text2G', 1,
		'child_text2B', 1
	)

	if self.db.profile.ChatLogging then
		chatcat:AddLine(
			'text', L["TTipState"] .. ":",
			'text2', L["TTipEnabled"]
		)
		chatcat:AddLine(
			'text', L["TTipPath"] .. ":",
			'text2', L["TTipFilePath"] .. "\\" .. L["TTipFileNameChat"]
		)
	else
		chatcat:AddLine(
			'text', L["TTipState"] .. ":",
			'text2', L["TTipDisabled"]
		)
	end
	
	tablet:SetHint(L["TTipLogWarning"])
end

-- Handler for left clicking the plugin
function LogFu2:OnClick() 
    self:ToggleChatLogging() 
    self:Update()
end
