LogFu = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "FuBarPlugin-2.0")
local tablet = AceLibrary("Tablet-2.0")

local LogFu_UpdatedText = ""

function LogFu:LogSwitch()
	if (LoggingCombat())
	then
		LoggingCombat(false)
		LogFu:Print("CombatLogging : |cffff0000OFF|r")
	else
		LoggingCombat(true)
		LogFu:Print("CombatLogging : |cff00ff00ON|r")
	end
	self:Update()
end

function LogFu:OnInitialize()
	self:RegisterChatCommand({"/cl"}, function()
		self:LogSwitch()
	end)
end

function LogFu:OnTextUpdate()
	if (LoggingCombat())
	then
		LogFu_UpdatedText = string.format("|cff00ff00CombatLogging|r") --ON
	else
		LogFu_UpdatedText = string.format("|cffff0000CombatLogging|r") --OFF
	end
	self:SetText(LogFu_UpdatedText)
end

function LogFu:OnTooltipUpdate()
	local cat = tablet:AddCategory(
		'columns', 1,
		'child_textR', 1,
		'child_textG', 1,
		'child_textB', 0
	)
	cat:AddLine(
		'text', LogFu_UpdatedText
	)
end

function LogFu:OnClick() 
	self:LogSwitch()
end
