KillMeterFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0","AceDB-2.0","AceEvent-2.0")
KillMeterFu:RegisterDB("KillMeterFuDB")
KillMeterFu:RegisterDefaults('profile', {
	historyLength = 5,
	ignoreRestedXP = false,
    show = {
       killHistory = true
    },
})

KillMeterFu.hasIcon = true
KillMeterFu.defaultPostion = "RIGHT"

local L = AceLibrary("AceLocale-2.2"):new("FuBar_KillMeterFu")

local Tablet = AceLibrary("Tablet-2.0")

local options = {
   type = "group",
   args = {
      reset_session = {
         type = "execute",
         name = L["Reset session"],
         desc = L["Reset session"],
         func = "ResetSession",
         order = 100
      },
      set_history_length = {
         type = "range",
         name = L["Set history length"],
         desc = L["Set history length"],
         min = 1,
         max = 50,
         step = 1,
         get = function() return KillMeterFu.db.profile.historyLength end,
         set = function(v)
                  KillMeterFu.db.profile.historyLength = v
                  KillMeterFu:Update()
               end,
         order = 10
      },
      show_kill_history = {
         type = "toggle",
         name = L["Show recent kills"],
         desc = L["Show recent kills"],
         get = function() return KillMeterFu.db.profile.show.killHistory end,
         set = function()
                  KillMeterFu.db.profile.show.killHistory = not KillMeterFu.db.profile.show.killHistory
                  KillMeterFu:Update()
               end,
         order = 11
      }
   }
}
KillMeterFu.OnMenuRequest = options

function KillMeterFu:OnEnable()
   self:RegisterEvent("PLAYER_XP_UPDATE","Update")
   self:RegisterEvent("PLAYER_LEVEL_UP","Update")
   self:RegisterEvent("CHAT_MSG_COMBAT_XP_GAIN","ProcessXPGain")

   self.kill_list = {}
   self.avg_xp = 0
end

function KillMeterFu:OnTextUpdate()
   local totalXP = UnitXPMax("player");
   local currentXP = UnitXP("player");
   local toLevelXP = totalXP - currentXP;
   local xpPerKill = self.avg_xp
   local killsToLevel = math.ceil(toLevelXP/xpPerKill)
   -- a?b:c => a and b or c; now I remember why I love python
   local killsToLevelText = (xpPerKill > 0) and
      (format("|cffffffff%d|r",killsToLevel) .. " " .. L["Kills Left"])
      or ""
   
   self:SetText(killsToLevelText)
end

function KillMeterFu:OnTooltipUpdate()
   local totalXP = UnitXPMax("player");
   local currentXP = UnitXP("player");
   local toLevelXP = totalXP - currentXP;
   local xpPerKill = self.avg_xp
   local killsToLevel = math.ceil(toLevelXP/xpPerKill)
   local restedXP = GetXPExhaustion() or 0
   local restedKills = math.ceil(restedXP/xpPerKill)

   local cat = Tablet:AddCategory(
      'columns', 2,
      'child_textR', 1,
      'child_textG', 1,
      'child_textB', 0,
      'child_text2R', 1,
      'child_text2G', 1,
      'child_text2B', 1
   )

   cat:AddLine(
      'text', L["Level"] .. ":",
      'text2', UnitLevel("player")
   )

   cat:AddLine(
      'text', L["Total XP this level"] .. ":",
      'text2', totalXP
   )

   cat:AddLine(
      'text', L["Gained"] .. ":",
      'text2', format("%d (%.1f%%)", currentXP, currentXP / totalXP * 100)
   )

   cat:AddLine(
      'text', L["Remaining"] .. ":",
      'text2', format("%d (%.1f%%)", toLevelXP, toLevelXP / totalXP * 100)
   )

   if (restedXP > 0) then
      cat:AddLine(
         'text', L["Rested XP"] .. ":",
         'text2', format("%d (%.1f%%)", restedXP, restedXP / totalXP * 100),
         'text2R', 0.439,
         'text2G', 0.722,
         'text2B', 1
      )
   end

   cat = Tablet:AddCategory(
      'columns', 2,
      'child_textR', 1,
      'child_textG', 1,
      'child_textB', 0,
      'child_text2R', 1,
      'child_text2G', 1,
      'child_text2B', 1
   )

   cat:AddLine(
      'text', L["History length"] .. ":",
      'text2', self.db.profile.historyLength
   )

   if (xpPerKill > 0) then
      cat:AddLine(
         'text', L["Average XP per kill"] .. ":",
         'text2', xpPerKill
      )
   
      cat:AddLine(
         'text', L["Kills until next level"] .. ":",
         'text2', killsToLevel
      )

      if (restedXP > 0) then
         cat:AddLine(
            'text', L["Kills while rested"] .. ":",
            'text2', restedKills,
            'text2R', 0.439,
            'text2G', 0.722,
            'text2B', 1
         )
      end
   end

   if (self.db.profile.show.killHistory) then
      cat = Tablet:AddCategory(
         'columns', 2,
         'text', L["Kill History"],
         'textR', 0.698,
         'textG', 0.133,
         'textB', 0.133,
         'size', 12,
         'child_textR', 1,
         'child_textG', 1,
         'child_textB', 0,
         'child_size', 11,
         'child_text2R', 1,
         'child_text2G', 1,
         'child_text2B', 1,
         'child_size2', 11
      )

      for i,kill in ipairs(self.kill_list) do
         cat:AddLine(
            'text', kill.name,
            'text2',  (tonumber(kill.restedXP) > 0)
               and string.format('%s |cff70b8ff(+%s)|r',kill.xp,kill.restedXP)
               or kill.xp
         )
      end
   end
end

function KillMeterFu:ResetSession()
   self.avg_xp = 0
   self.kill_list = {}
   self:Update()
end

function KillMeterFu:ProcessXPGain(combat_string)
   local name,xp,rxp
   _,_,name,xp = string.find(combat_string, L["Combat Message Search String"])
   _,_,rxp = string.find(combat_string, L["Combat Message Rested Search String"])
   
   if (not xp) then return end -- stop if we didn't find the xp gained

   rxp = rxp or 0
   
   table.insert(self.kill_list,1, {
                   ["name"] = name,
                   ["xp"] = xp,
                   ["restedXP"] = rxp
                })

   if (table.getn(self.kill_list) > (self.db.profile.historyLength + 1)) then
      -- we have too many values in the kill history,
      -- so we're trimming it down and starting from scratch
      while (table.getn(self.kill_list) > self.db.profile.historyLength) do
         table.remove(self.kill_list)
      end
            
      self.avg_xp = 0
      for i,v in ipairs(self.kill_list) do
         self.avg_xp = self.avg_xp + v.xp
      end
      self.avg_xp = self.avg_xp / table.getn(self.kill_list)
            
   elseif (table.getn(self.kill_list) > self.db.profile.historyLength) then
      -- if we have a full table, we pop off the oldest value.
      -- also, we can update the avg xp without having the sum the entire table
      self.avg_xp = self.avg_xp + ((xp - table.remove(self.kill_list).xp) / self.db.profile.historyLength)
   else
      -- otherwise we need to sum up the entire kill history
      self.avg_xp = 0
      for i,v in ipairs(self.kill_list) do
         self.avg_xp = self.avg_xp + v.xp
      end
      self.avg_xp = self.avg_xp / table.getn(self.kill_list)
   end
end