KTMFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceConsole-2.0", "AceDB-2.0", "AceEvent-2.0")

KTMFu.version = "1.3"
KTMFu.hasIcon = "Interface\\Icons\\Spell_Fire_Fireball02"

KTMFu:RegisterDB("KTMFu2DB")

KTMFu:RegisterDefaults('profile', {
	showRank = true,
	showDeficit = true,
	showPercent = true,
	updateInterval = 0.5,
	sctFrame = 1,
	sctStyle = 1,
	showTank = false,
	showNotify = false,
	showNotifyInSCT=false,
	showNotifyInMSBT=false,
	showNotifyInBigWigs=false,
	showNotifyInBFCT=false,
	showNotifyInRW=false,
	showPercInNotify=false,
	showRankInNotify=false,
	showStatusInNotify=false
})


local Tablet = AceLibrary("Tablet-2.0")
local Crayon = AceLibrary("Crayon-2.0")

function KTMFu:IsShowing(p)
	return self.db.profile["show"..p]
end

function KTMFu:ToggleShowing(p)
	self.db.profile["show"..p] = not self.db.profile["show"..p]
	self:UpdateText()
end

function KTMFu:IsShowingRank()return self:IsShowing("Rank")end
function KTMFu:IsShowingDeficit()return self:IsShowing("Deficit")end
function KTMFu:IsShowingPercent()return self:IsShowing("Percent")end
function KTMFu:IsShowingStatus()return self:IsShowing("Status")end
function KTMFu:IsShowingNotify()return self:IsShowing("Notify")end
function KTMFu:IsShowingNotifyInSCT()return self:IsShowing("NotifyInSCT")end
function KTMFu:IsShowingNotifyInMSBT()return self:IsShowing("NotifyInMSBT")end
function KTMFu:IsShowingNotifyInBigWigs()return self:IsShowing("NotifyInBigWigs")end
function KTMFu:IsShowingNotifyInBFCT()return self:IsShowing("NotifyInBFCT")end
function KTMFu:IsShowingNotifyInRW()return self:IsShowing("NotifyInRW")end
function KTMFu:IsShowingPercInNotify()return self:IsShowing("PercInNotify")end
function KTMFu:IsShowingRankInNotify()return self:IsShowing("RankInNotify")end
function KTMFu:IsShowingStatusInNotify()return self:IsShowing("StatusInNotify")end


function KTMFu:IsTank()return self:IsShowing("Tank")end

function KTMFu:GetSCTFrame()return self.db.profile.sctFrame end
function KTMFu:GetSCTStyle()return self.db.profile.sctStyle end
function KTMFu:GetUpdateInterval()return self.db.profile.updateInterval end

function KTMFu:ToggleShowingPercent()return self:ToggleShowing("Percent")end
function KTMFu:ToggleShowingDeficit()return self:ToggleShowing("Deficit")end
function KTMFu:ToggleShowingRank()return self:ToggleShowing("Rank")end
function KTMFu:ToggleShowingStatus()return self:ToggleShowing("Status")end
function KTMFu:ToggleShowingNotify()self:ToggleShowing("Notify")end
function KTMFu:ToggleShowingNotifyInSCT()self:ToggleShowing("NotifyInSCT")end
function KTMFu:ToggleShowingNotifyInMSBT()self:ToggleShowing("NotifyInMSBT")end
function KTMFu:ToggleShowingNotifyInBigWigs()self:ToggleShowing("NotifyInBigWigs")end
function KTMFu:ToggleShowingNotifyInBFCT()self:ToggleShowing("NotifyInBFCT")end
function KTMFu:ToggleShowingNotifyInRW()self:ToggleShowing("NotifyInRW")end
function KTMFu:ToggleShowingRankInNotify()self:ToggleShowing("RankInNotify")end
function KTMFu:ToggleShowingPercInNotify()self:ToggleShowing("PercInNotify")end
function KTMFu:ToggleShowingStatusInNotify()self:ToggleShowing("StatusInNotify")end


function KTMFu:ToggleTank()return self:ToggleShowing("Tank")end

function KTMFu:SetUpdateInterval(n)self.db.profile.updateInterval=n; self:UpdateUpdateInterval() end
function KTMFu:SetSCTFrame(n) self.db.profile.sctFrame=n end
function KTMFu:SetSCTStyle(n) self.db.profile.sctStyle=n end

function KTMFu:OnInitialize()
end

function KTMFu:OnEnable()
	self:UpdateUpdateInterval()
	self:RegisterEvent("KtmFuUpdate")
end

function KTMFu:KtmFuUpdate()
	self:UpdateText()
	self:UpdateTooltip()

end


function KTMFu:UpdateUpdateInterval()
	if self:IsEventScheduled("KTMFuUpdate") then
		self:CancelScheduledEvent("KTMFuUpdate")
	end
	self:ScheduleRepeatingEvent("KTMFuUpdate","KtmFuUpdate",self.db.profile.updateInterval)
end

local options = {
	type = 'group',
	args = {
		rank = {
			type = 'toggle',
			name = "Show rank",
			desc = "Show rank",
			get = "IsShowingRank",
			set = "ToggleShowingRank",
		},
		percent = {
			type = 'toggle',
			name = "Show percent",
			desc = "Show percent",
			get = "IsShowingPercent",
			set = "ToggleShowingPercent",
		},
		deficit = {
			type = 'toggle',
			name = "Show deficit",
			desc = "Show deficit",
			get = "IsShowingDeficit",
			set = "ToggleShowingDeficit",
		},
		status = {
			type = 'toggle',
			name = "Show status",
			desc = "Show status",
			get = "IsShowingStatus",
			set = "ToggleShowingStatus",
		},
		tank = {
			type = 'toggle',
			name = "Tank Mode",
			desc = "Changes the aggro warnings to those better suited for a tank",
			get = "IsTank",
			set = "ToggleTank",
		},		
		
		interval = {
			type = 'range',
			min = 0.25, max=5, step=0.05,
			name = "Update interval",
			desc = "Update interval in seconds",
			get = "GetUpdateInterval",
			set = "SetUpdateInterval",
		},
		statusNotify= {
			type = 'group',
			name='Status Notifications...',
			desc='Show status changes on screen',
			args= {
				showNotify= {
					type = 'toggle',
					name = 'Enable Notifications',
					desc = 'Globally enable/disable notifications',
					get = "IsShowingNotify",
					set = "ToggleShowingNotify",
					},			

				showIn={
					type = 'group',
					name = 'Show In...',
					desc = 'Addons to show notifications in',
					args={
						showInSCT= {
							type = 'toggle',
							name = 'Show in SCT',
							desc = 'Use Scrolling Combat Text to show',
							get = "IsShowingNotifyInSCT",
							set = "ToggleShowingNotifyInSCT",
							disabled = function()return SCT==nil end
							},					
						showInBigWigs= {
							type = 'toggle',
							name = 'Show in BigWigs',
							desc = 'Use BigWigs to show',
							get = "IsShowingNotifyInBigWigs",
							set = "ToggleShowingNotifyInBigWigs",
							disabled = function()return BigWigs==nil end
							},
						showInMSBT= {
							type = 'toggle',
							name = 'Show in MSBT',
							desc = 'Use MSBT to show',
							get = "IsShowingNotifyInMSBT",
							set = "ToggleShowingNotifyInMSBT",
							disabled = function()return MSBT==nil end
							},
						showInBlizzFCT= {
							type = 'toggle',
							name = 'Show in Blizzard FCT',
							desc = 'Use Blizzard Floating Combat Text to show',
							get = "IsShowingNotifyInBFCT",
							set = "ToggleShowingNotifyInBFCT",
							disabled = function()return CombatText_AddMessage==nil end
							},
						showInRaidWarning= {
							type = 'toggle',
							name = 'Show in Raid Warning',
							desc = 'Use Raid Warning frame to show',
							get = "IsShowingNotifyInRW",
							set = "ToggleShowingNotifyInRW",
							},						
					}
					},

				showStatusInNotify= {
					type = 'toggle',
					name = 'Show Status in Notification',
					desc = 'Show status in notification',
					get = "IsShowingStatusInNotify",
					set = "ToggleShowingStatusInNotify",
					},					
				showRankInNotify= {
					type = 'toggle',
					name = 'Show Rank in Notification',
					desc = 'Show ranking in notification',
					get = "IsShowingRankInNotify",
					set = "ToggleShowingRankInNotify",
					},
				showPercentInNotify= {
					type = 'toggle',
					name = 'Show Percent in Notification',
					desc = 'Show percent in notification',
					get = "IsShowingPercInNotify",
					set = "ToggleShowingPercInNotify",
					},

				sctFrame = {
					type = 'range',
					min = 1, max=3, step=1,
					name = "SCT Frame",
					desc = "SCT Frame to output status changes to. 0 if disabled.",
					get = "GetSCTFrame",
					set = "SetSCTFrame",
					disabled = function()return SCT==nil end
				},
				sctStyle = {
					type = 'range',
					min = 1, max=9, step=1,
					name = "SCT Style",
					desc = "SCT Style for output.",
					get = "GetSCTStyle",
					set = "SetSCTStyle",
					disabled = function()return SCT==nil end
				},
			}
		}
		
	}
}
KTMFu.OnMenuRequest = options

function KTMFu:ShowNotify(message,rc,gc,bc)
	-- Stolen from ErrorMonster by Rabbit. Thank you!!!
	if self:IsShowingNotifyInBigWigs() and BigWigs then
		self:TriggerEvent("BigWigs_Message", message, { r = rc, g = gc, b = bc }, false, false)
	end
	if self:IsShowingNotifyInSCT() and SCT and type(SCT.DisplayMessage) == "function" then
		if self.db.profile.sctStyle==9 then
			SCT:DisplayText(message, { r = rc, g = gc, b = bc }, 1, "event", self.db.profile.sctFrame, 0)
		else
			SCT:DisplayText(message, { r = rc, g = gc, b = bc }, nil, "event", self.db.profile.sctFrame, self.db.profile.sctStyle);
		end
	end
	if self:IsShowingNotifyInMSBT() and MikSBT then
		MikSBT.DisplayMessage(message, MikSBT.DISPLAYTYPE_NOTIFICATION, false, rc * 255, gc * 255, bc * 255)
	end
	if self:IsShowingNotifyInBFCT() and CombatText_AddMessage then
		CombatText_AddMessage(message, COMBAT_TEXT_SCROLL_FUNCTION, rc, gc, bc, "sticky", nil)
	end
	if self:IsShowingNotifyInRW() and RaidWarningFrame then
		RaidWarningFrame:AddMessage(message, r, g, b)
	end

end

function KTMFu:Abbreviate(p)
	if KLHTM_Abbreviate then return KLHTM_Abbreviate(p) end
	if p>1000 then return string.format("%.1f",p/1000.0).."k" end
	return tostring(floor(p))
end

function KTMFu:GetKTMData()
	if KLHTM_GetRaidData then -- Vintage Mode
		local data, playerCount, threat100,rowCount = KLHTM_GetRaidData();
		local userThreat = (klhtm.table.raiddata[UnitName("player")] or 0);
		local deficit = self:Abbreviate(threat100 - userThreat);
		local userRank = 1;
		local _,d;
		for _, d in pairs(data) do
			if (d.threat > userThreat) then
				userRank = userRank + 1;
			end
		end
		return userRank,deficit,userThreat,threat100,playerCount,userThreat/threat100;
	elseif klhtm.raidtable.instances[1] then -- New Style
		local data=klhtm.raidtable.instances[1].table
		local rowCount=data.length
		if rowCount==0 then
			return 0,0,0,0,0,0
		end
		local threat100=data[1].threat
		
		local userThreat=(klhtm.table.raiddata[UnitName("player")] or 0);
		local deficit=self:Abbreviate(threat100 - userThreat);
		local userRank=1;
		while data[userRank].threat>userThreat and userRank<rowCount do
			userRank=userRank+1;
		end
		return userRank,deficit,userThreat,threat100,rowCount,userThreat/threat100;
	end
end

function KTMFu:GetStatusString(t)
	if self.db.profile.showTank then
		if t>0.9 then return "Good Work"; end
		if t>0.8 then return "Slipping A Bit"; end
		if t>0.6 then return "Careful..."; end
		if t>0.4 then return "Shape Up!"; end
		if t>0.2 then return "Getting Away"; end
		return "Bad Doggy!";	
	else
		if t>0.9 then return "GTFO!"; end
		if t>0.7 then return "Careful..."; end
		if t>0.5 then return "Not That Safe"; end
		if t>0.3 then return "Fire Away"; end
		if t>0.1 then return "Safe"; end
		return "Doing Anything?";
	end
end

local tmp = {}
function KTMFu:OnTextUpdate()
	local userRank,deficit,userThreat,threat100,playerCount,p=self:GetKTMData();
	local status,msg
	if userRank==nil then
		self:SetText("KTM Problem");
		return
	end
	if userThreat > 0 then
		status=self:GetStatusString(p)
		if self:IsShowingPercent() then table.insert(tmp, string.format("%d%%",p*100)) end
		if self:IsShowingRank() then table.insert(tmp, string.format("%d/%d",userRank,playerCount)) end
		if self:IsShowingDeficit() then table.insert(tmp, deficit) end
		if self:IsShowingStatus() then table.insert(tmp, Crayon:Colorize(Crayon:GetThresholdHexColor(1-p),status)) end
		if self:IsTextColored() then
			self:SetText(Crayon:Colorize(Crayon:GetThresholdHexColor(1.0-p),table.concat(tmp, " | ")))
		else
			self:SetText(table.concat(tmp, " | "))
		end
		for k,v in pairs(tmp) do
			tmp[k] = nil
		end
		if self:IsShowingNotify() then
			if self.lastStatus~=nil and self.lastStatus~=status then
				msg=""
				local rc,gc,bc=Crayon:GetThresholdColor(1-p)
				if self:IsShowingStatusInNotify() then
					msg=msg.." "..status
				end

				if self:IsShowingPercInNotify() then
					msg=msg.." "..string.format("%d%%",p*100)
				end
				if self:IsShowingRankInNotify() then
					msg=msg.." "..string.format("%d/%d",userRank,playerCount)
				end
				
				self:ShowNotify(msg,rc,gc,bc)
			end
			self.lastStatus=status
		end		
	else
		self:SetText("KTM")
	end
end

function KTMFu:OnTooltipUpdate()
	local userRank,deficit,userThreat,threat100,playerCount,p=self:GetKTMData();
	local r,g,b;
	if userRank~=nil and threat100~=0 then
		r,g,b=Crayon:GetThresholdColor(1-p);
	else
		r,g,b=1,1,1;
	end
	Tablet:SetTitleColor(r,g,b)
	Tablet:SetTitle("KTMFu "..(self.version))
	local cat = Tablet:AddCategory(
		'columns', 2,
		'child_textR', r,'child_textG', g,'child_textB', b,
		'child_text2R', r,'child_text2G', g,'child_text2B', b
	)	
	if userRank==nil then
		cat:AddLine('text','Oops','text2',"There's a problem with KTM. Are you sure it's working?")
		return
	end	
	if threat100 ~= 0 then
		
		cat:AddLine('text','Percent','text2',string.format("%d%%",p*100),'text2R', r,'text2G', g,'text2B', b)
		cat:AddLine('text','Threat Rank','text2',string.format("%d/%d",userRank,playerCount))
		cat:AddLine('text','Deficit','text2',tostring(deficit))
		cat:AddLine('text','Status','text2',self:GetStatusString(p),'text2R', r,'text2G', g,'text2B', b)
	else
		cat:AddLine('text','Status','text2','Very Safe.')
	end
end

function KTMFu:OnClick()
	local g
	if klhtm.raidtable then
		g=klhtm.raidtable.instances[1].gui
		if g:IsShown() then g:Hide() else g:Show() end
	else
		KLHTM_SetVisible(KLHTM_GuiState.closed);
	end
end