local tablet = AceLibrary("Tablet-2.0")

FuBar_ItemListFu = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0", "FuBarPlugin-2.0")
FuBar_ItemListFu.hasIcon = "Interface\\Icons\\INV_Misc_QuestionMark"
FuBar_ItemListFu.clickableTooltip = true
FuBar_ItemListFu:RegisterDB("FuBar_ItemListFuDB", "FuBar_ItemListFuDBPC")
FuBar_ItemListFu:RegisterDefaults("char", {
	data = {
		{
			name = "Uncategorized",
			collapsed = false,
			items = {}
		}
	}
})

FuBar_ItemListFu.dropdown_cat = {}
FuBar_ItemListFu.dropdown_item = {}

FuBar_ItemListFu.dropdown = {
	type = "group", args = {
		cats = {
			type = "group",
			name = "Categories",
			desc = "List of all categories",
			args = FuBar_ItemListFu.dropdown_cat,
			order = 1
		},
		newcat = {
			type = "text",
			name = "New Categorie",
			desc = "Adds a new categorie",
			usage = "<cat name>",
			get = false,
			set = function(val) FuBar_ItemListFu:AddCat(val) end,
			order = 2
		},
		additem = {
			type = "text",
			name = "Add Item",
			desc = "Adds a new item",
			usage = "<item id>, <item link> or <item name>",
			get = false,
			set = function(val) FuBar_ItemListFu:AddItem(val) end,
			order = 3
		}
	}
}

FuBar_ItemListFu.OnMenuRequest = FuBar_ItemListFu.dropdown

function FuBar_ItemListFu:OnInitialize()
	self.itemdata = {}
end

function FuBar_ItemListFu:OnEnable()
	while #self.dropdown_cat > 0 do table.remove(self.dropdown_cat) end
	while #self.dropdown_item > 0 do table.remove(self.dropdown_item) end
	for catindex, catdata in ipairs(self.db.char.data) do
		table.insert(self.dropdown_item, {})
		local catddtable = self:GetCatDropdown(catindex)
		catddtable.args.items.args = self.dropdown_item[catindex]
		table.insert(self.dropdown_cat, catddtable)
		for itemindex, item in ipairs(catdata.items) do
			self:UpdateItem(item)
		end
	end
	for catindex in ipairs(self.db.char.data) do
		self:SetCatDropdown(self.dropdown_cat[catindex], catindex)
		self:RebuildCatItemDropdowns(catindex)
	end
	
	self:RegisterBucketEvent("BAG_UPDATE", 1, "Update")
end

function FuBar_ItemListFu:OnDataUpdate()
	for _, catdata in ipairs(self.db.char.data) do
		for _, item in ipairs(catdata.items) do
			self:UpdateItem(item)
		end
	end
end

function FuBar_ItemListFu:OnTextUpdate()
	if self.db.char.textitem and self.itemdata[self.db.char.textitem].name then
		self:SetIcon(self.itemdata[self.db.char.textitem].icon or "Interface\\Icons\\INV_Misc_QuestionMark")
		self:SetText("|cff00ff00"..self.itemdata[self.db.char.textitem].name..":|r |cffffff00"..self.itemdata[self.db.char.textitem].count.."|r(+"..self.itemdata[self.db.char.textitem].countbank..")")
	else
		self:SetIcon("Interface\\Icons\\INV_Misc_QuestionMark")
		self:SetText("|cffffffffItemList|cff00ff00Fu|r")
	end
end

function FuBar_ItemListFu:OnTooltipUpdate()
	local cat = tablet:AddCategory("columns", 3, "hideBlankLine", true, "showWithoutChildren", true)
	cat:AddLine({	text = "Item",	justify = "CENTER",
					text2 = "Bags",	justify2 = "CENTER",
					text3 = "Bank",	justify3 = "CENTER",
					indentation = 15})

	for catindex, catdata in ipairs(self.db.char.data) do
		cat:AddLine({	text = catdata.name,	justify = "LEFT",
						text2 = "",
						text3 = "",
						hasCheck = true,		checked = true,		checkIcon = catdata.collapsed and "Interface\\Buttons\\UI-PlusButton-Up" or "Interface\\Buttons\\UI-MinusButton-Up",
						func = "OnClick_TooltipCat",	arg1 = self,	arg2 = catindex})
		if not catdata.collapsed then
			for itemindex, item in ipairs(catdata.items) do
				if self.itemdata[item].name then
					cat:AddLine({	text = self.itemdata[item].name,		justify = "LEFT",
									textR = 1, textG = 1, textB = 0,
									text2 = self.itemdata[item].count,		justify2 = "RIGHT",
									text2R = 1, text2G = 1, text2B = 1,
									text3 = self.itemdata[item].countbank,	justify3 = "RIGHT",
									text3R = 1, text3G = 1, text3B = 1,
									indentation = 15,
									hasCheck = true,	checked = true,		checkIcon = self.itemdata[item].icon,
									func = "OnClick_TooltipItem",	arg1 = self,	arg2 = catindex, 	arg3 = itemindex})

				else
					cat:AddLine({	text = "Item "..item,					justify = "LEFT",
									textR = 1, textG = 1, textB = 0,
									text2 = self.itemdata[item].count,		justify2 = "RIGHT",
									text2R = 1, text2G = 1, text2B = 1,
									text3 = self.itemdata[item].countbank,	justify3 = "RIGHT",
									text3R = 1, text3G = 1, text3B = 1,
									indentation = 15,
									hasCheck = true,	checked = true,		checkIcon = "Interface\\Icons\\INV_Misc_QuestionMark",
									func = "OnClick_TooltipItem",	arg1 = self,	arg2 = catindex, 	arg3 = itemindex})
				end
			end
		end
	end
end

function FuBar_ItemListFu:UpdateItem(item)
	if not self.itemdata[item] then self.itemdata[item] = {} end
	self.itemdata[item].count = GetItemCount(item)
	self.itemdata[item].countbank = GetItemCount(item, true) - self.itemdata[item].count
	if not self.itemdata[item].name then
--		local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo(item)
		local itemName, itemLink, _, _, _, _, _, _, _, itemTexture = GetItemInfo(item)
		self.itemdata[item].name = itemName
		self.itemdata[item].link = itemLink
		self.itemdata[item].icon = itemTexture
	end
end

function FuBar_ItemListFu:OnClick_TooltipCat(catindex)
	if IsControlKeyDown() then
	else
		self.db.char.data[catindex].collapsed = not self.db.char.data[catindex].collapsed
	end
end

function FuBar_ItemListFu:OnClick_TooltipItem(catindex, itemindex)
	if IsControlKeyDown() then
	elseif IsShiftKeyDown() then
		if self.itemdata[self.db.char.data[catindex].items[itemindex]].link then
			ChatEdit_InsertLink(self.itemdata[self.db.char.data[catindex].items[itemindex]].link)
		end
	else
		if self.db.char.textitem == self.db.char.data[catindex].items[itemindex] then
			self.db.char.textitem = nil
		else
			self.db.char.textitem = self.db.char.data[catindex].items[itemindex]
		end
		self:UpdateText()
	end
end

-- --------------------

function FuBar_ItemListFu:GetCatDropdown(ci)				-- gets a dropdown for categorie index ci
	local catddtable = {
		type = "group",
		order = ci,
		args = {
			items = {
				type = "group",
				name = "Items",
				desc = "Items in this categorie",
				order = 1
			},
			name = {
				type = "text",
				name = "Name",
				desc = "Change the categorie's name",
				usage = "<cat name>",
				set = function(val) FuBar_ItemListFu:ChangeCatName(ci, val) end,
				order = 2
			},
			order = {
				type = "range",
				name = "Position",
				desc = "Change the categorie's position",
				step = 1,
				get = function() return ci end,
				set = function(val) FuBar_ItemListFu:ChangeCatPos(ci, val) end,
				order = 3
			},
			remove = {
				type = "execute",
				name = "Remove",
				desc = "Removes the categorie",
				func = function() FuBar_ItemListFu:RemoveCat(ci) end,
				order = 4
			}
		}
	}
	while #self.dropdown_item < ci do table.insert(self.dropdown_item, {}) end
	return catddtable
end

function FuBar_ItemListFu:SetCatDropdown(dd, ci)			-- sets given dropdown to categorie index ci's data
	dd.name = self.db.char.data[ci].name
	dd.desc = string.format("Settings for categorie %s", self.db.char.data[ci].name)
	dd.args.name.get = function() return self.db.char.data[ci].name end
	dd.args.order.min = #self.db.char.data <= 1 and 0 or 1
	dd.args.order.max = #self.db.char.data
	dd.args.order.disabled = #self.db.char.data <= 1
end

function FuBar_ItemListFu:GetItemDropdown(ci, ii)			-- gets a dropdown for item index ci.ii
	local itemddtable = {
		type = "group",
		order = ii,
		args = {
			cat = {
				type = "group",
				name = "Categorie",
				desc = "Change the item's categorie",
				args = {},
				order = 1
			},
			order = {
				type = "range",
				name = "Position",
				desc = "Change the items's position",
				step = 1,
				get = function() return ii end,
				set = function(val) FuBar_ItemListFu:ChangeItemPos(ci, ii, val) end,
				order = 2
			},
			remove = {
				type = "execute",
				name = "Remove",
				desc = "Removes the item",
				func = function() FuBar_ItemListFu:RemoveItem(ci, ii) end,
				order = 3
			}
		}
	}
	return itemddtable
end

function FuBar_ItemListFu:SetItemDropdown(dd, ci, ii)		-- sets given dropdown to item index ii's data
	dd.name = (self.itemdata[self.db.char.data[ci].items[ii]] and self.itemdata[self.db.char.data[ci].items[ii]].name) or ("Item "..self.db.char.data[ci].items[ii])
	dd.desc = string.format("Settings for %s", dd.name)
	dd.icon = (self.itemdata[self.db.char.data[ci].items[ii]] and self.itemdata[self.db.char.data[ci].items[ii]].icon) or "Interface\\Icons\\INV_Misc_QuestionMark"
	dd.args.order.min = #self.db.char.data[ci].items <= 1 and 0 or 1
	dd.args.order.max = #self.db.char.data[ci].items
	dd.args.order.disabled = #self.db.char.data[ci].items <= 1
end

function FuBar_ItemListFu:SetCatAssignDropdown(dd, ci, ii)	-- updates names, adjusts size
	for catindex, catdata in ipairs(self.db.char.data) do
		if not dd.args.cat.args[catindex] then
			local cattable = {
				type = "toggle",
				name = catdata.name,
				desc = string.format("Sets categorie to %s", catdata.name),
				isRadio = true,
				get = function() return catindex == ci end,
				set = function() FuBar_ItemListFu:ChangeItemCat(ci, ii, catindex) end,
				order = catindex
			}
			table.insert(dd.args.cat.args, cattable)
		else
			dd.args.cat.args[catindex].name = catdata.name
			dd.args.cat.args[catindex].desc = string.format("Sets categorie to %s", catdata.name)
		end
	end
	while #dd.args.cat.args > #self.db.char.data do table.remove(dd.args.cat.args) end
end

-- --------------------

function FuBar_ItemListFu:RebuildCatItemDropdowns(ci)
	for ii in ipairs(self.db.char.data[ci].items) do
		local dd = self.dropdown_item[ci][ii]
		if not dd then
			dd = self:GetItemDropdown(ci, ii)
			table.insert(self.dropdown_item[ci], dd)
		end
		self:SetItemDropdown(dd, ci, ii)
		self:SetCatAssignDropdown(dd, ci, ii)
	end
	while #self.dropdown_item[ci] > #self.db.char.data[ci].items do table.remove(self.dropdown_item[ci]) end
end

function FuBar_ItemListFu:AddCat(catname)
	if not catname or catname == "" then return end
	for _, catdata in ipairs(self.db.char.data) do
		if catdata.name == catname then return end
	end
	local cattable = {
		name = catname,
		collapsed = false,
		items = {}
	}
	table.insert(self.db.char.data, cattable)
	table.insert(self.dropdown_item, {})
	local catddtable = self:GetCatDropdown(#self.db.char.data)
	catddtable.args.items.args = self.dropdown_item[#self.db.char.data]
	table.insert(self.dropdown_cat, catddtable)
	for catindex in ipairs(self.db.char.data) do
		self:SetCatDropdown(self.dropdown_cat[catindex], catindex)
		self:RebuildCatItemDropdowns(catindex)
	end
	self:UpdateTooltip()
end

-- changes the name of categorie with index ci to name
-- updates the categories dropdown table and all item CatAssign dropdowns
function FuBar_ItemListFu:ChangeCatName(ci, name)
	for _, catdata in ipairs(self.db.char.data) do
		if catdata.name == name then return end -- there is already a categorie with that name
	end
	self.db.char.data[ci].name = name
	self:SetCatDropdown(self.dropdown_cat[ci], ci)
	for catid, catdata in ipairs(self.dropdown_item) do
		for ii, dd in ipairs(catdata) do
			self:SetCatAssignDropdown(dd, catid, ci)
		end
	end
	self:UpdateTooltip()
end

function FuBar_ItemListFu:ChangeCatPos(ci, ci_new)
	if ci_new == ci then return end
	local catdata = table.remove(self.db.char.data, catindex)
	table.insert(self.db.char.data, ci_new, catdata)
	for catindex in ipairs(self.db.char.data) do
		self:SetCatDropdown(self.dropdown_cat[catindex], catindex)
		self:RebuildCatItemDropdowns(catindex)
	end
	self:UpdateTooltip()
end

function FuBar_ItemListFu:RemoveCat(ci)
	for _, itemid in ipairs(self.db.char.data[catindex].items) do
		if self.db.char.textitem == itemid then
			self.db.char.textitem = nil
			self:UpdateText()
		end
	end
	table.remove(self.dropdown_cat, ci)
	table.remove(self.dropdown_item, ci)
	table.remove(self.db.char.data, ci)
	for catindex in ipairs(self.db.char.data) do
		self:SetCatDropdown(self.dropdown_cat[catindex], catindex)
		self:RebuildCatItemDropdowns(catindex)
	end
	self:UpdateTooltip()
end


function FuBar_ItemListFu:AddItem(item, catindex)
	local name, link = GetItemInfo(item)
	if not name then return end
	_, _, item = string.find(link, "item:(%-?%d+):")
	item = tonumber(item)
	for _, catdata in ipairs(self.db.char.data) do
		for _, itemid in ipairs(catdata.items) do
			if itemid == item then return end
		end
	end
	self:UpdateItem(item)
	if not catindex then catindex = 1 end
	table.insert(self.db.char.data[catindex].items, item)
	self:RebuildCatItemDropdowns(catindex)
	self:UpdateTooltip()
end

function FuBar_ItemListFu:ChangeItemCat(ci, ii, ci_new)
	local itemid = table.remove(self.db.char.data[ci].items, ii)
	table.insert(self.db.char.data[ci_new].items, itemid)
	self:RebuildCatItemDropdowns(ci)
	self:RebuildCatItemDropdowns(ci_new)
	self:UpdateTooltip()
end

function FuBar_ItemListFu:ChangeItemPos(ci, ii, ii_new)
	if ii_new == ii then return end
	local itemid = table.remove(self.db.char.data[ci].items, ii)
	table.insert(self.db.char.data[ci].items, ii_new, itemid)
	self:RebuildCatItemDropdowns(ci)
	self:UpdateTooltip()
end

function FuBar_ItemListFu:RemoveItem(ci, ii)
	local itemid = table.remove(self.db.char.data[ci].items, ii)
	if self.db.char.textitem == itemid then
		self.db.char.textitem = nil
		self:UpdateText()
	end
	self:RebuildCatItemDropdowns(ci)
	self:UpdateTooltip()
end

