local _G = getfenv(0)

local ipairs = _G.ipairs

local AceLibrary = _G.AceLibrary
local tablet = AceLibrary("Tablet-2.0")
local InventoryLib = LibStub("LibInventory-2.1")

FuBar_ItemDBFu = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "FuBarPlugin-2.0")
local FuBar_ItemDBFu = _G.FuBar_ItemDBFu
FuBar_ItemDBFu.hasIcon = "Interface\\Icons\\INV_Scroll_03"
FuBar_ItemDBFu.cannotDetachTooltip = true

-- function FuBar_ItemDBFu:OnInitialize()
-- end

function FuBar_ItemDBFu:OnEnable()
	self:ScheduleRepeatingEvent(self.Update, 1, self)
end

-- function FuBar_ItemDBFu:OnDisable()
-- end

function FuBar_ItemDBFu:OnDataUpdate()
	self.ItemsKnown, self.ItemsSafe = InventoryLib:GetCounts()
	self.ItemsPercentage = ("%.1f%%"):format(self.ItemsSafe / self.ItemsKnown * 100)
end

function FuBar_ItemDBFu:OnTextUpdate()
		if self.ItemsKnown > 0 then
			self:SetText(self.ItemsSafe.." / "..self.ItemsKnown)
		else
			self:SetText("N/A")
		end
end

function FuBar_ItemDBFu:OnTooltipUpdate()
	local cat = tablet:AddCategory(
		'columns', 2,
		'text', "Status",
		'child_textR', 1,
		'child_textG', 1,
		'child_textB', 0,
		'child_text2R', 1,
		'child_text2G', 1,
		'child_text2B', 1
	)
	cat:AddLine(
		'text', "safe items:",
		'text2', self.ItemsSafe
	)
	cat:AddLine(
		'text', "known items:",
		'text2', self.ItemsKnown
	)
	cat:AddLine(
		'text', "percentage:",
		'text2', self.ItemsPercentage
	)

	tablet:SetHint("Click to toggle ItemDB.")
end

function FuBar_ItemDBFu:OnClick()
	ItemDB_DBFrame_ToggleUI()
end
