------------------------------------------------------------------------------------------------------
-- Local variables
------------------------------------------------------------------------------------------------------
local InstanceInfoFu = InstanceInfoFu;
local L = LibStub("AceLocale-3.0"):GetLocale("InstanceInfoFu");


------------------------------------------------------------------------------------------------------
-- FuBar options
------------------------------------------------------------------------------------------------------
InstanceInfoFu.fubarOptions = {
	["tooltipType"] = "Tablet-2.0",
	["hasNoColor"] = true,
	["cannotDetachTooltip"] = true,
	["hideWithoutStandby"] = true,
	["iconPath"] =  "Interface\\Icons\\INV_Misc_PocketWatch_01",
	["defaultPosition"] = "LEFT",
};

------------------------------------------------------------------------------------------------------
-- Menu options
------------------------------------------------------------------------------------------------------
InstanceInfoFu.options = {
	name = "InstanceInfoFu",
	type = 'group',
	args = {
		gen = {
			type = "group",
			name = L["General Settings"],
			desc = L["Adjust various settings for InstanceInfoFu."],
			order = 10,
			args = {
				minlevel = {
					type = "range",
					name = L["Minimum Player Level"],
					desc = L["InstanceInfoFu will not save info for instances for characters below this level."],
					width = "full",
					get = function(info) return InstanceInfoFu.db.profile.minLevel; end,
					set = function(info, v) 
						InstanceInfoFu.db.profile.minLevel = v;
						InstanceInfoFu:UpdateFuBarPlugin();
					end,
					min = 1,
					max = 70,
					step = 1,
					order = 10
				},
				showself = {
					type = "toggle",
					name = L["Show Only Own Instance Info"],
					desc = L["Toggles whether you will only see your own instance info."],
					width = "full",
					get = function(info) return InstanceInfoFu.db.profile.showSelf; end,
					set = function(info, v) 
						InstanceInfoFu.db.profile.showSelf = v;
						InstanceInfoFu:UpdateFuBarPlugin();
					end,
					order = 20
				},
			}
		},
		profile = {
			type = "group",
			order = 25,
			name = L["Profile Options"],
			args = {
				desc = {
					order = 1,
					type = "description",
					name = L["InstanceInfoFu's saved variables are organized so you can have shared options across all your characters, while having different sets of custom buttons for each.  These options sections allow you to change the saved variable configurations so you can set up per-character options, or even share custom button setups between characters"],
				}
			}
		}
	}
};

------------------------------------------------------------------------------------------------------
-- FuBar Menu options
------------------------------------------------------------------------------------------------------
function ReturnFubarOptions(object, db)
	return {
		type = "group",
		name = L["FuBar Options"],
		desc = L["FuBar Options"],
		order = -16,
		args = {
			attachMinimap = {
				type = "toggle",
				name = L["Attach to minimap"],
				desc = L["Attach to minimap"],
				get = function(info)
					return object:IsFuBarMinimapAttached()
				end,
				set = function(info, v)
					if db.HideMinimapButton then return end
					object:ToggleFuBarMinimapAttached()
					db.attached = object:IsFuBarMinimapAttached()
				end,
				disabled = function(info) return db.HideMinimapButton end
			},
			hideIcon = {
				type = "toggle",
				name = L["Hide Plugin"],
				desc = L["Hide minimap/FuBar icon"],
				get = function(info) return db.HideMinimapButton end,
				set = function(info, v)
					db.HideMinimapButton = v
					if not v then
						object:Show()
					else
						object:Hide()
					end
				end
			},
			showIcon = {
				type = "toggle",
				name = L["Show icon"],
				desc = L["Show icon"],
				get = function(info) return db.showIcon end,
				set = function(info, v) 
					db.showIcon = object:IsFuBarIconShown()
					InstanceInfoFu:ToggleFuBarIconShown() end,
				disabled = function(info) return db.HideMinimapButton end
			},
			showText = {
				type = "toggle",
				name = L["Show text"],
				desc = L["Show text"],
				get = function(info) return db.showText end,
				set = function(info, v)
					db.showText = object:IsFuBarTextShown()
					object:ToggleFuBarTextShown()
				end,
				disabled = function(info) 
					if db.HideMinimapButton then
						return true
					end
				end,
			},
			position = {
				type = "select",
				name = L["Position"],
				desc = L["Position"],
				values = {LEFT = L["Left"], CENTER = L["Center"], RIGHT = L["Right"]},
				get = function() return object:GetPanel() and object:GetPanel():GetPluginSide(object) end,
				set = function(info, val)
					if object:GetPanel() and object:GetPanel().SetPluginSide then
						object:GetPanel():SetPluginSide(object, val)
					end
				end,
				disabled = function(info) return object:IsFuBarMinimapAttached() end
			}
		}
	}
end